/*
 * Decompiled with CFR 0.152.
 */
package gameCanvasUtil.Resource;

import gameCanvasUtil.Resource.ResourceUtil;
import gameCanvasUtil.Resource.SoundManagerInterface;
import java.io.InputStream;
import javax.sound.midi.InvalidMidiDataException;
import javax.sound.midi.MidiChannel;
import javax.sound.midi.MidiSystem;
import javax.sound.midi.MidiUnavailableException;
import javax.sound.midi.Sequence;
import javax.sound.midi.Sequencer;
import javax.sound.midi.ShortMessage;
import javax.sound.midi.Synthesizer;

public class MidiManager
implements SoundManagerInterface {
    private int resourceNum;
    private Sequencer[] sequencer = null;
    private Synthesizer synthesizer = null;
    private boolean[] loopFlag = null;
    private int[] volume = null;
    private static final int CHANGE_VOLUME = 7;
    private static MidiManager instance = null;

    private void MidiManager() {
        this.resourceNum = 0;
    }

    public static MidiManager getInstance() {
        if (instance == null) {
            instance = new MidiManager();
        }
        return instance;
    }

    @Override
    public void init(String string) {
        this.loadNumberingMidi(string);
        this.initSynthesizer();
    }

    private void loadNumberingMidi(String string) {
        String[] stringArray = new String[]{".mid"};
        this.resourceNum = ResourceUtil.getResourceLastID(string, stringArray);
        if (this.resourceNum <= 0) {
            return;
        }
        this.sequencer = new Sequencer[this.resourceNum];
        this.loopFlag = new boolean[this.resourceNum];
        this.volume = new int[this.resourceNum];
        for (int i = 0; i < this.resourceNum; ++i) {
            this.sequencer[i] = this.loadMidi(string + i + ".mid");
            if (this.sequencer[i] == null) break;
        }
    }

    private Sequencer loadMidi(String string) {
        try {
            Sequencer sequencer = MidiSystem.getSequencer();
            sequencer.open();
            InputStream inputStream = null;
            inputStream = this.getClass().getResourceAsStream("/" + string);
            Sequence sequence = MidiSystem.getSequence(inputStream);
            sequencer.setSequence(sequence);
            inputStream.close();
            return sequencer;
        }
        catch (Exception exception) {
            System.out.println("loadMidi Exception " + string + " " + exception);
            return null;
        }
    }

    @Override
    public void playSound(int n, boolean bl) {
        try {
            this.loopFlag[n] = bl;
            this.sequencer[n].start();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    @Override
    public void pauseSound(int n) {
        try {
            this.sequencer[n].stop();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    @Override
    public void stopSound(int n) {
        try {
            this.sequencer[n].stop();
            this.sequencer[n].setTickPosition(0L);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    @Override
    public void changeVolume(int n, int n2) {
        try {
            if (n2 < 0) {
                n2 = 0;
            } else if (n2 > 100) {
                n2 = 100;
            }
            this.volume[n] = n2 * 127 / 100;
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void setVolume(int n, int n2) {
        block8: {
            int n3 = n2;
            try {
                if (this.synthesizer.getDefaultSoundbank() == null) {
                    try {
                        ShortMessage shortMessage = new ShortMessage();
                        for (int i = 0; i < 16; ++i) {
                            shortMessage.setMessage(176, i, 7, n3);
                            MidiSystem.getReceiver().send(shortMessage, -1L);
                        }
                        break block8;
                    }
                    catch (InvalidMidiDataException invalidMidiDataException) {
                        System.err.println("Invalid MIDI data.");
                        return;
                    }
                    catch (MidiUnavailableException midiUnavailableException) {
                        System.err.println("MIDI unavailable.");
                        return;
                    }
                }
                MidiChannel[] midiChannelArray = this.synthesizer.getChannels();
                for (int i = 0; midiChannelArray != null && i < midiChannelArray.length; ++i) {
                    midiChannelArray[i].controlChange(7, n3);
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    @Override
    public void update() {
        for (int i = 0; i < this.resourceNum; ++i) {
            try {
                this.setVolume(i, this.volume[i]);
                if (this.sequencer[i] == null || this.sequencer[i].getTickLength() > this.sequencer[i].getTickPosition()) continue;
                this.sequencer[i].stop();
                this.sequencer[i].setTickPosition(0L);
                this.sequencer[i].start();
                continue;
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    @Override
    public void pauseSound() {
        for (int i = 0; i < this.resourceNum; ++i) {
            this.pauseSound(i);
        }
    }

    @Override
    public void stopSound() {
        for (int i = 0; i < this.resourceNum; ++i) {
            this.stopSound(i);
        }
    }

    @Override
    public void changeVolume(int n) {
        for (int i = 0; i < this.resourceNum; ++i) {
            this.changeVolume(i, n);
        }
    }

    private void initSynthesizer() {
        if (this.resourceNum <= 0) {
            return;
        }
        try {
            if (!(this.sequencer[0] instanceof Synthesizer)) {
                this.synthesizer = MidiSystem.getSynthesizer();
                this.synthesizer.open();
                if (this.synthesizer.getDefaultSoundbank() == null) {
                    for (int i = 0; i < this.resourceNum; ++i) {
                        this.sequencer[i].getTransmitter().setReceiver(MidiSystem.getReceiver());
                    }
                } else {
                    for (int i = 0; i < this.resourceNum; ++i) {
                        this.sequencer[i].getTransmitter().setReceiver(this.synthesizer.getReceiver());
                    }
                }
            } else {
                this.synthesizer = (Synthesizer)((Object)this.sequencer[0]);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }
}

