/*
 * Decompiled with CFR 0.152.
 */
package gameCanvasUtil.Resource;

import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;

public class InputManager {
    public static final int BUTTON_UP = 0;
    public static final int BUTTON_DOWN = 1;
    public static final int BUTTON_LEFT = 2;
    public static final int BUTTON_RIGHT = 3;
    public static final int BUTTON_A = 4;
    public static final int BUTTON_B = 5;
    public static final int BUTTON_C = 6;
    public static final int BUTTON_D = 7;
    public static final int BUTTON_PAUSE = 8;
    public static final int BUTTON_L = 9;
    public static final int BUTTON_R = 10;
    public static final int BUTTON_SELECT = 11;
    private static final int[] KEYLIST = new int[]{38, 40, 37, 39, 90, 88, 67, 86, 10, 65, 83, 32};
    private int[] Push_Key_State = new int[KEYLIST.length];
    private boolean[] keyReleaseFlag = new boolean[KEYLIST.length];
    private boolean[] keyPushFlag = new boolean[KEYLIST.length];
    private int mouse_x = 0;
    private int mouse_y = 0;
    private int mouse_click_time = 0;
    private static InputManager instance = null;

    public static InputManager getInstance() {
        if (instance == null) {
            instance = new InputManager();
        }
        return instance;
    }

    private InputManager() {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
        this.mouse_x = mouseEvent.getX();
        this.mouse_y = mouseEvent.getY();
    }

    public void mouseExited(MouseEvent mouseEvent) {
        this.mouse_x = mouseEvent.getX();
        this.mouse_y = mouseEvent.getY();
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        this.mouse_x = mouseEvent.getX();
        this.mouse_y = mouseEvent.getY();
    }

    public void mousePressed(MouseEvent mouseEvent) {
        this.mouse_x = mouseEvent.getX();
        this.mouse_y = mouseEvent.getY();
        this.mouse_click_time = 1;
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        this.mouse_x = mouseEvent.getX();
        this.mouse_y = mouseEvent.getY();
        this.mouse_click_time = -1;
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        this.mouse_x = mouseEvent.getX();
        this.mouse_y = mouseEvent.getY();
    }

    public void mouseMoved(MouseEvent mouseEvent) {
        this.mouse_x = mouseEvent.getX();
        this.mouse_y = mouseEvent.getY();
    }

    public int getMouseX() {
        return this.mouse_x;
    }

    public int getMouseY() {
        return this.mouse_y;
    }

    public int getMouseClickLength() {
        return this.mouse_click_time;
    }

    public boolean isMousePushed() {
        return this.mouse_click_time == 1;
    }

    public boolean isMouseReleased() {
        return this.mouse_click_time == -1;
    }

    public boolean isMousePress() {
        return this.mouse_click_time >= 1;
    }

    public void updateKeyData() {
        int n;
        for (n = 0; n < KEYLIST.length; ++n) {
            if (this.Push_Key_State[n] == 0) continue;
            int n2 = n;
            this.Push_Key_State[n2] = this.Push_Key_State[n2] + 1;
        }
        for (n = 0; n < KEYLIST.length; ++n) {
            if (this.keyPushFlag[n] && this.getKeyState(n) == 0) {
                this.Push_Key_State[n] = 1;
            } else if (this.keyReleaseFlag[n] && this.getKeyState(n) > 0) {
                this.Push_Key_State[n] = -1;
                this.keyReleaseFlag[n] = false;
            }
            this.keyPushFlag[n] = false;
        }
        if (this.mouse_click_time != 0) {
            ++this.mouse_click_time;
        }
    }

    public synchronized void keyPressed(KeyEvent keyEvent) {
        int n = keyEvent.getKeyCode();
        for (int i = 0; i < KEYLIST.length; ++i) {
            if (KEYLIST[i] != n) continue;
            this.keyPushFlag[i] = true;
            break;
        }
    }

    public synchronized void keyReleased(KeyEvent keyEvent) {
        int n = keyEvent.getKeyCode();
        for (int i = 0; i < KEYLIST.length; ++i) {
            if (KEYLIST[i] != n) continue;
            this.keyReleaseFlag[i] = true;
            break;
        }
    }

    public void keyTyped(KeyEvent keyEvent) {
    }

    private int getKeyState(int n) {
        if (n < 0 || n >= KEYLIST.length) {
            return -1;
        }
        return this.Push_Key_State[n];
    }

    public int getKeyPressLength(int n) {
        return this.getKeyState(n);
    }

    public boolean isKeyPressed(int n) {
        return this.getKeyState(n) > 0;
    }

    public boolean isKeyPushed(int n) {
        return this.getKeyState(n) == 1;
    }

    public boolean isKeyReleased(int n) {
        return this.getKeyState(n) < 0;
    }
}

