/*
 * Decompiled with CFR 0.152.
 */
package gameCanvasUtil.Resource;

import gameCanvasUtil.Resource.ResourceUtil;
import gameCanvasUtil.Resource.SoundManagerInterface;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.FloatControl;
import javax.sound.sampled.SourceDataLine;

public class StreamSoundManager
implements SoundManagerInterface {
    private int resourceNum;
    private AudioInputStream[] audioInputStream = null;
    private SourceDataLine[] line = null;
    private boolean[] loopFlag = null;
    private int[] bind = null;
    private static final int EXTERNAL_BUFFER_SIZE = 4266;
    private static final int LINE_BUFFER_NUM = 1;
    private int[] volume = null;
    private byte[] abData = new byte[4266];
    private String[] fileNameList = null;
    private static StreamSoundManager instance = null;

    private void StreamSoundManager() {
        this.resourceNum = 0;
    }

    public static StreamSoundManager getInstance() {
        if (instance == null) {
            instance = new StreamSoundManager();
        }
        return instance;
    }

    @Override
    public void init(String string) {
        int n;
        String[] stringArray = new String[]{".wav"};
        this.resourceNum = ResourceUtil.getResourceLastID(string, stringArray);
        if (this.resourceNum <= 0) {
            return;
        }
        this.fileNameList = new String[this.resourceNum];
        for (n = 0; n < this.resourceNum; ++n) {
            this.fileNameList[n] = string + n + ".wav";
        }
        this.audioInputStream = new AudioInputStream[1];
        this.line = new SourceDataLine[1];
        this.loopFlag = new boolean[1];
        this.bind = new int[1];
        this.volume = new int[1];
        for (n = 0; n < 1; ++n) {
            this.bind[n] = -1;
        }
    }

    private void loadAndPlaySound(int n, int n2) {
        try {
            this.audioInputStream[n] = AudioSystem.getAudioInputStream(this.getClass().getResourceAsStream("/" + this.fileNameList[n2]));
            AudioFormat audioFormat = this.audioInputStream[n].getFormat();
            DataLine.Info info = new DataLine.Info(SourceDataLine.class, audioFormat);
            this.line[n] = (SourceDataLine)AudioSystem.getLine(info);
            this.line[n].open(audioFormat);
            this.line[n].start();
            this.changeVolume(n, this.volume[n]);
            this.bind[n] = n2;
        }
        catch (Exception exception) {
            System.out.println("soundStream play Error " + exception);
            exception.printStackTrace();
        }
    }

    @Override
    public void update() {
        int n = 0;
        try {
            for (int i = 0; i < 1; ++i) {
                if (this.line[i] == null || !this.line[i].isOpen()) continue;
                n = this.audioInputStream[i].read(this.abData, 0, this.abData.length);
                if (n >= 0) {
                    this.line[i].write(this.abData, 0, n);
                    continue;
                }
                if (this.loopFlag[i]) {
                    this.loadAndPlaySound(i, this.bind[i]);
                    continue;
                }
                this.stopSound(i);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private int getFreeLineBuf() {
        try {
            for (int i = 0; i < 1; ++i) {
                if (this.line[i] != null && this.line[i].isOpen()) continue;
                return i;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return -1;
    }

    private void playSound(int n, int n2, boolean bl) {
        try {
            this.loopFlag[n] = bl;
            if (this.line[n] != null && this.line[n].isOpen()) {
                this.line[n].start();
            } else {
                this.loadAndPlaySound(n, n2);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    @Override
    public void playSound(int n, boolean bl) {
        int n2 = this.getFreeLineBuf();
        if (n2 >= 0) {
            this.playSound(n2, n, bl);
        } else {
            for (int i = 0; i < this.bind.length; ++i) {
                if (this.bind[i] != n) continue;
                this.playSound(i, n, bl);
            }
        }
    }

    @Override
    public void stopSound() {
        for (int i = 0; i < 1; ++i) {
            this.stopSound(i);
        }
    }

    @Override
    public void stopSound(int n) {
        try {
            this.line[n].drain();
            this.line[n].close();
            this.line[n] = null;
            this.bind[n] = -1;
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    @Override
    public void pauseSound(int n) {
        try {
            this.line[n].stop();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    @Override
    public void changeVolume(int n, int n2) {
        try {
            this.volume[n] = n2;
            FloatControl floatControl = (FloatControl)this.line[n].getControl(FloatControl.Type.MASTER_GAIN);
            float f = floatControl.getMaximum() - floatControl.getMinimum();
            floatControl.setValue(f * (float)Math.sqrt((float)n2 / 100.0f) + floatControl.getMinimum());
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    @Override
    public void pauseSound() {
        for (int i = 0; i < 1; ++i) {
            this.pauseSound(i);
        }
    }

    @Override
    public void changeVolume(int n) {
        for (int i = 0; i < 1; ++i) {
            this.changeVolume(i, n);
        }
    }
}

