//インポート
import gameCanvasUtil.*;

/** ゲームクラス。
 *
 * 学生が編集すべきソースコードです。
 */
public class Game extends GameBase
{
    /********* 変数定義はこちらに *********/
    // 型 変数名;　の順に書いて定義する
    // ボールのX座標
    int ball_x;
    // ボールのY座標
    int ball_y;
    // ボールのX方向の速度
    int ball_speed_x;
    // ボールのY方向の速度
    int ball_speed_y;
    // ボールの大きさ
    int ball_size;

    /********* 初期化の手順はこちらに *********/
    public void initGame()
    {
        // ボールの座標を初期化する
        ball_x = 0;
        ball_y = 0;

        // ボールの速度を 3 ～ 6 のランダムな数字で初期化する
        ball_speed_x = gc.rand(3, 6);
        ball_speed_y = gc.rand(3, 6);

        // ボールのサイズを初期化する
        ball_size = 24;
    }

    /********* 物体の移動等の更新処理はこちらに *********/
    public void updateGame()
    {
        // X方向に ball_speed_x ずつ進める
        ball_x = ball_x + ball_speed_x;

        // Y方向に ball_speed_y ずつ進める
        ball_y = ball_y + ball_speed_y;

        // ボールが画面の左を越えた場合
        if(ball_x < 0)
        {
            // ボールのX方向の速度を 3 ～ 6 のランダムな数字にする
            ball_speed_x = gc.rand(3, 6);
        }

        // ボールが画面の右を越えた場合
        if(ball_x > 640 - ball_size)
        {
            // ボールのX方向の速度を -3 ～ -6 のランダムな数字にする
            ball_speed_x = -gc.rand(3, 6);
        }

        // ボールが画面の上を越えた場合
        if(ball_y < 0)
        {
            // ボールのY方向の速度を 3 ～ 6 のランダムな数字にする
            ball_speed_y = gc.rand(3, 6);
        }

        // ボールが画面の下を越えた場合
        if(ball_y > 480 - ball_size)
        {
            // ボールのY方向の速度を -3 ～ -6 のランダムな数字にする
            ball_speed_y = -gc.rand(3, 6);
        }
    }

    /********* 画像の描画はこちらに *********/
    public void drawGame()
    {
        // 画面を白で塗りつぶします
        gc.clearScreen();

        // img0.png を(ball_x, ball_y)に描画します
        gc.drawImage(0, ball_x, ball_y);
    }

    /********* 終了時の処理はこちらに *********/
    public void finalGame() {}
}
