/*
 * Decompiled with CFR 0.152.
 */
import gameCanvasUtil.GameBase;

public class Game
extends GameBase {
    int player_x;
    int player_y;
    int player_w;
    int player_h;
    int[] shot_x = new int[10];
    int[] shot_y = new int[10];
    boolean[] shot_alive_flag = new boolean[10];
    int shot_speed_y;
    int shot_size;
    int next_alive_shot_num;
    int[] enemy_x = new int[10];
    int[] enemy_y = new int[10];
    int enemy_w;
    int enemy_h;
    int enemy_speed_y;
    boolean[] enemy_alive_flag = new boolean[10];
    int next_alive_enemy_num;
    int time;
    int score;
    int high_score;
    int gameState;

    @Override
    public void initGame() {
        int n;
        this.player_x = 270;
        this.player_y = 450;
        this.player_w = 50;
        this.player_h = 20;
        for (n = 0; n < 10; ++n) {
            this.shot_x[n] = 0;
            this.shot_y[n] = 0;
            this.shot_alive_flag[n] = false;
        }
        this.shot_speed_y = -20;
        this.shot_size = 24;
        this.next_alive_shot_num = 0;
        for (n = 0; n < 10; ++n) {
            this.enemy_x[n] = 0;
            this.enemy_y[n] = 0;
            this.enemy_alive_flag[n] = false;
        }
        this.enemy_w = 100;
        this.enemy_h = 20;
        this.enemy_speed_y = 5;
        this.next_alive_enemy_num = 0;
        this.time = 0;
        this.score = 0;
        this.high_score = this.gc.load(0);
        this.gameState = 0;
    }

    @Override
    public void updateGame() {
        if (this.gameState == 0) {
            if (this.gc.isKeyPushed(8)) {
                this.gameState = 1;
                this.gc.playBGM(0);
            }
        } else if (this.gameState == 1) {
            int n;
            if (this.gc.isKeyPushed(8)) {
                this.gameState = 2;
                this.gc.stopBGM();
            }
            if (this.gc.isKeyPress(2)) {
                this.player_x -= 5;
            }
            if (this.gc.isKeyPress(3)) {
                this.player_x += 5;
            }
            if (this.time % 30 == 0) {
                this.enemy_alive_flag[this.next_alive_enemy_num] = true;
                this.enemy_x[this.next_alive_enemy_num] = this.gc.rand(0, 640 - this.enemy_w);
                this.enemy_y[this.next_alive_enemy_num] = 0;
                ++this.next_alive_enemy_num;
                if (this.next_alive_enemy_num >= 10) {
                    this.next_alive_enemy_num = 0;
                }
            }
            for (n = 0; n < 10; ++n) {
                if (!this.enemy_alive_flag[n]) continue;
                this.enemy_y[n] = this.enemy_y[n] + this.enemy_speed_y;
                if (this.gc.checkHitRect(this.enemy_x[n], this.enemy_y[n], this.enemy_w, this.enemy_h, this.player_x, this.player_y, this.player_w, this.player_h)) {
                    this.gameState = 3;
                    this.gc.stopBGM();
                }
                if (this.enemy_y[n] <= 480) continue;
                this.enemy_alive_flag[n] = false;
            }
            if (this.gc.isKeyPushed(4)) {
                this.shot_alive_flag[this.next_alive_shot_num] = true;
                this.shot_x[this.next_alive_shot_num] = this.player_x + this.player_w / 2 - this.shot_size / 2;
                this.shot_y[this.next_alive_shot_num] = this.player_y + this.player_h / 2 - this.shot_size / 2;
                ++this.next_alive_shot_num;
                if (this.next_alive_shot_num >= 10) {
                    this.next_alive_shot_num = 0;
                }
            }
            block1: for (n = 0; n < 10; ++n) {
                if (!this.shot_alive_flag[n]) continue;
                this.shot_y[n] = this.shot_y[n] + this.shot_speed_y;
                if (this.shot_y[n] < -this.shot_size) {
                    this.shot_alive_flag[n] = false;
                }
                for (int i = 0; i < 10; ++i) {
                    if (!this.enemy_alive_flag[i] || !this.gc.checkHitRect(this.enemy_x[i], this.enemy_y[i], this.enemy_w, this.enemy_h, this.shot_x[n], this.shot_y[n], this.shot_size, this.shot_size)) continue;
                    this.enemy_alive_flag[i] = false;
                    this.shot_alive_flag[n] = false;
                    ++this.score;
                    if (this.high_score >= this.score) continue block1;
                    this.high_score = this.score;
                    continue block1;
                }
            }
            ++this.time;
            if (this.time >= 1800) {
                this.gameState = 4;
                this.gc.save(0, this.high_score);
                this.gc.stopBGM();
            }
        } else if (this.gameState == 2) {
            if (this.gc.isKeyPushed(8)) {
                this.gameState = 1;
                this.gc.playBGM(0);
            }
        } else if (this.gameState == 3 || this.gameState == 4) {
            // empty if block
        }
    }

    @Override
    public void drawGame() {
        this.gc.clearScreen();
        if (this.gameState == 0) {
            this.gc.setColor(0, 0, 0);
            this.gc.drawString("\u30b7\u30e5\u30fc\u30c6\u30a3\u30f3\u30b0\u30b2\u30fc\u30e0", 200, 150);
            this.gc.drawString("Push Enter", 260, 250);
        } else if (this.gameState == 1) {
            int n;
            for (n = 0; n < 10; ++n) {
                if (!this.shot_alive_flag[n]) continue;
                this.gc.drawImage(0, this.shot_x[n], this.shot_y[n]);
            }
            this.gc.setColor(255, 0, 0);
            for (n = 0; n < 10; ++n) {
                if (!this.enemy_alive_flag[n]) continue;
                this.gc.fillRect(this.enemy_x[n], this.enemy_y[n], this.enemy_w, this.enemy_h);
            }
            this.gc.setColor(0, 0, 255);
            this.gc.fillRect(this.player_x, this.player_y, this.player_w, this.player_h);
            this.gc.setColor(0, 0, 0);
            this.gc.drawString("Score:" + this.score, 0, 0);
            this.gc.drawString("HighScore:" + this.high_score, 0, 32);
        } else if (this.gameState == 2) {
            this.gc.setColor(0, 0, 0);
            this.gc.drawString("PAUSE", 280, 200);
        } else if (this.gameState == 3) {
            this.gc.setColor(0, 0, 0);
            this.gc.drawString("GAME OVER", 230, 200);
        } else if (this.gameState == 4) {
            this.gc.setColor(0, 0, 0);
            this.gc.drawString("RESULT", 280, 150);
            this.gc.drawString("Score:" + this.score, 290, 200);
            this.gc.drawString("HighScore:" + this.high_score, 260, 240);
        }
    }

    @Override
    public void finalGame() {
    }
}

