/*
 * Decompiled with CFR 0.152.
 */
package gameCanvasUtil.Resource;

import gameCanvasUtil.Resource.ResourceUtil;
import java.awt.Image;
import java.awt.Toolkit;
import java.io.File;
import java.io.InputStream;

public class ImageManager {
    private int resourceNum;
    private Image[] img = null;
    private byte[] imageBuffer = new byte[0x400000];
    private static ImageManager instance = null;

    private void ImageManager() {
        this.resourceNum = 0;
    }

    public static ImageManager getInstance() {
        if (instance == null) {
            instance = new ImageManager();
        }
        return instance;
    }

    public void init(String string) {
        this.loadNumberingImage(string);
    }

    private void loadNumberingImage(String string) {
        String[] stringArray = new String[]{".gif", ".GIF", ".png", ".PNG", ".jpg", ".JPG"};
        this.resourceNum = ResourceUtil.getResourceLastID(string, stringArray);
        if (this.resourceNum <= 0) {
            return;
        }
        this.img = new Image[this.resourceNum];
        block0: for (int i = 0; i < this.resourceNum; ++i) {
            for (int j = 0; j < stringArray.length; ++j) {
                File file = new File(string + i + stringArray[j]);
                if (!file.exists()) continue;
                this.img[i] = this.loadImage(string + i + stringArray[j]);
                if (this.img[i] != null) continue block0;
            }
        }
    }

    private Image loadImage(String string) {
        try {
            Image image = null;
            int n = 0;
            int n2 = 0;
            InputStream inputStream = this.getClass().getResourceAsStream("/" + string);
            if (inputStream == null) {
                return null;
            }
            while ((n2 = inputStream.read(this.imageBuffer, n, this.imageBuffer.length - n)) > 0) {
                n += n2;
            }
            inputStream.close();
            byte[] byArray = new byte[n];
            System.arraycopy(this.imageBuffer, 0, byArray, 0, n);
            image = Toolkit.getDefaultToolkit().createImage(byArray, 0, n);
            return image;
        }
        catch (Exception exception) {
            System.out.println("loadImage Exception " + string + "::" + exception);
            return null;
        }
    }

    public int getPicXsize(int n) {
        try {
            return this.img[n].getWidth(null);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return -1;
        }
    }

    public int getPicYsize(int n) {
        try {
            return this.img[n].getHeight(null);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return -1;
        }
    }

    public Image getImage(int n) {
        try {
            return this.img[n];
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }
}

