;;; -*- Mode: Lisp; Package: SYSTEM -*-
;;;
;;; This file is part of xyzzy.
;;;

(in-package "system")

(defmacro defun-builtin (name (&rest lambda-list) &optional doc)
  `(defun-builtin-1 ',name ',lambda-list ',doc))

(defun defun-builtin-1 (name lambda-list doc)
  (setf (get name 'builtin-function-argument)
	(if (stringp (car lambda-list)) (car lambda-list) lambda-list)))

(in-package "lisp")

(si::defun-builtin progn ("{FORM}*"))
(si::defun-builtin let ("({VAR|(VAR [VALUE])}*) {declaration}* {FORM}*"))
(si::defun-builtin let* ("({VAR|(VAR [VALUE])}*) {declaration}* {FORM}*"))
(si::defun-builtin if ("TEST THEN [ELSE]"))
(si::defun-builtin setq ("{VAR FORM}*"))
(si::defun-builtin block ("NAME {FORM}*"))
(si::defun-builtin return-from ("NAME [RESULT]"))
(si::defun-builtin tagbody ("{TAG|STATEMENT}*"))
(si::defun-builtin eval-when ("({SITUATION}*) {FORM}*"))
(si::defun-builtin unwind-protect ("PROTECTED-FORM {CLEANUP-FORM}*"))
(si::defun-builtin catch ("TAG {FORM}*"))
(si::defun-builtin flet ("({(NAME LAMBDA-LIST {declaration}* [doc-string] {FORM}*)}*) {FORM}*"))
(si::defun-builtin labels ("({(NAME LAMBDA-LIST {declaration}* [doc-string] {FORM}*)}*) {FORM}*"))
(si::defun-builtin macrolet ("({(NAME LAMBDA-LIST {declaration}* [doc-string] {FORM}*)}*) {FORM}*"))
(si::defun-builtin multiple-value-call ("FUNCTION {FORM}*"))
(si::defun-builtin multiple-value-prog1 ("FORM {FORM}*"))
(si::defun-builtin multiple-value-setq ("VARIABLES FORM"))
(si::defun-builtin multiple-value-bind ("({VAR}*) VALUES-FORM {declaration}* {FORM}*"))
(si::defun-builtin quote (object))
(si::defun-builtin function (fn))
(si::defun-builtin go (tag))
(si::defun-builtin throw (tag result))
(si::defun-builtin set (symbol value))
(si::defun-builtin symbol-value (symbol))
(si::defun-builtin special-form-p (symbol))
(si::defun-builtin macro-function (symbol))
(si::defun-builtin symbol-function (symbol))
(si::defun-builtin set-default (symbol value))
(si::defun-builtin default-value (symbol))
(si::defun-builtin boundp (symbol))
(si::defun-builtin fboundp (symbol))
(si::defun-builtin constantp (object))
(si::defun-builtin eval (form))
(si::defun-builtin funcall (fn &rest arguments))
(si::defun-builtin apply (function arg &rest more-args))
(si::defun-builtin evalhook (form evalhookfn applyhookfn &optional env))
(si::defun-builtin applyhook (function args evalhookfn applyhookfn))
(si::defun-builtin mapcar (function list &rest more-lists))
(si::defun-builtin maplist (function list &rest more-lists))
(si::defun-builtin mapc (function list &rest more-lists))
(si::defun-builtin mapl (function list &rest more-lists))
(si::defun-builtin values-list (list))
(si::defun-builtin macroexpand (form &optional env))
(si::defun-builtin macroexpand-1 (form &optional env))
(si::defun-builtin makunbound (symbol))
(si::defun-builtin fmakunbound (symbol))
(si::defun-builtin identity (object))
(si::defun-builtin type-of (object))
(si::defun-builtin null (object))
(si::defun-builtin symbolp (object))
(si::defun-builtin atom (object))
(si::defun-builtin consp (object))
(si::defun-builtin listp (object))
(si::defun-builtin numberp (object))
(si::defun-builtin integerp (object))
(si::defun-builtin rationalp (object))
(si::defun-builtin floatp (object))
(si::defun-builtin short-float-p (object))
(si::defun-builtin single-float-p (object))
(si::defun-builtin double-float-p (object))
(si::defun-builtin long-float-p (object))
(si::defun-builtin realp (object))
(si::defun-builtin complexp (object))
(si::defun-builtin characterp (object))
(si::defun-builtin stringp (object))
(si::defun-builtin simple-string-p (object))
(si::defun-builtin vectorp (object))
(si::defun-builtin simple-vector-p (object))
(si::defun-builtin arrayp (object))
(si::defun-builtin functionp (object))
(si::defun-builtin compiled-function-p (object))
(si::defun-builtin packagep (object))
(si::defun-builtin readtablep (object))
(si::defun-builtin eq (x y))
(si::defun-builtin eql (x y))
(si::defun-builtin equal (x y))
(si::defun-builtin equalp (x y))
(si::defun-builtin get (symbol indicator &optional default))
(si::defun-builtin remprop (symbol indicator))
(si::defun-builtin symbol-plist (symbol))
(si::defun-builtin getf (place indicator &optional default))
(si::defun-builtin get-properties (place indicator-list))
(si::defun-builtin symbol-name (symbol))
(si::defun-builtin make-symbol (print-name))
(si::defun-builtin copy-symbol (symbol &optional copy-props))
(si::defun-builtin symbol-package (symbol))
(si::defun-builtin keywordp (object))
(si::defun-builtin car (list))
(si::defun-builtin cdr (list))
(si::defun-builtin cons (x y))
(si::defun-builtin tree-equal (x y &key :test :test-not))
(si::defun-builtin endp (object))
(si::defun-builtin list-length (list))
(si::defun-builtin nth (n list))
(si::defun-builtin nthcdr (n list))
(si::defun-builtin last (list &optional (n 1)))
(si::defun-builtin list (&rest args))
(si::defun-builtin list* (&rest args))
(si::defun-builtin make-list (size &key :initial-element))
(si::defun-builtin append (&rest lists))
(si::defun-builtin copy-list (list))
(si::defun-builtin copy-alist (list))
(si::defun-builtin copy-tree (object))
(si::defun-builtin revappend (x y))
(si::defun-builtin nconc (&rest lists))
(si::defun-builtin nreconc (x y))
(si::defun-builtin rplaca (x y))
(si::defun-builtin rplacd (x y))
(si::defun-builtin subst (new old tree &key :test :test-not :key))
(si::defun-builtin subst-if (new test tree &key :key))
(si::defun-builtin subst-if-not (new test tree &key :key))
(si::defun-builtin nsubst (new old tree &key :test :test-not :key))
(si::defun-builtin nsubst-if (new test tree &key :key))
(si::defun-builtin nsubst-if-not (new test tree &key :key))
(si::defun-builtin sublis (alist tree &key :test :test-not :key))
(si::defun-builtin nsublis (alist tree &key :test :test-not :key))
(si::defun-builtin member (item list &key :test :test-not :key))
(si::defun-builtin member-if (predicate list &key :key))
(si::defun-builtin member-if-not (predicate list &key :key))
(si::defun-builtin adjoin (item list &key :test :test-not :key))
(si::defun-builtin acons (key datum a-list))
(si::defun-builtin pairlis (keys data &optional a-list))
(si::defun-builtin assoc (item a-list &key :test :test-not :key))
(si::defun-builtin assoc-if (predicate a-list &key :key))
(si::defun-builtin assoc-if-not (predicate a-list &key :key))
(si::defun-builtin rassoc (item a-list &key :test :test-not :key))
(si::defun-builtin rassoc-if (predicate a-list &key :key))
(si::defun-builtin rassoc-if-not (predicate a-list &key :key))
(si::defun-builtin make-hash-table (&key :test :size :rehash-size))
(si::defun-builtin hash-table-p (object))
(si::defun-builtin gethash (key hash-table &optional default))
(si::defun-builtin remhash (key hash-table))
(si::defun-builtin clrhash (hash-table))
(si::defun-builtin hash-table-count (hash-table))
(si::defun-builtin hash-table-rehash-size (hash-table))
(si::defun-builtin hash-table-size (hash-table))
(si::defun-builtin hash-table-test (hash-table))
(si::defun-builtin sxhash (object))
(si::defun-builtin sequencep (object))
(si::defun-builtin elt (sequence index))
(si::defun-builtin subseq (sequence start &optional end))
(si::defun-builtin copy-seq (sequence))
(si::defun-builtin length (sequence))
(si::defun-builtin reverse (sequence))
(si::defun-builtin nreverse (sequence))
(si::defun-builtin fill (sequence item &key :start :end))
(si::defun-builtin replace (sequence1 sequence2 &key :start1 :end1 :start2 :end2))
(si::defun-builtin remove (item sequence &key :from-end :test :test-not :start :end :count :key))
(si::defun-builtin remove-if (predicate sequence &key :from-end :start :end :count :key))
(si::defun-builtin remove-if-not (predicate sequence &key :from-end :start :end :count :key))
(si::defun-builtin delete (item sequence &key :from-end :test :test-not :start :end :count :key))
(si::defun-builtin delete-if (predicate sequence &key :from-end :start :end :count :key))
(si::defun-builtin delete-if-not (predicate sequence &key :from-end :start :end :count :key))
(si::defun-builtin find (item sequence &key :from-end :test :test-not :start :end :key))
(si::defun-builtin find-if (predicate sequence &key :from-end :start :end :key))
(si::defun-builtin find-if-not (predicate sequence &key :from-end :start :end :key))
(si::defun-builtin position (item sequence &key :from-end :test :test-not :start :end :key))
(si::defun-builtin position-if (predicate sequence &key :from-end :start :end :key))
(si::defun-builtin position-if-not (predicate sequence &key :from-end :start :end :key))
(si::defun-builtin stable-sort (sequence predicate &key :key))
(si::defun-builtin aref (array &rest subscripts))
(si::defun-builtin array-has-fill-pointer-p (array))
(si::defun-builtin array-total-size (array))
(si::defun-builtin array-element-type (array))
(si::defun-builtin array-rank (array))
(si::defun-builtin array-dimension (array axis-number))
(si::defun-builtin array-row-major-index (array &rest subscripts))
(si::defun-builtin row-major-aref (array index))
(si::defun-builtin adjustable-array-p (array))
(si::defun-builtin svref (simple-vector index))
(si::defun-builtin vector-push (new-element vector))
(si::defun-builtin vector-push-extend (new-element vector &optional extension))
(si::defun-builtin vector-pop (vector))
(si::defun-builtin fill-pointer (vector))
(si::defun-builtin copy-string (string))
(si::defun-builtin char (string index))
(si::defun-builtin schar (simple-string index))
(si::defun-builtin substring (string start &optional end))
(si::defun-builtin string= (string1 string2 &key :start1 :end1 :start2 :end2))
(si::defun-builtin string-equal (string1 string2 &key :start1 :end1 :start2 :end2))
(si::defun-builtin string/= (string1 string2 &key :start1 :end1 :start2 :end2))
(si::defun-builtin string-not-equal (string1 string2 &key :start1 :end1 :start2 :end2))
(si::defun-builtin string< (string1 string2 &key :start1 :end1 :start2 :end2))
(si::defun-builtin string-lessp (string1 string2 &key :start1 :end1 :start2 :end2))
(si::defun-builtin string> (string1 string2 &key :start1 :end1 :start2 :end2))
(si::defun-builtin string-greaterp (string1 string2 &key :start1 :end1 :start2 :end2))
(si::defun-builtin string<= (string1 string2 &key :start1 :end1 :start2 :end2))
(si::defun-builtin string-not-greaterp (string1 string2 &key :start1 :end1 :start2 :end2))
(si::defun-builtin string>= (string1 string2 &key :start1 :end1 :start2 :end2))
(si::defun-builtin string-not-lessp (string1 string2 &key :start1 :end1 :start2 :end2))
(si::defun-builtin string-trim (character-bag string))
(si::defun-builtin string-left-trim (character-bag string))
(si::defun-builtin string-right-trim (character-bag string))
(si::defun-builtin string-upcase (string &key :start :end))
(si::defun-builtin string-downcase (string &key :start :end))
(si::defun-builtin string-capitalize (string &key :start :end))
(si::defun-builtin nstring-upcase (string &key :start :end))
(si::defun-builtin nstring-downcase (string &key :start :end))
(si::defun-builtin nstring-capitalize (string &key :start :end))
(si::defun-builtin string (x))
(si::defun-builtin parse-integer (string &key :start :end :radix :junk-allowed))
(si::defun-builtin zerop (number))
(si::defun-builtin plusp (number))
(si::defun-builtin minusp (number))
(si::defun-builtin oddp (integer))
(si::defun-builtin evenp (integer))
(si::defun-builtin = (number &rest more-numbers))
(si::defun-builtin /= (number &rest more-numbers))
(si::defun-builtin < (number &rest more-numbers))
(si::defun-builtin > (number &rest more-numbers))
(si::defun-builtin <= (number &rest more-numbers))
(si::defun-builtin >= (number &rest more-numbers))
(si::defun-builtin max (number &rest more-numbers))
(si::defun-builtin min (number &rest more-numbers))
(si::defun-builtin + (&rest numbers))
(si::defun-builtin - (number &rest more-numbers))
(si::defun-builtin * (&rest numbers))
(si::defun-builtin / (number &rest more-numbers))
(si::defun-builtin conjugate (number))
(si::defun-builtin gcd (&rest integers))
(si::defun-builtin lcm (integer &rest more-integers))
(si::defun-builtin exp (number))
(si::defun-builtin expt (base-number power-number))
(si::defun-builtin log (number &optional base))
(si::defun-builtin sqrt (number))
(si::defun-builtin isqrt (integer))
(si::defun-builtin abs (number))
(si::defun-builtin signum (number))
(si::defun-builtin sin (radians))
(si::defun-builtin cos (radians))
(si::defun-builtin tan (radians))
(si::defun-builtin asin (number))
(si::defun-builtin acos (number))
(si::defun-builtin atan (y &optional x))
(si::defun-builtin float (number &optional other))
(si::defun-builtin rational (number))
(si::defun-builtin rationalize (number))
(si::defun-builtin complex (realpart &optional imagpart))
(si::defun-builtin realpart (number))
(si::defun-builtin imagpart (number))
(si::defun-builtin numerator (rational))
(si::defun-builtin denominator (rational))
(si::defun-builtin floor (number &optional divisor))
(si::defun-builtin ceiling (number &optional divisor))
(si::defun-builtin truncate (number &optional divisor))
(si::defun-builtin round (number &optional divisor))
(si::defun-builtin mod (number divisor))
(si::defun-builtin rem (number divisor))
(si::defun-builtin ffloor (number &optional divisor))
(si::defun-builtin fceiling (number &optional divisor))
(si::defun-builtin ftruncate (number &optional divisor))
(si::defun-builtin fround (number &optional divisor))
(si::defun-builtin decode-float (float))
(si::defun-builtin scale-float (float integer))
(si::defun-builtin float-radix (float))
(si::defun-builtin float-sign (float1 &optional float2))
(si::defun-builtin float-digits (float))
(si::defun-builtin float-precision (float))
(si::defun-builtin boole (op integer1 integer2))
(si::defun-builtin lognot (integer))
(si::defun-builtin logtest (integer1 integer2))
(si::defun-builtin logbitp (index integer))
(si::defun-builtin ash (integer count))
(si::defun-builtin logcount (integer))
(si::defun-builtin integer-length (integer))
(si::defun-builtin standard-char-p (char))
(si::defun-builtin graphic-char-p (char))
(si::defun-builtin alpha-char-p (char))
(si::defun-builtin upper-case-p (char))
(si::defun-builtin lower-case-p (char))
(si::defun-builtin both-case-p (char))
(si::defun-builtin digit-char-p (char &optional (radix 10)))
(si::defun-builtin alphanumericp (char))
(si::defun-builtin char= (character &rest more-characters))
(si::defun-builtin char/= (character &rest more-characters))
(si::defun-builtin char< (character &rest more-characters))
(si::defun-builtin char> (character &rest more-characters))
(si::defun-builtin char<= (character &rest more-characters))
(si::defun-builtin char>= (character &rest more-characters))
(si::defun-builtin char-equal (character &rest more-characters))
(si::defun-builtin char-not-equal (character &rest more-characters))
(si::defun-builtin char-lessp (character &rest more-characters))
(si::defun-builtin char-greaterp (character &rest more-characters))
(si::defun-builtin char-not-greaterp (character &rest more-characters))
(si::defun-builtin char-not-lessp (character &rest more-characters))
(si::defun-builtin char-code (char))
(si::defun-builtin code-char (code))
(si::defun-builtin char-upcase (char))
(si::defun-builtin char-downcase (char))
(si::defun-builtin digit-char (weight &optional (radix 10)))
(si::defun-builtin character (object))
(si::defun-builtin write (object &key :stream :escape :pretty :base :radix :circle :level :length :readably))
(si::defun-builtin write-char (character &optional output-stream))
(si::defun-builtin terpri (&optional output-stream))
(si::defun-builtin fresh-line (&optional output-stream))
(si::defun-builtin finish-output (&optional output-stream))
(si::defun-builtin write-to-string (object &key :escape :pretty :base :radix :circle :level :length :readably))
(si::defun-builtin format (destination control-string &rest arguments))
(si::defun-builtin stack-trace (&optional stream))
(si::defun-builtin merge-pathnames (pathname &optional defaults))
(si::defun-builtin namestring (pathname))
(si::defun-builtin file-namestring (pathname))
(si::defun-builtin directory-namestring (pathname))
(si::defun-builtin pathname-host (pathname))
(si::defun-builtin pathname-device (pathname))
(si::defun-builtin pathname-directory (pathname))
(si::defun-builtin pathname-name (pathname))
(si::defun-builtin pathname-type (pathname))
(si::defun-builtin truename (pathname))
(si::defun-builtin file-exist-p (pathname))
(si::defun-builtin file-readable-p (pathname))
(si::defun-builtin file-writable-p (pathname))
(si::defun-builtin file-executable-p (pathname))
(si::defun-builtin file-directory-p (pathname))
(si::defun-builtin special-file-p (pathname))
(si::defun-builtin path-equal (pathname1 pathname2))
(si::defun-builtin sub-directory-p (directory parent))
(si::defun-builtin valid-path-p (pathname))
(si::defun-builtin check-valid-pathname (pathname))
(si::defun-builtin user-homedir-pathname ())
(si::defun-builtin compile-file-pathname (pathname))
(si::defun-builtin delete-file (file &key :if-does-not-exist :if-access-denied :recycle))
(si::defun-builtin rename-file (file new-name :if-exists :if-access-denied))
(si::defun-builtin copy-file (file new-file :if-exists :copy-attributes :if-access-denied))
(si::defun-builtin create-directory (dirname &key :if-exists))
(si::defun-builtin delete-directory (dirname &key :if-does-not-exist :if-access-denied))
(si::defun-builtin directory (pathname &key :absolute :recursive :wild :depth :file-only :show-dots :count :directory-only :callback :file-info))
(si::defun-builtin wild-pathname-p (pathname))
(si::defun-builtin pathname-match-p (pathname wildname))
(si::defun-builtin streamp (object))
(si::defun-builtin open-stream-p (stream))
(si::defun-builtin input-stream-p (stream))
(si::defun-builtin output-stream-p (stream))
(si::defun-builtin synonym-stream-p (stream))
(si::defun-builtin broadcast-stream-p (stream))
(si::defun-builtin concatenated-stream-p (stream))
(si::defun-builtin echo-stream-p (stream))
(si::defun-builtin two-way-stream-p (stream))
(si::defun-builtin string-stream-p (stream))
(si::defun-builtin string-input-stream-p (stream))
(si::defun-builtin string-output-stream-p (stream))
(si::defun-builtin open (filename &key :direction :if-exists :if-does-not-exist :encoding :share))
(si::defun-builtin file-length (pathname))
(si::defun-builtin file-write-time (filename))
(si::defun-builtin set-file-write-time (filename universal-time))
(si::defun-builtin file-position (file-stream &optional position))
(si::defun-builtin make-synonym-stream (symbol))
(si::defun-builtin make-broadcast-stream (&rest streams))
(si::defun-builtin make-concatenated-stream (&rest streams))
(si::defun-builtin make-two-way-stream (input-stream output-stream))
(si::defun-builtin make-echo-stream (input-stream output-stream))
(si::defun-builtin make-string-input-stream (string &optional start end))
(si::defun-builtin make-string-output-stream ())
(si::defun-builtin get-output-stream-string ())
(si::defun-builtin close (stream &key :abort))
(si::defun-builtin broadcast-stream-streams (broadcast-stream))
(si::defun-builtin concatenated-stream-streams (concatenated-stream))
(si::defun-builtin echo-stream-input-stream (echo-stream))
(si::defun-builtin echo-stream-output-stream (echo-stream))
(si::defun-builtin two-way-stream-input-stream (two-way-stream))
(si::defun-builtin two-way-stream-output-stream (two-way-stream))
(si::defun-builtin synonym-stream-symbol (synonym-stream))
(si::defun-builtin interactive-stream-p (stream))
(si::defun-builtin read (&optional input-stream eof-error-p eof-value recursive-p))
(si::defun-builtin read-line (&optional input-stream eof-error-p eof-value recursive-p))
(si::defun-builtin read-char (&optional input-stream eof-error-p eof-value recursive-p))
(si::defun-builtin unread-char (character &optional input-stream))
(si::defun-builtin peek-char (&optional peek-type input-stream eof-error-p eof-value recursive-p))
(si::defun-builtin listen (&optional input-stream))
(si::defun-builtin read-char-no-hang (&optional input-stream eof-error-p eof-value))
(si::defun-builtin clear-input (&optional input-stream))
(si::defun-builtin load (filename &key :verbose :print :if-does-not-exist))
(si::defun-builtin find-load-path (filename))
(si::defun-builtin copy-readtable (&optional from-readtable to-readtable))
(si::defun-builtin read-preserving-whitespace (&optional in-stream eof-error-p eof-value recursive-p))
(si::defun-builtin set-syntax-from-char (to-char from-char &optional to-readtable from-readtable))
(si::defun-builtin set-macro-character (char function &optional non-terminating-p readtable))
(si::defun-builtin get-macro-character (char &optional readtable))
(si::defun-builtin make-dispatch-macro-character (char &optional non-terminating-p readtable))
(si::defun-builtin set-dispatch-macro-character (disp-char sub-char function &optional readtable))
(si::defun-builtin get-dispatch-macro-character (disp-char sub-char &optional readtable))
(si::defun-builtin read-delimited-list (char &optional input-stream recursive-p))
(si::defun-builtin readtable-case (readtable))
(si::defun-builtin make-package (package-name &key :nicknames :use :internal-size :external-size))
(si::defun-builtin find-package (name))
(si::defun-builtin package-name (package))
(si::defun-builtin package-nicknames (package))
(si::defun-builtin rename-package (package new-name &optional new-nicknames))
(si::defun-builtin package-use-list (package))
(si::defun-builtin package-used-by-list (package))
(si::defun-builtin package-shadowing-symbols (package))
(si::defun-builtin list-all-packages ())
(si::defun-builtin delete-package (package))
(si::defun-builtin intern (string &optional package))
(si::defun-builtin find-symbol (string &optional package))
(si::defun-builtin unintern (symbol &optional package))
(si::defun-builtin export (symbols &optional package))
(si::defun-builtin unexport (symbols &optional package))
(si::defun-builtin import (symbols &optional package))
(si::defun-builtin shadowing-import (symbols &optional package))
(si::defun-builtin shadow (symbols &optional package))
(si::defun-builtin use-package (packages-to-use &optional package))
(si::defun-builtin unuse-package (packages-to-unuse &optional package))
(si::defun-builtin random (number &optional state))
(si::defun-builtin make-random-state (&optional state))
(si::defun-builtin random-state-p (object))
(si::defun-builtin gc (&optional no-message))
(si::defun-builtin get-decoded-time ())
(si::defun-builtin get-universal-time ())
(si::defun-builtin decode-universal-time (universal-time &optional time-zone))
(si::defun-builtin encode-universal-time (second minute hour date month year &optional time-zone))
(si::defun-builtin get-internal-real-time ())
(si::defun-builtin software-type ())
(si::defun-builtin software-version ())

(gc)

(in-package "system")

(si::defun-builtin *byte-code ("BYTE-STRING [PARAMETERS]"))
(si::defun-builtin *specialp (object))
(si::defun-builtin *make-constant (symbol))
(si::defun-builtin *make-special (symbol))
(si::defun-builtin *fset (symbol function))
(si::defun-builtin *bq-completely-process (form))
(si::defun-builtin *remf (place indicator))
(si::defun-builtin *putprop (symbol value indicator))
(si::defun-builtin *putf (place value indicator))
(si::defun-builtin *set-symbol-plist (symbol plist))
(si::defun-builtin *throw-error (condition))
(si::defun-builtin *report-simple-condition (condition stream))
(si::defun-builtin *report-target-missing (condition stream))
(si::defun-builtin *report-file-error (condition stream))
(si::defun-builtin *report-file-lost-error (condition stream))
(si::defun-builtin *report-no-target-for (condition stream))
(si::defun-builtin *report-reader-error (condition stream))
(si::defun-builtin *report-simple-package-error (condition stream))
(si::defun-builtin *tree-find (item tree &key :test :test-not :key))
(si::defun-builtin *tree-count (item tree &key :test :test-not :key))
(si::defun-builtin *aset (array value indexes))
(si::defun-builtin *make-array (dimensions element-type initial-element adjustable-p displaced-to displaced-index-offset))
(si::defun-builtin *row-major-aset (array index value))
(si::defun-builtin *replace-array (array1 array2))
(si::defun-builtin *make-vector (dimension element-type initial-element adjustable-p fill-pointer displaced-to displaced-index-offset))
(si::defun-builtin *svset (vector index value))
(si::defun-builtin *set-fill-pointer (vector fill-pointer))
(si::defun-builtin *set-vector-length (vector length))
(si::defun-builtin *set-char (string index char))
(si::defun-builtin *set-schar (string index char))
(si::defun-builtin *puthash (key hash-table value))
(si::defun-builtin *enum-hash-table (hash-table index))
(si::defun-builtin *set-elt (sequence index value))
(si::defun-builtin *copy-into-seq (result-sequence &rest sequences))
(si::defun-builtin *make-string-output-stream-from-string (string))
(si::defun-builtin *get-string-input-stream-index (stream))
(si::defun-builtin *package-internal (package))
(si::defun-builtin *package-external (package))
(si::defun-builtin *package-summary (package))
(si::defun-builtin *print-condition (condition))
(si::defun-builtin *condition-string (condition))
(si::defun-builtin *stream-column (&optional stream))
(si::defun-builtin *stream-line-number (&optional stream))
(si::defun-builtin *startup ())
(si::defun-builtin *minibuffer-message (message &optional prompt-p))
(si::defun-builtin *show-window-foreground ())
(si::defun-builtin *activate-toplevel ())
(si::defun-builtin *create-wait-object ())
(si::defun-builtin *add-wait-object (wait-object &optional buffer))
(si::defun-builtin *remove-wait-object (wait-object &optional buffer))
(si::defun-builtin *ratiop (object))
(si::defun-builtin *builtin-function-p (object))
(si::defun-builtin *c-callable-p (object))
(si::defun-builtin *dll-function-p (object))
(si::defun-builtin *bignump (object))
(si::defun-builtin *fixnump (object))
(si::defun-builtin *simple-array-p (object))
(si::defun-builtin closure-variable (closure))
(si::defun-builtin closure-function (closure))
(si::defun-builtin closure-frame (closure))
(si::defun-builtin closure-body (closure))
(si::defun-builtin *closurep (object))
(si::defun-builtin *structure-definition-p (object))
(si::defun-builtin *make-structure-definition (name type include constructors print-function named slots &optional report important))
(si::defun-builtin *structure-definition-name (structure-definition))
(si::defun-builtin *structure-definition-type (structure-definition))
(si::defun-builtin *structure-definition-constructors (structure-definition))
(si::defun-builtin *structure-definition-add-constructor (structure-definition constructor))
(si::defun-builtin *structure-definition-print-function (structure-definition))
(si::defun-builtin *structure-definition-report (structure-definition))
(si::defun-builtin *structure-definition-nslots ())
(si::defun-builtin *structure-definition-slot-description (structure-definition))
(si::defun-builtin *structure-definition-named-p (structure-definition))
(si::defun-builtin *structure-definition-read-only-p (structure-definition))
(si::defun-builtin *structure-definition-important-p ())
(si::defun-builtin *make-structure-data (structure-definition))
(si::defun-builtin *copy-structure-data (from-structure))
(si::defun-builtin *structurep (object))
(si::defun-builtin *structure-definition (structure))
(si::defun-builtin *slot-index (structure-definition slot))
(si::defun-builtin *slot-value (structure slot))
(si::defun-builtin *set-slot-value (structure slot value))
(si::defun-builtin *index-slot-value (structure index))
(si::defun-builtin *set-index-slot-value (structure index value))
(si::defun-builtin *structure-subtypep (type1 type2))
(si::defun-builtin *structure-reader (name args))
(si::defun-builtin system-root ())
(si::defun-builtin getenv (variable))
(si::defun-builtin make-chunk (type size &optional source offset))
(si::defun-builtin make-string-chunk (string))
(si::defun-builtin chunk-data (chunk))
(si::defun-builtin chunk-size (chunk))
(si::defun-builtin chunk-type (chunk))
(si::defun-builtin chunk-owner (chunk))
(si::defun-builtin address-of (chunk))
(si::defun-builtin fill-chunk (chunk byte &optional offset size))
(si::defun-builtin clear-chunk (chunk &optional offset size))
(si::defun-builtin copy-chunk (from-chunk to-chunk &optional size from-offset to-offset))
(si::defun-builtin unpack-int8 (chunk offset))
(si::defun-builtin unpack-uint8 (chunk offset))
(si::defun-builtin unpack-int16 (chunk offset))
(si::defun-builtin unpack-uint16 (chunk offset))
(si::defun-builtin unpack-int32 (chunk offset))
(si::defun-builtin unpack-uint32 (chunk offset))
(si::defun-builtin unpack-float (chunk offset))
(si::defun-builtin unpack-double (chunk offset))
(si::defun-builtin unpack-string (chunk offset size &optional zero-terminating-p))
(si::defun-builtin pack-int8 (chunk offset value))
(si::defun-builtin pack-uint8 (chunk offset value))
(si::defun-builtin pack-int16 (chunk offset value))
(si::defun-builtin pack-uint16 (chunk offset value))
(si::defun-builtin pack-int32 (chunk offset value))
(si::defun-builtin pack-uint32 (chunk offset value))
(si::defun-builtin pack-float (chunk offset value))
(si::defun-builtin pack-double (chunk offset value))
(si::defun-builtin pack-string (chunk offset value &optional size))
(si::defun-builtin load-dll-module (module-name))
(si::defun-builtin make-c-function (module name args result-type))
(si::defun-builtin make-c-callable (function args result-type))
(si::defun-builtin base64-decode (input-string-or-stream &optional output-stream fold-width))
(si::defun-builtin base64-encode (input-string-or-stream &optional output-stream))
(si::defun-builtin uuencode (input-string-or-stream &optional output-stream))
(si::defun-builtin uudecode (input-string-or-stream &optional output-stream))
(si::defun-builtin quoted-printable-decode (input-string-or-stream &optional output-stream underscore-to-space))
(si::defun-builtin quoted-printable-encode (input-string-or-stream &optional output-stream space-to-underscore))
(si::defun-builtin www-url-encode (input-string-or-stream &optional output-stream literal-chars))
(si::defun-builtin www-url-decode (input-string-or-stream &optional output-stream))
(si::defun-builtin binhex-decode (input-string-or-stream &optional output-stream))
(si::defun-builtin md5 (input-string-or-stream))
(si::defun-builtin sha-1 (input-string-or-stream))
(si::defun-builtin hmac-md5 (key input-string-or-stream))
(si::defun-builtin hmac-sha-1 (key input-string-or-stream))
(si::defun-builtin inflate-stream (input-string-or-stream &optional output-stream))
(si::defun-builtin *load-library (filename &key :no-suffix :if-does-not-exist :no-message))
(si::defun-builtin *set-readtable-case (readtable case))
(si::defun-builtin |\"-reader| (stream c))
(si::defun-builtin |'-reader| (stream c))
(si::defun-builtin |(-reader| (stream c))
(si::defun-builtin |)-reader| (stream c))
(si::defun-builtin |\;-reader| (stream c))
(si::defun-builtin |,-reader| (stream c))
(si::defun-builtin |`-reader| (stream c))
(si::defun-builtin |#-reader| (stream c))
(si::defun-builtin |#\\-reader| (stream c))
(si::defun-builtin |#'-reader| (stream c))
(si::defun-builtin |#(-reader| (stream c param))
(si::defun-builtin |#:-reader| (stream c param))
(si::defun-builtin |#.-reader| (stream c param))
(si::defun-builtin |#B-reader| (stream c param))
(si::defun-builtin |#O-reader| (stream c param))
(si::defun-builtin |#X-reader| (stream c param))
(si::defun-builtin |#R-reader| (stream c param))
(si::defun-builtin |#S-reader| (stream c param))
(si::defun-builtin |#C-reader| (stream c param))
(si::defun-builtin |#A-reader| (stream c param))
(si::defun-builtin |#=-reader| (stream c param))
(si::defun-builtin |##-reader| (stream c param))
(si::defun-builtin |#+-reader| (stream c param))
(si::defun-builtin |#--reader| (stream c param))
(si::defun-builtin |#\|-reader| (stream c param))
(si::defun-builtin *instance-number ())
(si::defun-builtin plugin-arg ())
(si::defun-builtin *snarf-documentation (path list))
(si::defun-builtin get-documentation-string (symbol indicator apropos-p path))
(si::defun-builtin delete-registry-tree ())
(si::defun-builtin performance-counter ())

(gc)

(in-package "editor")

(si::defun-builtin interactive ("{INTERACTIVE-STRING {PARAMETER}*|LIST}"))
(si::defun-builtin save-excursion ("{FORM}*"))
(si::defun-builtin save-restriction ("{FORM}*"))
(si::defun-builtin save-window-excursion ("{FORM}*"))
(si::defun-builtin make-local-variable (symbol))
(si::defun-builtin make-variable-buffer-local (symbol))
(si::defun-builtin local-variable-p (symbol &optional buffer))
(si::defun-builtin kill-all-local-variables ())
(si::defun-builtin kill-local-variable (symbol))
(si::defun-builtin command-execute (command &optional hook))
(si::defun-builtin interactive-p ())
(si::defun-builtin commandp (object))
(si::defun-builtin buffer-local-value (buffer symbol))
(si::defun-builtin write-registry (section key value))
(si::defun-builtin write-registry-literally (section key value))
(si::defun-builtin read-registry (section key &optional root))
(si::defun-builtin list-registry-key (section &optional root))
(si::defun-builtin user-config-path ())
(si::defun-builtin dump-image-path ())
(si::defun-builtin user-name ())
(si::defun-builtin machine-name ())
(si::defun-builtin os-major-version ())
(si::defun-builtin os-minor-version ())
(si::defun-builtin os-build-number ())
(si::defun-builtin os-platform ())
(si::defun-builtin os-csd-version ())
(si::defun-builtin get-windows-directory ())
(si::defun-builtin get-system-directory ())
(si::defun-builtin erase-buffer (buffer))
(si::defun-builtin buffer-size (&optional buffer))
(si::defun-builtin buffer-lines (&optional buffer))
(si::defun-builtin create-new-buffer (name))
(si::defun-builtin selected-buffer ())
(si::defun-builtin deleted-buffer-p (buffer))
(si::defun-builtin get-next-buffer (&optional buffer reverse tab-order internal))
(si::defun-builtin set-buffer (buffer))
(si::defun-builtin get-file-buffer (filename))
(si::defun-builtin create-file-buffer (filename))
(si::defun-builtin set-buffer-modified-p (flag &optional buffer))
(si::defun-builtin buffer-modified-p (&optional buffer))
(si::defun-builtin buffer-modified-count (&optional buffer))
(si::defun-builtin set-buffer-truncated-p (flag &optional buffer))
(si::defun-builtin buffer-truncated-p (&optional buffer))
(si::defun-builtin file-visited-p (&optional buffer))
(si::defun-builtin delete-buffer (buffer))
(si::defun-builtin buffer-name (buffer))
(si::defun-builtin find-buffer (buffer-name))
(si::defun-builtin other-buffer (&optional buffer))
(si::defun-builtin bury-buffer (&optional buffer))
(si::defun-builtin set-buffer-file-name (file-name &optional buffer))
(si::defun-builtin get-buffer-file-name (&optional buffer))
(si::defun-builtin set-buffer-alternate-file-name (name &optional buffer))
(si::defun-builtin get-buffer-alternate-file-name (&optional buffer))
(si::defun-builtin default-directory (&optional buffer))
(si::defun-builtin set-default-directory (directory &optional buffer))
(si::defun-builtin rename-buffer (buffer-name &optional buffer))
(si::defun-builtin buffer-fileio-encoding (&optional buffer))
(si::defun-builtin buffer-eol-code (&optional buffer))
(si::defun-builtin set-buffer-fileio-encoding (code &optional buffer))
(si::defun-builtin set-buffer-eol-code (code &optional buffer))
(si::defun-builtin buffer-list (&key :buffer-bar-order))
(si::defun-builtin enum-buffers (fn))
(si::defun-builtin find-name-buffer (buffer-name))
(si::defun-builtin need-buffer-save-p (buffer))
(si::defun-builtin count-modified-buffers ())
(si::defun-builtin count-buffers (&optional all))
(si::defun-builtin kill-xyzzy ())
(si::defun-builtin lock-file (&optional buffer))
(si::defun-builtin unlock-file (&optional buffer))
(si::defun-builtin file-locked-p (&optional buffer))
(si::defun-builtin set-buffer-colors (colors &optional buffer))
(si::defun-builtin set-default-fold-width (width))
(si::defun-builtin set-buffer-fold-width (width &optional buffer))
(si::defun-builtin default-fold-width (width))
(si::defun-builtin buffer-fold-width (&optional buffer))
(si::defun-builtin buffer-fold-column (&optional buffer))
(si::defun-builtin hjump-columns (&optional buffer))
(si::defun-builtin set-hjump-columns (columns &optional buffer))
(si::defun-builtin default-line-number-mode ())
(si::defun-builtin buffer-line-number-mode (&optional buffer))
(si::defun-builtin set-default-line-number-mode (mode))
(si::defun-builtin set-buffer-line-number-mode (mode &optional buffer))
(si::defun-builtin last-modified-point (&optional buffer))
(si::defun-builtin update-mode-line (&optional buffer))
(si::defun-builtin set-kinsoku-chars (bol-chars eol-chars &optional buffer))
(si::defun-builtin kinsoku-bol-chars (&optional buffer))
(si::defun-builtin kinsoku-eol-chars (&optional buffer))
(si::defun-builtin kinsoku-mode (&optional buffer))
(si::defun-builtin set-kinsoku-mode (mode &optional buffer))
(si::defun-builtin kinsoku-extend-limit (&optional buffer))
(si::defun-builtin set-kinsoku-extend-limit (nchars &optional buffer))
(si::defun-builtin kinsoku-shorten-limit (&optional buffer))
(si::defun-builtin set-kinsoku-shorten-limit (nchars &optional buffer))
(si::defun-builtin buffer-ime-mode (&optional buffer))
(si::defun-builtin set-buffer-ime-mode (mode &optional buffer))
(si::defun-builtin enable-post-buffer-modified-hook (enable &optional buffer))
(si::defun-builtin post-buffer-modified-hook-enabled-p (&optional buffer))
(si::defun-builtin insert-file-contents (filename &optional visit-p offset size))
(si::defun-builtin insert (&rest string-or-char))
(si::defun-builtin delete-region (from to))
(si::defun-builtin buffer-substring (from to))
(si::defun-builtin copy-to-clipboard (string))
(si::defun-builtin get-clipboard-data ())
(si::defun-builtin clipboard-empty-p ())
(si::defun-builtin set-text-attribute (from to tag &key :foreground :background :bold :underline :strike-out :prefix :extend))
(si::defun-builtin clear-all-text-attributes ())
(si::defun-builtin delete-text-attributes (tag &key :test :test-not :key))
(si::defun-builtin delete-text-attributes-if (test &key :key))
(si::defun-builtin delete-text-attributes-if-not (test &key :key))
(si::defun-builtin find-text-attribute (tag &key :start :end :from-end :test :test-not :key))
(si::defun-builtin find-text-attribute-if (test &key :start :end :from-end :key))
(si::defun-builtin find-text-attribute-if-not (test &key :start :end :from-end :key))
(si::defun-builtin modify-text-attributes (tag &key :foreground :background :bold :underline :strike-out :prefix :extend :start :end :test :test-not :key))
(si::defun-builtin modify-text-attributes-if (test &key :foreground :background :bold :underline :strike-out :prefix :extend :start :end :key))
(si::defun-builtin modify-text-attributes-if-not (test &key :foreground :background :bold :underline :strike-out :prefix :extend :start :end :key))
(si::defun-builtin find-text-attribute-point (point))
(si::defun-builtin delete-text-attribute-point (point))
(si::defun-builtin list-text-attributes (&optional start end))
(si::defun-builtin dump-xyzzy (&optional filename))
(si::defun-builtin xyzzy-dumped-p ())
(si::defun-builtin windowp (object))
(si::defun-builtin bufferp (object))
(si::defun-builtin syntax-table-p (object))
(si::defun-builtin markerp (object))
(si::defun-builtin regexpp (object))
(si::defun-builtin processp (object))
(si::defun-builtin menup (object))
(si::defun-builtin dde-handle-p (object))
(si::defun-builtin oledatap (object))
(si::defun-builtin wait-object-p (object))
(si::defun-builtin status-window-stream-p (stream))
(si::defun-builtin buffer-stream-p (stream))
(si::defun-builtin make-buffer-stream (buffer &optional point eob))
(si::defun-builtin buffer-stream-buffer (buffer-stream))
(si::defun-builtin buffer-stream-point (buffer-stream))
(si::defun-builtin buffer-stream-set-point (buffer-stream point))
(si::defun-builtin stream-encoding (stream))
(si::defun-builtin set-stream-encoding (stream encoding))
(si::defun-builtin connect (hostname service &key :encoding))
(si::defun-builtin make-listen-socket (&optional address port &key :backlog :reuseaddr))
(si::defun-builtin accept-connection (stream &key :encoding))
(si::defun-builtin socket-stream-send-oob-data (stream data))
(si::defun-builtin socket-stream-set-oob-inline (stream on))
(si::defun-builtin socket-stream-p (stream))
(si::defun-builtin socket-stream-local-name (stream))
(si::defun-builtin socket-stream-local-address (stream))
(si::defun-builtin socket-stream-local-port (stream))
(si::defun-builtin socket-stream-peer-name (stream))
(si::defun-builtin socket-stream-peer-address (stream))
(si::defun-builtin socket-stream-peer-port (stream))
(si::defun-builtin socket-stream-set-timeout (stream timeout))
(si::defun-builtin socket-stream-get-timeout (stream))
(si::defun-builtin make-general-input-stream (input-fn &optional close-fn listen-fn))
(si::defun-builtin make-general-output-stream (output-fn &optional close-fn flush-fn))
(si::defun-builtin general-input-stream-p (stream))
(si::defun-builtin general-output-stream-p (stream))
(si::defun-builtin keyboard-stream-p (stream))
(si::defun-builtin set-end-of-file (file-stream))
(si::defun-builtin forward-char (&optional (arg 1)))
(si::defun-builtin forward-line (&optional (arg 1)))
(si::defun-builtin forward-word (&optional (arg 1)))
(si::defun-builtin forward-virtual-line (&optional (arg 1)))
(si::defun-builtin goto-bol ())
(si::defun-builtin goto-eol ())
(si::defun-builtin goto-virtual-bol ())
(si::defun-builtin goto-virtual-eol ())
(si::defun-builtin point-min ())
(si::defun-builtin point-max ())
(si::defun-builtin goto-char (point))
(si::defun-builtin goto-column (column &optional exceed-p))
(si::defun-builtin goto-virtual-column (column &optional exceed-p))
(si::defun-builtin kinsoku-goto-column (column &optional kinsoku-mode))
(si::defun-builtin char-columns (char))
(si::defun-builtin forward-column (current-column ncolumns &optional exceed-p))
(si::defun-builtin point ())
(si::defun-builtin set-mark (&optional point))
(si::defun-builtin mark (&optional force))
(si::defun-builtin region-beginning ())
(si::defun-builtin region-end ())
(si::defun-builtin continue-pre-selection ())
(si::defun-builtin pre-selection-p ())
(si::defun-builtin get-selection-type ())
(si::defun-builtin set-selection-type (type &optional temporary))
(si::defun-builtin start-selection (type &optional temporary point))
(si::defun-builtin stop-selection ())
(si::defun-builtin fix-selection-point ())
(si::defun-builtin selection-point ())
(si::defun-builtin selection-mark ())
(si::defun-builtin reverse-region (from to &optional temporary))
(si::defun-builtin clear-reverse-region ())
(si::defun-builtin make-marker (&optional buffer))
(si::defun-builtin set-marker (marker &optional point))
(si::defun-builtin unset-marker (marker))
(si::defun-builtin goto-marker (marker))
(si::defun-builtin delete-marker (marker))
(si::defun-builtin marker-point (marker))
(si::defun-builtin marker-buffer (marker))
(si::defun-builtin scroll-window (arg))
(si::defun-builtin scroll-window-horizontally (arg))
(si::defun-builtin narrow-to-region (from to))
(si::defun-builtin widen ())
(si::defun-builtin bolp ())
(si::defun-builtin eolp ())
(si::defun-builtin virtual-bolp ())
(si::defun-builtin virtual-eolp ())
(si::defun-builtin bobp ())
(si::defun-builtin eobp ())
(si::defun-builtin char-after (point &optional not-used))
(si::defun-builtin char-before (&optional not-used))
(si::defun-builtin following-char ())
(si::defun-builtin preceding-char ())
(si::defun-builtin current-column ())
(si::defun-builtin current-virtual-column ())
(si::defun-builtin goal-column ())
(si::defun-builtin set-goal-column (column))
(si::defun-builtin goto-line (line))
(si::defun-builtin current-line-number ())
(si::defun-builtin goto-virtual-line (line))
(si::defun-builtin current-virtual-line-number ())
(si::defun-builtin count-column (string &optional start buffer))
(si::defun-builtin current-line-columns ())
(si::defun-builtin undo-boundary ())
(si::defun-builtin clear-undo-boundary (&optional buffer))
(si::defun-builtin undo ())
(si::defun-builtin redo ())
(si::defun-builtin buffer-can-undo-p (buffer))
(si::defun-builtin buffer-can-redo-p (buffer))
(si::defun-builtin keymapp (object))
(si::defun-builtin make-keymap ())
(si::defun-builtin make-sparse-keymap ())
(si::defun-builtin use-keymap (keymap &optional buffer))
(si::defun-builtin define-key (keymap key command))
(si::defun-builtin lookup-keymap (keymap key &optional ignore-case symbol-only))
(si::defun-builtin local-keymap (&optional buffer))
(si::defun-builtin *keymap-index-char (index))
(si::defun-builtin *keymap-char-index (char))
(si::defun-builtin command-keys (command global-keymap local-keymap &optional minor-mode-keymaps))
(si::defun-builtin set-minor-mode-map (keymap &optional buffer))
(si::defun-builtin unset-minor-mode-map (keymap &optional buffer))
(si::defun-builtin minor-mode-map (&optional buffer))
(si::defun-builtin current-selection-keymap ())
(si::defun-builtin ding ())
(si::defun-builtin message-box (message &optional title styles &key :button1 :button2 :button3 :button4 :button5 :no-wrap))
(si::defun-builtin split-string (string separator &optional ignore-empty char-bag))
(si::defun-builtin quote-string (string target-char quote-char))
(si::defun-builtin abbreviate-display-string (string length &optional pathnamep))
(si::defun-builtin abbreviate-string-column (string column))
(si::defun-builtin decode-escape-sequence (string regexpp))
(si::defun-builtin scan-buffer (pattern &key :no-dup :case-fold :reverse :tail :regexp :left-bound :right-bound :last-match))
(si::defun-builtin replace-buffer (pattern replacement &key :case-fold :tail :regexp :left-bound :right-bound :once :literal :last-match))
(si::defun-builtin string-match (regexp string &optional start end))
(si::defun-builtin string-matchp (regexp string &optional start end))
(si::defun-builtin match-beginning (regnum))
(si::defun-builtin match-end (regnum))
(si::defun-builtin match-string (regnum))
(si::defun-builtin compile-regexp (regexp &optional case-fold))
(si::defun-builtin compiled-regexp-source (regexp))
(si::defun-builtin compiled-regexp-case-fold-p (regexp))
(si::defun-builtin regexp-quote (regexp))
(si::defun-builtin looking-at (regexp &optional case-fold))
(si::defun-builtin looking-for (string &optional case-fold))
(si::defun-builtin looking-back (string &optional case-fold))
(si::defun-builtin skip-chars-forward (chars))
(si::defun-builtin skip-chars-backward (chars))
(si::defun-builtin skip-syntax-spec-forward (syntax-spec))
(si::defun-builtin skip-syntax-spec-backward (syntax-spec))
(si::defun-builtin replace-match (string &key :literal))
(si::defun-builtin match-data (&optional data))
(si::defun-builtin store-match-data (data))
(si::defun-builtin string-replace-match (string replacement))
(si::defun-builtin substitute-string (string pattern replacement &key :case-fold :start :end :skip :count))
(si::defun-builtin string-looking-at (regexp string &key :start :end :case-fold))
(si::defun-builtin compare-buffer-substrings (buffer1 start1 end1 buffer2 start2 end2 &optional case-fold))
(si::defun-builtin split-window (&optional arg vertical))
(si::defun-builtin delete-other-windows ())
(si::defun-builtin delete-window ())
(si::defun-builtin selected-window ())
(si::defun-builtin minibuffer-window ())
(si::defun-builtin minibuffer-window-p (window))
(si::defun-builtin window-buffer (window))
(si::defun-builtin next-window (window &optional minibuf))
(si::defun-builtin previous-window (window &optional minibuf))
(si::defun-builtin get-buffer-window (buffer &optional start-window))
(si::defun-builtin set-window (window))
(si::defun-builtin enlarge-window (&optional extend vertical))
(si::defun-builtin screen-width ())
(si::defun-builtin screen-height ())
(si::defun-builtin window-width (&optional window))
(si::defun-builtin window-height (&optional window))
(si::defun-builtin window-columns (&optional window))
(si::defun-builtin window-lines (&optional window))
(si::defun-builtin pos-not-visible-in-window-p (point &optional window))
(si::defun-builtin get-window-line (&optional window))
(si::defun-builtin get-window-start-line (&optional window))
(si::defun-builtin get-window-handle (&optional window))
(si::defun-builtin get-window-flags ())
(si::defun-builtin set-window-flags (flags))
(si::defun-builtin get-local-window-flags (window-or-buffer))
(si::defun-builtin set-local-window-flags (window-or-buffer flags on-or-off))
(si::defun-builtin next-xyzzy-window ())
(si::defun-builtin previous-xyzzy-window ())
(si::defun-builtin list-xyzzy-windows ())
(si::defun-builtin activate-xyzzy-window (instance))
(si::defun-builtin count-xyzzy-instance ())
(si::defun-builtin current-window-configuration ())
(si::defun-builtin set-window-configuration (conf))
(si::defun-builtin window-coordinate (&optional window))
(si::defun-builtin begin-auto-scroll ())
(si::defun-builtin make-syntax-table ())
(si::defun-builtin syntax-table (&optional buffer))
(si::defun-builtin use-syntax-table (syntax-table &optional buffer (invalidate-p t)))
(si::defun-builtin copy-syntax-table (from-syntax-table to-syntax-table))
(si::defun-builtin set-syntax-whitespace (syntax-table char))
(si::defun-builtin set-syntax-punctuation (syntax-table char))
(si::defun-builtin set-syntax-match (syntax-table open-char close-char))
(si::defun-builtin set-syntax-math (syntax-table char))
(si::defun-builtin set-syntax-string (syntax-table char))
(si::defun-builtin set-syntax-start-comment (syntax-table char &optional parse-sexp-ignore-comment-p))
(si::defun-builtin set-syntax-end-comment (syntax-table char &optional parse-sexp-ignore-comment-p maybe-comment-end-p))
(si::defun-builtin set-syntax-end-c++-comment (syntax-table char &optional parse-sexp-ignore-comment-p))
(si::defun-builtin set-syntax-escape (syntax-table char))
(si::defun-builtin set-syntax-quote (syntax-table char))
(si::defun-builtin set-syntax-symbol (syntax-table char))
(si::defun-builtin set-syntax-symbol-prefix (syntax-table char))
(si::defun-builtin set-syntax-word (syntax-table char))
(si::defun-builtin set-syntax-junk (syntax-table char))
(si::defun-builtin set-syntax-tag (syntax-table open-char close-char))
(si::defun-builtin set-syntax-start-multi-comment (syntax-table string))
(si::defun-builtin set-syntax-end-multi-comment (syntax-table string))
(si::defun-builtin set-syntax-start-c++-comment (syntax-table char &optional parse-sexp-ignore-comment-p))
(si::defun-builtin set-syntax-start-column-comment (syntax-table char &optional parse-sexp-ignore-comment-p))
(si::defun-builtin syntax-whitespace-p (char &optional syntax-table))
(si::defun-builtin syntax-punctuation-p (char &optional syntax-table))
(si::defun-builtin syntax-open-p (char &optional syntax-table))
(si::defun-builtin syntax-close-p (char &optional syntax-table))
(si::defun-builtin syntax-open-tag-p (char &optional syntax-table))
(si::defun-builtin syntax-close-tag-p (char &optional syntax-table))
(si::defun-builtin syntax-math-p (char &optional syntax-table))
(si::defun-builtin syntax-string-p (char &optional syntax-table))
(si::defun-builtin syntax-start-comment-p (char &optional syntax-table))
(si::defun-builtin syntax-end-comment-p (char &optional syntax-table))
(si::defun-builtin syntax-end-c++-comment-p (char &optional syntax-table))
(si::defun-builtin syntax-escape-p (char &optional syntax-table))
(si::defun-builtin syntax-quote-p (char &optional syntax-table))
(si::defun-builtin syntax-symbol-p (char &optional syntax-table))
(si::defun-builtin syntax-symbol-prefix-p (char &optional syntax-table))
(si::defun-builtin syntax-word-p (char &optional syntax-table))
(si::defun-builtin syntax-junk-p (char &optional syntax-table))
(si::defun-builtin syntax-start-multi-comment-1-p (char &optional syntax-table))
(si::defun-builtin syntax-start-multi-comment-2-p (char &optional syntax-table))
(si::defun-builtin syntax-end-multi-comment-1-p (char &optional syntax-table))
(si::defun-builtin syntax-end-multi-comment-2-p (char &optional syntax-table))
(si::defun-builtin syntax-c++-comment-p (char &optional syntax-table))
(si::defun-builtin syntax-start-column-comment-p (char &optional syntax-table))
(si::defun-builtin set-syntax-option (syntax-table option))
(si::defun-builtin get-syntax-option (syntax-table))
(si::defun-builtin set-syntax-comment-column (syntax-table column))
(si::defun-builtin upcase-region (from to))
(si::defun-builtin downcase-region (from to))
(si::defun-builtin capitalize-region (from to))
(si::defun-builtin goto-matched-parenthesis (&optional arg))
(si::defun-builtin forward-sexp (&optional arg no-errors))
(si::defun-builtin forward-list (&optional arg no-errors))
(si::defun-builtin up-list (&optional arg no-errors))
(si::defun-builtin down-list (&optional arg no-errors))
(si::defun-builtin skip-white-forward ())
(si::defun-builtin skip-white-backward ())
(si::defun-builtin skip-token ())
(si::defun-builtin indent-to (column))
(si::defun-builtin forward-identifier (begin end ignore-case))
(si::defun-builtin backward-identifier (begin end ignore-case))
(si::defun-builtin calc-c-indent ())
(si::defun-builtin tab-columns (&optional buffer))
(si::defun-builtin set-tab-columns (column &optional buffer))
(si::defun-builtin parse-point-syntax (&optional point))
(si::defun-builtin refresh-highlight-info (&optional buffer))
(si::defun-builtin exit-recursive-edit (&optional value))
(si::defun-builtin quit-recursive-edit (&optional value))
(si::defun-builtin *do-completion (string type &optional wordp list))
(si::defun-builtin minibuffer-completion-type (&optional buffer))
(si::defun-builtin minibuffer-completion-list (&optional buffer))
(si::defun-builtin minibuffer-buffer (&optional buffer))
(si::defun-builtin minibuffer-dialog-title (&optional buffer))
(si::defun-builtin minibuffer-default (&optional buffer))
(si::defun-builtin read-string (prompt &key :default :history))
(si::defun-builtin read-function-name (prompt &key :default :history))
(si::defun-builtin read-command-name (prompt &key :default :history))
(si::defun-builtin read-symbol-name (prompt &key :default :history))
(si::defun-builtin read-variable-name (prompt &key :default :history))
(si::defun-builtin read-file-name (prompt &key :default :title :history))
(si::defun-builtin read-file-name-list (prompt &key :default :title :history))
(si::defun-builtin read-exist-file-name (prompt &key :default :title :history))
(si::defun-builtin read-directory-name (prompt &key :default :title :history))
(si::defun-builtin read-buffer-name (prompt &key :default :history))
(si::defun-builtin read-exist-buffer-name (prompt &key :default :history))
(si::defun-builtin read-integer (prompt))
(si::defun-builtin read-sexp (prompt))
(si::defun-builtin read-char-encoding (prompt &key :history))
(si::defun-builtin read-exact-char-encoding (prompt &key :history))
(si::defun-builtin completing-read (prompt completions &key :case-fold :default :history :must-match))
(si::defun-builtin clear-visited-file-modtime (&optional buffer))
(si::defun-builtin update-visited-file-modtime (&optional buffer))
(si::defun-builtin verify-visited-file-modtime (&optional buffer))
(si::defun-builtin save-buffer (&optional char-encoding eol-code))
(si::defun-builtin delete-auto-save-file (buffer))
(si::defun-builtin do-auto-save (&optional not-all))
(si::defun-builtin write-region (from to filename &optional append char-encoding eol-code))
(si::defun-builtin lookup-symbol (from to &optional package))
(si::defun-builtin sit-for (timeout &optional no-redraw))
(si::defun-builtin sleep-for (timeout))
(si::defun-builtin do-events ())
(si::defun-builtin reset-prefix-args (arg value))
(si::defun-builtin set-next-prefix-args (arg value char))
(si::defun-builtin start-save-kbd-macro ())
(si::defun-builtin stop-save-kbd-macro ())
(si::defun-builtin kbd-macro-saving-p ())
(si::defun-builtin cancel-mouse-event ())
(si::defun-builtin begin-wait-cursor ())
(si::defun-builtin end-wait-cursor ())
(si::defun-builtin main-loop ())
(si::defun-builtin set-cursor (cursor))
(si::defun-builtin toggle-ime (&optional on-or-off))
(si::defun-builtin list-kbd-layout ())
(si::defun-builtin select-kbd-layout (layout))
(si::defun-builtin get-recent-keys ())
(si::defun-builtin get-ime-composition-string ())
(si::defun-builtin pop-ime-composition-string ())
(si::defun-builtin set-ime-read-string (&optional string))
(si::defun-builtin get-ime-mode ())
(si::defun-builtin *ime-register-word-dialog (&optional composition-string read-string))
(si::defun-builtin call-menu (n))
(si::defun-builtin set-quit-char (char))
(si::defun-builtin quit-char ())
(si::defun-builtin refresh-screen (&optional f))
(si::defun-builtin set-meta-bit (char set))
(si::defun-builtin dbc-first-byte-p (char))
(si::defun-builtin dbc-second-byte-p (char))
(si::defun-builtin kanji-char-p (char))
(si::defun-builtin kana-char-p (char))
(si::defun-builtin unicode-char (code))
(si::defun-builtin char-unicode (char))
(si::defun-builtin iso-char-code (char &optional vender-depend-code-mapping))
(si::defun-builtin iso-code-char (code charset &optional vender-depend-code-mapping))
(si::defun-builtin iso-char-charset (char &optional vender-depend-code-mapping))
(si::defun-builtin word-char-p (char))
(si::defun-builtin make-temp-file-name (&optional prefix suffix directory directory-p))
(si::defun-builtin file-newer-than-file-p (file1 file2))
(si::defun-builtin file-system-supports-long-file-name-p (pathname))
(si::defun-builtin append-trail-slash (string))
(si::defun-builtin remove-trail-slash (string))
(si::defun-builtin cwd ())
(si::defun-builtin map-slash-to-backslash (string))
(si::defun-builtin map-backslash-to-slash (string))
(si::defun-builtin network-connect-dialog ())
(si::defun-builtin network-disconnect-dialog ())
(si::defun-builtin get-file-attributes (pathname))
(si::defun-builtin set-file-attributes (pathname attributes))
(si::defun-builtin modify-file-attributes (pathname on &optional off))
(si::defun-builtin get-disk-usage ())
(si::defun-builtin format-drive (&optional drive quick))
(si::defun-builtin compare-file (pathname1 pathname2))
(si::defun-builtin file-property (pathname))
(si::defun-builtin eject-media (drive))
(si::defun-builtin list-servers (&optional comment-p))
(si::defun-builtin list-server-resources (server-name &optional comment-p))
(si::defun-builtin get-short-path-name (pathname))
(si::defun-builtin get-file-info (pathname))
(si::defun-builtin call-process (command-line &key :environ :no-std-handles :input :output :error :exec-directory :show :wait))
(si::defun-builtin make-process (command-line &key :environ :output :exec-directory :incode :outcode :eol-code))
(si::defun-builtin open-network-stream (buffer hostname service &key :incode :outcode :eol-code))
(si::defun-builtin buffer-process (buffer))
(si::defun-builtin process-buffer (process))
(si::defun-builtin process-command (process))
(si::defun-builtin process-status (process))
(si::defun-builtin process-exit-code (process))
(si::defun-builtin process-incode (process))
(si::defun-builtin process-outcode (process))
(si::defun-builtin set-process-incode (process code))
(si::defun-builtin set-process-outcode (process code))
(si::defun-builtin set-process-filter (process filter))
(si::defun-builtin process-filter (process))
(si::defun-builtin set-process-sentinel (process sentinel))
(si::defun-builtin process-sentinel (process))
(si::defun-builtin process-eol-code (process))
(si::defun-builtin process-marker (process))
(si::defun-builtin set-process-eol-code (process code))
(si::defun-builtin signal-process (process))
(si::defun-builtin kill-process (process))
(si::defun-builtin process-send-string (process string))
(si::defun-builtin shell-execute (filename &optional directory params))
(si::defun-builtin create-menu (&optional tag))
(si::defun-builtin create-popup-menu (&optional tag))
(si::defun-builtin add-popup-menu (menu popup-menu name))
(si::defun-builtin add-menu-item (menu tag item-name &optional command init))
(si::defun-builtin add-menu-separator (menu &optional tag))
(si::defun-builtin get-menu-position (menu tag))
(si::defun-builtin insert-popup-menu (menu position popup-menu name))
(si::defun-builtin insert-menu-item (menu position tag item-name &optional command init))
(si::defun-builtin insert-menu-separator (menu position &optional tag))
(si::defun-builtin set-menu (menu))
(si::defun-builtin get-menu (menu tag-or-position &optional tag-or-position-p))
(si::defun-builtin delete-menu (menu tag-or-position &optional tag-or-position-p))
(si::defun-builtin track-popup-menu (menu))
(si::defun-builtin use-local-menu (menu))
(si::defun-builtin copy-menu-items (from-menu to-menu))
(si::defun-builtin current-menu (&optional buffer))
(si::defun-builtin map-to-half-width-region (from to &key :ascii :hiragana :katakana :greek :cyrillic))
(si::defun-builtin map-to-full-width-region (from to &key :ascii :hiragana :katakana :greek :cyrillic))
(si::defun-builtin map-to-half-width-string (string &key :ascii :hiragana :katakana :greek :cyrillic))
(si::defun-builtin map-to-full-width-string (string &key :ascii :hiragana :katakana :greek :cyrillic))
(si::defun-builtin convert-encoding-to-internal (encoding input-string-or-stream &optional output-stream))
(si::defun-builtin convert-encoding-from-internal (encoding input-string-or-stream &optional output-stream))
(si::defun-builtin detect-char-encoding (string-or-stream))
(si::defun-builtin dialog-box (dialog initializers handlers))
(si::defun-builtin property-sheet (pages &optional caption start-page))
(si::defun-builtin buffer-selector ())
(si::defun-builtin file-name-dialog (:char-encoding :eol-code :filter :filter-index :title :default :extension :save :multiple :must-exist :explorer :hide-read-only :initial-directory))
(si::defun-builtin directory-name-dialog (:title :default))
(si::defun-builtin drive-dialog (&optional drive))
(si::defun-builtin *run-winhelp (help-filename &optional topic))
(si::defun-builtin *kill-winhelp (help-filename))
(si::defun-builtin find-winhelp-path (index-filename topic))
(si::defun-builtin print-dialog (&optional buffer))
(si::defun-builtin print-buffer (&optional buffer))
(si::defun-builtin dde-initiate (service topic))
(si::defun-builtin dde-terminate (chan))
(si::defun-builtin dde-execute (chan data))
(si::defun-builtin dde-poke (chan item data))
(si::defun-builtin dde-request (chan data type))
(si::defun-builtin filer (&optional path allow-multiple-select-p caption dual-window-p modelessp))
(si::defun-builtin filer-forward-line (&optional arg secondary-window-p))
(si::defun-builtin filer-forward-page (&optional arg secondary-window-p))
(si::defun-builtin filer-goto-bof (&optional secondary-window-p))
(si::defun-builtin filer-goto-eof (&optional secondary-window-p))
(si::defun-builtin filer-scroll-left (&optional secondary-window-p))
(si::defun-builtin filer-scroll-right (&optional secondary-window-p))
(si::defun-builtin filer-reload (&optional mask secondary-window-p))
(si::defun-builtin filer-demand-reload ())
(si::defun-builtin filer-subscribe-to-reload (path &optional sub-directory-p))
(si::defun-builtin filer-set-directory (directory &optional secondary-window-p))
(si::defun-builtin filer-get-directory (&optional secondary-window-p))
(si::defun-builtin filer-get-drive (&optional secondary-window-p))
(si::defun-builtin filer-mark (&optional file-only-p secondary-window-p))
(si::defun-builtin filer-mark-all (&optional file-only-p secondary-window-p))
(si::defun-builtin filer-mark-match-files (mask &optional secondary-window-p))
(si::defun-builtin filer-toggle-mark (&optional file-only-p secondary-window-p))
(si::defun-builtin filer-toggle-all-marks (&optional file-only-p secondary-window-p))
(si::defun-builtin filer-close (result))
(si::defun-builtin filer-get-mark-files (&optional file-only-p secondary-window-p))
(si::defun-builtin filer-get-current-file (&optional secondary-window-p))
(si::defun-builtin filer-current-file-dot-dot-p (&optional secondary-window-p))
(si::defun-builtin filer-current-file-directory-p (&optional secondary-window-p))
(si::defun-builtin filer-get-text ())
(si::defun-builtin filer-set-text (string))
(si::defun-builtin filer-isearch (&optional char no-wrap secondary-window-p))
(si::defun-builtin filer-goto-file (string &optional start reverse wild-p))
(si::defun-builtin filer-set-file-mask (mask &optional secondary-window-p))
(si::defun-builtin filer-clear-all-marks (&optional secondary-window-p))
(si::defun-builtin filer-count-marks (&optional file-only-p secondary-window-p))
(si::defun-builtin filer-sort (arg &optional secondary-window-p))
(si::defun-builtin filer-get-sort-order (&optional secondary-window-p))
(si::defun-builtin filer-dual-window-p ())
(si::defun-builtin filer-left-window ())
(si::defun-builtin filer-right-window ())
(si::defun-builtin filer-left-window-p ())
(si::defun-builtin filer-calc-directory-size (&optional keep-marks))
(si::defun-builtin filer-calc-directory-byte-size (&optional keep-marks))
(si::defun-builtin filer-viewer ())
(si::defun-builtin filer-modal-p ())
(si::defun-builtin filer-modify-column-width (n d &optional secondary-window-p))
(si::defun-builtin filer-swap-windows ())
(si::defun-builtin filer-read-char ())
(si::defun-builtin lookup-dictionary (directory dic-file index-file word))
(si::defun-builtin extract-archive (archive-file to-directory &rest files))
(si::defun-builtin create-archive ( archive-file files base-directory))
(si::defun-builtin list-archive (archive-file &optional file-name-only))
(si::defun-builtin delete-file-in-archive (archive-file &rest files))
(si::defun-builtin archiver-dll-version (dll))
(si::defun-builtin archiver-dll-config-dialog (dll &optional mode))
(si::defun-builtin convert-to-SFX (archive-file &optional option-string))
(si::defun-builtin get-special-folder-location (place))
(si::defun-builtin *create-shortcut (from-filename to-filename &key :description :arguments :working-directory :show))
(si::defun-builtin resolve-shortcut (pathname))
(si::defun-builtin ole-drop-files (path clsid-string directory files))
(si::defun-builtin set-function-bar-label (char label))
(si::defun-builtin set-number-of-function-bar-labels (n))
(si::defun-builtin number-of-function-bar-labels ())
(si::defun-builtin drag-region (from to))
(si::defun-builtin gethash-region (from to hashtable &optional default))
(si::defun-builtin continue-popup ())
(si::defun-builtin popup-string (string point &optional timeout))
(si::defun-builtin popup-list (list callback &optional point))
(si::defun-builtin ole-create-object (program-id))
(si::defun-builtin ole-get-object (program-id))
(si::defun-builtin ole-putprop (object property value &rest args))
(si::defun-builtin ole-method (object property &rest args))
(si::defun-builtin ole-getprop (object property &rest args))
(si::defun-builtin read-as-string (stream &optional eof-error-p eof-value))
(si::defun-builtin read-line-into (string &optional input-stream eof-error-p eof-value))
(si::defun-builtin read-into (string &optional input-stream eof-error-p eof-value max-length))
(si::defun-builtin char-encoding-p (object))
(si::defun-builtin make-auto-detect-encoding (name display-name))
(si::defun-builtin make-sjis-encoding (name display-name))
(si::defun-builtin make-big5-encoding (name display-name))
(si::defun-builtin make-binary-encoding (name display-name))
(si::defun-builtin make-iso2022-encoding (name display-name :g0 :g1 :g2 :g3 :ascii-eol :ascii-control :7bits :locking-shift :short-form :no-escape :cjk :use-cns11643 :vender))
(si::defun-builtin make-iso8859-encoding (name display-name ccs))
(si::defun-builtin make-windows-codepage-encoding (name display-name codepage))
(si::defun-builtin make-utf16-encoding (name display-name :signature :byte-order :windows :cjk))
(si::defun-builtin make-utf8-encoding (name display-name :signature :windows :cjk))
(si::defun-builtin make-utf7-encoding (name display-name :windows :imap4 :white :set-o :cjk))
(si::defun-builtin make-utf5-encoding (name display-name :windows :imap4 :white :set-o :cjk))
(si::defun-builtin char-encoding-name (char-encoding))
(si::defun-builtin char-encoding-display-name (char-encoding))
(si::defun-builtin parse-char-encoding-region (accept-char-encoding from to))
(si::defun-builtin parse-char-encoding-string (accept-char-encoding string :start :end))
(si::defun-builtin run-hooks (&rest hooks))
(si::defun-builtin run-hook-with-args (hook &rest args))
(si::defun-builtin run-hook-with-args-while-success (hook &rest args))
(si::defun-builtin run-hook-with-args-until-success (hook &rest args))
(si::defun-builtin enable-global-ime (enable))
(si::defun-builtin start-xyzzy-server ())
(si::defun-builtin stop-xyzzy-server ())
(si::defun-builtin refresh-title-bar ())
(si::defun-builtin create-buffer-bar ())
(si::defun-builtin create-tool-bar (name bitmap items))
(si::defun-builtin show-tool-bar (name &optional edge x y w))
(si::defun-builtin hide-tool-bar (name))
(si::defun-builtin delete-tool-bar (name))
(si::defun-builtin tool-bar-exist-p (name))
(si::defun-builtin tool-bar-info (name))
(si::defun-builtin list-tool-bars ())
(si::defun-builtin focus-tool-bar ())
(si::defun-builtin create-tab-bar (bar callback))
(si::defun-builtin tab-bar-add-item (bar item string &optional tooltip menu &key :first :last :before :after))
(si::defun-builtin tab-bar-delete-item (bar item))
(si::defun-builtin tab-bar-select-item (bar item))
(si::defun-builtin tab-bar-current-item (bar))
(si::defun-builtin tab-bar-find-item (bar item))
(si::defun-builtin tab-bar-list-items (bar))
(si::defun-builtin tab-bar-modify-item (bar item &optional string tooltip menu))
(si::defun-builtin ole-create-event-sink (oleobj &optional interface typelib-file))
(si::defun-builtin set-ole-event-handler (oleobj event-name handler))
(si::defun-builtin start-timer (interval fn &optional one-shot-p))
(si::defun-builtin stop-timer (fn))
(si::defun-builtin set-per-device-directory (directory))
(si::defun-builtin refresh-tool-bars ())
(si::defun-builtin ole-enumerator-next (oleobj))
(si::defun-builtin ole-enumerator-reset (oleobj))
(si::defun-builtin ole-enumerator-skip (oleobj &optional count))

(gc)

