﻿
class AlgorithmedData
{
	var data :Array;
	var procdata :Array;
	
	var a :Array = [];
	
	
	var SIGFIG = 100000//* 100; //有効桁数(LatLngの少数以下)
	var LATLNG_ALTRATE = .00001 * .5 * .01; //Altに対するLatLngの変換係数
	
	var DATANUM = 128 * 10;
	var TIMEINT = 1;
	var SPEED = .0000001; //1Step辺りの速度(単位＝？)
	var MIN_SPEED = .0000001; //1Step辺りの速度(単位＝？)
	var MAX_SPEED = .0000010; //1Step辺りの速度(単位＝？)
	var PB_CHSPEED = .7 //速度変化の確率[0-1]
	
	var STEP_PER_SEC = 4; //１秒当たりの歩数
	var TIME_RESOLUTION = 4; //１秒あたりのデータトラック数
	var TH_STEPCOUNT = TIME_RESOLUTION / STEP_PER_SEC; //.25秒に１ステップという設定
	
	var PI_180 = Math.PI / 180;
	
	
	
	function AlgorithmedData ( num ) 
	{
		data = generate( num );
		
		//trace( dump() );
	}
	
	/**
	* ランダムにそれっぽいTrackデータをつくる
	* 
	* それっぽさの基準:
	* 1.ステップのリズム・テンポをそれなりに保つ -->Stepsの発生条件
	* 2.進行方向が適度な間隔でランダムに変化 --> xyzの発生条件(ある確率で進行方向変化イベント発生)
	* 3.進行方向を向く --> Angleの発生条件(xyzに完全依存)
	* 4.速度の同心円状にXYZが決まる
	*
	* STEPがある？ない？ Y --> Step++ N --> 以下なし 
	* 速度変化はある？ Y --> veloc +- chage N --> veloc +-d  
	* 向き（XY平面）は変わるか？ Y --> direction +- chage N --> direction +-d
	* 高さは変わるか? Y --> alt += change N --> alt +=d
	* 距離が求まる (向き・と速度[大きさ]からなるベクトル)
	* ベクトルを分解する --> [ x, y, z ], [ anble ]
	*/
	
	
	function hasStep( stepCount ) 
	{
		var R = .48;
		var c0 = Number( stepCount > TH_STEPCOUNT );
		var c1 = Math.random() < R;
		return Number( c0 && c1 );
	}
	
	function getSpeed ( j, val ) 
	{
		var PB = .1//急角度の確率 
		var p = Math.random();
		var d; //差分
		
		//var l0 = .000001;
		//var l1 = .000010;
		//var l0 = .00000001;
		//var l1 = .00000010;
		var l0 = MIN_SPEED;
		var l1 = MAX_SPEED;
		
		
		//A.急角度
		if( p < PB )
		d = Math.random() * ( 6 - 1 )  + 1;
		
		//B.ゆるやか
		else
		d = Math.random() * 1;
		
		var sig = Math.random() < .5 ? -1 : 1;
		var ret = val + d/2 * sig;
		ret = ret < l0 ? l0 : ret;
		ret = ret > l1 ? l1 : ret;
		
		//trace( [ "SPD:[" + j + "]", p < PB ,ret, d ])
		
		return ret;
	}
	
	function getAngle( j, val ) 
	{
		var PB = .6//急角度の確率 
		var p = Math.random();
		var d; //差分
		
		var thres = 30;
		
		//A.急角度
		if( p < PB )
		{
			d = Math.random() * ( 360 - thres )  + thres;
		}
		//B.ゆるやか
		else
		{
			d = Math.random() * thres;
		}
		
		var sig = Math.random() < .5 ? -1 : 1;
		var ret = Math.floor( val + d/2 * sig );
		//trace( [ sig, ret ] )
		
		return ret;
	}
	
	function getDAlt( j, val, sp ) 
	{
		var PB = .1//急角度の確率 
		var p = Math.random();
		var d; //差分
		
		var l0 = 1 * .5;
		var l1 = 3 * .5;
		
		//速度はやければよりゆるやか
		if( sp > 4 ) PB = .6;
		
		//A.急角度
		if( p < PB )
		d = Math.random() * ( 10 - 1 )  + 2;
		
		//B.ゆるやか
		else
		d = Math.random() * 1.5;
		
		var sig = Math.random() < .5 ? -1 : 1;
		var ret = val + d/2 * sig;
		ret = ret < l0 ? l0 : ret;
		ret = ret > l1 ? l1 : ret;
	
		return ret;
	}
	
	
	
	function hello () 
	{
		var i = 10;
		while( --i > -1 ) a[ i ] = i * 100; 
		dump();
	}
	
	
	static var tracknum = -1;
	var deg = 0;
	function generate ( num :Number ) 
	{
		var DEBUG = false;
		return $generate( num );
		
	}
	
	function $generate( num :Number ) 
	{
		var i, j, l;
		var time;
		var steps;
		var isStep;
		var isLocated;
		var angle ,oldAngle;
		var alt, lat, lon;
		var dAlt;
		var PI = Math.PI;
		var speed;
		var dSpeed;
		var velocity; //加速度=速度の微分
		var staytime; //同一箇所への滞在時間(stepsベース)
		var staytime2; //同一箇所への滞在時間(locationベース)
		var stepCount; //同一箇所への滞在時間カウンタ(stepsベース)
		var immigrationCount; //同一箇所への滞在時間カウンタ(locationベース)
		
		//初期化
		a = new Array( num || DATANUM );
		steps = 0;
		angle = Math.floor( Math.random() * 360 );
		alt = 10;
		lat =  39 + Math.floor( Math.random() * 0 ) + Math.floor( Math.random() * SIGFIG * 1 ) / SIGFIG * 1;
		lon = 134 + Math.floor( Math.random() * 0 ) + Math.floor( Math.random() * SIGFIG * 1 ) / SIGFIG * 1;
		dAlt = 0;
		stepCount = -1;
		immigrationCount = -1;
		speed = SPEED;
		
		//データの作成ループ
		i = l = a.length;
		while( --i > -1 )
		{
			//インデックス
			j = l - i - 1;
			
			/*/////////////////////////////////////////////////////////
			TIME - 時刻をすすめる
			**/////////////////////////////////////////////////////////
			time = j * TIMEINT;
			
			/*/////////////////////////////////////////////////////////
			1.一歩進む？
			**/////////////////////////////////////////////////////////
			isStep = hasStep( ++stepCount );
			if( isStep )
			{
				steps++;
				staytime = stepCount;
				stepCount = -1;
			}
			else
			{
				staytime = stepCount;
				steps = a[ j - 1 ][ 1 ] || steps;
			}
			/*/////////////////////////////////////////////////////////
			2.まがる？
			**/////////////////////////////////////////////////////////
			if( isStep )
			{
				oldAngle = angle;
				
				//１．意思決定アルゴリズム
				//angle = getAngle( j, angle );
				
				//2.まがらない
				//angle += 0;
				
				//3.逓増
				//angle = deg++;
				deg += 10;
				angle = deg;
				
				//4.きちんとくん
				//angle = deg%4 ? angle : angle + 15;
				
				//FIX
				/*
				angle = angle%360;
				angle = angle < 0 ? angle + 360 : angle;
				*/
				
			}
			else
			{
				oldAngle = angle;
				//angle = a[ j - 1 ][ 3 ] || angle;
			}
			/*/////////////////////////////////////////////////////////
			３．速度かわる？
			**/////////////////////////////////////////////////////////
			if( isStep )
			{
				dSpeed = speed;
				speed  = getSpeed( j , speed );
			}
			else
			{
				speed = speed;
			}
			/*/////////////////////////////////////////////////////////
			4.高さかわる？
			**/////////////////////////////////////////////////////////
			if( isStep )
			{
				var oldAlt = alt;
				alt  = alt//getDAlt( j, alt, speed );
				dAlt = oldAlt- alt;
			}
			else
			{
				dAlt = 0;
				alt = a[ j - 1 ][ 4 ] || alt;
			}
			/*/////////////////////////////////////////////////////////
			以上からXYを求める
			**/////////////////////////////////////////////////////////
			if( isStep )
			{
				var x0,y0;
				var r;
				var rad;
				
				x0 = a[ j - 1 ][ 6 ] || lon;
				y0 = a[ j - 1 ][ 5 ] || lat;
				
				if( j == 0 ) continue;

				
				//斜辺speed,高さaltよりXY平面の半径rを求める
				//r = Math.sqrt( Math.abs( speed*speed - dAlt*dAlt ) ) * LATLNG_ALTRATE;
				r = speed * LATLNG_ALTRATE;
				
				//よくわからんがなんとなく
				//var angleFix;
				//angleFix = ( angle + 90 );
				
				//半径r、角度angleよりlon,latを求める
				rad = (angle%360) * PI_180;
				/*
				if( angle >= 180 )
				{
				lon =  ( Math.cos( rad )) * r + x0;
				}
				else
				{
				lon = -( Math.cos( rad )) * r + x0;
				}
				*/
				
				lon = (  Math.cos( rad )) * r + x0;
				lat = ( -Math.sin( rad )) * r + y0;
				
				
				lon = Math.floor( lon * SIGFIG ) / SIGFIG;
				lat = Math.floor( lat * SIGFIG ) / SIGFIG;

				//trace( [ angle%360, Math.cos( rad ), Math.sin( rad ) ] )
				
				//trace( [ angleFix, angle < 180, lon > x0 ] );
				
				isLocated = 1;
				staytime2 = ++immigrationCount;
				immigrationCount = -1;
			}
			
			else
			{
				isLocated = 0;
				staytime2 = ++immigrationCount;
			}
			/*/////////////////////////////////////////////////////////
			微分値
			**/////////////////////////////////////////////////////////
			velocity = ( speed - dSpeed ) || 0;
			
			
			var angleFix = angle % 360;
			/*
			angleFix = angleFix + 90;
			if( angleFix > 360 ) angleFix -= 360;
			if( angleFix <   0 ) angleFix += 360;
			
			angleFix = 360 - angleFix;
			*/
			
			//trace([ angle, angleFix ])
			
			//データの格納
			a[ j ] = [];
			a[ j ][ 0 ] = time;
			a[ j ][ 1 ] = steps;
			a[ j ][ 2 ] = isStep;
			a[ j ][ 3 ] = angleFix;
			a[ j ][ 4 ] = alt;
			a[ j ][ 5 ] = lat;
			a[ j ][ 6 ] = lon;
			
			a[ j ][ 7 ] = speed;
			a[ j ][ 8 ] = velocity;
			a[ j ][ 9 ] = staytime;		//stepsが変化しない継続時間
			a[ j ][ 10 ] = isLocated;
			a[ j ][ 11 ] = staytime2;	//locationが変化しない継続時間
			
		}
		
		data = a;
		return a;
	}


	function drawLine ( cont :MovieClip ) 
	{
		var mc = cont.createEmptyMovieClip( "canvas", 999 );
		
		mc.lineStyle( 0, 0x000000, 100 );
		mc._x = 256;
		mc._y = 256 + 128;
		
		var x0, y0, x1, y1;
		var i = a.length;
		while( --i > -1 )
		{
			x1 = a[ i ][ 6 ];
			y1 = a[ i ][ 5 ];
			x0 = a[ i + 1 ][ 6 ] || 0;
			y0 = a[ i + 1 ][ 5 ] || 0;
			
			
			mc.moveTo( x0, y0 );
			mc.lineTo( x1, y1 );
			
			//trace( [ i, x0, y0 ] )
		}
	}
	
	
	
	function dump () 
	{
		var t :String = "";
		var da :String = "";
		var i, j, l;
		
		//t += "a[i]:time/steps/hasStep/angle/alt/lat/lon";
		//t += "\n";
		var isLast;
		i = l = a.length;
		while( --i > -1 )
		{
			j = l - i - 1;
			isLast = i == 0;
			
			//if( !isLast )  da += "["+j+"]" + a[ j ] + ",";
			//else  		   da += "["+j+"]" + a[ j ];
			
			if( !isLast )  da += "		[ " + a[ j ] + " ],";
			else  		   da += "		[ " + a[ j ] + " ]";
			da += "\n";
		}
	
		t += "function makeData()" + "\n";
		t += "{" + "\n";
		t += "	var a :Array;" + "\n";
		t += "	a = [" + "\n";
		t += "" + da;
		t += "		];" + "\n";
		t += "	return a" + "\n";
		t += "};" + "\n";
		
		//dumper.text = t;
		
		return t;
	}

}