﻿import  utils.ColorSet;

class ColorScheme
{
	static var prisets :Array=[];// = __initColorPrisets();
	
	static var singleton :ColorScheme;
	
	
	var scheme :Number = 0;
	var schemeChanged :Boolean;
	
	//collars
	var brush   = [];
	var stamp	= [];
	var texture = [];
	
	var listener :Array;
	
	function addListener ( lis :Object ) 
	{
		listener.push( lis );
	}

	function changeScheme( i :Number )
	{
		scheme  = i == undefined ? scheme : i;
		//trace([ "カラースキーム:" + scheme ]);
		texture = prisets[ scheme ].texture;
		brush   = prisets[ scheme ].brush;
		//trace( brush )
		schemeChanged = true;
		
		var a = listener;
		var i = a.length;
		while( --i > -1 )
		{
			a[ i ].schemeChanged = true;
		}
	}
	
	private function ColorScheme()
	{
		prisets = __initColorPrisets();
		//テスト
		scheme = 7//Math.round( Math.random() * prisets.length )
		//trace([ "カラースキーム:" + scheme ]);
		
		texture = prisets[ scheme ].texture;
		brush   = prisets[ scheme ].brush;
		
		listener = [];
	}
	
	static function getInstance()
	{
		if( !singleton ) singleton = new ColorScheme();
		return singleton;
	}
	
	static function __initColorPrisets()
	{
		var a = [];
		/*
		a[  0 ] = { name :"0xD6D4BF", color :new ColorSet( 0xD6D4BF ) };
		a[  1 ] = { name :"0x0B0C0C", color :new ColorSet( 0x0B0C0C ) };
		a[  2 ] = { name :"0xDFDDCC", color :new ColorSet( 0xDFDDCC ) };
		a[  3 ] = { name :"0x070707", color :new ColorSet( 0x070707 ) };
		a[  4 ] = { name :"0xD6D4BF", color :new ColorSet( 0xD6D4BF ) };
		a[  5 ] = { name :"0xD8954E", color :new ColorSet( 0xD8954E ) };
		a[  6 ] = { name :"0xDBDACA", color :new ColorSet( 0xDBDACA ) };
		a[  7 ] = { name :"0xF4ECD0", color :new ColorSet( 0xF4ECD0 ) };
		a[  8 ] = { name :"0xDFC995", color :new ColorSet( 0xDFC995 ) };
		a[  9 ] = { name :"0xEFEEDC", color :new ColorSet( 0xEFEEDC ) };
		a[ 10 ] = { name :"0xEFEEDC", color :new ColorSet( 0xEFEEDC ) };
		*/
		//a[  0 ] = [ new ColorSet( 0xFFFFFF )]
		
		a[  0 ] = { texture : 	new ColorSet( 0xD6D4BF ),
					brush	: [ new ColorSet(  30,  29,  34 ),
								new ColorSet( 160,   9,   9 ),
								new ColorSet(  92,  91,  98 ),
								new ColorSet( 192, 192, 197 ),
								new ColorSet( 249, 249, 255 ) ] };
		a[  1 ] = { texture : 	new ColorSet( 0x0B0C0C ),
					brush	: [ new ColorSet( 255, 255, 255 ) ] };
		a[  2 ] = { texture : 	new ColorSet( 0xDFDDCC ),
					brush	: [ new ColorSet(  30,  29,  34 ),
								new ColorSet( 191,  10,  10 ),
								new ColorSet( 155, 161, 184 ),
								new ColorSet( 106, 120, 170 ),
								new ColorSet( 249, 249, 255 ) ] };
		a[  3 ] = { texture : 	new ColorSet( 0x070707 ),
					brush	: [ new ColorSet( 229, 211,  10 ),
								new ColorSet( 187,   5,   9 ),
								new ColorSet( 213, 213, 225 ),
								new ColorSet(  12,  48, 164 ),
								new ColorSet( 249, 249, 255 ) ] };
		a[  4 ] = { texture : 	new ColorSet( 0xD6D4BF ),
					brush	: [ new ColorSet(  30,  29,  34 ),
								new ColorSet( 192, 192, 197 ),
								new ColorSet( 249, 249, 255 ) ] };
		a[  5 ] = { texture : 	new ColorSet( 0x8954E ),
					brush	: [ new ColorSet(  30,  29,  34 ),
								new ColorSet(  82,  72,  70 ),
								new ColorSet(  41,  89, 177 ),
								new ColorSet( 209,  31,   2 ),
								new ColorSet( 240, 204,   8 ),
								new ColorSet( 249, 249, 255 ) ] };
		a[  6 ] = { texture : 	new ColorSet( 0xDBDACA ),
					brush	: [ new ColorSet(  30,  29,  34 ),
								new ColorSet(  82,  72,  70 ),
								new ColorSet( 219, 218, 202 ),
								new ColorSet( 197,  29,   2 ),
								new ColorSet( 240, 205,  16 ),
								new ColorSet( 249, 249, 255 ) ] };
		a[  7 ] = { texture : 	new ColorSet( 0xF4ECD0 ),
					brush	: [ new ColorSet(  30,  29,  34 ),
								new ColorSet( 158, 157, 180 ),
								new ColorSet(  79, 146,  84 ),
								new ColorSet(  73, 132, 151 ),
								new ColorSet( 216,  47,  19 ),
								new ColorSet( 253, 223,  63 ),
								new ColorSet( 249, 249, 255 ) ] };
		a[  8 ] = { texture : 	new ColorSet( 0xDFC995 ),
					brush	: [ new ColorSet(  30,  29,  34 ),
								new ColorSet( 169, 169, 191 ),
								new ColorSet(  80, 141,  84 ),
								new ColorSet( 247, 245, 227 ) ] };
		a[  9 ] = { texture : 	new ColorSet( 0xEFEEDC ),
					brush	: [ new ColorSet(  30,  29,  34 ),
								new ColorSet( 169, 169, 191 ),
								new ColorSet(  76,  78, 154 ), //グラデ0
								new ColorSet(  11,   8,  57 ), //グラデ1
								new ColorSet( 245, 204,  40 ),
								new ColorSet( 217,  40,  11 ) ] };
		a[ 10 ] = { texture : 	new ColorSet( 0xEFEEDC ),
					brush	: [ new ColorSet(  79,  78,  84 ), //グラデ0
								new ColorSet(  21,  20,  24 ) //グラデ1
								] };
		
		
		
		return a; 
	}

}