﻿import Project;
import Track;

/**
* TrackデータをダンプするためのUtilクラス
*/
class DataDumper
{
	static var depth :Number = 7248;
	static var name  :String = "__dumper_view__";
	static var scope :MovieClip = _root;
	
	static var dumper_view :MovieClip;
	
	/**
	* 任意のTrackデータをCSV形式に書き出す。
	*/
	static function dump ( tk :Track )
	{
		//dumper_viewが存在しなければ生成
		if( !dumper_view ) createView();
		dumper_view._visible = true;
		
		println( "--------------------------------" );
		println( tk.data.join( '\n' ) );
	}

	static function println()
	{
		dumper_view.txt.text += String( arguments ) + "\n";
	}
	
	/**
	* すべてのTrackデータをCSV形式に書き出す。
	*/
	static function dumpAll() 
	{			
		var proj :Project = Project.getInstance();
		var a = proj.tracks.getValues();
		
		//Trackの数だけdump
		var i = a.length;
		while( --i > -1 )
		{
			dump( a[ i ] );
		}
	}

	static function initialize() 
	{
		createView();
	}

	static function createView () 
	{
		var txt :TextField;
		var dump_btn :MovieClip;
		var hide_btn :MovieClip;
		
		
		dumper_view = scope.createEmptyMovieClip( name, depth );
		
		var tm  :TextFormat;
		tm = new TextFormat();
		txt = dumper_view.createTextField( "txt", 0, 0, 0, 300, 300 );
		txt.selectable 	= true;
		txt.border 		= true;
		txt.multiline 	= true;
		txt.background	= true;
		txt.setNewTextFormat( tm );
		txt.text = String( getTimer() );
		
		dump_btn = dumper_view.createEmptyMovieClip( "dump_btn", 1 );
		dump_btn._x = 0;
		dump_btn._y = 300; 
		with( dump_btn )
		{
			lineStyle( 0, 0, 100 );
			beginFill( 0xFFFFFF, 100 );
			moveTo( 0, 0 );
			lineTo( 100, 0 );
			lineTo( 100, 20 );
			lineTo( 0, 20 );
			lineTo( 0, 0 );
			endFill();
		}
		dump_btn.createTextField( "txt", 0, 0, 0, 100, 20 );
		dump_btn.txt.text = "DUMP!";
		dump_btn.scope = dumper_view;
		dump_btn.onRelease = function()
		{
			DataDumper.dumpAll();
		}
		
		hide_btn = dumper_view.createEmptyMovieClip( "hide_btn", 2 );
		hide_btn._x = 100;
		hide_btn._y = 300; 
		with( hide_btn )
		{
			lineStyle( 0, 0, 100 );
			beginFill( 0xFFFFFF, 100 );
			moveTo( 0, 0 );
			lineTo( 100, 0 );
			lineTo( 100, 20 );
			lineTo( 0, 20 );
			lineTo( 0, 0 );
			endFill();
		}
		hide_btn.createTextField( "txt", 0, 0, 0, 100, 20 );
		hide_btn.txt.text = "HIDE";
		hide_btn.scope = dumper_view;
		hide_btn.onRelease = function()
		{
			this.scope._visible = false;
		}
		
	}

}