﻿import utils.CSV;


class LocomotionData
extends CSV
{
	//	PUBLIC PROPERTIES:
	//	-------------------
	public static var DEBUG :Boolean = false;   
	
	public var DELIMITER_WIN  :String  = "\r"; 	//- default for 'linebreak'
	public var DELIMITER_MAC  :String  = "\n"; 	//- default for 'linebreak'
	public var DELIMITER_UNIX :String  = "\r\n"; 	//- default for 'linebreak'
	public var DELIMITER   :String  = DELIMITER_WIN; 	//- default for 'linebreak'
	public var SEPERATER   :String  = ",";		//- default for 'comma'
	public var USECODEPAGE :Boolean = false;	//- default for 'UTL-8'

	public var src   :String;
	public var array :Array;
	public var status :Boolean;
	public var onParseStr  :Function;
	public var getProgress :Function;

	
	//	PUBLIC METHODS:
	//	-------------------
	//	@method:	load - load CSV file
	//	   @arg:	url  - path to the file
	public function load( url :String ) :Void
	{
		System.useCodepage = USECODEPAGE;
		getProgress = getLoadProgress;
		super.load( url );
	}
	
	public function onData( src :String ) :Void
	{
		this.src = src;
		this.status = src !== undefined;
		this.onLoad( status );
	}

	
	public function toArray() :Array
	{
		//改行コードを識別
		var del :String = DELIMITER_WIN; //デフォルトはWINの改行コード
		if( src.indexOf( DELIMITER_UNIX ) != -1 )
		{
			del = DELIMITER_UNIX; //UNIXの改行コード
			trace( "UNIXの改行コード" )
		}
		else if( src.indexOf( DELIMITER_MAC ) != -1 )
		{ 
			del = DELIMITER_MAC; //MACの改行コード
			trace( "MACの改行コード" )
		}
		
		var a   :Array;
		a = src.split( del );
		
		var i = a.length;
		while( --i > -1 ) a[ i ] = a[ i ].split( SEPERATER );

		return a;
	}
	
	
	private var $i, $l:Number;
	private var $parse_iv :Number;
	private function $parseStr( sep :String, scope ) :Void
	{
		var T = getTimer() + 24;
		clearInterval( scope.$parse_iv );
		
		var a :Array = array;
		var time 	 :String; // 0
		var steps 	 :Number; // 1
		var isStep 	 :Number; // 2
		var angle 	 :Number; // 3
		var alt 	 :Number; // 4
		var lat 	 :Number; // 5
		var lng 	 :Number; // 6
		var speed 	 :Number; // 7
		var velocity :Number; // 8
		var staytime :Number; // 9
		var isLocated :Number; // 10
		var staytime2 :Number; // 11
		var e0, e1 :Array;
		
		var j;
		
		while( true )
		{
			//ループ終了条件１
			if( --$i < 1 ) 
			{
				//trace([ "ループ終了条件１:", array[ 0 ], typeof( array[ 0 ] ) == "string"  ]);
				onParseStr( true );
				return;
			}
			
			//ループ終了条件２
			if( ( T - getTimer() ) < 0 )
			{
				$i++;
				scope.$parse_iv = setInterval( scope, "$parseStr", 10, sep, scope );
				return;
			}

			j = $l - ( $i + 1 );
			e0 = array[ j - 1 ];
			e1 = array[ j ] = array[ j ].split( sep );
			
			time 	 = String( e1[ 0 ].valueOf() );
			steps 	 = Number( e1[ 1 ].valueOf() );
			isStep 	 = hasStep( e0[ 1 ].valueOf(), steps.valueOf() );
			angle 	 = Number( e1[ 2 ].valueOf() );
			alt 	 = Number( e1[ 3 ].valueOf() );
			lat 	 = Number( e1[ 4 ].valueOf() );
			lng 	 = Number( e1[ 5 ].valueOf() );
			
			//Y軸の補正はTrackData内部で補正する
			
			speed 	 = culcSpeed( a[ j - ( 4 - 1 ) ], e1, 4 ) || 0;
			velocity = culcVeloc( a[ j - ( 4 - 1 ) ][ 7 ], speed ) || 0;
			staytime = culcStaytime( isStep );
			isLocated = hasLocated( e0, e1 );
			staytime2 = culcStaytime2( isLocated );
			
				
			//データの格納
			array[ j ] = [];
			array[ j ][ 0 ] = time;
			array[ j ][ 1 ] = steps;
			array[ j ][ 2 ] = isStep;
			array[ j ][ 3 ] = angle;
			array[ j ][ 4 ] = alt;
			array[ j ][ 5 ] = lat;
			array[ j ][ 6 ] = lng;
			
			array[ j ][ 7 ] = speed;
			array[ j ][ 8 ] = velocity;
			array[ j ][ 9 ] = staytime;		//stepsが変化しない継続時間
			array[ j ][ 10 ] = isLocated;
			array[ j ][ 11 ] = staytime2;	//locationが変化しない継続時間
			
			//trace([ j+" / "+ isLocated, staytime2])
			if( staytime2 > 1 )
			{
				//trace([  "average:" + j, staytime2 ] )
				//averageXYZ( array, j, staytime2 );
			}
			
		}
	}
	
	
	function averageXYZ ( data :Array, index, d ) 
	{
		var x, y, z;
		var dx, dy, dz;
		
		dz = ( data[ index ][ 4 ] - data[ index - d + 1 ][ 4 ] ) / d;
		dy = ( data[ index ][ 5 ] - data[ index - d + 1 ][ 5 ] ) / d;
		dx = ( data[ index ][ 6 ] - data[ index - d + 1 ][ 6 ] ) / d;
		
		//trace([ "D:" + d, [ dz, dy, dx ] ])
		
		var j;
		var i = d;
		while( --i > -1 )
		{
			j = index - i;
			data[ j ][ 4 ] += i * dz;
			data[ j ][ 5 ] += i * dy;
			data[ j ][ 6 ] += i * dx;
			//trace([ "	" + i, [ data[ j ][ 4 ], data[ j ][ 5 ], data[ j ][ 6 ] ] ])
		}
		
	}
	
	function hasStep ( s0 :Number, s1 :Number ) :Number
	{
		return Number( s0 != s1 );
	}
	
	function hasLocated ( s0 :Array, s1 :Array ) :Number
	{
		/*
		trace("--")
		trace( [ s0.length, s1.length ] )
		trace([ s0 ])
		trace([ s1 ])
		trace("--")
		trace([ ( s0[ 4 ] != s1[ 3 ] ) , ( s0[ 5 ] != s1[ 4 ] ) , ( s0[ 6 ] != s1[ 5 ] ) ])
		trace([ [ s0[ 4 ] , s1[ 3 ] ] , [ s0[ 5 ] , s1[ 4 ] ] , [ s0[ 6 ] , s1[ 5 ] ] ])
		*/
		
		//return Number( ( s0[ 4 ] != s1[ 3 ] ) || ( s0[ 5 ] != s1[ 4 ] ) || ( s0[ 6 ] != s1[ 5 ] ) );
		return Number( ( s0[ 5 ] != s1[ 4 ] ) || ( s0[ 6 ] != s1[ 5 ] ) );
	}
	function culcSpeed ( s0 :Array, s1 :Array, dt :Number ) :Number
	{
		//本当は３軸の速度を計算・格納したいが、当座は２軸（XY）で済ませる
		var ly = s1[ 4 ] - s0[ 4 ];
		var lx = s1[ 5 ] - s0[ 5 ];
		
		return Math.sqrt( lx*lx + ly*ly ) / dt;
	}
	function culcVeloc ( s0 :Number, s1 :Number ) :Number
	{
		return s1 - s0;
	}
	
	var stepCount :Number = 1;
	function culcStaytime ( isStep ) :Number
	{
		stepCount = isStep ? 1 : stepCount + 1;
		return stepCount;
	}
	
	var stepCount2 :Number = 1;
	function culcStaytime2 ( isLocated ) :Number
	{
		stepCount2 = isLocated ? 1 : stepCount2 + 1;
		return stepCount2;
	}

	
	public function parseStr() :Void
	{
		var $this = this;
		
		//改行コードを識別
		var del :String = DELIMITER_WIN; //デフォルトはWINの改行コード
		if( src.indexOf( DELIMITER_UNIX ) != -1 )
		{
			del = DELIMITER_UNIX; //UNIXの改行コード
			//trace( "UNIXの改行コード" )
		}
		else if( src.indexOf( DELIMITER_MAC ) != -1 )
		{ 
			del = DELIMITER_MAC; //MACの改行コード
			//trace( "MACの改行コード" )
		}
			
		array = src.split( del );
		$l = $i = array.length;
		
		getProgress = getParseProgress;
		$parse_iv = setInterval( this, "$parseStr", 10, SEPERATER, $this );
	}
	
	//	CONSTRUCTOR:
	//	-------------------
	//	@method:	CSV   - constructor
	//	   @arg:	scope - [OPTINAL] set callback scope
	//	   @arg:	unUTF - [OPTINAL] set System.useCodepage
	public function LocomotionData ( unUTF :Boolean ) 
	{
		super( unUTF );
	}
	
	public function toString() :String
	{
		var a :Array = array.slice() || toArray();
		
		//trace([ array[ 0 ] ])
		//trace( [array.slice()[ 0 ]] )
		/*
		a.unshift( '----------------------------' );
		a.unshift( "LocomotionData: seperated by '" + SEPERATER + "'" );
		a.unshift( '\r' + '\r' );
		a.push( '----------------------------' );
		*/
		return a.join( '\r' );
	}
}