﻿import utils.Hash;
import utils.XMLUtil;
import utils.CSV;
import task.TipLayer;
import task.RouteLayer;
import task.ObjLayer;

class Project
{
	/*////////////////////////
	* 永続データ
	*/////////////////////////
	var projectList 	  :XMLUtil;
	var selectedProject   :XML;
	var selectedProjectId :Number;
	var projects :Hash;
	var $projects :Array;
	function get projectLength() { return projects.size(); };
	
	/*////////////////////////
	* トラック
	*/////////////////////////
	var tracks :Hash;
	var selectedTrack   :Track;
	var selectedTrackId :Number;
	function get trackLength() { return tracks.size(); };
	
	/*////////////////////////
	* コメント
	*/////////////////////////
	var comments :Hash;
	
	/*////////////////////////
	* UI
	*/////////////////////////
	var root 	   :MovieClip;
	var workarea   :MovieClip;
	var workarea3D :MovieClip;
	var seeker     :MovieClip;
	var dataindexer :Object;
	var MD2D, MD3D :Number;
	
	function get viewMode(){ return root.viewMode; };
	function set viewMode( mode :Number ){ root.viewMode = mode; };
	
	/*//////////////////////////////////////////////////////////////////
	* 初期化
	*///////////////////////////////////////////////////////////////////
	private function Project()
	{
		//クリア
		clear();
		
		projectList = new XMLUtil();
	}
	function destroy()
	{
		clear();
		for( var i in this ) 	delete this[ i ];
		for( var i in Project ) delete Project[ i ];
		delete this;
		delete Project;
	}
	
	static var singleton :Project;
	static function getInstance() :Project
	{
		if( !singleton ) singleton = new Project();
		return singleton;
	}
	
	/*//////////////////////////////////////////////////////////////////
	* プロジェクトを開く・閉じる・作る
	*///////////////////////////////////////////////////////////////////
	function open()
	{
		//クリア
		clear();
	}
	function close()
	{
		//クリア
		clear();
	}
	function create()
	{
		//クリア
		clear();
	}
	
	function clear () 
	{
		//参照の解除
		selectedTrack 	= null;
		selectedTrackId = -1;
		
		
		//トラックのデストラクト
		var a = tracks.getValues();
		var i = a.length;
		while( --i > -1 ) a[ i ].destroy();
		
		//コメントのデストラクト
		var a = comments.getValues();
		var i = a.length;
		while( --i > -1 ) a[ i ].destroy();
		
		//プロジェクトのデストラクト
		selectedProject = new XML();
		
		//トラックのデストラクト
		var a = projects.getValues();
		var i = a.length;
		while( --i > -1 ) a[ i ].destroy();
		
		//ハッシュの初期化
		tracks   = new Hash();
		comments = new Hash();
		projects = new Hash();
	}

	
	/*//////////////////////////////////////////////////////////////////
	* トラックの追加・削除
	*///////////////////////////////////////////////////////////////////
	function addTrack( type :Number, name :String, 
					   sequence :Array, brush :Array, stamp :Array, background :Number,
					   locomotion )
	{
		trace([ "addTrack:", type, name ]);
		
		//トラックの生成
		var tk :Track;
		var id;
		id = selectedTrackId = trackLength;
		tk = selectedTrack   = createTrack( id, type, name, sequence, brush, stamp, background, locomotion );
		tracks.put( id, tk );
		
		//trace([ "selectedTrackId:" + selectedTrackId ])
	}
	function removeTrack( id :Number )
	{
		//trace([ "DW", id ])
		var tk :Track = tracks.get( id );
		
		//* 1.Track削除時にChaaraを破棄
		tk.destroyChara();
		
		//* 3.Track削除時にObjPaneを破棄
		tk.destroyObjPane();
		
	
		//* 4.Track削除時にScorePaneを破棄
		tk.destroyScorePane();
		
		tk.destroyCharaTip( tk.chara );
		
		//* 2.Trackを削除(destroy)
		tk.destroy();
		
		
		tracks.remove( id );
		//selectedTrackId --;
	}
	private function createTrack ( id :Number, type :Number, name :String, 
								   sequence :Array, brush :Array, stamp :Array, background :Number,
								   locomotion ) :Track
	{
		var tk :Track = new Track( id, type );
		tk.objColumn   = workarea.objColumn;
		tk.scoreColumn = workarea.scoreColumn;
		tk.scr1 = workarea.scr1;
		tk.scr2 = workarea.scr2;
		tk.scr3 = seeker;
		tk.dataindexer = dataindexer;
		
		tk.charaName = name || "someone"//_root.getPlayerName();
		
		//* 3.Track生成時にObjPaneを生成
		tk.createObjPane();
		
		//* 4.Track生成時にScorePaneを生成
		tk.createScorePane();
		
		//* 5.Track生成時にFootstepを割り当て
		tk.attachFootstep( sequence );
		
		
		//関数ポインタを更新
		tk.$update = tk.upd_retain;
		
		
		tk.addLocomotionData( locomotion.array, false );
		tk.drawData( tk.scorePane.canvas );
		
		
		//* 5.Track生成時にCharaを生成
		//2D
		tk.createChara();
		
		//3D
		var d = tk.depth;
		var cont = workarea3D.getCharaLayer().createEmptyMovieClip( "chara" + d, d );
		var chara = tk.createCharaOn3D( cont );
		tk.removeCharaTip( tk.chara3D );
		tk.createCharaTip( tk.chara3D );
		tk.chara = tk.chara3D;
		
		
		//キャラのポインタ更新
		switch( viewMode )
		{
			case MD2D:
			tk.chara = tk.chara2D;
			//TipLayerの関数ポインタをセット
			var tip :TipLayer = TipLayer.getInstance();
			tip.$func_main = null;
			tip.$func_draw = null;
			break;
			
			case MD3D:
			default:
			tk.chara = tk.chara3D;
			tk.locateTo = tk.$locateTo;	//有効化
			//TipLayerの関数ポインタをセット
			var tip :TipLayer = TipLayer.getInstance();
			tip.$func_main = tip.func_updateTips;
			tip.$func_draw = tip.func_drawTips;
			break;
		}
		
		//balloon
		//trace([ "Project.createTrack():" + tk.chara3D, tk ]);
		tk.createCharaBalloon( tk.chara3D, tk );
		
		return tk;
	}

	/*//////////////////////////////////////////////////////////////////
	* プロジェクトの選択
	*///////////////////////////////////////////////////////////////////
	function selectProject( id :Number ) :XML
	{
		selectedProjectId = id;
		selectedProject   = projects.get( selectedProjectId );
		
		return selectedProject;
	}
	function nextProject() :XML
	{
		var hasNext :Boolean;
		hasNext = projects.containsKey( selectedProjectId + 1 );
		selectedProjectId = hasNext ? selectedProjectId + 1 : 0;
		
		return selectProject( selectedProjectId );
	}
	function prevProject()  :XML
	{
		var hasPrev :Boolean;
		hasPrev = projects.containsKey( selectedProjectId - 1 );
		selectedProjectId = hasPrev ? selectedProjectId - 1 : projects.size() - 1;
		
		return selectProject( selectedProjectId );
	}
	
	function setProjects ( a :Array ) 
	{
		projects = new Hash();
		
		var i = a.length;
		while( --i > -1 )
		{
			if( a[ i ].id == -1 ) continue;
			
			projects.put( a[ i ].id, a[ i ] );
			//trace( ["@@@@@ serProjects():" + i, a[ i ], projects.get( a[ i ].id ) ] )
		}
	}
	
	/*//////////////////////////////////////////////////////////////////
	* InformationのGet/Set
	*///////////////////////////////////////////////////////////////////
	function getPlace() :String 
	{
		var place :String = projects.get( selectedProjectId ).place;
		return place;
	}
	function getDate() :Date 
	{
		var d :String = projects.get( selectedProjectId ).date || "--.--.--";
		var a = d.split( "." );
		var date :Date = new Date();
		date.setFullYear( a[0] );
		date.setMonth( a[1] );
		date.setDate( a[2] );
		//trace([ "####:getDate():" + d, a, date ])
		return date;
	}
	function getDateString() :String 
	{
		var d :String = projects.get( selectedProjectId ).date || "--.--.--";
		return d;
	}
	//選択されたTrackの再生時刻
	function getTime() :Date
	{
		var time :String = selectedTrack.data[ selectedTrack.$p ][ 0 ] || "--:--:--";
		//trace([ "####:getTime():" +  time ])
		var a = time.split( ":" );
		var date :Date = new Date();
		date.setHours( a[0] );
		date.setMinutes( a[1] );
		date.setSeconds( a[2] );
		return date;
	}
	//選択されたTrackの再生時刻
	function getTimeString() :String
	{
		var time :String = selectedTrack.data[ selectedTrack.$p ][ 0 ];
		//trace([ "####:getTime():" +  time ])
		return time || "--:--:--";
	}


	/*//////////////////////////////////////////////////////////////////
	* トラックの選択
	*///////////////////////////////////////////////////////////////////
	function selectTrack( id :Number ) :Track
	{
		selectedTrackId = id;
		selectedTrack   = tracks.get( selectedTrackId );
		
		return selectedTrack;
	}
	function nextTrack() :Track
	{
		var hasNext :Boolean;
		hasNext = tracks.containsKey( selectedTrackId + 1 );
		selectedTrackId = hasNext ? selectedTrackId + 1 : 0;
		
		return selectTrack( selectedTrackId );
	}
	function prevTrack()  :Track
	{
		var hasPrev :Boolean;
		hasPrev = tracks.containsKey( selectedTrackId - 1 );
		selectedTrackId = hasPrev ? selectedTrackId - 1 : tracks.size() - 1;
		
		return selectTrack( selectedTrackId );
	}

	/*//////////////////////////////////////////////////////////////////
	* コメントの書き込み・消去
	*///////////////////////////////////////////////////////////////////
	function writeComment( p0 :Number, p1 :Number, type :Number, message :String )
	{
		var tk :Track = selectedTrack;
		
		var comment :Comment = new Comment();
		comment.inP = p0;
		comment.outP = p1;
		comment.message = message;
		
		//in点からout点までコメントを挿入
		var a = tk.commentdata;
		for( var i = p0; i <= p1; i++ )
		{
			a.put( i, comment );
		}
		
		//trace([ "writeComment:", comment ])
	}
	function clearComment()
	{
	}
	
}