﻿import task.Screen;
import task.TipLayer;
import task.BalloonLayer;
import task.Footstep;
import utils.Vector;
import utils.Hash;


class Track
{
	//ビュー
	var HEIGHT = 88;
	var OBJP_WIDTH = 328;
	var SCRP_WIDTH = 568;
	
	var objColumn 	:MovieClip;
	var scoreColumn :MovieClip;
	var objPane 	:MovieClip;
	var scorePane	:MovieClip;
	
	var chara :Chara;
	var chara2D :Chara;
	var chara3D :Chara;
	var charaName :String;
	
	//モデル
	var id 	  :Number;
	var depth :Number;
	var charatype  :Number;
	var characlass :Number;
	var characlass_tbl = [ "Chara", "BabyChara", "WomanChara", "TetekeChara", "TotoChara" ];
	//var characlass_tbl = [ "BabyChara" ];
	
	var HEIGHT_RANGE0 = 10;
	var HEIGHT_RANGE1 = 20;
	var XDR = 5; //ピクセル・データ比

	//データ
	var DATANUM// = 2000;
	var data 	    :Array; //ロコモーション
	var procdata    :Array; //ロコモーション(前処理後)
	var commentdata :Hash; //コメントデータ
	
	/** データ区間 */
	var $p, $q;
	var ratio;
	var offsetX = 0;
	
	var longestDataLength :Number;
	
	
	static var SO0 = ["ExpBleepA_0_.wav", 
			   "ExpBleepB_0.wav"]
	static var SO1 = [ "ExpBleepA_0_.wav", 
			   "ExpBleepB_0.wav",
			   "slip_0.wav",
			   "ExpBleepB_0.wav",
			   "slip_0.wav"];
	static var SO2 = [ 
			   "conga_7.wav",
			   "conga_8.wav",
			   "conga_7.wav",
			   "conga_8.wav",
			   "conga_7.wav",
			   "conga_8.wav",
			   "conga_7.wav",
			   "conga_8.wav",
			   "conga_7.wav",
			   "conga_8.wav",
			   "clap_m1.wav"]
	static var SO3 = [ 
			   "conga_0.wav",
			   "conga_1.wav",
			   "conga_2.wav",
			   "conga_3.wav"];
	static var SO4 = [ 
			   "conga_0.wav",
			   "conga_1.wav",
			   "conga_5.wav",
			   "conga_6.wav"];
	
	static var SO5 = [ 
			   "pom_6.wav", 
			   "pom_0.wav", 
			   "pom_5.wav", 
			   "pom_1.wav",
			   "clap_m1.wav",
			   "pom_6.wav", 
			   "pom_0.wav", 
			   "pom_5.wav", 
			   "pom_6.wav", 
			   "pom_0.wav", 
			   "pom_5.wav", 
			   "pom_6.wav", 
			   "pom_0.wav", 
			   "pom_5.wav", 
			   "pom_6.wav", 
			   "pom_0.wav", 
			   "pom_5.wav"
			   ];
	static var SO6 = [ 
			   "pom_6.wav", 
			   "pom_6.wav", 
			   "pom_6.wav", 
			   "pom_1.wav"
			   ];
	static var SO7 = [ 
			   "pom_6.wav", 
			   "pom_3.wav", 
			   "pom_1.wav", 
			   "pom_3.wav"
			   ];
	static var SO8 = [ 
			   "pom_4.wav", 
			   "pom_2.wav", 
			   "pom_3.wav", 
			   "pom_5.wav"
			   ];
	
	static var SO9 = [ 
			   "clap_m1.wav",
			   "pek_00.wav",
			   "pek_01.wav",
			   "pom_3.wav", 
			   "pom_1.wav", 
			   "slip_0.wav",
			   "ExpBleepB_0.wav",
			   "pek_00.wav",
			   "pek_01.wav",
			   "pom_3.wav", 
			   "pom_1.wav", 
			   "slip_0.wav",
			   "ExpBleepB_0.wav"
			   ]
	static var SO10 = [ 
			   "clap_p1.wav",
			   "conga_0.wav",
			   "pek_11.wav",
			   "slip_0.wav",			
			   "pek_04.wav",
			   "ExpBleepB_0.wav",
			   "conga_1.wav",	
			   "pek_02.wav",
			   "conga_0.wav",
			   "pek_11.wav",
			   "slip_0.wav",			
			   "pek_04.wav",
			   "conga_0.wav",
			   "pek_11.wav",
			   "slip_0.wav",			
			   "pek_04.wav",
			   "ExpBleepB_0.wav",
			   "conga_1.wav",	
			   "pek_02.wav",
			   "conga_0.wav",
			   "pek_11.wav",
			   "slip_0.wav",			
			   "pek_04.wav"
			   ]
	static var SO11 = [ 
			   "pek_04.wav",
			   "pek_11.wav",
			   "slip_0.wav",			
			   "pek_06.wav",			
			   "pek_09.wav",			
			   "pek_11.wav",			
			   "pek_11.wav",
			   "ExpBleepB_0.wav",
			   "pek_02.wav",			
			   "pek_03.wav"
			   ]
	static var SO12 = [ 
			   "pek_01.wav",
			   "pek_08.wav",
			   "slip_0.wav",			
			   "pek_03.wav",			
			   "pek_06.wav",			
			   "pek_09.wav",			
			   "pek_00.wav",
			   "ExpBleepA_0.wav",
			   "pek_07.wav",			
			   "pek_03.wav"
			   ]
	static var SO13 = [ 
			   "conga_0.wav",
			   "conga_1.wav",
			   "conga_2.wav",
			   "conga_3.wav",
			   "conga_4.wav",
			   "conga_5.wav",
			   "conga_6.wav",
			   "conga_7.wav",
			   "conga_8.wav"
			   ]
	static var SO14 = [ 
			   "conga_8.wav",
			   "conga_7.wav",
			   "conga_6.wav",
			   "conga_5.wav",
			   "conga_4.wav",
			   "conga_3.wav",
			   "conga_2.wav",
			   "conga_1.wav",
			   "conga_0.wav"
			   ]
	static var SO15 = [ 
			   "pek_01.wav",
			   "pek_02.wav",
			   "pek_03.wav",			
			   "pek_04.wav",			
			   "pek_05.wav",			
			   "pek_06.wav",			
			   "pek_07.wav",			
			   "pek_08.wav",			
			   "pek_09.wav",			
			   "pek_10.wav",			
			   "pek_11.wav"
			   ]
	static var SO16 = [ 
			   "pek_11.wav",
			   "pek_10.wav",
			   "pek_09.wav",			
			   "pek_08.wav",			
			   "pek_07.wav",			
			   "pek_06.wav",			
			   "pek_05.wav",			
			   "pek_04.wav",			
			   "pek_03.wav",			
			   "pek_02.wav",			
			   "pek_01.wav"
			   ]
	static var SO17 = [ 
			   "pom_6.wav", 
			   "pom_5.wav", 
			   "pom_4.wav", 
			   "pom_3.wav", 
			   "pom_2.wav", 
			   "pom_1.wav", 
			   "pom_0.wav"
			   ]
	static var SO18 = [ 
			   "pom_0.wav", 
			   "pom_1.wav", 
			   "pom_2.wav", 
			   "pom_3.wav", 
			   "pom_4.wav", 
			   "pom_5.wav", 
			   "pom_6.wav"
			   ]
	static var SO19 = [ 
			   "part1.wav", 
			   "part2.wav", 
			   "part3.wav", 
			   "part1.wav", 
			   "part2.wav", 
			   "part3.wav", 
			   "part1.wav",
			   "part2.wav", 
			   "part3.wav", 
			   "part4.wav"
			   ]
	static var SO20 = [ 
			   "part1.wav", 
			   "part2.wav", 
			   "part3.wav", 
			   "part1.wav", 
			   "part2.wav", 
			   "part3.wav", 
			   "part1.wav",
			   "part2.wav", 
			   "part3.wav", 
			   "part4.wav",
			   "part1.wav",
			   "part2.wav", 
			   "part3.wav",
			   "part1.wav",
			   "part2.wav", 
			   "part3.wav", 
			   "part5.wav",
			   "part6.wav"
			   ]
	static var SO21 = [ 
			   "part1.wav", 
			   "sub1.wav", 
			   "sub2.wav", 
			   "part2.wav"
			   ]
	static var SO22 = [ 
			   "pek_01b.wav",
			   "pek_02b.wav",
			   "pek_03b.wav",			
			   "pek_04b.wav",			
			   "pek_05b.wav",			
			   "pek_06b.wav",			
			   "pek_07b.wav",			
			   "pek_08b.wav",			
			   "pek_09b.wav",			
			   "pek_10b.wav",			
			   "pek_11b.wav"
			   ]
	static var SO23 = [ 
			   "pek_11b.wav",
			   "pek_10b.wav",
			   "pek_09b.wav",			
			   "pek_08b.wav",			
			   "pek_07b.wav",			
			   "pek_06b.wav",			
			   "pek_05b.wav",			
			   "pek_04b.wav",			
			   "pek_03b.wav",			
			   "pek_02b.wav",			
			   "pek_01b.wav"
			   ]
	
	static var SO24 = [ 
			   "pi.wav",
			   "po.wav"
			   ]
	
	
	var SEQNUM;
	//var SEQ = [ SO0, SO1, SO2, SO3, SO4, SO5, SO8, SO9, SO10, SO11, SO12 ];
	//var SEQ = [ SO13, SO14, SO16, SO16 ]//, SO17, SO18 ];
	//var SEQ = [ SO19, SO20, SO21 ]//, SO17, SO18 ];
	//var SEQ = [ SO19, SO20, SO21, SO22, SO23 ];
	var SEQ = [ SO24 ];
	
	
	//サウンドオブジェクトのリスト, sobuf[0]はダミー音源配列(null), sobuf[1][i]が音源
	var sobuf :Array;
	var MYSO :Array;
	var LRStep; //0か１
	var step_so :Sound;
	
	function Track( id :Number, type :Number ) 
	{
		//おまじない
		Chara; BabyChara, WomanChara, TetekeChara, TotoChara;
		
		this.id    = id;
		this.depth = id;
		this.charatype = type || 0//Math.round( Math.random() * ( characlass_tbl.length - 1 ) );
		this.characlass = characlass_tbl[ charatype ];
		
		//ダミーデータのデータ長
		DATANUM = 100 * id;
	}
	
	function addLocomotionData ( locomotion :Array, isDammy :Boolean ) 
	{
		data 	 	= [];
		procdata 	= [];
		commentdata = new Hash();
		
		var td = new TrackData( DATANUM, this, locomotion, isDammy );
		
		data 	 	= td.data;
		procdata	= td.procdata;
	}
	
	
	
	//生成時
	function createObjPane() 
	{
		var initObj = { _y :( id ) * HEIGHT };
		objPane = objColumn.attachMovie( "TKObjPane", "TKObjPane" + depth, depth, initObj );
		
		//ダミー
		var d :Date   = _root.getDate();
		var n :String = charaName;
		
		var mm = d.getMonth();
		var dd = d.getDate();
		while( mm.length < 2 ) mm = "0" + mm;
		while( dd.length < 2 ) dd = "0" + dd;
		
		objPane.name.text = n;
		objPane.date.text = d.getFullYear() + "." + mm + "." + dd;
		objPane.alt.text = chara.location[ 2 ];
		objPane.lat.text = chara.location[ 1 ];
		objPane.lng.text = chara.location[ 0 ];
		objPane.velocity.text = chara.velocity;
	}
	function createScorePane() 
	{
		var initObj = { _y :( id ) * HEIGHT };
		scorePane = scoreColumn.attachMovie( "TKScorePane", "TKScorePane" + depth, depth, initObj );
	}
	function createChara() 
	{
		var target :MovieClip = objPane.charaContainer.createEmptyMovieClip( "target", 0 );
		target._x = objPane.charaContainer.origin._x;
		target._y = objPane.charaContainer.origin._y;
		
		chara2D = new _global[ characlass ]( target );
		chara2D.tipName = charaName;
		chara2D.scaleAt( 100 * 1 );
	}
	var chara3DContainer :MovieClip;
	function createCharaOn3D( container :MovieClip ) 
	{
		if( !chara3D )
		{
			//trace( "キャラがない！" )
			chara3DContainer = container.createEmptyMovieClip( "target", 0 );
		
			chara3D = new _global[ characlass ]( chara3DContainer );
			chara3D.tipName = charaName;
			chara3D.scaleAt( 100 * .33 );
		}
		
		return chara3D;
	}
	function createCharaTip( chara :Chara )
	{
		TipLayer.getInstance().addTip( chara, this );
	}
	function removeCharaTip( chara :Chara )
	{
		TipLayer.getInstance().removeTip( chara, this );
	}
	function createCharaBalloon( chara :Chara )
	{
		BalloonLayer.getInstance().addBalloon( chara, this );
	}
	function removeCharaBalloon( chara :Chara )
	{
		BalloonLayer.getInstance().removeBalloon( chara, this );
	}
	function showCharaBalloon( chara :Chara )
	{
		BalloonLayer.getInstance().showBalloon( chara, this );
	}
	function hideCharaBalloon( chara :Chara )
	{
		BalloonLayer.getInstance().hideBalloon( chara, this );
	}
	
	/**
	* トラックのサウンドの初期化。sequenceは外部XMLで制御する。
	* sequence :Array - Footstepシーケンス （FootstepのサウンドIDにひも付けられているIDを要素とする配列）
	*/
	function attachFootstep( sequence :Array )
	{
		//サウンド初期化
		var _seq :Array = MYSO = sequence || [ 0, 1 ];
		var i = SEQNUM = _seq.length;
		var so :Sound;
		sobuf = [];
		sobuf[ 0 ] = null;
		sobuf[ 1 ] = [];
		while( --i > -1 )
		{
			//trace([ "objPane: " + objPane ])
			sobuf[ 1 ][ i ] = Footstep.attach( Number( _seq[ i ] ), objPane );
		}
		
	}

	
	
	//削除時
	function destroy () 
	{
		for( var i in this ) delete this[ i ];
		
		TrackData.removeTrack( this );
		
		delete this;
	}

	function destroyObjPane() 
	{
		objPane.removeMovieClip();
	}
	function destroyScorePane() 
	{
		scorePane.removeMovieClip();
	}

	function destroyChara() 
	{
		objPane.charaContainer.removeMovieClip();
		chara3DContainer.removeMovieClip();
	}
	function destroyCharaTip( chara :Chara ) 
	{
		TipLayer.getInstance().removeTip( chara );
	}

	/*////////////////////////////////////////////////////////////////////////
	
	Score描画まわり
	
	////////////////////////////////////////////////////////////////////////*/
	
	var scr1, scr2, scr3 :MovieClip;
	var $update :Function = upd_null;
	var dataindexer;
	
	var so :Sound;
	var d0, d1;
	
	var screenXYZ :Vector;
	
	//キャラの位置を移動する関数ポインタ
	var locateTo :Function = $locateToNull;
	
	function $locateTo() 
	{
		var screen = Screen.getInstance();
		var nx, ny, nz;
		
		nx = chara.location[ 0 ];
		ny = chara.location[ 1 ];
		nz = chara.location[ 2 ];
		//if( id == 0 )trace([ $p, nx, ny, nz, chara ])
		
		//３D変換(スクリーンに投影)
		var v = new Vector( nx, ny, nz );
		screen.transVector( v );
		screenXYZ = v;
		
		//描画データ更新
		var cx, cy, cz;
		//cx = Math.floor( v.x );
		//cy = Math.floor( v.y );
		//cz = Math.floor( v.z );
		cx = v.x;
		cy = v.y;
		cz = v.z;
		//if( chara.hasStep ) 
		if( chara.hasLocated )
		{
			chara.dx = cx - chara.x;
			chara.dy = cy - chara.y;
			chara.dz = cz - chara.z;
		}
		chara.x = cx;
		chara.y = cy;
		chara.z = cz;
		//trace([ chara.x, chara.y, chara.dx, chara.dy ])
	}
	function $locateToNull() 
	{
		//trace([ "locateToNull" ])
	}


	
	function update () 
	{
		$update();
		
		/*///////////////////////////////////////
		* 
		* キャラのupdateを叩く処理
		/////////////////////////////////////////*/
		var dp = data[ $p ];
		
		var steps = dp[ 1 ];
		var hasStep = dp[ 2 ] && d0 != d1 ;
		var hasLocated = dp[ 10 ] && d0 != d1 ;
		
		//基本データ
		chara.hasStep = hasStep;
		chara.speed = dp[ 7 ];
		chara.velocity = dp[ 8 ];
		chara.staytime = dp[ 9 ];
		chara.hasLocated = hasLocated;
		chara.staytime2 = dp[ 11 ];
		
		//trace([ $p, dp[ 11 ], dp[ 10 ] + "/", dp ])
		
		//1.アニメアクション ---> 今はなし
		//if( dp[ 7 ] )
		if( false )
		{
			chara.update = chara.upd_anim;
		}
		
		//2.基本アクション
		else
		{
			chara.update = chara.upd_normal;
			
			//着地
			chara.steps = steps;
			
			//方位
			chara.angle = dp[ 3 ];
		}
		
		
		//次の足音を決定
		LRStep = steps % 2;
		step_so = sobuf[ Number( hasStep ) ][ steps % MYSO.length ];
		step_so.setPan( 100 * LRStep * 2 - 1 );
		
		
		//前処理語の位置座標を取得
		var dp = procdata[ $p ];
		//trace([ dp ]);
		chara.location0 = [ chara.location[ 0 ], chara.location[ 1 ], chara.location[ 2 ], $p - 1  ]; //lon, lat, alt
		chara.location = [ dp[ 0 ], dp[ 1 ], dp[ 2 ], $p  ]; //lon, lat, alt
		
		//Locationを移動(3Dモードのみ有効)
		locateTo( dp );
		
		/*///////////////////////////////////////
		* 
		* コメント！
		/////////////////////////////////////////*/
		var hasComment :Boolean = commentdata.containsKey( $p );
		//trace([ $p, hasComment ])
		if( hasComment ) 
		{
			var comm = commentdata.get( $p );
			chara.comm = comm.message;
			//trace([ comm.message ])
			
			//removeCharaBalloon( chara, this );
			//createCharaBalloon( chara, this );
			
			showCharaBalloon( chara, this );
		}
		else
		{
			chara.comm = "";
			//removeCharaBalloon( chara, this );
			
			hideCharaBalloon( chara, this );
		}
		
		
		//更新
		chara.update();
	}
	
	
	
	function draw () 
	{
		var target = scorePane.canvas;
		
		//描画		
		target.clear();
		//drawBound( target );
		drawZoneData( $p, $q, target );	
		target._x = offsetX;
		
		//音の再生
		step_so.start();
		
		//キャラ描画更新
		chara.draw();
		
		//情報パネル
		var pane = objPane;
		pane.date.text = Project.getInstance().getDateString();
		pane.steps.text = chara.steps;//chara.location[ 2 ];
		pane.sty.text = chara.staytime;//chara.location[ 1 ];
		pane.spd.text = Math.floor( chara.speed * 10000 ) / 10000;//chara.location[ 0 ];
		pane.velocity.text = Math.floor( chara.velocity * 10000 ) / 10000;
		pane.hitSign.gotoAndStop( chara.hasStep + 1 );
	}

	//ダミーのupdate関数
	function upd_null() 
	{
	};
	//現在の状態を保持するupdate関数(更新しない)
	function upd_retain() 
	{
		var target = scorePane.canvas;
		
		//ピクセルデータ比を変更を反映
		XDR = scr2.$ratio * 10 + 1;
		target._xscale = 100 * XDR;
		
		//表示範囲の更新
		updateArea();
	};
	//シーク中のupdate関数
	function upd_seek () 
	{
		var target = scorePane.canvas;
		
		//スクロール位置をゲット
		var ratio = scr1.$ratio;
		
		//ピクセルデータ比を変更を反映
		XDR = scr2.$ratio * 10 + 1;
		target._xscale = 100 * XDR;
		
		//表示範囲の更新
		offsetX  = ( 0 - longestDataLength * XDR ) * ratio;
		updateArea();
		
		if( offsetX <= ( 0 - longestDataLength  * XDR ) + 1 ) offsetX = 0;
		
		//データのindexを更新
		dataindexer.index = Math.floor( ratio * longestDataLength );
	}
	//再生中のupdate関数
	function upd_proceed () 
	{
		var target = scorePane.canvas;
		var t = dataindexer.index;
		
		
		//ピクセルデータ比を変更を反映
		XDR = scr2.$ratio * 10 + 1;
		target._xscale = 100 * XDR;
		
		
		//表示範囲の更新
		offsetX = -XDR * t;
		
		updateArea();	
		if( offsetX <= ( 0 - longestDataLength * XDR ) + 1 ) offsetX = 0;
		
		//スクロールバーを更新
		scr1.$ratio = offsetX / ( 0 - longestDataLength * XDR );
	}
	//シーク中のupdate関数
	function upd_seek3D () 
	{
		var target = scorePane.canvas;
		
		//スクロール位置をゲット
		var ratio = scr3.$ratio;
		
		//ピクセルデータ比を変更を反映
		XDR = scr2.$ratio * 10 + 1;
		target._xscale = 100 * XDR;
		
		//表示範囲の更新
		offsetX  = ( 0 - longestDataLength * XDR ) * ratio;
		updateArea();
		
		if( offsetX <= ( 0 - longestDataLength  * XDR ) + 1 ) offsetX = 0;
		
		//データのindexを更新
		dataindexer.index = Math.floor( ratio * longestDataLength );
	}
	//再生中のupdate関数
	function upd_proceed3D () 
	{
		var target = scorePane.canvas;
		var t = dataindexer.index;
		
		
		//ピクセルデータ比を変更を反映
		XDR = scr2.$ratio * 10 + 1;
		target._xscale = 100 * XDR;
		
		
		//表示範囲の更新
		offsetX = -XDR * t;
		
		updateArea();	
		if( offsetX <= ( 0 - longestDataLength * XDR ) + 1 ) offsetX = 0;
		
		//スクロールバーを更新
		scr3.$ratio = offsetX / ( 0 - longestDataLength * XDR );
	}

	
	function getIndex( xi, xoff )
	{
		return Math.floor( ( xi - xoff ) / XDR );
	}
	
	function updateArea() 
	{
		//pとｑを更新する
		$p = getIndex(  0, 			offsetX );
		$q = getIndex( SCRP_WIDTH, 	offsetX );
		//trace( [ $p, $q ] );
	}
	
	function drawZoneData( p, q, tgt :MovieClip ) 
	{
		var a = data;
		var i = q - p;
		var j;
		
		var y;
		var H = HEIGHT *.5;
		
		var LR = [ -1, 1 ];
		
		//頂点データを描画
		while( --i > -1 )
		{
			j = i + p;
			//着地したか？(hasStep)
			//if( !a[ j ][ 0 ] ) continue;
			//if( !a[ j ][ TrackData.I_HASSTEP ] ) continue;
			if( !a[ j ][ 2 ] ) continue;
			
			//トラックの上下にはみ出ないようクリッピング
			y = a[ j - 1 ][ 9 ] / 10 * H//a[ j ][ 7 ] * .5;//a[ j ][ 4 ];
			y = y > H ? H : y;
			
			drawLine( tgt, 
					  j, 0, 
					  j, y * LR[ a[ j ][ 1 ] % 2 ] );
		}
	}
	function drawData( tgt ) 
	{
		var a = data;
		var i = a.length;
		
		//頂点データを描画
		while( --i > -1 )
		{
			//if( !a[ i ][ 0 ] ) continue;
			if( !a[ i ][ TrackData.I_HASSTEP ] ) continue;
			if( !a[ i ][ 2 ] ) continue;
			//drawLine( tgt, i, 0, i, a[ i ][ 1 ] );
			drawLine( tgt, 
					  i, 0, 
					  i, a[ i ][ 4 ] );
		}
	}

	function drawLine( mc :MovieClip, x1, y1, x2, y2, color ) 
	{
		with( mc )
		{
			lineStyle( 1, color | 0x000000, 80, false, "vertical", "none" );
			moveTo( x1, y1 );
			lineTo( x2, y2 );
		}
	}

}