﻿import utils.Hash;

class TrackData
{
	
	//静的データのインデックス
	static var I_TIME     	= 0; //時刻 time
	static var I_STEPS    	= 1; //歩数(トータル) steps
	static var I_HASSTEP  	= 2; //着地(１歩)
	static var I_ANGLE		= 3; //向き head
	static var I_ALT	    = 4; //高度 DAlt
	static var I_LAT	 	= 5; //緯度 DLat
	static var I_LON		= 6; //経度 DLon
	static var I_ACT		= 7; //アクション種別
	
	//データ範囲
	static var LX = .0000001//0;
	static var LY = .0000001//0;
	static var LZ = 1//0;
	static var CX = 0;
	static var CY = 0;
	static var CZ = 0;
	static var isRangeChanged :Boolean;
	static var longestDataLength :Number = 1;
	static var track :Hash = new Hash();
	
	var data 		:Array; //ロコモーション
	var procdata 	:Array; //ロコモーション（前処理後）
	
	
	function TrackData( num, tk :Track, locomotion :Array, isDammy :Boolean ) 
	{
		//トラックをハッシュ
		addTrack( tk );
		
		if( isDammy )
		{
			trace( "[TrackData:Dammyモード]" );
			//ダミーデータの作成
			makeDammyData();
		}
		
		else
		{
			trace( "[TrackData:CSVモード]" );
			addLocomotionData( locomotion );
		}
	}

	function addLocomotionData ( locomotion :Array ) 
	{
		data = locomotion;
		
		//trace([ "addLocomotionData:", data[ 0 ] ])
		
		//データの前処理
		procdata = preprocess( data );
		
		
		//最長データ長を更新	
		//最長データ長が変わったならすべてのトラックの最長データ長を更新
		if( data.length > longestDataLength )
		{
			longestDataLength = data.length;
			
			var a = track.getValues();
			var i = a.length;
			while( --i > -1 )
			{
				a[ i ].longestDataLength = longestDataLength;
			}
		}
		
		//データレンジが変わったならすべてのトラックデータを更新
		if( isRangeChanged )
		{
			var a = track.getValues();
			var i = a.length;
			while( --i > -1 )
			{
				a[ i ].procdata = re_preprocess( a[ i ].data );
			}
			
			isRangeChanged = false;
		}
	}

	function makeDammyData2 ( num ) 
	{
		data = [];
		
		var a = [];
		
		a[ 0 ] = [ 0, 0, 0, 0, 10 ];
		a[ 1 ] = [ 0, 1, 1, 0, 10 ];
		a[ 2 ] = [ 0, 0, 0, 0, 10 ];
		a[ 3 ] = [ 0, 0, 0, 0, 10 ];
		a[ 4 ] = [ 0, 2, 1, 0, 20 ];
		a[ 5 ] = [ 0, 0, 0, 0, 20 ];
		a[ 6 ] = [ 0, 0, 0, 0, 20 ];
		a[ 7 ] = [ 0, 3, 1, 0, 30 ];
		a[ 8 ] = [ 0, 0, 0, 0, 30 ];
		a[ 9 ] = [ 0, 0, 0, 0, 30 ];
		
		data = a;
	}
	
	static function removeTrack ( tk :Track ) 
	{
		track.remove( tk.id );
	}
	static function addTrack ( tk :Track ) 
	{
		track.put( tk.id, tk );
	}

	static var count = 0;
	function makeDammyData ( num ) 
	{
		//データの生成
		data 	 = new AlgorithmedData( num ).data;
				
		//データの前処理
		procdata = preprocess( data );
		
		
		//最長データ長を更新	
		//最長データ長が変わったならすべてのトラックの最長データ長を更新
		if( data.length > longestDataLength )
		{
			longestDataLength = data.length;
			
			var a = track.getValues();
			var i = a.length;
			while( --i > -1 )
			{
				a[ i ].longestDataLength = longestDataLength;
			}
		}
		
		//データレンジが変わったならすべてのトラックデータを更新
		if( isRangeChanged )
		{
			var a = track.getValues();
			var i = a.length;
			while( --i > -1 )
			{
				a[ i ].procdata = re_preprocess( a[ i ].data );
			}
			
			isRangeChanged = false;
		}
	}
	
	function makeDammyDataFromNum ( num ) 
	{
		data = [];
		procdata = [];
		
		var a  = [];
		var l  = num;
		var i  = 0;
		
		//初期値
		var time0 = 0;
		var steps0 = 0;
		var hasstep0 = 0;
		var angle0 = 0;
		var alt0 = 10;
		var lat0 = 34;
		var lon0 = 139;
		var act0 = 0;
		
		
		a[ 0 ] = [];
		a[ 0 ][ 0 ] = time0;
		a[ 0 ][ 1 ] = steps0;
		a[ 0 ][ 2 ] = hasstep0;
		a[ 0 ][ 3 ] = angle0;
		a[ 0 ][ 4 ] = alt0;
		a[ 0 ][ 5 ] = lat0;
		a[ 0 ][ 6 ] = lon0;
		a[ 0 ][ 7 ] = act0;
		
		//trace([ "[ " + i + " ]", a[ i ] ]);
		
		while( ++i < l )
		{
			a[ i ] = [];
			a[ i ][ 0 ] = a[ i - 1 ][ 0 ] + 250;
			a[ i ][ 1 ] = a[ i - 1 ][ 1 ] + Math.round( Math.random() );
			a[ i ][ 2 ] = Math.floor( a[ i ][ 1 ] - a[ i - 1 ][ 1 ] );
			a[ i ][ 3 ] = Math.floor( Math.random() * 360 );//Math.floor( a[ i - 1 ][ 1 ] + Math.random() * 30 );
			a[ i ][ 4 ] = Math.floor( Math.random() * 30 );
			a[ i ][ 5 ] = lat0 = lat0 + ( Math.random() * .00001 ) * ( Math.random() < .5 ? -1 : 1 );
			a[ i ][ 6 ] = lon0 = lon0 + ( Math.random() * .00001 ) * ( Math.random() < .5 ? -1 : 1 );
			a[ i ][ 7 ] = 0;
			
			//trace([ a[ i ][ 5 ],a[ i ][ 6 ] ])
		}
		
		data 	 = a;
		procdata = preprocess( a );
		
	}
	/*
	*/
		
	function preprocess( arr ) 
	{
		var x, y, z;
		var bx, by, bz;
		var bcx, bcy, bcz;
		var blx, bly, blz;
		var dx, dy, dz;
		var sx, sy, sz;
	
		var cx, cy, cz; //中央座標
		var lx, ly, lz; //長さ
		var x0, x1, y0, y1, z0, z1;
		
		//戻り値
		var ret = [];
	
		
		//中央値と距離を求める
		x0 = x1 = arr[ 0 ][ 6 ];
		y0 = y1 = arr[ 0 ][ 5 ];
		z0 = z1 = arr[ 0 ][ 4 ];

		//Y軸補正
		y0 = y1 = 180 - ( y0 + 90 );

		//trace([ "中央値と距離を求める:" + x0, y0, z0, arr[ 0 ][ 6 ], arr[ 0 ][ 5 ], arr[ 0 ][ 4 ], arr[ 0 ] ])
		
		var $x, $y, $z;
		var i = arr.length;
		while( --i > -1 )
		{
			$x = arr[ i ][ 6 ];
			$y = 180 - ( arr[ i ][ 5 ] + 90 ); //Y軸補正
			$z = arr[ i ][ 4 ];
			
			x0 = x0 < $x ? x0 : $x;
			y0 = y0 < $y ? y0 : $y;
			z0 = z0 < $z ? z0 : $z;
			x1 = x1 > $x ? x1 : $x;
			y1 = y1 > $y ? y1 : $y;
			z1 = z1 > $z ? z1 : $z;
		}
		
		lx = x1 - x0;
		ly = y1 - y0;
		lz = z1 - z0;
		
		
		//プロジェクト全体の中央値・距離と比較更新
		var isLXChanged, isLYChanged, isLZChanged :Boolean; 
		if( lx > LX ) { LX = lx; isLXChanged = true; }
		else 		  { lx = LX; isLXChanged = false; };
		if( ly > LY ) { LY = ly; isLYChanged = true; }
		else 		  { ly = LY; isLYChanged = false; };
		if( lz > LZ ) { LZ = lz; isLZChanged = true; }
		else 		  { lz = LZ; isLZChanged = false; };
		isRangeChanged = ( isLXChanged || isLYChanged || isLZChanged );
		
		cx = x0 + lx *.5;
		cy = y0 + ly *.5;
		cz = z0 + lz *.5;
		
		//trace([ "プロジェクト全体の中央値・距離と比較更新:" + cx, cy, cz ])
		
		
		//1.軸間のスケール差異を解消するためバイアスを掛ける
		bcx = lonToMeter( cx );
		blx = lonToMeter( lx )// * .5; //マジックナンバー .5
		bcy = latToMeter( cy );
		bly = latToMeter( ly )// * .5; //マジックナンバー .5
		bcz = cz;
		blz = lz;
		var sc = Math.max( blx, bly );
			sc = Math.max( blz, sc );
			
			sc = Stage.height / sc;
			//sc = 256 / sc;
			
		//trace([ "軸間のスケール差異を解消するためバイアスを掛ける:" + bcx, bcy, bcz, blx, bly, blz, sc ])
			
		
		var i = arr.length;
		while( --i > -1 )
		{
			x = arr[ i ][ 6 ];
			y = arr[ i ][ 5 ];
			z = arr[ i ][ 4 ];
			
			//0.Y軸をスクリーン座標に合わせて反転
			y  = 180 - (  y + 90 );
			cy = 180 - ( cy + 90 );
		
			//1.軸間のスケール差異を解消するためバイアスを掛ける
			bx  = lonToMeter( x );
			by  = latToMeter( y );
			bz  = z;
			
			//2.空間の中央点を原点へ移動
			dx = bx - bcx;
			dy = by - bcy;
			dz = bz - z0 + 10;	//ゼロを原点
			
			//3.スケーリング
			sx = dx * sc;
			sy = dy * sc;
			//sz = dz * 125 / lz; // --> Zのスケーリングだけ特殊...あとで考えよう。
			//sz = dz * 125 * 8 / lz; // --> Zのスケーリングだけ特殊...あとで考えよう。
			sz = dz * sc; // --> Zのスケーリングだけ特殊...あとで考えよう。
			
			//4.格納
			ret[ i ] = [ sx, sy, sz ];
			
			//trace([ 100 / lz, dz ])
		}
		
		return ret;
	}
	
	function re_preprocess( arr ) 
	{
		
		return preprocess( arr );
		
	}

	/**
	* SEE: http://www.meridianworlddata.com/Distance-Calculation.asp
	*/
	function calcDist( lon1 :Number, lat1 :Number, 
					   lon2 :Number, lat2 :Number, inMile :Boolean ) :Number
	{
		var R		   :Number = 3963.0;	//地球の半径（マイル単位）
		var D		   :Number = 57.2958;	//緯度一度分の距離（赤道付近では経度一度分の距離でもある）
		var MILE	   :Number = 1.0;
		var KILLOMETER :Number = 1.609344;
		var MULTIPLIER :Number = inMile ? MILE : KILLOMETER;
		
		
		return MULTIPLIER * R * Math.acos
			   ( 
					Math.sin( lat1 / D ) * Math.sin( lat2 / D ) + 
					Math.cos( lat1 / D ) * Math.cos( lat2 / D ) * 
					Math.cos( lon2 / D - lon1 / D ) 
			   );
	}
	
	function lonToMeter( lon :Number ) 
	{
		return calcDist( 0, 0, lon, 0 ) * 1000;
	}
	function latToMeter( lat :Number ) 
	{
		return calcDist( 0, 0, 0, lat ) * 1000;
	}

}