﻿import utils.*;
import task.*;
import flash.display.BitmapData;
import flash.geom.*;
import mx.controls.tracklist_cb;


class task.BalloonLayer
{
	private static var instance :BalloonLayer;
	private static var sprite   :MovieClip;
	
	var $func_main :Function = func_null;
	var $func_draw :Function = func_null;
	
	var scale, x, y;
	var balloons :Hash;
	
	//================================================================================================
	
	//	CONSTRUCTOR
	
	//================================================================================================
	
	private function BalloonLayer()
	{
		
		refresh();
		
		//次の状態へ
		//changeState( S_WAIT );
		$func_main = func_updateBalloons;
		$func_draw = func_drawBalloons;
	}
	
	public static function getInstance()
	{
		if( !instance )
		{
			instance = new BalloonLayer();
		}
		
		return instance;
	}
	
	public function refresh() :Boolean
	{
		//参照を解放
		balloons = new Hash();
		
		//_rootを基準(ステージ左上)
		x = 0;
		y = 0;
		scale = 100;
		
		//コンテナ
		sprite = createNew();
		
		//trace([ "balloonレイヤ：refresh", sprite ])
		
		return true;
	}
	
	public function getLayer()
	{
		return sprite;
	}
	
	public function addBalloon( chara :Chara, track :Track )
	{
		var balloon :Balloon = BalloonFactory.createBalloon( track );
		
		//Balloonとキャラを関連づける
		balloon.chara = chara;
		
		balloons.put( chara, balloon );
		
		//trace([ "BalloonLayer.addBalloon::", chara, balloon.sprite ])
	}
	public function removeBalloon( chara :Chara )
	{
		var balloon :Balloon;
		balloon = balloons.get( chara );
		balloon.destroy();
		balloons.remove( chara );
	}
	
	private function createCharaBalloon() :Balloon
	{
		return BalloonFactory.createBalloon();
	}
	public function hideBalloon( chara :Chara )
	{
		var balloon :Balloon;
		balloon = balloons.get( chara );
		balloon.hide();
	}
	public function showBalloon( chara :Chara )
	{
		var balloon :Balloon;
		balloon = balloons.get( chara );
		balloon.show();
	}
	
	function layerOn () 
	{
		sprite._visible = true;
	}
	function layerOff () 
	{
		sprite._visible = false;
	}
	
	//================================================================================================
	
	//	PROCEDURE
	
	//================================================================================================
	
	public function main()
	{
		$func_main();
	}
	
	public function draw()
	{
		$func_draw();
	}
	
	
	//================================================================================================
	
	//	PRIVATE FUNC
	
	//================================================================================================
	
	//========================================
	// 待機
	//========================================
	
	/**
	* Null関数
	*/
	private function func_null() :Void
	{
	}
	
	function func_updateBalloons() :Void
	{
		var a :Array = balloons.getValues();
		var i = a.length;
		while( --i > -1 )
		{
			var balloon :Balloon = a[ i ];
			balloon.main();
		}
	}
	
	function func_drawBalloons() :Void
	{
		var a :Array = balloons.getValues();
		var i = a.length;
		while( --i > -1 )
		{
			var balloon :Balloon = a[ i ];
			balloon.draw();
		}
	}
	
	private function createNew() :MovieClip
	{
		var mc  = AppInfo.root.createEmptyMovieClip( "balloonLayer", 12678 );
		return mc;
	}
}