﻿import utils.*;
import task.*;
import scenes.*;
import flash.display.BitmapData;
import flash.geom.*;


class task.FootprintLayer
//extends Task
{
	static var singleton :FootprintLayer;
	var sprite :MovieClip;
	var footprints :Hash;
	
	private function FootprintLayer( sprite :MovieClip )
	{
		singleton = this;
		this.sprite = sprite;
		refresh();
	}
	
	static function getInstance ( sprite :MovieClip ) :FootprintLayer
	{
		if( !singleton ) singleton = new FootprintLayer( sprite );
		return singleton;
	}

	
	function refresh () 
	{
		var a = footprints.getValues();
		var i = a.length;
		while( --i > -1 )
		{
			a[ i ].destroy();
		}
		footprints.clear();
		footprints = new Hash();
	}
	function destroy () 
	{
	}

	
	function addFootprint ( key :Track, data :Array ) 
	{
		var footprint = createFootprint( key );
		footprint.setData( data );
		footprints.put( key, footprint );
	}
	
	function removeFootprint ( key )
	{
		var r = footprints.get( key );
		r.destroy();
		footprints.remove( key );
	}
	function createFootprint( key ) 
	{
		var d = sprite.getNextHighestDepth();
		var mc = sprite.createEmptyMovieClip( "footprint" + d, d );
		return new Footprint( key, mc );
	}

	
	function main () 
	{
		var a = footprints.getValues();
		var i = a.length;
		while( --i > -1 )
		{
			a[ i ].main();
		}
		
	}
	
	function draw () 
	{
		var a = footprints.getValues();
		var i = a.length;
		while( --i > -1 )
		{
			a[ i ].draw();
		}
	}
	
	function redraw () 
	{
		var a = footprints.getValues();
		var i = a.length;
		while( --i > -1 )
		{
			a[ i ].redraw();
		}
	}
	


}