﻿import flash.display.*;
import flash.geom.*;
import utils.Hash;
import utils.ColorSet;
import task.Screen;


class task.ObjLayer
{
	static var singleton :ObjLayer;
	var main :Function;
	var draw :Function;
	
	static var DISPLWIDTH  = Stage.width*3;
	static var DISPLHEIGHT = Stage.height*3;
	
	static var quadra0_lnk :String = "quadra0.png";
	static var quadra1_lnk :String = "quadra1.png";
	static var quadra2_lnk :String = "quadra2.png";
	static var quadra3_lnk :String = "quadra3.png";
	static var drawobj_lnk :String = "drawobj.png";
	//static var drawobj_lnk :String = "quadra1.png";
	
	//ブラシ
	//static var currentBrush :Array = Brush.getBrush( Brush.BALL );
	static var currentBrush :BitmapData = Brush.getBrush( Brush.FELT );
	var brushPoints :Hash;
	var brushes 	:Hash;
	var isDraw 		:Hash; //描画更新フラグ(キャラが移動かつ未描画ならtrue, 一度描画したらfalse)
	
	
	var DRAWCOUNT = 10;
	var counter :Hash;
	
	var screen :Screen;
	
	var cont 		:MovieClip;
	var displayMC 	:MovieClip;
	var displayRect :Rectangle;
	var drawobj 	:BitmapData;
	var drawobjmask :BitmapData;
	var drawobjRect :Rectangle;
	var diagRect	:Rectangle;
	
	var quadra  :Array = new Array( 4 );
	var quadra0 :Array = new Array();
	var quadra1 :Array = new Array();
	var quadra2 :Array = new Array();
	var quadra3 :Array = new Array();
	
	var buffer  :Array = new Array( 4 );
	var buffer0 :BitmapData;
	var buffer1 :BitmapData;
	var buffer2 :BitmapData;
	var buffer3 :BitmapData;
	
	var geometry :BitmapData;
	var tempbf   :BitmapData;
	
	var drawobjData :Hash;
	
	var W, H, HW, HH, w, h, hw, hh;
	var DIAG, diag;
	var quadraOffset :Array = new Array( 4 );
	var offset :Rectangle; //象限のマージン含めたrect (x,y,w,h)=(オフセットx,オフセットy,バッファ幅,バッファ高さ)
	
	var schemeChanged :Boolean;
	
	
	static function getInstance( sprite :MovieClip, screen :Screen ) :ObjLayer
	{
		if( !singleton ) singleton = new ObjLayer( sprite, screen );
		return singleton;
	}
	
	private function ObjLayer ( sprite :MovieClip, screen :Screen ) 
	{
		//MCの生成
		cont = sprite;
		displayMC = cont.createEmptyMovieClip( "displayMC", 0 );
		
		
		//ブラシ
		brushes		= new Hash();
		brushPoints = new Hash();
		isDraw 		= new Hash();
		
		var cs :ColorScheme = ColorScheme.getInstance();
		cs.addListener( this );
		
		this.screen = screen;
		
		//表示用バッファを用意
		offset = new Rectangle( 128 / 2, 128 / 2, DISPLWIDTH, DISPLHEIGHT );
		//offset = new Rectangle( 16 / 2, 16 / 2, 128, 128 );
		//buffer[ 0 ] = buffer0 = BitmapData.loadBitmap( quadra0_lnk );
		//buffer[ 1 ] = buffer1 = BitmapData.loadBitmap( quadra1_lnk );
		//buffer[ 2 ] = buffer2 = BitmapData.loadBitmap( quadra2_lnk );
		//buffer[ 3 ] = buffer3 = BitmapData.loadBitmap( quadra3_lnk );
		buffer[ 0 ] = buffer0 = new BitmapData( offset.width/2 + offset.x*2, offset.height/2 + offset.y*2, true, 0 );
		buffer[ 1 ] = buffer1 = new BitmapData( offset.width/2 + offset.x*2, offset.height/2 + offset.y*2, true, 0 );
		buffer[ 2 ] = buffer2 = new BitmapData( offset.width/2 + offset.x*2, offset.height/2 + offset.y*2, true, 0 );
		buffer[ 3 ] = buffer3 = new BitmapData( offset.width/2 + offset.x*2, offset.height/2 + offset.y*2, true, 0 );
		W = buffer3.width;
		H = buffer3.height;
		HW = W / 2;
		HH = H / 2;
		DIAG = Math.sqrt( W*W + H*H );
		displayRect = new Rectangle( 0, 0, W, H );
		
		//trace(displayRect)
		
		//buffer0.fillRect( displayRect, 0 );
		//buffer1.fillRect( displayRect, 0 );
		//buffer2.fillRect( displayRect, 0 );
		//buffer3.fillRect( displayRect, 0 );
		
		
		//描画オブジェクトを用意
		drawobj = BitmapData.loadBitmap( drawobj_lnk );
		w = drawobj.width;
		h = drawobj.height;
		hw = w / 2;
		hh = h / 2;
		diag = Math.sqrt( w*w + h*h + h*h );
		drawobjRect = new Rectangle( 0, 0, w, h );
		diagRect    = new Rectangle( 0, 0, diag, diag );
		
		
		
		//幾何変換用ビットマップ
		geometry = new BitmapData( W, H, true, 0 );
		tempbf   = new BitmapData( W, H, true, 0 );
		
		
		//象限キューを用意
		quadra[ 0 ] = quadra0;
		quadra[ 1 ] = quadra1;
		quadra[ 2 ] = quadra2;
		quadra[ 3 ] = quadra3;
		
		//象限のオフセット
		
		quadraOffset[ 0 ] = new Point( W - offset.x, H - offset.y );
		quadraOffset[ 1 ] = new Point( 0 + offset.x, H - offset.y );
		quadraOffset[ 2 ] = new Point( W - offset.x, 0 + offset.y );
		quadraOffset[ 3 ] = new Point( 0 + offset.x, 0 + offset.y );
		//trace( quadraOffset)
		
		
		//表示用コンテナにバッファを転送
		var mc :MovieClip;
		var m :Matrix = new Matrix();
		mc = displayMC.createEmptyMovieClip( "inner0", 0 );
		mc.attachBitmap( buffer[ 0 ], 0, "auto", false );
		m.identity();
		m.translate( -W + offset.x, -H + offset.y );
		mc.transform.matrix = m;
	
		mc = displayMC.createEmptyMovieClip( "inner1", 1 );
		mc.attachBitmap( buffer[ 1 ], 0, "auto", false );
		m.identity();
		m.translate(  0 - offset.x, -H + offset.y );
		mc.transform.matrix = m;
		
		mc = displayMC.createEmptyMovieClip( "inner2", 2 );
		mc.attachBitmap( buffer[ 2 ], 0, "auto", false );
		m.identity();
		m.translate( -W + offset.x,  0 - offset.y );
		mc.transform.matrix = m;
		
		mc = displayMC.createEmptyMovieClip( "inner3", 3 );
		mc.attachBitmap( buffer[ 3 ], 0, "auto", false );
		m.identity();
		m.translate(  0 - offset.x,  0 - offset.y );
		mc.transform.matrix = m;
		
		/*
		drawRect( displayMC.inner0, offset );
		drawRect( displayMC.inner1, offset );
		drawRect( displayMC.inner2, offset );
		drawRect( displayMC.inner3, offset );
		
		function drawRect ( mc, offset )
		{
			
			with( mc )
			{
				lineStyle( 0, 0x333333, 80 )
				moveTo( 0, 0 );
				lineTo( mc._width, 0 );
				lineTo( mc._width, mc._height );
				lineTo( 0, mc._height );
				lineTo( 0, 0 );
				
				lineStyle( 0, 0x33FF00, 80 )
				moveTo( offset.x, 			  offset.y );
				lineTo( mc._width - offset.x, offset.y );
				lineTo( mc._width - offset.x, mc._height - offset.y );
				lineTo( offset.x, 			  mc._height - offset.y );
				lineTo( offset.x, 			  offset.y );
			}
		}
		*/

		//描画オブジェクトのデータオブジェクトを格納する配列を用意
		drawobjData = new Hash();
			
		//描画カウンタハッシュ
		counter = new Hash();
		
		//関数ポインタの初期化
		main = $main;
		draw = $draw;
		
		$x = $y = 0;
	}

	
	var degree = 0;
	var radian = 0;
	
	var $x, $y;
	function $main () 
	{
		//trace([ "ObjLayer.main()" ]);
		var x, y, z;
		var r, s;
		var qoff = quadraOffset;
		var off;
		var n;
		var a = drawobjData.getValues();
		var i = a.length;
		var chara;
		var PI_180 = Math.PI / 180;
		var $zeroCounter  = zeroCounter;
		var $resetCounter = resetCounter;
		
		var tk :Track;
		var $brushPoints :Hash = brushPoints;
		var $isDraw   	 :Hash = isDraw;
		var $addPoint :Function = addPoint;
		var $brushR = 32;
		
		//デバッグ用
		degree++;
		//degree -= 180;
		radian = degree * PI_180;
		
		//カラースキームが変わったら
		//色の決定
		var cs = ColorScheme.getInstance();
		if( schemeChanged )
		{
			schemeChanged = false;
			var i = a.length;
			//トラックの数(drawobjData)だけループ
			while( --i > -1 )
			{
				var colors = cs.brush;
				var n = Math.round( Math.random() * colors.length );
				a[ i ].color = colors[ n ];
				//trace([ "STAMP:" + a[i].color ])
			}
		}
		
		var i = a.length;
		//トラックの数(drawobjData)だけループ
		while( --i > -1 )
		{
			
			chara = a[ i ].track.chara;
			
			//タイムラインの先頭ならブラシ座標初期化
			if( tk.$p == 0 )
			{
				//trace([ "タイムラインの先頭ならブラシ座標初期化:", tk.$p ])
				$brushPoints.put( tk, [] );
			}
			
			//歩いてなければスキップ
			if( !chara.hasStep ) 
			{
				//$minusCounter(i);
				$zeroCounter(i);
				continue;
			}
			
			//描画カウンタを戻す
			//$resetCounter(i);
			//$minusCounter(i);
			if( counter.get( i ) === null )
			{
				$resetCounter(i);
			}
			
			x = chara.x + 0;
			y = chara.y + 0;
			z = chara.z;
			r = chara.angle - 90;
			if( r < 0 )   r += 360;
			if( r >= 360 ) r -= 360;
			//trace( r )
			
			//s = chara.staytime * .40;
			//s = chara.staytime * .16;
			s = chara.staytime * .16 *.3;
			//if( s < .25 ) s = .25;
			if( s < .25 *.3 ) s = .25 *.3;
			if( s > 2 ) s = 2;
			
			//ブラシ座標の追加
			$addPoint( $brushPoints.get( tk ), x, y, z, s, a[ i ].color );
			$isDraw.put( tk, true );
			
			/*****************************************************************
									コ　コ　カ　ラ
									
			１．x, yを各象限に合わせた座標値に変換する
			下記プロセスを、処理を軽くする方法は？
			******************************************************************/
			//象限を決定
			if( y < 0 )
			{
				if( x < 0 )
				{
					n = 0;
					off = qoff[ n ];
					x = x + off.x;
					y = y + off.y;
				}
				else		
				{
					n = 1;
					off = qoff[ n ];
					x = x + off.x;
					y = y + off.y;
				}
			}
			else
			{
				if( x < 0 ) 
				{
					n = 2;
					off = qoff[ n ];
					x = x + off.x;
					y = y + off.y;
				}
				else		
				{
					n  = 3;
					off = qoff[ n ];
					x = x + off.x;
					y = y + off.y;
				}
			}
			
			quadra[ n ].push( { x :x, y :y, offset :off, id :i,
							    degree :r, scale :s, 
								color :a[ i ].color } );
			
			//trace([ i, x, y, n ])
			/*****************************************************************
									コ　コ　マ　デ
			******************************************************************/
		}
	}
	
	
	function addPoint ( data :Array, x, y, z, p, color ) 
	{
		var x1, y1, z1, dir;
		var i = data.length;
		x1 = x - data[ i - 1 ].x;
		y1 = y - data[ i - 1 ].y; 
		z1 = z - data[ i - 1 ].z; 
		dir = Math.atan2( y1, x1 );
		if( !dir ) dir = data[ i - 1 ].dir;
		
		data[ i ] = new BrushPoint4( x, y, z, p, dir, color );
	}
	
	function $draw () 
	{
		var obj  :BitmapData; //描画オブジェ
		var buf  :BitmapData; //表示用バッファ
		var geom :BitmapData; //幾何変換用バッファ
		var temp :BitmapData; //一時バッファ
		var rect1:Rectangle;
		var rect2:Rectangle;
		var rect3:Rectangle;
		var rect4:Rectangle;
		var point:Point;
		var m    :Matrix;
		
		//データ
		var data :Object;
		var x, y;
		var r; //回転(radian)
		var s; //スケール(1 = 100%)
		var c; //カラーObject
		var color :ColorTransform;		
		var off;
		
		//幾何変換に必要なパラメタ
		var x0, y0;
		var dx, dy;
		var dw, dh;
		var dhw, dhh;
		var radius;
		var id;
				
		var $counter = counter;
		var $minusCounter = minusCounter;
		
		temp = tempbf;
		obj  = drawobj;
		geom = geometry;
		rect1 = drawobjRect;
		rect2 = displayRect;
		rect3 = new Rectangle();
		rect4 = diagRect;
		point = new Point();
		m     = new Matrix();
		

		var a, i;
		var q = quadra;
		var n = q.length;
		while( --n > -1 )
		{
			buf = buffer[ n ];
			
			//バッファのクリア
			//buf.fillRect( displayRect, 0 );
				
			a = q[ n ];
			i = a.length;
			while( --i > -1 )
			{
				//データの取得
				data = a[ i ];
				id = data.id;
				
				/*
				//描画カウンタが0以下ならば描画しない
				$minusCounter(id);
				//trace( [id,counter.get( id )] )
				if( !$counter.get( id ) )
				{
					//$resetCounter(id);
					continue;
				}
				*/
				
				x = data.x;
				y = data.y;
				r = data.degree;
				s = data.scale;
				//c = data.color;
				//color = data.color//new ColorTransform( 1, 1, 1, .05, c.ro, c.go, c.bo, c.ao );
				off = data.offset;
				
				c = a[ i ].color;
				color = new ColorTransform( 1, 1, 1, .6, c.r, c.g, c.b, 128 );
				
				
				//得たマトリクスを利用して、Bitmapをはりつける
				dw  = diag * s;		dh  = diag * s;
				dhw = dw *.5;		dhh = dw *.5;
				rect3.x = HW;
				rect3.y = HH;
				rect3.width  = dw;
				rect3.height = dh;
				m = screen.getTransformMatrix( obj, r, s );
				m.translate( rect3.x, rect3.y );
				geom.fillRect( rect2, 0 );
				geom.draw( obj, m, color );
				
				//trace([ a[ i ] ])
				
				//任意の座標x,yに描画
				rect3.x -= dhw;
				rect3.y -= dhh;
				point.x = x - dhw;
				point.y = y - dhh;
				buf.copyPixels( geom, rect3, point, null, null, true );
				
			}
			
			//キューを空に
			q[ n ] = [];
		}
	}

	function createObj( key ) 
	{
		//色の決定
		var cs = ColorScheme.getInstance();
		var colors = cs.brush;
		var n = Math.round( Math.random() * colors.length - 1 );
		var color = colors[ n ];
		//trace( [ "color:"+ color, cs.scheme, colors ] )
		
		//ブラシの決定
		var type = Brush.FELT;
		var brush = new Brush( type, color );
		brushes.put( key, brush );
		
		//return { track :key, color :{ ro :ro, go :go, bo :bo, ao :ao } };
		return { track :key, color :color };
	}

	function addObj ( key :Track, data :Array ) 
	{
		var obj = createObj( key );
		drawobjData.put( ( key.id - 1 ), obj );
		addCounter( key.id - 1 );
		//trace([ "ObjLayer:addObj()", key, key.id, obj.chara, obj.chara.x ])
	}
	
	function removeObj( key ) 
	{
		var obj = drawobjData.get( key );
		
		for( var i in obj ) delete obj[ i ];
		delete obj;
		
		drawobjData.remove( key );
		removeCounter( key.id - 1 );
	}
	
	function redraw () 
	{
		//ビットマップをクリア
		clear();
	}

	function clear () 
	{
		buffer0.fillRect( displayRect, 0 );
		buffer1.fillRect( displayRect, 0 );
		buffer2.fillRect( displayRect, 0 );
		buffer3.fillRect( displayRect, 0 );
	}
	
	function resetAllCounter () 
	{
		var a = drawobjData.getValues();
		var i = a.length;
		while( --i > -1 )
		{
			counter.put( i, DRAWCOUNT );
		}
	}
	function resetCounter ( i ) 
	{
			counter.put( i, DRAWCOUNT );
	}
	function addCounter ( i ) 
	{
			counter.put( i, DRAWCOUNT );
			//trace([ "addCounter:",i, counter.get( i ) ])
	}
	function removeCounter ( i ) 
	{
			counter.remove( i );
	}
	function minusCounter ( i ) 
	{
			var c = counter.get( i );
			counter.put( i, --c );
			//trace([ "minusCounter:",i, counter.get( i ) ])
	}
	function zeroCounter ( i ) 
	{
			counter.put( i, null );
			//trace([ "minusCounter:",i, counter.get( i ) ])
	}

}