﻿import utils.*;
import task.*;
import scenes.*;
import flash.display.BitmapData;
import flash.geom.*;


class task.Route
//extends Task
{
	var sprite  :MovieClip;
	var main_mc :MovieClip;
	var draw_mc :MovieClip;
	var bitmap  :BitmapData;
	var bmpd    :BitmapData;
	
	var xyArray :Array;
	var index   :Number;
	var DRAWSTEP :Number = 3;
	var key :Track;
	
	var color = 0xFFFFFF;
	var thick = 3;
	var alpha = 20;
	
	function Route( key :Track, sprite :MovieClip, bmp :BitmapData, mc :MovieClip )
	{
		this.key = key;
		this.sprite = sprite;
		this.bitmap = bmp;
		this.draw_mc = mc;
		
		color = randomColor();
		
		
		refresh();
		
		//test
		//testData();
	}
	
	function randomColor () 
	{
		var r, g, b;
		r = Math.floor( Math.random() * 0 ) * Math.pow( 16, 4 );
		g = Math.floor( Math.random() * 256 ) * Math.pow( 16, 2 );
		b = Math.floor( Math.random() * 256 ) * Math.pow( 16, 0 );
		//trace( [ "RGB:" + r + g + b ] );
		return r + g + b;
	}

	function setData ( data ) 
	{
		xyArray = data;
		//trace( "データせっと！！！！！！！！！！！！！！！！！" + data )
	}
	
	function testData () 
	{
		var a = xyArray;
		var i = 100;
		while( --i > -1 )
		{
			a[ i ] = new Point( key + i, key + i * 2 );
		}
	}

	function destroy () 
	{
		//bitmap.dispose();
		xyArray = new Array();
		
		main_mc.removeMovieClip();
		//draw_mc.removeMovieClip();
		sprite.removeMovieClip();
		
		for( var i in this )
		{
			delete this[ i ];
		}
		
		
	}

	
	function refresh () 
	{
		//bitmap.dispose();
		//bitmap = createBitmap()//new BitmapData( 0, 0, true, 0 );
		
		main_mc = sprite.createEmptyMovieClip( "main", 0 );
		//draw_mc = sprite.createEmptyMovieClip( "draw", 1 );
		main_mc._visible = false;
		main_mc.lineStyle( thick, color, alpha,
						   false, "normal", "round", "round" );
		//draw_mc.attachBitmap( bitmap, 0, "auto", false );
		
		//xyArray = new Array();
		//index = 0;
	}
	
	function main () 
	{
		var mc = main_mc;
		var x0, y0, x1, y1;
		
		var screen = Screen.getInstance();
		var chara = key.chara;
		var nx0, ny0, nz0;
		var nx1, ny1, nz1;
		
		
		var j = 1//DRAWSTEP;
		while( --j > -1 )
		{
			if( chara.location0[ 3 ] < 0 ) continue;
			
			nx0 = chara.location0[ 0 ];
			ny0 = chara.location0[ 1 ];
			nz0 = chara.location0[ 2 ];
			nx1 = chara.location[ 0 ];
			ny1 = chara.location[ 1 ];
			nz1 = chara.location[ 2 ];
			//trace([ nx, ny, nz, chara ])
					

			var p1 :Point = projection( nx1, ny1, nz1, screen );
			var p0 :Point = projection( nx0, ny0, nz0, screen );
			x1 = p1.x;
			y1 = p1.y;
			x0 = p0.x;
			y0 = p0.y;
			
			var th, sp, ve;
			sp = chara.speed;
			ve = chara.velocity;
			
			/*
			*/
			if( sp < .6 ) th =  1;
			else if( sp > 8 ) th = 50;
			else
			{
				th = sp / ( 8 - .6 ) * 50 + 1;
			}
			
			th *= ve;
			
			/*
			if( ve < 0 ) th =  0;
			else if( ve > 6 ) th = 100;
			else
			{
				th = ve / ( 6 - 0 ) * 100 + 1;
			}
			*/
			
			
			//trace( th )
			mc.lineStyle( th, color, alpha,
						   false, "normal", "round", "round" );
			mc.moveTo( x0, y0 );
			mc.lineTo( x1, y1 );
			
			//trace( index )
		}
			
				
			/*//////////////////////////////////////////
			// transfer
			//////////////////////////////////////////*/
			bmpd = createBitmap();
			
			var w = W;
			var h = H;
			var matrix = new Matrix();
			matrix.translate( w/2, h/2 );
			var rect = new Rectangle( -w/2, -h/2, w*2, h*2 );
			bmpd.draw( mc, matrix, new ColorTransform(), null, rect );
			
	}
	
	
	var W = Stage.width// * 4;
	var H = Stage.height// * 4;
	var drawMatrix :Matrix;
	
	function draw () 
	{
		//一次転写
		/**
		* 一次転写することで、mc.clear()して
		* bmpdのデータ内容が変わっても、bitmapのデータは影響を受けない。
		* 
		*/
		//bitmap.draw( bmpd ); 
		
		//ローカルbmpdだけどメモリリークするので、
		//明示的にDispose()してやる必要がある
		//bmpd.dispose();
		
		//trace( bitmap.width )
		
		//drawMatrix = new Matrix();
		//drawMatrix.translate( -W/2, -H/2 );
			
		//var mc = draw_mc.createEmptyMovieClip( "inner", 0 );
		//mc.attachBitmap( bitmap, 0, "auto", true );
		
		//draw_mc.attachBitmap( bitmap, 0, "auto", true );
		//draw_mc.transform.matrix = drawMatrix;
		
		
	}
	/*
	function draw () 
	{
		bitmap.draw( main_mc, new Matrix() );
		cab( main_mc, draw_mc );
	}
	*/
	
	/*
	function redraw () 
	{
		main_mc.clear();
		main_mc.lineStyle( thick, color, alpha,
						   false, "normal", "round", "round" );
		index = 0;
	}*/
	
	
	function redraw () 
	{
		index = 0;
		clearDrawing();
		clearBitmap();
	}

	
	
	function projection( nx, ny, nz, screen )
	{
		//３D変換(スクリーンに投影)
		var v = new Vector( nx, ny, nz );
		screen.transVector( v );
		
		//描画更新
		var x = Math.floor( v.x );
		var y = Math.floor( v.y );
		
		var x = v.x;
		var y = v.y;
		
		return new Point( x, y );
	}
	/*
	function projection( x, y, z ) 
	{
		var screen = Screen.getInstance();
		var nx, ny, nz;
		var dx, dy, dz;
		var chara = Track( key ).chara;
		
		dx = chara.dx;
		dy = chara.dy;
		dz = chara.dz;
		
		//座標調整とY軸反転
		//##デモコンテンツ用にコメントアウト
		nx =  Math.floor(( x - dx )) * 5;
		ny = -Math.floor(( y - dy )) * 5;
		nz =  Math.floor(( z - dz )) * 5;
		//nx =  Math.floor(( x * 100000 - dx )) * 5;
		//ny = -Math.floor(( y * 100000 - dy )) * 5;
		//nz =  Math.floor(( z - dz )) * 3;

		//３D変換(スクリーンに投影)
		var v = new Vector( nx, ny, nz );
		screen.transVector( v );
		
		//描画
		x = Math.floor( v.x );
		y = Math.floor( v.y );
		
		return new Point( x, y );
	}
	*/
	
	
	
	function cab ( from :MovieClip, to :MovieClip ) 
	{
		//_quality = "MEDIUM";	
		
		var w = from._width;
		var h = from._height;
		
		var bmp :BitmapData = new BitmapData( w, h, true, 0 );
		var matrix = new Matrix();
		matrix.translate( -w/2, -h/2 );
		var rect = new Rectangle( -w/2, -h/2, w, h );
		//var rect = new Rectangle( -1000, -1000, 2000, 2000 );
		bmp.draw( from, matrix, new ColorTransform(), null, rect );
		to.attachBitmap( bmp, 0, "auto", false );
		
		//_quality = "LOW";
	}

	function clearBitmap () 
	{
		//bitmap.dispose();
		//bitmap = createBitmap();
	}
	
	function createBitmap () :BitmapData
	{
		return new BitmapData( W, H, true, 0 );
	}
	
	function clearDrawing () 
	{
		main_mc.clear();
		//main_mc.lineStyle( 0, 0, 50 );
		main_mc.lineStyle( thick, color, alpha,
						   false, "normal", "round", "round" );
	}
	

}