﻿import flash.display.*;
import flash.geom.*;
import utils.Hash;
import utils.ColorSet;
import task.Screen;


class task.RouteLayer
{
	static var singleton :RouteLayer;
	var main :Function;
	var draw :Function;
	
	static var DISPLWIDTH  = Stage.width*3;
	static var DISPLHEIGHT = Stage.height*3;
	
	static var quadra0_lnk :String = "quadra0.png";
	static var quadra1_lnk :String = "quadra1.png";
	static var quadra2_lnk :String = "quadra2.png";
	static var quadra3_lnk :String = "quadra3.png";
	static var drawobj_lnk :String = "brush.png";
	
	
	//ブラシ
	//static var currentBrush :Array = Brush.getBrush( Brush.BALL );
	static var currentBrush :BitmapData = Brush.getBrush( Brush.FELT );
	var brushPoints :Hash;
	var brushes 	:Hash;
	var isDraw 		:Hash; //描画更新フラグ(キャラが移動かつ未描画ならtrue, 一度描画したらfalse)
	
	var DRAWCOUNT = 10;
	var counter :Hash;
	
	var screen :Screen;
	
	var cont 		:MovieClip;
	var displayMC 	:MovieClip;
	var displayRect :Rectangle;
	var drawobj 	:BitmapData;
	var drawobjmask :BitmapData;
	var drawobjRect :Rectangle;
	var diagRect	:Rectangle;
	
	var quadra  :Array = new Array( 4 );
	var quadra0 :Array = new Array();
	var quadra1 :Array = new Array();
	var quadra2 :Array = new Array();
	var quadra3 :Array = new Array();
	
	var buffer  :Array = new Array( 4 );
	var buffer0 :BitmapData;
	var buffer1 :BitmapData;
	var buffer2 :BitmapData;
	var buffer3 :BitmapData;
	
	var geometry :BitmapData;
	var tempbf   :BitmapData;
	
	var drawobjData :Hash;
	
	var W, H, HW, HH, w, h, hw, hh;
	var DIAG, diag;
	var quadraOffset :Array = new Array( 4 );
	var offset :Rectangle; //象限のマージン含めたrect (x,y,w,h)=(オフセットx,オフセットy,バッファ幅,バッファ高さ)
	
	var schemeChanged :Boolean;
	
	
	static function getInstance( sprite :MovieClip, screen :Screen ) :RouteLayer
	{
		if( !singleton ) singleton = new RouteLayer( sprite, screen );
		return singleton;
	}
	
	private function RouteLayer ( sprite :MovieClip, screen :Screen ) 
	{
		//MCの生成
		cont = sprite;
		displayMC = cont.createEmptyMovieClip( "displayMC", 0 );
		
		var cs :ColorScheme = ColorScheme.getInstance();
		cs.addListener( this );
		
		this.screen = screen;
		
		
		//ブラシ
		brushes		= new Hash();
		brushPoints = new Hash();
		isDraw 		= new Hash();
		
		//表示用バッファを用意
		offset = new Rectangle( 128 / 2, 128 / 2, DISPLWIDTH, DISPLHEIGHT );
		//offset = new Rectangle( 16 / 2, 16 / 2, 128, 128 );
		//buffer[ 0 ] = buffer0 = BitmapData.loadBitmap( quadra0_lnk );
		//buffer[ 1 ] = buffer1 = BitmapData.loadBitmap( quadra1_lnk );
		//buffer[ 2 ] = buffer2 = BitmapData.loadBitmap( quadra2_lnk );
		//buffer[ 3 ] = buffer3 = BitmapData.loadBitmap( quadra3_lnk );
		buffer[ 0 ] = buffer0 = new BitmapData( offset.width/2 + offset.x*2, offset.height/2 + offset.y*2, true, 0 );
		buffer[ 1 ] = buffer1 = new BitmapData( offset.width/2 + offset.x*2, offset.height/2 + offset.y*2, true, 0 );
		buffer[ 2 ] = buffer2 = new BitmapData( offset.width/2 + offset.x*2, offset.height/2 + offset.y*2, true, 0 );
		buffer[ 3 ] = buffer3 = new BitmapData( offset.width/2 + offset.x*2, offset.height/2 + offset.y*2, true, 0 );
		W = buffer3.width;
		H = buffer3.height;
		HW = W / 2;
		HH = H / 2;
		DIAG = Math.sqrt( W*W + H*H );
		displayRect = new Rectangle( 0, 0, W, H );
		
		//trace(displayRect)
		
		//buffer0.fillRect( displayRect, 0 );
		//buffer1.fillRect( displayRect, 0 );
		//buffer2.fillRect( displayRect, 0 );
		//buffer3.fillRect( displayRect, 0 );
		
		
		//描画オブジェクトを用意
		//drawobj = BitmapData.loadBitmap( drawobj_lnk );
		//drawobj = currentBrush[ 0 ];
		drawobj = currentBrush;
		w = drawobj.width;
		h = drawobj.height;
		hw = w / 2;
		hh = h / 2;
		diag = Math.sqrt( w*w + h*h + h*h );
		drawobjRect = new Rectangle( 0, 0, w, h );
		diagRect    = new Rectangle( 0, 0, diag, diag );
		
		
		
		//幾何変換用ビットマップ
		geometry = new BitmapData( W, H, true, 0 );
		tempbf   = new BitmapData( W, H, true, 0 );
		
		
		//象限キューを用意
		quadra[ 0 ] = quadra0;
		quadra[ 1 ] = quadra1;
		quadra[ 2 ] = quadra2;
		quadra[ 3 ] = quadra3;
		
		//象限のオフセット
		
		quadraOffset[ 0 ] = new Point( W - offset.x, H - offset.y );
		quadraOffset[ 1 ] = new Point( 0 + offset.x, H - offset.y );
		quadraOffset[ 2 ] = new Point( W - offset.x, 0 + offset.y );
		quadraOffset[ 3 ] = new Point( 0 + offset.x, 0 + offset.y );
		//trace( quadraOffset)
		
		
		//表示用コンテナにバッファを転送
		var mc :MovieClip;
		var m :Matrix = new Matrix();
		mc = displayMC.createEmptyMovieClip( "inner0", 0 );
		mc.attachBitmap( buffer[ 0 ], 0, "auto", false );
		m.identity();
		m.translate( -W + offset.x, -H + offset.y );
		mc.transform.matrix = m;
	
		mc = displayMC.createEmptyMovieClip( "inner1", 1 );
		mc.attachBitmap( buffer[ 1 ], 0, "auto", false );
		m.identity();
		m.translate(  0 - offset.x, -H + offset.y );
		mc.transform.matrix = m;
		
		mc = displayMC.createEmptyMovieClip( "inner2", 2 );
		mc.attachBitmap( buffer[ 2 ], 0, "auto", false );
		m.identity();
		m.translate( -W + offset.x,  0 - offset.y );
		mc.transform.matrix = m;
		
		mc = displayMC.createEmptyMovieClip( "inner3", 3 );
		mc.attachBitmap( buffer[ 3 ], 0, "auto", false );
		m.identity();
		m.translate(  0 - offset.x,  0 - offset.y );
		mc.transform.matrix = m;
		
		/*
		drawRect( displayMC.inner0, offset );
		drawRect( displayMC.inner1, offset );
		drawRect( displayMC.inner2, offset );
		drawRect( displayMC.inner3, offset );
		
		function drawRect ( mc, offset )
		{
			
			with( mc )
			{
				lineStyle( 0, 0x333333, 80 )
				moveTo( 0, 0 );
				lineTo( mc._width, 0 );
				lineTo( mc._width, mc._height );
				lineTo( 0, mc._height );
				lineTo( 0, 0 );
				
				lineStyle( 0, 0x33FF00, 80 )
				moveTo( offset.x, 			  offset.y );
				lineTo( mc._width - offset.x, offset.y );
				lineTo( mc._width - offset.x, mc._height - offset.y );
				lineTo( offset.x, 			  mc._height - offset.y );
				lineTo( offset.x, 			  offset.y );
			}
		}
		*/
		

		//描画オブジェクトのデータオブジェクトを格納する配列を用意
		drawobjData = new Hash();
			
		//描画カウンタハッシュ
		counter = new Hash();
		
		//関数ポインタの初期化
		main = $main;
		draw = $draw;
	}

	
	var degree = 0;
	var radian = 0;
	function $main () 
	{
		//trace([ "RouteLayer.main()" ]);
		var x, y, z;
		var s, r;
		var chara;
		var tk :Track;
		var $brushPoints :Hash = brushPoints;
		var $isDraw   	 :Hash = isDraw;
		var $addPoint :Function = addPoint;
		var $brushR = 32;
		var a = drawobjData.getValues();
		
		//デバッグ用
		var PI_180 = Math.PI / 180;
		radian = degree++ * PI_180;

		
		//カラースキームが変わったら
		//色の決定
		var cs = ColorScheme.getInstance();
		if( cs.schemeChanged )
		{
			cs.schemeChanged = false;
			var i = a.length;
			//トラックの数(drawobjData)だけループ
			while( --i > -1 )
			{
				var colors = cs.brush;
				var n = Math.round( Math.random() * colors.length );
				a[ i ].color = colors[ n ];
				//trace([ "BRUSH:" + a[i].color ])
			}
		}
			
		var i = a.length;
		//トラックの数(drawobjData)だけループ
		while( --i > -1 )
		{
			tk    = a[ i ].track
			chara = tk.chara;
			
			
			//タイムラインの先頭ならブラシ座標初期化
			if( tk.$p == 0 )
			{
				//trace([ "タイムラインの先頭ならブラシ座標初期化:", tk.$p ])
				$brushPoints.put( tk, [] );
			}
			
			//歩いてなければスキップ
			//if( !chara.hasStep ) continue;
			if( !chara.hasLocated ) { $staytime2 = chara.staytime2; continue };
			
			
			x = chara.x;
			y = chara.y;
			z = chara.z;
			r = chara.r;
			//s = chara.staytime * $brushR *.125 *.5;
			//s = chara.staytime2 * $brushR *.125 *.5;
			s = $staytime2 * $brushR *.125 *.5;
			if( s < 1 ) s = 1;
			if( s > 8 ) s = 8;
			
			//trace([ s, chara.staytime2 ])
			
			
			//ブラシ座標の追加
			$addPoint( $brushPoints.get( tk ), x, y, z, s, a[ i ].color );
			$isDraw.put( tk, true );
		}
	}
	
	var $staytime2 = 1;
	
	function addPoint ( data :Array, x, y, z, p, color ) 
	{
		var x1, y1, z1, dir;
		var i = data.length;
		x1 = x - data[ i - 1 ].x;
		y1 = y - data[ i - 1 ].y; 
		z1 = z - data[ i - 1 ].z; 
		dir = Math.atan2( y1, x1 );
		if( !dir ) dir = data[ i - 1 ].dir;
		
		data[ i ] = new BrushPoint4( x, y, z, p, dir, color );
	}
	function average ( data :Array, i0, i1, i2 ) 
	{
		var p0, p1, p2 :BrushPoint4;
	
		p0 = data[ i0 ];
		p1 = data[ i1 ];
		p2 = data[ i2 ];
		
		p1.x = ( p0.x + p2.x ) *.5;
		p1.y = ( p0.y + p2.y ) *.5;
		p1.z = ( p0.z + p2.z ) *.5;
		p1.p = ( p0.p + p2.p ) *.5;
		if( p1.p < 1 ) p1.p = 1;
		
		//p1.dir = ( p0.dir + p2.dir ) *.5;
	}
	function average10 ( data :Array, i0, i1, i2, i3, i4, i5, i6, i7, i8, i9, i10 ) 
	{
		var p0, p1, p2 :BrushPoint4;
		var p3, p4, p5 :BrushPoint4;
		var p6, p7, p8 :BrushPoint4;
		var p9, p10 :BrushPoint4;
	
		p0 = data[ i0 ];
		p1 = data[ i1 ];
		p2 = data[ i2 ];
		p3 = data[ i3 ];
		p4 = data[ i4 ];
		p5 = data[ i5 ];
		p6 = data[ i6 ];
		p7 = data[ i7 ];
		p8 = data[ i8 ];
		p9 = data[ i9 ];
		p10 = data[ i10 ];
		
		p5.x = ( p0.x + p1.x + p2.x + p3.x + p4.x + p6.x + p7.x + p8.x + p9.x + p10.x ) *.1;
		p5.y = ( p0.y + p1.y + p2.y + p3.y + p4.y + p6.y + p7.y + p8.y + p9.y + p10.y ) *.1;
		p5.z = ( p0.z + p1.z + p2.z + p3.z + p4.z + p6.z + p7.z + p8.z + p9.z + p10.z ) *.1;
		p5.p = ( p0.p + p1.p + p2.p + p3.p + p4.p + p6.p + p7.p + p8.p + p9.p + p10.p ) *.1;
		if( p5.p < 1 ) p5.p = 1;
		
		//p1.dir = ( p0.dir + p2.dir ) *.5;
	}
	
	function interpolate ( data :Array, i :Number, t ) 
	{
		var p0, p1 :BrushPoint4;
		var lx, ly, lz, lp, ld, lc;
		var x, y, z;
		var p, l, dir, color;
		
		p0 = data[ i ];
		p1 = data[ i + 1 ];
		
		lx = p1.x - p0.x;
		ly = p1.y - p0.y;
		lz = p1.z - p0.z;
		lp = p1.p - p0.p;
		ld = p1.dir - p0.dir;
		//lc = minusColor( p1.color, p0.color );
		lc = p1.color;
		
		x = p0.x + lx * t;
		y = p0.y + ly * t;
		z = p0.z + lz * t;
		p = p0.p + lp * t;
		dir   = p0.dir   + ld * t;
		//color = plusColor( p0.color, multiplyColor( lc, t ) );
		color = p0.color;
		l = lx*lx + ly*ly;
		
		/*
		if( l == 0 ) trace( [ "L:" + l, "0" ] );
		if( l == Number.NaN ) trace( [ "L:" + l, "NaN" ] );
		if( l == Number.NEGATIVE_INFINITY ) trace( [ "L:" + l, "NEGATIVE_INFINITY" ] );
		if( l == Number.POSITIVE_INFINITY ) trace( [ "L:" + l, "POSITIVE_INFINITY" ] );
		*/
		
		l = ( !!l ) ? Math.sqrt( l ) : .1;
		return { x :x, y :y, z :z, p: p, l :l, dir :dir, color :color };
	}
	/*
	*/
	function $draw () 
	{
		//ブラシ座標
		var points :Array;
		var index :Number;
		
		var $average	  :Function = average;
		var $average10	  :Function = average10;
		var $interpolate :Function = interpolate;
		
		var minX, minY, maxX, maxY;
		var $buffer :BitmapData;
		var $brush  :BitmapData;
		var $brushW = w;
		var $brushH = h;
		var m :Matrix = new Matrix();
		var x, y, z, p, l, dir, o;
		var c; //カラーObject
		var color :ColorTransform;		
		var r = 1;
		var cr; //描画する円の半径
		var tk :Track;
		var n;
		var off;
		var $quad 	 :Array;
		var $buffers :Array;
		var $isDraw  :Hash;
		
		$quad    = quadraOffset;
		$buffers = buffer;
		$isDraw  = isDraw;
		$brush   = drawobj;
			
		var a = drawobjData.getValues();
		var i = a.length;
		//トラック数だけループ
		while( --i > -1 )
		{
			//ブラシ座標を取得
			tk = a[ i ].track;
			points = brushPoints.get( tk );
			index  = points.length - 4;
			//index  = points.length - 11;
			
			//描画更新しないならスキップ
			if( !$isDraw.get( tk ) ) continue;
			$isDraw.put( tk, false );
			
			//座標が足りなければスキップ
			if( index < 0 ) continue;
			
			//平滑化
			$average( points, index, index + 1, index + 2 );
			/*$average10( points, index, index + 1, index + 2,
					   index + 3, index + 4, index + 5, index + 6, 
					   index + 7, index + 8, index + 9, index + 10 );
			*/
			
			
			//分割座標だけ描画ループ
			var t = 0;
			while( t < 1 )
			{
				//座標取得
				o = $interpolate( points, index, t );
				x = o.x; y = o.y;  z = o.z;
				p = o.p; 
				l = o.l;
				dir = o.dir;
				//color = o.color || color;
				//color = new ColorTransform( 0, .5, .5, .08, 0, 0, 0, 0 );
				
				c = a[ i ].color;
				color = new ColorTransform( 1, 1, 1, .8, c.r, c.g, c.b, 32 );
				//trace( c )
				
				//円の半径
				p  = p < .1 ? .1 : p;
				cr = r * p;
				l  = l < .1 ? .1 : l;
				cr = cr  < .1 ? .1 : cr;
				
				//描画先バッファの決定
				if( y < 0 ) { n = x < 0 ? 0 : 1 }
				else		{ n = x < 0 ? 2 : 3 }
						
				//座標補正
				off = $quad[ n ];
				x += off.x;
				y += off.y;
				
				//マトリクス
				m.identity();
				m.translate( -$brushW*.5, -$brushH*.5 );
				m.rotate( dir );
				m.scale( cr*2/$brushW, cr*2/$brushH );
				m.translate( x, y );

				//描画
				$buffer = $buffers[ n ];
				$buffer.draw( $brush, m, color );
				
				//次の分割座標
				t += cr *.33 / l;
			}
			
			//trace([ t, cr, r, p, index, l ])
		}
	}

	

	
	
	function createObj( key :Track ) 
	{
		//ブラシ座標の初期化
		brushPoints.put( key, [] );
		
		//色の決定
		var cs = ColorScheme.getInstance();
		var colors = cs.brush;
		var n = Math.round( Math.random() * colors.length - 1 );
		var color = colors[ n ];
		//trace( [ "color:"+ color, cs.scheme, colors ] )
		
		//ブラシの決定
		var type = Brush.FELT;
		var brush = new Brush( type, color );
		brushes.put( key, brush );
		
		//return { track :key, color :{ ro :ro, go :go, bo :bo, ao :ao } };
		return { track :key, color :color };
		//return { track :key };
	}

	function addRoute ( key :Track, data :Array ) 
	{
		var obj = createObj( key );
		drawobjData.put( ( key.id - 1 ), obj );
		addCounter( key.id - 1 );
		//trace([ "RouteLayer:addObj()", key, key.id, obj.chara, obj.chara.x ])
	}
	
	function removeRoute( key :Track ) 
	{
		var obj = drawobjData.get( key );
		
		for( var i in obj ) delete obj[ i ];
		delete obj;
		
		drawobjData.remove( key );
		brushes.remove( key );
		brushPoints.remove( key );
		isDraw.remove( key );
		removeCounter( key.id - 1 );
	}
	
	function redraw () 
	{
		//ビットマップをクリア
		clear();
		
		//ブラシ座標をクリア
		clearBrushPoints();

		//描画更新フラグをクリア
		isDraw.clear();
	}

	function clear () 
	{
		buffer0.fillRect( displayRect, 0 );
		buffer1.fillRect( displayRect, 0 );
		buffer2.fillRect( displayRect, 0 );
		buffer3.fillRect( displayRect, 0 );
	}
	function clearBrushPoints () 
	{
		brushPoints.clear();
		
		var a = drawobjData.getValues();
		var i = a.length;
		while( --i > -1 )
		{
			brushPoints.put( a[ i ].track, [] );
		}
	}

	
	function resetAllCounter () 
	{
		var a = drawobjData.getValues();
		var i = a.length;
		while( --i > -1 )
		{
			counter.put( i, DRAWCOUNT );
		}
	}
	function resetCounter ( i ) 
	{
			counter.put( i, DRAWCOUNT );
	}
	function addCounter ( i ) 
	{
			counter.put( i, DRAWCOUNT );
			//trace([ "addCounter:",i, counter.get( i ) ])
	}
	function removeCounter ( i ) 
	{
			counter.remove( i );
	}
	function minusCounter ( i ) 
	{
			var c = counter.get( i );
			counter.put( i, --c );
			//trace([ "minusCounter:",i, counter.get( i ) ])
	}
	function minusColor ( c1 :ColorTransform, c0 :ColorTransform ) :ColorTransform 
	{
		var r0, g0, b0, a0, r1, g1, b1, a1;
		r0 = c1.redMultiplier 	- c0.redMultiplier;
		g0 = c1.greenMultiplier - c0.greenMultiplier;
		b0 = c1.blueMultiplier  - c0.blueMultiplier;
		a0 = c1.alphaMultiplier - c0.alphaMultiplier;
		r1 = c1.redOffset 	- c0.redOffset;
		g1 = c1.greenOffset - c0.greenOffset;
		b1 = c1.blueOffset 	- c0.blueOffset;
		a1 = c1.alphaOffset - c0.alphaOffset;
		return new ColorTransform( r0, g0, b0, a0, r1, g1, b1, a1 );
	}
	function plusColor ( c1 :ColorTransform, c0 :ColorTransform ) :ColorTransform 
	{
		var r0, g0, b0, a0, r1, g1, b1, a1;
		r0 = c1.redMultiplier 	+ c0.redMultiplier;
		g0 = c1.greenMultiplier + c0.greenMultiplier;
		b0 = c1.blueMultiplier  + c0.blueMultiplier;
		a0 = c1.alphaMultiplier + c0.alphaMultiplier;
		r1 = c1.redOffset 	+ c0.redOffset;
		g1 = c1.greenOffset + c0.greenOffset;
		b1 = c1.blueOffset 	+ c0.blueOffset;
		a1 = c1.alphaOffset + c0.alphaOffset;
		return new ColorTransform( r0, g0, b0, a0, r1, g1, b1, a1 );
	}
	function multiplyColor ( c1 :ColorTransform, n :Number ) :ColorTransform 
	{
		var r0, g0, b0, a0, r1, g1, b1, a1;
		r0 = c1.redMultiplier 	* n;
		g0 = c1.greenMultiplier * n;
		b0 = c1.blueMultiplier  * n;
		a0 = c1.alphaMultiplier * n;
		r1 = c1.redOffset 	* n;
		g1 = c1.greenOffset * n;
		b1 = c1.blueOffset 	* n;
		a1 = c1.alphaOffset * n;
		return new ColorTransform( r0, g0, b0, a0, r1, g1, b1, a1 );
	}

}