﻿import utils.*;
import task.*;
import scenes.*;
import flash.display.BitmapData;
import flash.geom.*;


/**
* TODO
* 1.位置と大きさがわかる「スケール・グリッド」を表示 --> ズームレベルに応じて、レイヤを切り替えることで、常に見やすいスケールを表示
* ２．処理速度向上 ---> Bitmapの描画領域が広いと極端に遅くなる
* 
*/
class task.Screen
//extends Task
{
	//var key  :KeyWatcher;
	private static var instance :Screen;
	public static var sprite   :MovieClip;
	
	private static var texture  :BitmapData;
	
	
	static var INIT_TILT3D = 80;
	static var INIT_ROT3D  = 45;
	static var INIT_ZOOM3D = 300;
	static var INIT_TILT2D = 90;
	static var INIT_ROT2D  = 0;
	static var INIT_ZOOM2D = 100;
	static var INIT_TILT   = INIT_TILT2D;
	static var INIT_ROT    = INIT_ROT2D;
	static var INIT_ZOOM   = INIT_ZOOM3D;
	
	var camera2D :Object;
	var camera3D :Object;
	var scale, x, y;
	var rotation;
	var $tiltAngle;
	
	function set tiltAngle( t )
	{
		$tiltAngle = t;
		navi.isTilt = 0;
	}
	function get tiltAngle()
	{
		return $tiltAngle;
	}
	
	static var tilt_step = 5;
	static var rot_step  = 3;
	static var zoom_step  = 16//4;
	static var PANSTEP  = 12;
	
	var angleChange :Boolean = false;
	var refreshed   :Boolean = false;
	var isPanTo 	:Boolean = false;
	var pan :Point;
	var focalPoint :Point;
	
	var textureMatrix :Matrix;
	var size :Point// = new Point( 256, 256 );
	
	var footprint :FootprintLayer;
	var route :RouteLayer;
	var objlayer :ObjLayer;
	var tip :TipLayer;
	var balloon :BalloonLayer;
	
	var defaultX :Number = 0// - Stage.width / 2;
	var defaultY :Number = 0// - Stage.height / 2;
	
	//ナビゲーション
	var navi; //3Dナビ
	
	//================================================================================================
	
	//	CONSTRUCTOR
	
	//================================================================================================
	
	private function Screen()
	{
		//初期化
		refreshed = refresh();
		//setTexture( new BitmapData( 256, 256, false, 0x999999 ) );
		setTexture( "texture1" );
		
		angleChange = true;
		updateTexture();
		
		//footprintレイヤ
		footprint = createFootprintLayer();
		//Routeレイヤ
		route = createRouteLayer();
		//Routeレイヤ
		objlayer = createObjLayer();
		
		//Tipレイヤ
		tip = TipLayer.getInstance();
		balloon = BalloonLayer.getInstance();
		
		isPanTo = true;
		pan 	   = new Point( defaultX, defaultY );
		focalPoint = pan.clone(); 
		panTo();
	}
	
	private function createRouteLayer() //:RouteLayer
	{
		if(!route)
		{
			var mc = sprite.createEmptyMovieClip( "route", 5 );
			return RouteLayer.getInstance( mc, this );
		}
 	}
	private function createFootprintLayer() :FootprintLayer
	{
		if(!footprint)
		{
			var mc = sprite.createEmptyMovieClip( "footprint", 50 );
			return FootprintLayer.getInstance( mc );
		}
 	}
	private function createObjLayer() :ObjLayer
	{
		if(!objlayer)
		{
			var mc = sprite.createEmptyMovieClip( "objlayer", 150 );
			return ObjLayer.getInstance( mc, this );
		}
 	}
	function createCharaLayer() :MovieClip
	{
		var mc = sprite.createEmptyMovieClip( "chara", 500 );
		return mc;
 	}
	
	static var ROUTE :Number = 0;
	static var OBJ   :Number = 1;
	static var CHARA :Number = 2;
	function layerOn ( layerCode :Number ) 
	{
		switch( layerCode )
		{
			case ROUTE :
			sprite.route._visible = true;
			break;
			case OBJ :
			sprite.objlayer._visible = true;
			break;
			case CHARA :
			sprite.chara._visible = true;
			tip.layerOn();
			balloon.layerOn();
			break;
		}
	}
	function layerOff ( layerCode :Number ) 
	{
		switch( layerCode )
		{
			case ROUTE :
			sprite.route._visible = false;
			break;
			case OBJ :
			sprite.objlayer._visible = false;
			break;
			case CHARA :
			sprite.chara._visible = false;
			tip.layerOff();
			balloon.layerOff();
			break;
		}
	}

	/**/
	
	/*
	//パンのイベント発生
	function onMouseDown ()
	{
		var mox, moy;
		mox = _root._xmouse;
		moy = _root._ymouse;
		
		var ui = UI.getInstance().getUI();
		var isHit = ui.footer.hitTest( mox, moy );
		if( isHit ) return;
		
		var isHit = ui.navi.hitTest( mox, moy );
		if( isHit ) return;
		
		isPanTo = true;
		
		var x, y;
		x = mox - Stage.width / 2;
		y = moy - Stage.height / 2;
		pan = new Point( x, y );
	}*/
	
	public static function getInstance()
	{
		if( !instance )
		{
			instance = new Screen();
		}
		
		return instance;
	}
	
	/*
	public function setKeyFunc( k :KeyWatcher )
	{
		key = k;	
	}
	*/
	
	public function refresh() :Boolean
	{
		scale = INIT_ZOOM;
		x = Stage.width  *.5;
		y = Stage.height *.5;
		
		rotation  = INIT_ROT;
		$tiltAngle = INIT_TILT;
		
		sprite = createNewScreen();
		
		
		var rnd = Math.random() * 64 + 8;
		texture.dispose();
		texture = new BitmapData( rnd, rnd, false, 0 );
		
		
		Projector.clear();
		
		return true;
	}
	function resetZoom()
	{
		scale = INIT_ZOOM;
		navi.isZoom = 0;
	}
	function resetPan()
	{
		focalPoint.x = -( Stage.width  *.5 - defaultX );
		focalPoint.y = -( Stage.height *.5 - defaultY );
		navi.panX = 0;
		navi.panY = 0;
	}
	function resetTilt()
	{
		$tiltAngle = INIT_TILT;
		navi.isTilt = 0;
	}
	function resetRotation()
	{
		rotation = navi.rotation = INIT_ROT;
	}
	function resetCamera()
	{
		resetZoom();
		resetPan();
		resetTilt();
		resetRotation();
		
		updateTexture();
		route.redraw();
		footprint.redraw();
		objlayer.redraw();
		
		sprite.texture.transform.matrix = textureMatrix;
		refreshed  = false;
		
	}
	function resetCameraWithoutRedraw()
	{
		resetZoom();
		resetPan();
		resetTilt();
		resetRotation();
		
		updateTexture();
		
		sprite.texture.transform.matrix = textureMatrix;
		refreshed  = false;
		
	}
	
	
	function keepCamera2D () 
	{
		var initialized :Boolean = camera2D != undefined;
		//trace( ["keepCamera2D:" + initialized ] );
		if( initialized )
		{
			camera2D.tilt = $tiltAngle;
			camera2D.rot  = rotation;
			camera2D.zoom = scale;
		}
		
		else
		{
			camera2D = {};
			camera2D.zoom = INIT_ZOOM2D;
			camera2D.rot  = INIT_ROT2D;
			camera2D.tilt = INIT_TILT2D;
		}
	}
	function keepCamera3D () 
	{
		var initialized :Boolean = camera3D != undefined;
		//trace( ["keepCamera3D:" + initialized ] );
		if( initialized )
		{
			camera3D.tilt = $tiltAngle;
			camera3D.rot  = rotation;
			camera3D.zoom = scale;
		}
		
		else
		{
			camera3D = {};
			camera3D.zoom = INIT_ZOOM3D;
			camera3D.rot  = INIT_ROT3D;
			camera3D.tilt = INIT_TILT3D;
		}
	}

	function cameraMode2D ( reset :Boolean )
	{
		INIT_TILT = reset ? INIT_TILT2D : camera2D.tilt;
		INIT_ROT  = reset ? INIT_ROT2D  : camera2D.rot;
		INIT_ZOOM = reset ? INIT_ZOOM2D : camera2D.zoom;
	}
	function cameraMode3D ( reset :Boolean ) 
	{
		INIT_TILT = reset ? INIT_TILT3D : camera3D.tilt;
		INIT_ROT  = reset ? INIT_ROT3D  : camera3D.rot;
		INIT_ZOOM = reset ? INIT_ZOOM3D : camera3D.zoom;
	}

	//================================================================================================
	
	//	PROCEDURE
	
	//================================================================================================
	
	
	public function main()
	{
		
		//key.main();
		
		angleChange = false;
		
		//var navi = UI.getInstance().getNavi();
			 if( navi.isTilt > 0 ) { tilt( $tiltAngle + tilt_step );   angleChange = true; }
		else if( navi.isTilt < 0 ) { tilt( $tiltAngle - tilt_step );   angleChange = true; };

			 if( navi.isZoom > 0 ) zoomIn();
		else if( navi.isZoom < 0 ) zoomOut();
		
			 if( navi.isRotate ) { rotate( navi.rotation ); angleChange = true; };
		
			 if( navi.panReset ) { resetPan(); navi.panReset = false; };
		
		
		var px = navi.panX * PANSTEP;
		var py = navi.panY * PANSTEP;
		pan = new Point( px, py );
		panTo();
		
		
		//スムース
		zoomTask();
		panTask();
		var s = scale *.01;
		x = -focalPoint.x*s + ( Stage.width  *.5 );
		y = -focalPoint.y*s + ( Stage.height *.5 ) -75;
		//trace([ isPanTo, px, py, x, y ])
		
		
		
		if( angleChange )
		{
			updateTexture();
			route.redraw();
			objlayer.redraw();
		}
		
		
		route.main();
		objlayer.main();
		tip.main();
		balloon.main();

	}
	
	
	public function draw()
	{
		sprite._xscale = sprite._yscale = scale;
		sprite._x = x;
		sprite._y = y;
		
		if( angleChange || refreshed )
		{
			sprite.texture.transform.matrix = textureMatrix;
			refreshed  = false;
		}
	
		//あしあと
		route.draw();
		objlayer.draw();
		tip.draw();
		balloon.draw();
		
		//色の決定
		var cs = ColorScheme.getInstance();
		var c  = cs.texture;
		var color :ColorTransform = new ColorTransform( 1, 1, 1, 1, c.r, c.g, c.b, 0 );
		
		sprite.texture.transform.colorTransform = color;
		
	}
	
	public function redraw()
	{
		//resetPan();
		route.redraw();
		objlayer.redraw();
		
	}
	
	//================================================================================================
	
	//	INTERFACE
	
	//================================================================================================
	
	/**
	* 渡されたベクターを投影変換する
	*/
	public function transVector( vector )
	{
		Projector.transVector( vector );
	}
	
	/**
	//							  - MCの変換マトリクスを返す
	//	   @arg:	mc		 	  - MovieClip 変換対象のmc
	//	   @arg:	a	  		  - Vector プレートの座標 v0
	//	   @arg:	b	  		  - Vector プレートの座標 v1
	//	   @arg:	c	  		  - Vector プレートの座標 v2
	//  @return:	Matrix	  	  - Matrix 変換後のMatorix（ mc.transform.matrix = m; として使う）
	*/
	public function getTransmatrix( mc :MovieClip, v0, v1, v2 ) :Matrix
	{
		return Projector.getMovieClipTransformMatrix( mc, v0, v1, v2 );
	}
	
	
	public function getTransformMatrix( obj, angle, scale, x, y, z )
	{
		var s = obj.width*.5 * scale;
		var v0 = new Vector(  1*s, -1*s, 0 );
		var v1 = new Vector( -1*s, -1*s, 0 );
		var v2 = new Vector( -1*s,  1*s, 0 );
		
		x = x || 0;
		y = y || 0;
		z = z || 0;
		
		//回転行列の作成と合成。
		//発生順と逆に掛け合わせていく。
		//Projector.clear();
		//Projector.translate( x*s*2, y*s*2, z*s*2 );
		//Projector.rotate( Axis.X, $tiltAngle );//回転行列の作成(X方向・傾斜)
		//Projector.rotate( Axis.Z, rotation + angle );	//回転行列の作成(Z方向・回旋)
		//Projector.transVector( v0 );
		//Projector.transVector( v1 );
		//Projector.transVector( v2 );
		
		//return Projector.getTransformMatrix( obj, v0, v1, v2 );
		
		TempProjector.clear();
		TempProjector.translate( x*s*2, y*s*2, z*s*2 );
		TempProjector.rotate( Axis.X, $tiltAngle );//回転行列の作成(X方向・傾斜)
		TempProjector.rotate( Axis.Z, rotation + angle );	//回転行列の作成(Z方向・回旋)
		TempProjector.transVector( v0 );
		TempProjector.transVector( v1 );
		TempProjector.transVector( v2 );
		
		return TempProjector.getTransformMatrix( obj, v0, v1, v2 );
	}
	
	public function getScreen()
	{
		return sprite;
	}
	
	/**
	*  ##バグのため仕様変更
	*  BitmapをattachしたMCを拡大したとき、ある一定の範囲で透明の帯が出現するバグ
	*  ---> 原因不明　仕様？
	*  解決策；bitmapをatachしないでMCのままにする。
	*/
	
	static var color :ColorTransform = new ColorTransform( 1, 1, 1, 1, 255, 255, 255, 0 ); 
	
	public function setTexture( drawable )
	{
		//スクリーン深度0に、テクスチャMCを生成
		var mc  :MovieClip = sprite.createEmptyMovieClip( "texture", 0 );
		var bmp :MovieClip = mc.createEmptyMovieClip( "inner", 1 );
		var overlay :MovieClip = mc.createEmptyMovieClip( "overlay", 2 );
		
		//テクスチャをdraw
		if( typeof( drawable ) == "string" ) 
		{
			drawable = bmp.attachMovie( drawable, "drawable", 0 );
		}
		
		with( overlay )
		{
			lineStyle( 4, 0x000000, 75, false, "none" );
			beginFill( 0x000000, 75 );
			moveTo( 0, 0 );
			lineTo( bmp._width, 0 );
			lineTo( bmp._width, bmp._height );
			lineTo( 0, bmp._height );
			lineTo( 0, 0 );
			endFill();
		}
		
		//カラー設定
		//var color :ColorTransform = new ColorTransform( .5, .5, .5, 1, 100, 100, 100, 0 ); //オリジナル
		//var color :ColorTransform = new ColorTransform( .5, .8, .8, 1, 180, 150, 150, 0 ); //適当にやってみた
		//var color :ColorTransform = new ColorTransform( .5, .8, .8, 1, 255, 255, 255, 0 ); //適当にやってみた
		
		/*var color :ColorTransform = new ColorTransform( .5, .8, .8, 1, Math.random() * 180, 
																	   Math.random() * 150, 
																	   Math.random() * 150, 
																	   0 ); //適当にやってみた
		*/
		//色の決定
		var cs = ColorScheme.getInstance();
		var c  = cs.texture;
		var color :ColorTransform = new ColorTransform( 1, 1, 1, 1, c.r, c.g, c.b, 0 );
		
		mc.transform.colorTransform = color;
		
		//位置およびスケール設定
		var matrix = new Matrix();
		matrix.translate( -bmp._width / 2, -bmp._height / 2 );
		mc.transform.matrix = matrix;
		
	}
	
	
	//================================================================================================
	
	//	PRIVATE FUNC
	
	//================================================================================================
	private function updateTexture()
	{
		var s = 256 * 8//.5;
		var v0 = new Vector(  1*s, -1*s, 0 );
		var v1 = new Vector( -1*s, -1*s, 0 );
		var v2 = new Vector( -1*s,  1*s, 0 );
		
		//回転行列の作成と合成。
		//発生順と逆に掛け合わせていく。
		Projector.clear();
		Projector.rotate( Axis.X, $tiltAngle );//回転行列の作成(X方向・傾斜)
		Projector.rotate( Axis.Z, rotation );	//回転行列の作成(Z方向・回旋)
		Projector.transVector( v0 );
		Projector.transVector( v1 );
		Projector.transVector( v2 );
		
		
		textureMatrix = Projector.getMovieClipTransformMatrix( sprite.texture, v0, v1, v2 );
	}
	
	var zoomTask :Function;
	var zoomDest;
	function $zoomIn() 
	{
		var ds = zoomDest - scale
		
		if( Math.abs( ds ) < 1 )
		{
			scale = zoomDest;
			zoomDest = null;
			zoomTask = null;
			
			return;
		}
		
		scale += ds * .38;		
		//trace( [ "ZOOMIN:", zoomDest, ds ])
		
	}
	function $zoomOut() 
	{
		var ds = zoomDest - scale
		
		if(   Math.abs( ds ) < 1
		   || sprite._width < 256 
		   || sprite._height < 256 
		   )
		{
			scale = zoomDest;
			zoomDest = null;
			zoomTask = null;
			
			return;
		}
		
		scale += ds * .38;
		//trace( [ "ZOOMOUT:", zoomDest, ds, scale ])
		
	}

	private function zoomIn()
	{
		zoomDest = scale + zoom_step;
		zoomTask = $zoomIn;
		
		//scale += zoom_step;
	}	
	private function zoomOut()
	{
		//if( sprite._width > Stage.width || sprite._height > Stage.height )
		if( sprite._width > 256 || sprite._height > 256 )
		{
			
			zoomDest = scale - zoom_step;
			if( zoomDest < 8 ) zoomDest = 8;
			zoomTask = $zoomOut;
			//scale -= zoom_step;
		}
	}
	private function rotate( r )
	{
		rotation = r || rotation//( rotation + rot_step ); 
	}
	
	private function tilt( t )
	{
		if( t < 0 ) t = 0;
		if( t > 90 ) t = 90;
		
		$tiltAngle = t;
	}
	
	
	var panTask :Function;
	var panDest :Point;
	function $smoothPanTo() 
	{
		var dx = panDest.x - focalPoint.x;
		var dy = panDest.y - focalPoint.y;
		
		if(    Math.abs( dx ) < 5
		    && Math.abs( dy ) < 5 )
		{
			focalPoint.x = panDest.x;
			focalPoint.y = panDest.y;
			panTask = null;
			
			return;
		}
		
		focalPoint.x += dx *.5// .18;
		focalPoint.y += dy *.5// .18;
		
		//trace( [ "smoothPanTo:", panDest, dx, dy ])
		
	}
	private function smoothPanTo( dx :Number, dy :Number, coord :MovieClip )
	{
		var p :Point = new Point( dx, dy );
		coord._parent.localToGlobal( p );
		sprite.globalToLocal( p );
		
		var s = scale / 100;
		dx = p.x;
		dy = p.y;
				
		panDest = new Point( dx, dy );
		panTask = $smoothPanTo;
		
		//trace([ "smoothPanTo:panDest = " + panDest ])
	}
	
	private function panTo()
	{
		var s = 100 / scale;
		focalPoint.x += pan.x * s;
		focalPoint.y += pan.y * s;
		
		isPanTo = false;
		//trace([ "PAN:", pan ])
	}
	
	private function createNewScreen() :MovieClip
	{
		var mc   =  AppInfo.root.createEmptyMovieClip( "screen", 1 );
		var mask =  AppInfo.root.createEmptyMovieClip( "screen_mask", 2 );
		
		var W = Stage.width;
		var H = Stage.height;
		
		
		with( mask )
		{
			beginFill( 0x000000, 100 );
			moveTo( 0, 0 );
			lineTo( W, 0 );
			lineTo( W, H );
			lineTo( 0, H );
			lineTo( 0, 0 );
			endFill();
		}
		
		mask._x = x - mask._width * .5;
		mask._y = y - mask._height * .5;
		
		mc.setMask( mask );
		
		return mc;
	}
	
}