﻿import utils.*;
import task.*;
import flash.display.BitmapData;
import flash.geom.*;
import mx.controls.tracklist_cb;


class task.TipLayer
{
	private static var instance :TipLayer;
	private static var sprite   :MovieClip;
	
	var $func_main :Function = func_null;
	var $func_draw :Function = func_null;
	
	var scale, x, y;
	var tips :Hash;
	
	//================================================================================================
	
	//	CONSTRUCTOR
	
	//================================================================================================
	
	private function TipLayer()
	{
		
		refresh();
		
		//次の状態へ
		//changeState( S_WAIT );
		$func_main = func_updateTips;
		$func_draw = func_drawTips;
	}
	
	public static function getInstance()
	{
		if( !instance )
		{
			instance = new TipLayer();
		}
		
		return instance;
	}
	
	public function refresh() :Boolean
	{
		//参照を解放
		tips = new Hash();
		
		//_rootを基準(ステージ左上)
		x = 0;
		y = 0;
		scale = 100;
		
		//コンテナ
		sprite = createNew();
		
		return true;
	}
	
	public function getLayer()
	{
		return sprite;
	}
	
	public function addTip( chara :Chara, tk :Track )
	{
		var tip :Tip = TipFactory.createTip( tk );
		
		//Tipとキャラを関連づける
		tip.chara = chara;
		
		tips.put( chara, tip );
		
		//trace([ "TipLayer.addTip::", chara, tip ])
	}
	public function removeTip( chara :Chara )
	{
		var tip :Tip;
		tip = tips.get( chara );
		tip.destroy();
		tips.remove( chara );
	}
	
	private function createCharaTip() :Tip
	{
		return TipFactory.createTip();
	}
	
	function layerOn () 
	{
		sprite._visible = true;
	}
	function layerOff () 
	{
		sprite._visible = false;
	}
	
	//================================================================================================
	
	//	PROCEDURE
	
	//================================================================================================
	
	public function main()
	{
		$func_main();
	}
	
	public function draw()
	{
		$func_draw();
	}
	
	
	//================================================================================================
	
	//	PRIVATE FUNC
	
	//================================================================================================
	
	//========================================
	// 待機
	//========================================
	
	/**
	* Null関数
	*/
	private function func_null() :Void
	{
	}
	
	function func_updateTips() :Void
	{
		var a :Array = tips.getValues();
		var i = a.length;
		while( --i > -1 )
		{
			var tip :Tip = a[ i ];
			tip.main();
		}
	}
	
	function func_drawTips() :Void
	{
		var a :Array = tips.getValues();
		var i = a.length;
		while( --i > -1 )
		{
			var tip :Tip = a[ i ];
			tip.draw();
		}
	}
	
	private function createNew() :MovieClip
	{
		var mc  = AppInfo.root.createEmptyMovieClip( "tipLayer", 9999 );
		return mc;
	}
}