﻿

class utils.CSV
extends LoadVars
{
	//	PUBLIC PROPERTIES:
	//	-------------------
	public static var DEBUG :Boolean = false;   
	
	public var DELIMITER_WIN  :String  = "\r"; 	//- default for 'linebreak'
	public var DELIMITER_MAC  :String  = "\n"; 	//- default for 'linebreak'
	public var DELIMITER_UNIX :String  = "\r\n"; 	//- default for 'linebreak'
	public var DELIMITER   :String  = DELIMITER_WIN; 	//- default for 'linebreak'
	public var SEPERATER   :String  = ",";		//- default for 'comma'
	public var USECODEPAGE :Boolean = false;	//- default for 'UTL-8'

	public var src   :String;
	public var array :Array;
	public var status :Boolean;
	public var onParseStr  :Function;
	public var getProgress :Function;

	
	//	PUBLIC METHODS:
	//	-------------------
	//	@method:	load - load CSV file
	//	   @arg:	url  - path to the file
	public function load( url :String ) :Void
	{
		System.useCodepage = USECODEPAGE;
		getProgress = getLoadProgress;
		super.load( url );
	}
	
	public function onData( src :String ) :Void
	{
		this.src = src;
		this.status = src !== undefined;
		this.onLoad( status );
	}

	public function toArray() :Array
	{
		//改行コードを識別
		var del :String = DELIMITER_WIN; //デフォルトはWINの改行コード
		if( src.indexOf( DELIMITER_UNIX ) != -1 )
		{
			del = DELIMITER_UNIX; //UNIXの改行コード
			trace( "UNIXの改行コード" )
		}
		else if( src.indexOf( DELIMITER_MAC ) != -1 )
		{ 
			del = DELIMITER_MAC; //MACの改行コード
			trace( "MACの改行コード" )
		}
		
		var a   :Array;
		a = src.split( del );
		
		var i = a.length;
		while( --i > -1 ) a[ i ] = a[ i ].split( SEPERATER );

		return a;
	}
	
	
	private var $i, $l:Number;
	private var $parse_iv :Number;
	private function $parseStr( sep :String, scope ) :Void
	{
		var T = getTimer() + 512;
		clearInterval( scope.$parse_iv );
		
		while( true )
		{
			//ループ終了条件１
			if( --$i < 0 ) 
			{
				onParseStr( true );
				return;
			}
			
			//ループ終了条件２
			if( ( T - getTimer() ) < 0 )
			{
				scope.$parse_iv = setInterval( scope, "$parseStr", 10, [ sep, scope ] );
				return;
			}

			var a :Array = array;
			a[ $i ] = a[ $i ].split( sep );
		}
	}/*
	private function $parseStr( sep :String, scope ) :Void
	{
		if( --$i < 0 ) 
		{
			clearInterval( scope.$parse_iv );
			onParseStr( true );
			return;
		}
		
		var a :Array = array;
		a[ $i ] = a[ $i ].split( sep || SEPERATER );
	}*/
	public function parseStr() :Void
	{
		var $this = this;
		
		//改行コードを識別
		var del :String = DELIMITER_WIN; //デフォルトはWINの改行コード
		if( src.indexOf( DELIMITER_UNIX ) != -1 )
		{
			del = DELIMITER_UNIX; //UNIXの改行コード
			//trace( "UNIXの改行コード" )
		}
		else if( src.indexOf( DELIMITER_MAC ) != -1 )
		{ 
			del = DELIMITER_MAC; //MACの改行コード
			//trace( "MACの改行コード" )
		}
			
		array = src.split( del );
		$l = $i = array.length;
		
		getProgress = getParseProgress;
		$parse_iv = setInterval( this, "$parseStr", 10, SEPERATER, $this );
	}
	
	
	
	public function getLoadProgress( Void ) :Number
	{
		var n :Number;
		var lb = getBytesLoaded();
		var tb = getBytesTotal();
		if( !tb ) n = 0;
		else	  n = Math.round( lb / tb * 1000 ) / 10;
		return n;
	}
	
	public function getParseProgress( Void ) :Number
	{
		var n :Number;
		var lb = $l - ( $i < 0 ? 0 : $i );
		var tb = $l;
		if( !tb ) n = 0;
		else	  n = Math.round( lb / tb * 1000 ) / 10;
		return n;
	}
	
	//	CONSTRUCTOR:
	//	-------------------
	//	@method:	CSV   - constructor
	//	   @arg:	scope - [OPTINAL] set callback scope
	//	   @arg:	unUTF - [OPTINAL] set System.useCodepage
	public function CSV ( unUTF :Boolean ) 
	{
		super();
		USECODEPAGE = unUTF || USECODEPAGE;
	}
	
	public function toString() :String
	{
		var a :Array = array.slice() || toArray();
		
		a.unshift( '----------------------------' );
		a.unshift( "CSV list: seperated by '" + SEPERATER + "'" );
		a.unshift( '\r' + '\r' );
		a.push( '----------------------------' );
		
		return a.join( '\r' );
	}
}