﻿
class utils.ColorUtil
{
	/**
	* ARGBの各チャンネルから16進カラー値を得る(出力は10進値)
	* 
	* param  a :Number - アルファ値　10進数[ 0 - 255 ]
	* param  r :Number - 赤値　		 10進数[ 0 - 255 ]
	* param  g :Number - 青値　		 10進数[ 0 - 255 ]
	* param  b :Number - 緑値　		 10進数[ 0 - 255 ]
	* return hex10	   - ARGBの10進数値
	* eg.
	* var hex = toHEX( 255, 0, 255, 0 ) // 緑を表す 32 ビット 16 進値を 10 進数として出力
	*/
	static function toHEX( a :Number, r :Number, g :Number, b :Number ) :Number
	{
		return ( a << 24 | r << 16 | g << 8 | b );
	}
	
	/**
	* 16進カラー値からARGBオブジェクトを得る
	*
	* param  val :Number  - 16進カラー値[ 0x00000000 - 0xFFFFFFFF ](もちろん10進値でもよい)
	* return argb :Object - ARGBオブジェクト { a, r, g, b }
	* eg.
	* var argb = toARGB( 0xFFFFCC00 );
	* alpha = argb.a;
	* red   = argb.r;
	* green = argb.g;
	* blue  = argb.b;
	*/
	static function toARGB( val :Number ) :Object
	{
		var col = {};
		col.a = ( val >> 24 ) & 0xFF
		col.r = ( val >> 16 ) & 0xFF
		col.g = ( val >>  8 ) & 0xFF
		col.b =   val & 0xFF
		return col;
	}
}
