﻿

class utils.Hash
{
    
    /** Contains the keys. */
    private var keys :Array;
    
    /** Contains the values. */
    private var values :Array;
    
	
    public function Hash( source ) 
	{
        keys   = new Array();
        values = new Array();
        populate( source );
    }
	
    /**
     * Populates the map with the content of the passed-in {@code source}.
     * 
     * <p>Iterates over the passed-in source with the for..in loop and uses the variables'
     * names as key and their values as value. Variables that are hidden from for..in
     * loops will not be added to this map.
     * 
     * <p>This method uses the {@code put} method to add the key-value pairs.
     * 
     * @param source an object that contains key-value pairs to populate this map with
     */
    private function populate( source ) :Void 
	{
        if ( source ) 
		{
            for ( var i :String in source ) 
			{
                this[ "put" ]( i, source[ i ] );
            }
        }
    }

    /**
     * Checks if the passed-in {@code key} exists.
     *
     * <p>That means whether a value has been mapped to it.
     *
     * @param key the key to be checked for availability
     * @return {@code true} if the {@code key} exists else {@code false}
     */
    public function containsKey( key ) :Boolean 
	{
        return ( findKey( key ) > -1 );
    }
    
    /**
     * Checks if the passed-in {@code value} is mapped to a key.
     * 
     * @param value the value to be checked for availability
     * @return {@code true} if the {@code value} is mapped to a key else {@code false}
     */
    public function containsValue(value):Boolean 
	{
        return (findValue(value) > -1);
    }
    
    /**
     * Returns an array that contains all keys that have a value mapped to it.
     * 
     * @return an array that contains all keys
     */
    public function getKeys(Void):Array {
        return keys.slice();
    }
    
    /**
     * Returns an array that contains all values that are mapped to a key.
     *
     * @return an array that contains all mapped values
     */
    public function getValues(Void):Array {
        return values.slice();
    }
    
    /**
     * Returns the value that is mapped to the passed-in {@code key}.
     *
     * @param key the key to return the corresponding value for
     * @return the value corresponding to the passed-in {@code key}
     */
    public function get(key) 
	{
        return values[findKey(key)];
    }
    
    /**
     * Maps the given {@code key} to the {@code value}.
     *
     * <p>Both {@code key} and {@code value} are allowed to be {@code null} and
     * {@code undefined}.
     * 
     * @param key the key used as identifier for the {@code value}
     * @param value the value to map to the {@code key}
     * @return the value that was originally mapped to the {@code key} or {@code undefined}
     */
    public function put( key, value ) 
	{
        var result;
        var i :Number = findKey( key ); 
    	
		if( i < 0 ) 
		{
			keys.push( key );
            values.push( value );
        } 
		
		else 
		{
            result = values[ i ];
            values[ i ] = value;
        }
		
		return result;
    }
    
    /**
     * Copies all mappings from the passed-in {@code map} to this map.
     *
     * @param map the mappings to add to this map
     */
    public function putAll( map :Hash ) :Void 
	{
        var values :Array = map.getValues();
        var keys   :Array = map.getKeys();

		var l :Number = keys.length;
        for ( var i :Number = 0; i < l; i = i - ( - 1 ) ) 
		{
            put( keys[ i ], values[ i ] );
        }
    }
    
    /**
     * Clears all mappings.
     */
    public function clear( Void ) :Void 
	{
        keys   = new Array();
        values = new Array();
    }
    
    /**
     * Removes the mapping from the given {@code key} to the value.
     *
     * @param key the key identifying the mapping to remove
     * @return the value that was originally mapped to the {@code key}
     */
    public function remove( key ) 
	{
        var i :Number = findKey( key );
        
		if( i > -1 ) 
		{
            var result = values[ i ];
            values.splice( i, 1 );
            keys.splice( i, 1 );

			return result;
        }
		
        return;
    }
    
    /**
     * Returns an iterator to iterate over the values of this map.
     *
     * @return an iterator to iterate over the values of this map
     * @see #valueIterator
     * @see #getValues
     */
	 /*
    public function iterator(Void):Iterator {
        return new ValueMapIterator(this);
    }
	*/
    
    /**
     * Returns an iterator to iterate over the values of this map.
     *
     * @return an iterator to iterate over the values of this map
     * @see #iterator
     * @see #getValues
     */
	 /*
    public function valueIterator(Void):Iterator {
        return iterator();
    }
	*/
    
    /**
     * Returns an iterator to iterate over the keys of this map.
     *
     * @return an iterator to iterate over the keys of this map
     * @see #getKeys
     */
	 /*
    public function keyIterator(Void):Iterator {
        return new KeyMapIterator(this);
    }
	*/

    /**
     * Returns the amount of mappings.
     *
     * @return the amount of mappings
     */
    public function size(Void):Number 
	{
        return keys.length;
    }
    
    /**
     * Returns whether this map contains any mappings.
     * 
     * @return {@code true} if this map contains no mappings else {@code false}
     */
    public function isEmpty(Void):Boolean 
	{
        return (size() < 1);
    }
    
	/**
	 * Searches for the given {@code value} and returns the index where it is stored.
	 *
	 * @param value the value to search for
	 * @return the index where the {@code value} is stored
	 */
	private function findValue(value):Number {
		var l:Number = values.length;
		while (values[--l] !== value && l>-1);
		return l;
	}
	
	/**
	 * Searches for the given {@code key} and returns the index where it is stored.
	 * 
	 * @param key the key to search for
	 * @return the index where the {@code key} is stored
	 */
	private function findKey( key ) :Number 
	{
		var l :Number = keys.length;
		while ( keys[ --l ] !== key && l > - 1 );
		
		return l;
	}
    
    /**
     * Returns the string representation of this map.
     *
     * <p>The string representation is obtained using the stringifier returned by the
     * static {@link AbstractMap#getStringifier} method.
     * 
     * @return the string representation of this map
     */
    public function toString():String 
	{
        //return getStringifier().execute(this);
		return "[type Hash]";
    }
    
}