﻿import utils.*;
import flash.geom.*;


class utils.TempProjector
extends Projector
{
	private static var PI = 3.14159265;
	private static var D  = 0.0174532925;
	private static var R  = 57.2957795;
	
	/** 変換行列 */
	private static var m :Matrix4x4;
	
	
	public static function clear()
	{
		m = new Matrix4x4();
	}
	
	public static function toRadian( degree )
	{
		//return ( degree * Math.PI / 180 );
		return degree * D;
	}
	public static function toDegree( radian )
	{
		//return  radian * 180 / Math.PI;
		return  radian * R;
	}
	
	public static function translate( x, y, z ): Void
	{
		//m.translate( z, y, z ); // <-- なぜｚ,y,z？
		m.translate( x, y, z );
	}
	public static function rotate( axis: Number, degree :Number ): Void
	{
		m.rotate( axis, toRadian( degree ) );
	};
	
	
	public static function transVector( vector )
	{
		m.transformNode( vector );
	}
	
	public static function transNodes( nodes :Array ) :Array
	{
		var a = new Array();
		var i = nodes.length;
		while( --i > -1)
		{
			//ノードのリセット
			nodes[ i ].reset();
			
			//ノードの変換
			a[ i ] = m.transformNode( nodes[ i ] );
		};
		
		return a;
	};
	
	
	
	//	-------------------
	//	@method:	getMovieClipTransformMatrix   
	//							  - MCの変換後のマトリクスを返す
	//	   @arg:	mc		 	  - MovieClip 変換対象のmc
	//	   @arg:	a	  		  - Vector プレートの座標 v0
	//	   @arg:	b	  		  - Vector プレートの座標 v1
	//	   @arg:	c	  		  - Vector プレートの座標 v2
	//  @return:	Matrix	  	  - Matrix 変換後のMatorix（ mc.transform.matrix = m; として使う）
	static function getMovieClipTransformMatrix( mc :MovieClip, a ,b ,c ) :Matrix
	{
		// deterimine visibility
		//mc._visible = pointsIsVisible( a, b, c );
	
		// if not visible, exit function
		//if ( !mc._visible ) return;
		
		
		/* Points
		   3 - 4
		  /   /|
		 0 -   5
		 |   |/
		 2 - 1
		 
		 Notice that 2 points are missing, one in the front upper
		 right and one in the back lower left. These are not needed
		 since each side only requires 3 points to define its place
		 in 3D space.  Depending on intented image orientation,
		 though, these points may be necessary for your images to
		 go and face where you want them to
		*/
		// set values for matrix using point b as top left
		var m :Matrix = mc.transform.matrix;
		
		m.tx = b.x;
		m.ty = b.y;
		
		//注意！
		//mcの内部に、必ずinnerという名前のMCが必要！
		if( !mc.inner ) 
		{
			trace( [ "エラー：ルール違反 RendererImpl.getMovieClipTransformMatrix()", mc, mc.inner ] );
			trace( [ "NOT FOUND mc.inner at :" + mc  ])
			trace( [ "注意！:mcの内部に、必ずinnerという名前のMCが必要！" ] );
			return;
		}
		
		var inner = mc.inner;
		var w = inner._width;
		var h = inner._height;
		m.a  = ( a.x - b.x ) / w;
		m.b  = ( a.y - b.y ) / w;
		m.c  = ( c.x - b.x ) / h;
		m.d  = ( c.y - b.y ) / h;
		
		return m;
	}
	
	static function getTransformMatrix( obj, a ,b ,c, matrix :Matrix ) :Matrix
	{
		// deterimine visibility
		//mc._visible = pointsIsVisible( a, b, c );
	
		// if not visible, exit function
		//if ( !mc._visible ) return;
		
		
		/* Points
		   3 - 4
		  /   /|
		 0 -   5
		 |   |/
		 2 - 1
		 
		 Notice that 2 points are missing, one in the front upper
		 right and one in the back lower left. These are not needed
		 since each side only requires 3 points to define its place
		 in 3D space.  Depending on intented image orientation,
		 though, these points may be necessary for your images to
		 go and face where you want them to
		*/
		// set values for matrix using point b as top left
		var m :Matrix = matrix || new Matrix();
		
		m.tx = b.x;
		m.ty = b.y;
		
		var w = obj.width;
		var h = obj.height;
		m.a  = ( a.x - b.x ) / w;
		m.b  = ( a.y - b.y ) / w;
		m.c  = ( c.x - b.x ) / h;
		m.d  = ( c.y - b.y ) / h;
		
		return m;
	}
	
	// using a 2D relationship between 3 points
	// determine if a 3D face is visible
	static function pointsIsVisible( a, b, c )
	{
		var db = b.x - a.x;
		if ( !db ) return ( a.y > b.y == c.x > a.x );
		
		var dc = c.x - a.x;
		if ( !dc ) return ( a.y > c.y == b.x < a.x );
		
		return ( ( b.y - a.y ) / db < ( c.y - a.y ) / dc ) != ( a.x < b.x == a.x > c.x );
	}

}