﻿
class utils.Vector
{
	var x :Number;
	var y :Number;
	var z :Number;
	
	function Vector( x, y, z )
	{
		this.x = x || 0;
		this.y = y || 0;
		this.z = z || 0;
	}
	
	//ベクトルの初期化
	public function identity( Void ) :Void
	{
		x = 1;		y = 1;		z = 1;	
	}
	//ベクトルの大きさ
	public function magnitude( Void ) :Number
	{
		return Math.sqrt( x * x + y * y + z * z );
	}
	
	//スカラー倍
	public function multiply( n :Number ) :Vector
	{
		var v :Vector = clone();
		
		v.x *= n;		v.y *= n;		v.z *= n;	
		
		return new Vector( v.x, v.y, v.z );
	}
	//ベクトルの加算
	public function plus( vec :Vector ) :Vector
	{
		var v :Vector = clone();
		
		v.x += vec.x;	v.y += vec.y;	v.z += vec.z; 
		
		return new Vector( v.x, v.y, v.z );
	}
	
	//ベクトルの減算
	public function minus( vec :Vector ) :Vector
	{
		var v :Vector = clone();
		
		v.x -= vec.x;	v.y -= vec.y;	v.z -= vec.z; 
		
		return new Vector( v.x, v.y, v.z );
	}
	
	//正規化
	public function normalize( Void ) :Vector
	{
		var v :Vector = clone();
		
		var mag :Number = magnitude();
		v.x *= 1 / mag;	v.y *= 1 / mag;	v.z *= 1 / mag;
		
		return new Vector( v.x, v.y, v.z );
	}
	//内積
	public function dot( vec :Vector ) :Number
	{
		var v :Vector = clone();
		
		return v.x * vec.x + v.y * vec.y + v.z * vec.z; 
	}
	//外積
	public function cross( b :Vector ) :Vector
	{
		var v :Vector = clone();
		var a :Vector = v.clone();
		
		v.x = a.y * b.z - a.z * b.y;
		v.y = a.z * b.x - a.x * b.z;
		v.z = a.x * b.y - a.y * b.x;
		
		return new Vector( v.x, v.y, v.z );
	}

	//反転
	public function invert( Void ) :Vector
	{
		var v :Vector = clone();
		
		v.x = -v.x;		v.y = -v.y;		v.z = -v.z;	
		
		return new Vector( v.x, v.y, v.z );
	}
	
	
	//複製
	public function clone() :Vector
	{
		return new Vector( x, y, z );
	}
	
	function toString () :String
	{
		return "( x = "+ x + ", y = "+ y + ", z = " + z + " )"
	}

}