﻿/*
 ====================================================
   XPathWrapper v1.0 2005
   author:sakana sato
   e-mail:sakana.sato@nifty.com
   an extention of XPath4AS2
   http://www.xfactorstudio.com/Actionscript/AS2/XPath/
 ====================================================
 */
/*
import com.hidesignlab.core.*;
import org.as2lib.data.holder.*;
import org.as2lib.data.holder.map.*;
*/
import com.xfactorstudio.xml.xpath.*;
import utils.Hash;

/**
* XMLの高機能なUtil。Singleton
* ## 注意	XPathの使用上の注意
* 1.XPath.selectNodes()は、Arrayを返す。
* 	(--->要素のアクセスには、[0]など配列アクセス演算子と数値インデックスをキーにアクセスする)
* {@code
* 	var nodes :Array  = XPath.selectNodes( xml, "/root/items/item" );
* 	var item0 :Object = nodes[ 0 ];
* 	var item1 :Object = nodes[ 1 ];
* 	var item2 :Object = nodes[ 2 ];
* }
* 2.XPath.selectNodes()で返されたArrayの要素は、object型である。
* 	(--->文字列や数値を得たければ、型キャストが必要(しかも、Number型の場合、一度StringにキャストしてからNumberにする必要がある。かなり面倒。))
* {@code
* 	var nodes :Array  = XPath.selectNodes( xml, "/root/items/item/@id" );
* 	var id    :Number = Number( String( nodes[ 0 ] ) );
* 	
* }
*/
class utils.XMLUtil
extends XML
{
	private var cache :Hash;
	
	
	public function getProgress( Void ) :Number
	{
		var n :Number;
		var lb = getBytesLoaded();
		var tb = getBytesTotal();
		if( !tb ) n = 0;
		else	  n = Math.round( lb / tb * 1000 ) / 10;
		return n;
	}
	
	
	/**
	* ノードを配列で得る。
	* @param  x :XML
	* @param  _xpath :String
	* @param  type   :Function		- [OPTION] ノード内のオブジェクト型をキャストする型(デフォルト：Object)
	* @return nodes  :Array			- 該当するノードをArrayで返す。
	*/
	public function getData( x :XML, _xpath :String, type :Function ) :Array
	{
		var t :Array;
		
		t = cache.get( x + ":" + _xpath );
		
		if( !t ) 
		{
			switch( type )
			{
				case String :
				t = XPath.selectNodesAsString( x, _xpath );
				break;
				
				case Number :
				t = XPath.selectNodesAsNumber( x, _xpath );
				break;
				
				case Boolean :
				t = XPath.selectNodesAsBoolean( x, _xpath );
				break;
				
				case Object :
				default :
				t = XPath.selectNodes( x, _xpath );	// ---> Object型で返す。
				break;
				
			}
			
			//trace([ "キャッシュなし。", [ x + ":" + _xpath ]  ])
			cache.put( x + ":" + _xpath, t );
			return t;
		}
		
		
		//trace([ "キャッシュがありました。", x + ":" + _xpath  ])
		return t;
	}
	
	/**
	* ノードを単独で得る。通常、getData()[ 0 ]で行う処理を簡略化するための便利メソッド。
	* @param  x :XML
	* @param  _xpath :String
	* @param  type   :Function		- [OPTION] ノード内のオブジェクト型をキャストする型(デフォルト：Object)
	* @return node   :				- 該当するノードを単独で返す。
	*/
	public function getSingleData( x :XML, _xpath :String, type :Function )
	{
		return getData(  x, _xpath, type )[ 0 ];
	}
	
	/**
	* 同じノード名を持つ子ノードのindexを返す。子ノード自体の存在が無ければ-1を返す。
	* ## 注意	本家XPathでは、配列のインデックスではなくて、カウントを返す。(何もなければ、0)
	* @param  kid :XMLNode		- 
	* @return index :Number		- 兄弟ノードの配列のにおけるindex(0〜)。あり得ないが、子ノード自体の存在が無ければ-1を返す。
	*/
	public function getChildIndex( kid :XMLNode ) :Number
	{
		return XPath.getChildIndex( kid ) - 1;
	}
	
	public function setData( x :XML, _xpath :String, _val :String ) :XML 
	{
		//this = new XML();
		//this = x;
		var targetNode = String( XPath.selectNodes( this, _xpath ) );
		var targetTextNode = String( XPath.selectNodes( this, _xpath + "text()" ) );
		var convNode = convSentence( targetNode, targetTextNode, _val );
		var convXML = new XML( convSentence( this.toString(), targetNode, convNode ) );

		//delete this;
		return convXML;
	}
	
	public function removeData( x :XML, _xpath :String ) :XML 
	{
		//this = new XML();
		//this = x;
		var targetNode = String( XPath.selectNodes( this, _xpath ) );
		var convXML = new XML( convSentence( this.toString(), targetNode, "" ) );
		
		//delete this;
		return convXML;
	}
	
	public function addData( x :XML, _xpath :String, addingNode :XML ) :XML 
	{
		//this = new XML();
		//this = x;
		var targetNode :Array = XPath.selectNodes( this, _xpath );
		var convXML = new XML( convSentence( this.toString(), targetNode[ targetNode.length - 1 ], targetNode[ targetNode.length - 1 ] + addingNode.toString() ) );
		
		//delete this;
		return convXML;
	}

	private function convSentence( _str :String, oldKey :String, convkey :String ) :String 
	{
		var sentenceArray = [];
		sentenceArray = _str.split( oldKey );
		
		return sentenceArray.join( convkey );
	}
	
	
	private function clear( Void ) :Boolean 
	{
		cache.clear();
		
		return true;
	}
	
	public function destroy( Void ) 
	{
		clear();
		for( var i in this ) delete this[ i ];
		for( var i in XMLUtil ) delete XMLUtil[ i ];
		delete this;
		delete XMLUtil;
	}
	public function XMLUtil() 
	{
		cache = new Hash();
	}
}
/*

 _xml = new XML("<root><container><item>アイテム1</item><item attr='aa'>アイテム2</item></container></root>");
 var xpw:XPathWrapper = new XPathWrapper();
 // こんな感じでnewして

trace( xpw.getData( _xml , "root/container/item/text()" ) );
 // こんな風にXpathを書くと「アイテム１」が（配列で）帰ってくる

trace( xpw.getData( _xml , "root/container/item[2]/@attr" ) );
 // アトリビュートもお手の物。

trace( _xml=xpw.setData( _xml , "root/container/item[2]/" , "アイテム4") );
 // XMLを書き換えるのはこんな感じ。

trace( _xml=xpw.setData( _xml , "root/container/item[2]/@attr" , "アイテム3") );
 // アトリビュートの値も書き換えられる。

trace( xpw.removeData( _xml , "root/container/item[1]/" ) );
 // ノードごと消したくなったらこんな感じで。
 
 */
