/*
 * Decompiled with CFR 0.152.
 */
package controlP5;

import controlP5.Button;
import controlP5.ControlEvent;
import controlP5.ControlGroup;
import controlP5.ControlListener;
import controlP5.ControlP5;
import controlP5.ControlP5XMLElement;
import controlP5.Controller;
import controlP5.ControllerGroup;
import controlP5.Slider;
import java.util.Hashtable;
import processing.core.PApplet;

public class ScrollList
extends ControlGroup
implements ControlListener {
    int _myListHeight;
    int _mySpacing = 13;
    Slider _myScrollbar;
    String _myName;
    private float _myScrollValue = 0.0f;
    private boolean isScrollbarVisible = true;

    protected ScrollList(ControlP5 controlP5, ControllerGroup controllerGroup, String string, int n, int n2, int n3, int n4) {
        super(controlP5, controllerGroup, string, n, n2, n3, 9);
        this._myWidth = n3;
        this._myListHeight = n4 / this._mySpacing * this._mySpacing + 1 - 2;
        this._myScrollbar = new Slider(this.controlP5, this._myParent, string + "Scroller", 0.0f, 1.0f, 1.0f, this._myWidth + 1, 0, 10, this._myListHeight);
        this._myName = string;
        this._myScrollbar.setBroadcast(false);
        this._myScrollbar.setSliderMode(0);
        this._myScrollbar.setMoveable(false);
        this._myScrollbar.setLabelVisible(false);
        this._myScrollbar.setParent(this);
        this.add(this._myScrollbar);
        this._myScrollbar.addListener(this);
        this._myScrollbar.setVisible(false);
        this._myScrollbar.hide();
    }

    public void hideScrollbar() {
        this.isScrollbarVisible = false;
        this._myScrollbar.hide();
    }

    public void showScrollbar() {
        this.isScrollbarVisible = true;
        if ((this.controllers.size() - 1) * this._mySpacing > this._myListHeight && this.isScrollbarVisible) {
            this._myScrollbar.show();
        }
    }

    public boolean isScrollbarVisible() {
        return this.isScrollbarVisible;
    }

    public void scroll(float f) {
        if ((this.controllers.size() - 1) * this._mySpacing > this._myListHeight) {
            this._myScrollbar.setValue(PApplet.abs((float)(1.0f - PApplet.min((float)PApplet.max((float)0.0f, (float)f), (float)1.0f))));
        }
    }

    private void scroll() {
        int n = (int)(this._myScrollValue * (float)((this.controllers.size() - 1) * this._mySpacing - this._myListHeight) / (float)this._mySpacing) * this._mySpacing;
        for (int i = 1; i < this.controllers.size(); ++i) {
            this.controllers.get((int)i).position().y = n + (i - 1) * this._mySpacing;
            if (this.controllers.get(i).position().y() < 0.0f || this.controllers.get(i).position().y() > (float)this._myListHeight) {
                this.controllers.get(i).hide();
                continue;
            }
            this.controllers.get(i).show();
        }
    }

    public Button addItem(String string, int n) {
        int n2 = this.controllers.size() - 1;
        Button button = new Button(this.controlP5, this, string, n, 0, n2 * this._mySpacing, this._myWidth, this._mySpacing - 1);
        button.setMoveable(false);
        this.add(button);
        this.controlP5.register(button);
        button.addListener(this);
        this._myScrollValue = this._myScrollbar.value();
        this._myScrollbar.setValue(this._myScrollValue);
        if ((this.controllers.size() - 1) * this._mySpacing > this._myListHeight && this.isScrollbarVisible) {
            this._myScrollbar.show();
        }
        this.scroll();
        return button;
    }

    public void removeItem(String string) {
        block5: {
            try {
                for (int i = this.controllers.size() - 1; i >= 0; --i) {
                    if (!this.controllers.get(i).name().equals(string)) continue;
                    ((Button)this.controllers.get(i)).removeListener(this);
                    this.controllers.get(i).remove();
                    this.controllers.remove(this.controllers.get(i));
                    if ((this.controllers.size() - 1) * this._mySpacing > this._myListHeight && this.isScrollbarVisible) {
                        this._myScrollValue = this._myScrollbar.value();
                        this._myScrollbar.show();
                    } else {
                        this._myScrollValue = 1.0f;
                        this._myScrollbar.hide();
                    }
                    this._myScrollbar.setValue(this._myScrollValue);
                }
            }
            catch (Exception exception) {
                if (!ControlP5.DEBUG) break block5;
                System.out.println("ScrollList.removeItem exception:" + exception);
            }
        }
        this.scroll();
    }

    public void controlEvent(ControlEvent controlEvent) {
        if (controlEvent.controller() instanceof Button) {
            this._myValue = controlEvent.controller().value();
            ControlEvent controlEvent2 = new ControlEvent(this);
            this.controlP5.controlbroadcaster().broadcast(controlEvent2, 1);
        } else {
            this._myScrollValue = -(1.0f - controlEvent.value());
            this.scroll();
        }
    }

    public void addToXMLElement(ControlP5XMLElement controlP5XMLElement) {
        controlP5XMLElement.setName("controller");
        controlP5XMLElement.setAttribute("type", "scrolllist");
        controlP5XMLElement.setAttribute("width", new Integer(this._myWidth));
        controlP5XMLElement.setAttribute("height", new Integer(this._myListHeight + 1));
        for (int i = 1; i < this.controllers.size(); ++i) {
            ControlP5XMLElement controlP5XMLElement2 = new ControlP5XMLElement(new Hashtable(), true, false);
            controlP5XMLElement2.setName("item");
            controlP5XMLElement2.setAttribute("name", ((Controller)this.controllers.get(i)).name());
            controlP5XMLElement2.setAttribute("id", new Integer(((Controller)this.controllers.get(i)).id()));
            controlP5XMLElement2.setAttribute("value", new Float(((Controller)this.controllers.get(i)).value()));
            controlP5XMLElement.addChild(controlP5XMLElement2);
        }
    }
}

