/*
 * Decompiled with CFR 0.152.
 */
package controlP5;

import controlP5.ControlP5IOHandler;
import controlP5.Label;
import java.awt.Component;
import processing.core.PImage;

public class BitFontRenderer {
    static int numFonts = 4;
    int[] characters = new int[numFonts];
    int[][] charWidth = new int[numFonts][255];
    int[] charHeight = new int[numFonts];
    int[][][] chars = new int[numFonts][][];
    int[] lineHeight = new int[numFonts];
    int[] wh = new int[numFonts];
    protected static PImage[] font = new PImage[numFonts];
    public static final int standard58 = 0;
    public static final int standard56 = 1;
    public static final int synt24 = 2;
    public static final int grixel = 3;
    protected float height;
    protected int _mySpacing = 1;
    public static boolean isInit = false;

    protected BitFontRenderer(Component component) {
        this.loadFonts(component);
        this.init(0, numFonts);
    }

    private void loadFonts(Component component) {
        if (!isInit) {
            BitFontRenderer.font[0] = new PImage(ControlP5IOHandler.loadImage(component, this.getClass().getResource("standard58.gif")));
            BitFontRenderer.font[1] = new PImage(ControlP5IOHandler.loadImage(component, this.getClass().getResource("standard56.gif")));
            BitFontRenderer.font[2] = new PImage(ControlP5IOHandler.loadImage(component, this.getClass().getResource("synt24.gif")));
            BitFontRenderer.font[3] = new PImage(ControlP5IOHandler.loadImage(component, this.getClass().getResource("GrixelKyrou9.gif")));
        }
    }

    public BitFontRenderer() {
        this.loadFonts(null);
        this.init(0, numFonts);
    }

    private void init(int n, int n2) {
        isInit = true;
        for (int i = n; i < n2; ++i) {
            int n3;
            this.charHeight[i] = BitFontRenderer.font[i].height;
            this.lineHeight[i] = this.charHeight[i];
            int n4 = 0;
            int n5 = 0;
            for (n3 = 0; n3 < BitFontRenderer.font[i].width; ++n3) {
                ++n4;
                if (BitFontRenderer.font[i].pixels[n3] != -65536) continue;
                this.charWidth[i][this.characters[i]] = n4;
                int n6 = i;
                this.characters[n6] = this.characters[n6] + 1;
                if (n4 > n5) {
                    n5 = n4;
                }
                n4 = 0;
            }
            this.chars[i] = new int[this.characters[i]][n5 * this.charHeight[i]];
            n3 = 0;
            for (int j = 0; j < this.characters[i]; ++j) {
                for (int k = 0; k < this.charWidth[i][j] * this.charHeight[i]; ++k) {
                    this.chars[i][j][k] = BitFontRenderer.font[i].pixels[n3 + k / this.charWidth[i][j] * BitFontRenderer.font[i].width + k % this.charWidth[i][j]];
                }
                n3 += this.charWidth[i][j];
            }
        }
    }

    protected int addBitFont(PImage pImage) {
        PImage[] pImageArray = new PImage[numFonts];
        System.arraycopy(font, 0, pImageArray, 0, font.length);
        font = new PImage[++numFonts];
        System.arraycopy(pImageArray, 0, font, 0, pImageArray.length);
        try {
            BitFontRenderer.font[BitFontRenderer.numFonts - 1] = (PImage)pImage.get().clone();
        }
        catch (Exception exception) {
            System.out.println("ERROR BitFontRenderer.addBitFont(). " + exception);
        }
        this.init(numFonts - 1, numFonts);
        return numFonts - 1;
    }

    public int getWidth(String string, int n) {
        return this.getWidth(string, n, string.length());
    }

    protected int getWidth(String string, int n, int n2) {
        int n3 = 0;
        if (string == null) {
            string = " ";
        }
        for (int i = 0; i < n2; ++i) {
            int n4 = string.charAt(i) - 32;
            if (n4 < 0) continue;
            n3 += this.charWidth[n][n4] + this._mySpacing + 1;
        }
        return n3;
    }

    private void putchar(int n, int n2, int n3, int n4, boolean bl, PImage pImage, PImage pImage2, int n5) {
        int n6 = pImage.width * pImage.height;
        int n7 = this.charWidth[n5][n] * this.charHeight[n5];
        int n8 = n3 * pImage.width;
        for (int i = 0; i < n7; ++i) {
            int n9 = n2 + i % this.charWidth[n5][n];
            int n10 = n9 + n8 + i / this.charWidth[n5][n] * pImage.width;
            if (this.chars[n5][n][i] != -16777216 || n9 >= pImage.width || n9 < 0 || n10 < 0 || n10 >= n6) continue;
            pImage.pixels[n10] = !bl ? n4 : -6710887;
            pImage2.pixels[n10] = -1;
        }
    }

    private int writeCharacters(Label label) {
        int n;
        int n2 = 0;
        int n3 = label.getOffsetY();
        int n4 = label.getOffsetY();
        String string = label.isToUpperCase ? label.getText().toUpperCase() : label.getText();
        int n5 = label.isMultiline() ? label.getImage().width : -1;
        Letter[] letterArray = new Letter[string.length()];
        int n6 = 0;
        for (n = 0; n < string.length(); ++n) {
            char c = string.charAt(n);
            if (c != '\n') {
                if (n5 > 0 && n2 > n5) {
                    n2 = 0;
                    n4 += label.getLineHeight();
                    int n7 = n;
                    ++n6;
                    while (n > 0 && n6 < string.length()) {
                        if (--n == 1) {
                            n = n7;
                            break;
                        }
                        if (string.charAt(n) != ' ' && string.charAt(n) != '-') continue;
                        c = string.charAt(++n);
                        break;
                    }
                }
                letterArray[n] = new Letter(n2, c - 32, n4, n == label.getCursorPosition() - 1);
                n2 += this.charWidth[label.getFontIndex()][c - 32] + label.getLetterSpacing();
                continue;
            }
            n4 += label.getLineHeight();
            n2 = 0;
            letterArray[n] = new Letter(0, -1, 0, false);
        }
        for (n = 0; n < letterArray.length; ++n) {
            if (letterArray[n].letter == -1) continue;
            this.putchar(letterArray[n].letter, label.getOffsetX() + letterArray[n].indent, letterArray[n].lineheight, label.getColor(), letterArray[n].isHighlight, label.getImage(), label.getImageMask(), label.getFontIndex());
        }
        return n4 - n3;
    }

    public int write(Label label) {
        int n;
        int n2 = label.getImage().width * label.getImage().height;
        for (n = 0; n < n2; ++n) {
            label.getImage().pixels[n] = 0xFFFFFF;
            label.getImageMask().pixels[n] = -16777216;
        }
        n = this.writeCharacters(label);
        label.getImage().mask(label.getImageMask());
        return n;
    }

    private class Letter {
        int indent;
        int letter;
        boolean isHighlight;
        int lineheight;

        Letter(int n, int n2, int n3, boolean bl) {
            this.indent = n;
            this.letter = n2;
            this.isHighlight = bl;
            this.lineheight = n3;
        }
    }
}

