/*
 * Decompiled with CFR 0.152.
 */
package controlP5;

import controlP5.Bang;
import controlP5.Button;
import controlP5.CColor;
import controlP5.ControlBroadcaster;
import controlP5.ControlGroup;
import controlP5.ControlP5Constants;
import controlP5.ControlP5IOHandler;
import controlP5.ControlWindow;
import controlP5.ControlWindowKeyHandler;
import controlP5.ControlWindowKeyListener;
import controlP5.Controller;
import controlP5.ControllerGroup;
import controlP5.ControllerInterface;
import controlP5.Knob;
import controlP5.Matrix;
import controlP5.MultiList;
import controlP5.Numberbox;
import controlP5.PAppletWindow;
import controlP5.Radio;
import controlP5.Range;
import controlP5.ScrollList;
import controlP5.Slider;
import controlP5.Tab;
import controlP5.Textarea;
import controlP5.Textfield;
import controlP5.Textlabel;
import controlP5.Toggle;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Vector;
import processing.core.PApplet;

public class ControlP5
implements ControlP5Constants {
    public ControlWindow controlWindow;
    private Hashtable _myControllerMap;
    protected ControlBroadcaster _myControlBroadcaster;
    private String _myUrlPath = "";
    private String _myFilePath = "controlP5.xml";
    public CColor color = new CColor();
    protected Vector _myControlWindowList;
    protected static boolean isLock = false;
    protected boolean isAutoInitialization = false;
    protected boolean isGlobalControllersAlwaysVisible = true;
    public static final int standard58 = 0;
    public static final int standard56 = 1;
    public static final int synt24 = 2;
    public static final int grixel = 3;
    public static ControlWindowKeyHandler keyHandler;
    public static PApplet papplet;
    public static final String VERSION = "0.3.14";
    public static boolean isApplet;
    public static boolean DEBUG;
    protected ControlP5IOHandler _myControlP5IOHandler;
    protected boolean isTabEventsActive;
    protected boolean isUpdate;

    public ControlP5(PApplet pApplet) {
        papplet = pApplet;
        this.welcome();
        this.isTabEventsActive = false;
        this._myControlP5IOHandler = new ControlP5IOHandler(this);
        this._myControlWindowList = new Vector();
        this._myControlBroadcaster = new ControlBroadcaster(this);
        keyHandler = new ControlWindowKeyHandler(this);
        this.controlWindow = new ControlWindow(this, papplet);
        papplet.registerKeyEvent((Object)new ControlWindowKeyListener(this));
        this._myControllerMap = new Hashtable();
        this._myControlWindowList.add(this.controlWindow);
        isApplet = pApplet.online;
    }

    private void welcome() {
        System.out.println("ControlP5 0.3.14 infos, comments, questions at http://www.sojamo.de/libraries/controlP5");
    }

    public void setTabEventsActive(boolean bl) {
        this.isTabEventsActive = bl;
    }

    public void setAutoInitialization(boolean bl) {
        this.isAutoInitialization = bl;
    }

    public void setAutoDraw(boolean bl) {
        if (this.isAutoDraw() && !bl) {
            this.controlWindow.papplet().unregisterDraw((Object)this.controlWindow);
        }
        if (!this.isAutoDraw() && bl) {
            this.controlWindow.papplet().registerDraw((Object)this.controlWindow);
        }
        this.controlWindow.isAutoDraw = bl;
    }

    public boolean isAutoDraw() {
        return this.controlWindow.isAutoDraw;
    }

    public ControlBroadcaster controlbroadcaster() {
        return this._myControlBroadcaster;
    }

    public Tab addTab(String string) {
        return this.addTab(this.controlWindow, string);
    }

    public Tab addTab(PApplet pApplet, String string) {
        return this.addTab(this.controlWindow, string);
    }

    public Tab addTab(ControlWindow controlWindow, String string) {
        for (int i = 0; i < controlWindow.tabs().size(); ++i) {
            if (!controlWindow.tabs().get(i).name().equals(string)) continue;
            return (Tab)controlWindow.tabs().get(i);
        }
        Tab tab = new Tab(this, controlWindow, string);
        controlWindow.tabs().add(tab);
        return tab;
    }

    public Tab tab(String string) {
        return this.getTab(string);
    }

    public Tab getTab(String string) {
        for (int i = 0; i < this._myControlWindowList.size(); ++i) {
            for (int j = 0; j < ((ControlWindow)this._myControlWindowList.get(i)).tabs().size(); ++j) {
                if (!((Tab)((ControlWindow)this._myControlWindowList.get(i)).tabs().get(j)).name().equals(string)) continue;
                return (Tab)((ControlWindow)this._myControlWindowList.get(i)).tabs().get(j);
            }
        }
        Tab tab = this.addTab(string);
        return tab;
    }

    public Tab tab(ControlWindow controlWindow, String string) {
        return this.getTab(controlWindow, string);
    }

    public Tab getTab(ControlWindow controlWindow, String string) {
        for (int i = 0; i < controlWindow.tabs().size(); ++i) {
            if (!((Tab)controlWindow.tabs().get(i)).name().equals(string)) continue;
            return (Tab)controlWindow.tabs().get(i);
        }
        Tab tab = controlWindow.add(new Tab(this, controlWindow, string));
        return tab;
    }

    public Button addButton(String string, float f, int n, int n2, int n3, int n4) {
        Button button = new Button(this, (ControllerGroup)this.controlWindow.tabs().get(1), string, f, n, n2, n3, n4);
        this.register(button);
        return button;
    }

    public Bang addBang(String string, int n, int n2, int n3, int n4) {
        Bang bang = new Bang(this, (Tab)this.controlWindow.tabs().get(1), string, n, n2, n3, n4);
        this.register(bang);
        return bang;
    }

    public Toggle addToggle(String string, boolean bl, float f, float f2, int n, int n2) {
        Toggle toggle = new Toggle(this, (Tab)this.controlWindow.tabs().get(1), string, bl ? 1.0f : 0.0f, f, f2, n, n2);
        this.register(toggle);
        return toggle;
    }

    public Toggle addToggle(String string, float f, float f2, int n, int n2) {
        Toggle toggle = new Toggle(this, (Tab)this.controlWindow.tabs().get(1), string, Float.NaN, f, f2, n, n2);
        this.register(toggle);
        return toggle;
    }

    public Matrix addMatrix(String string, int n, int n2, int n3, int n4, int n5, int n6) {
        Matrix matrix = new Matrix(this, (Tab)this.controlWindow.tabs().get(1), string, n, n2, n3, n4, n5, n6);
        this.register(matrix);
        return matrix;
    }

    public Slider addSlider(String string, float f, float f2, float f3, int n, int n2, int n3, int n4) {
        Slider slider = new Slider(this, (ControllerGroup)this.controlWindow.tabs().get(1), string, f, f2, f3, n, n2, n3, n4);
        this.register(slider);
        return slider;
    }

    public Slider addSlider(String string, float f, float f2, int n, int n2, int n3, int n4) {
        return this.addSlider(string, f, f2, Float.NaN, n, n2, n3, n4);
    }

    public Range addRange(String string, float f, float f2, float f3, float f4, int n, int n2, int n3, int n4) {
        Range range = new Range(this, (ControllerGroup)this.controlWindow.tabs().get(1), string, f, f2, f3, f4, n, n2, n3, n4);
        this.register(range);
        return range;
    }

    public Range addRange(String string, float f, float f2, int n, int n2, int n3, int n4) {
        return this.addRange(string, f, f2, f, f2, n, n2, n3, n4);
    }

    public Numberbox addNumberbox(String string, int n, int n2, int n3, int n4) {
        return this.addNumberbox(string, Float.NaN, n, n2, n3, n4);
    }

    public Numberbox addNumberbox(String string, float f, int n, int n2, int n3, int n4) {
        Numberbox numberbox = new Numberbox(this, (Tab)this.controlWindow.tabs().get(1), string, f, n, n2, n3, n4);
        this.register(numberbox);
        return numberbox;
    }

    public Knob addKnob(String string, float f, float f2, int n, int n2, int n3) {
        return this.addKnob(string, f, f2, Float.NaN, n, n2, n3);
    }

    public MultiList addMultiList(String string, int n, int n2, int n3, int n4) {
        MultiList multiList = new MultiList(this, (Tab)this.controlWindow.tabs().get(1), string, n, n2, n3, n4);
        this.register(multiList);
        return multiList;
    }

    public Knob addKnob(String string, float f, float f2, float f3, int n, int n2, int n3) {
        Knob knob = new Knob(this, (Tab)this.controlWindow.tabs().get(1), string, f, f2, f3, n, n2, n3);
        this.register(knob);
        return knob;
    }

    public Textarea addTextarea(String string, String string2, int n, int n2, int n3, int n4) {
        Textarea textarea = new Textarea(this, (Tab)this.controlWindow.tabs().get(1), string, string2, n, n2, n3, n4);
        this.register(textarea);
        return textarea;
    }

    public Textlabel addTextlabel(String string, String string2, int n, int n2) {
        Textlabel textlabel = new Textlabel(this, (Tab)this.controlWindow.tabs().get(1), string, string2, n, n2);
        this.register(textlabel);
        return textlabel;
    }

    public Textfield addTextfield(String string, int n, int n2, int n3, int n4) {
        Textfield textfield = new Textfield(this, (Tab)this.controlWindow.tabs().get(1), string, "", n, n2, n3, n4);
        this.register(textfield);
        return textfield;
    }

    public Radio addRadio(String string, int n, int n2) {
        Radio radio = new Radio(this, (Tab)this.controlWindow.tabs().get(1), string, n, n2);
        this.register(radio);
        return radio;
    }

    public Radio addRadio(String string, int n, int n2, int n3, int n4, int n5) {
        Radio radio = new Radio(this, (Tab)this.controlWindow.tabs().get(1), string, n, n2, n3, n4, n5);
        this.register(radio);
        return radio;
    }

    public ScrollList addScrollList(String string, int n, int n2, int n3, int n4) {
        ScrollList scrollList = new ScrollList(this, (Tab)this.controlWindow.tabs().get(1), string, n, n2, n3, n4);
        this.register(scrollList);
        return scrollList;
    }

    public ControlGroup addGroup(String string, int n, int n2, int n3) {
        ControlGroup controlGroup = new ControlGroup(this, (ControllerGroup)this.controlWindow.tabs().get(1), string, n, n2, n3, 9);
        this.register(controlGroup);
        return controlGroup;
    }

    public ControlGroup addGroup(String string, int n, int n2) {
        return this.addGroup(string, n, n2, 99);
    }

    public void register(ControllerInterface controllerInterface) {
        this.checkName(controllerInterface.name());
        this._myControllerMap.put(controllerInterface.name(), controllerInterface);
        controllerInterface.init();
    }

    public ControllerInterface[] getControllerList() {
        ControllerInterface[] controllerInterfaceArray = new ControllerInterface[this._myControllerMap.size()];
        this._myControllerMap.values().toArray(controllerInterfaceArray);
        return controllerInterfaceArray;
    }

    protected void deactivateControllers() {
        if (this.getControllerList() != null) {
            ControllerInterface[] controllerInterfaceArray = this.getControllerList();
            for (int i = 0; i < controllerInterfaceArray.length; ++i) {
                if (!(controllerInterfaceArray[i] instanceof Textfield)) continue;
                ((Textfield)controllerInterfaceArray[i]).setFocus(false);
            }
        }
    }

    protected void clear() {
        int n;
        for (n = 0; n < this._myControlWindowList.size(); ++n) {
            ((ControlWindow)this._myControlWindowList.get(n)).clear();
        }
        for (n = 1; n < this._myControlWindowList.size(); ++n) {
            this._myControlWindowList.remove(n);
        }
        this._myControllerMap.clear();
        this.controlWindow.init();
    }

    protected void remove(ControlWindow controlWindow) {
        controlWindow.remove();
        this._myControlWindowList.remove(controlWindow);
    }

    protected void remove(ControllerInterface controllerInterface) {
        this._myControllerMap.remove(controllerInterface.name());
    }

    public void remove(String string) {
        if (this.controller(string) != null) {
            this.controller(string).remove();
        }
        if (this.group(string) != null) {
            this.group(string).remove();
        }
        for (int i = 0; i < this._myControlWindowList.size(); ++i) {
            for (int j = 0; j < ((ControlWindow)this._myControlWindowList.get(i)).tabs().size(); ++j) {
                if (!((Tab)((ControlWindow)this._myControlWindowList.get(i)).tabs().get(j)).name().equals(string)) continue;
                ((Tab)((ControlWindow)this._myControlWindowList.get(i)).tabs().get(j)).remove();
            }
        }
    }

    public Controller controller(String string) {
        if (this._myControllerMap.containsKey(string) && this._myControllerMap.get(string) instanceof Controller) {
            return (Controller)this._myControllerMap.get(string);
        }
        return null;
    }

    public ControllerGroup group(String string) {
        return this.getGroup(string);
    }

    public ControllerGroup getGroup(String string) {
        if (this._myControllerMap.containsKey(string) && this._myControllerMap.get(string) instanceof ControllerGroup) {
            return (ControllerGroup)this._myControllerMap.get(string);
        }
        return null;
    }

    public void draw() {
        this.controlWindow.draw();
    }

    public ControlWindow addControlWindow(String string, int n, int n2) {
        return this.addControlWindow(string, 400, 200, n, n2, "", 15);
    }

    public ControlWindow addControlWindow(String string, int n, int n2, int n3, int n4) {
        return this.addControlWindow(string, n, n2, n3, n4, "", 15);
    }

    public ControlWindow addControlWindow(String string, int n, int n2, int n3, int n4, int n5) {
        return this.addControlWindow(string, n, n2, n3, n4, "", n5);
    }

    public ControlWindow addControlWindow(String string, int n, int n2, int n3, int n4, String string2, int n5) {
        for (int i = 0; i < this._myControlWindowList.size(); ++i) {
            if (!((ControlWindow)this._myControlWindowList.get(i)).name().equals(string)) continue;
            System.out.println("### WARNING ###\n### ControlWindow with name " + string + " already exists. overwritten!");
        }
        PAppletWindow pAppletWindow = new PAppletWindow(string, n, n2, n3, n4, string2, n5);
        pAppletWindow.setParent(this);
        pAppletWindow.setMode(1);
        ControlWindow controlWindow = new ControlWindow(this, pAppletWindow);
        this._myControlWindowList.add(controlWindow);
        return controlWindow;
    }

    public ControlWindow window(PApplet pApplet) {
        if (pApplet.equals(papplet)) {
            return this.controlWindow;
        }
        return this.controlWindow;
    }

    public ControlWindow window(String string) {
        for (int i = 0; i < this._myControlWindowList.size(); ++i) {
            if (!((ControlWindow)this._myControlWindowList.get(i)).name().equals(string)) continue;
            return (ControlWindow)this._myControlWindowList.get(i);
        }
        System.out.println("### WARNING ###\n### ControlWindow " + string + " does not exist. returning null.");
        return null;
    }

    private boolean checkName(String string) {
        if (this._myControllerMap.containsKey(string)) {
            System.out.println("### WARNING. controller with name \"" + string + "\" already exists. overwriting reference of existing controller.");
            return true;
        }
        return false;
    }

    public void setFilePath(String string) {
        if (string == null) {
            string = "";
        }
        this._myFilePath = string;
    }

    public void setUrlPath(String string) {
        this.setUrlPath(string, "controlP5.xml");
    }

    public void setUrlPath(String string, String string2) {
        if (string == null) {
            string = "";
            return;
        }
        if ((string = ControlP5IOHandler.replace(string, "&amp;", "&")).indexOf(63) == -1) {
            string = string + '?';
        } else if (!string.endsWith("&") && !string.endsWith("?")) {
            string = string + "&";
        }
        this._myUrlPath = string + "filename=" + string2;
    }

    public String filePath() {
        return this._myFilePath;
    }

    public String urlPath() {
        return this._myUrlPath;
    }

    public void setColorActive(int n) {
        this.color.colorActive = n;
        Enumeration enumeration = this._myControlWindowList.elements();
        while (enumeration.hasMoreElements()) {
            ControlWindow controlWindow = (ControlWindow)enumeration.nextElement();
            controlWindow.setColorActive(n);
        }
    }

    public void setColorForeground(int n) {
        this.color.colorForeground = n;
        Enumeration enumeration = this._myControlWindowList.elements();
        while (enumeration.hasMoreElements()) {
            ControlWindow controlWindow = (ControlWindow)enumeration.nextElement();
            controlWindow.setColorForeground(n);
        }
    }

    public void setColorBackground(int n) {
        this.color.colorBackground = n;
        Enumeration enumeration = this._myControlWindowList.elements();
        while (enumeration.hasMoreElements()) {
            ControlWindow controlWindow = (ControlWindow)enumeration.nextElement();
            controlWindow.setColorBackground(n);
        }
    }

    public void setColorLabel(int n) {
        this.color.colorLabel = n;
        Enumeration enumeration = this._myControlWindowList.elements();
        while (enumeration.hasMoreElements()) {
            ControlWindow controlWindow = (ControlWindow)enumeration.nextElement();
            controlWindow.setColorLabel(n);
        }
    }

    public void setColorValue(int n) {
        this.color.colorValue = n;
        Enumeration enumeration = this._myControlWindowList.elements();
        while (enumeration.hasMoreElements()) {
            ControlWindow controlWindow = (ControlWindow)enumeration.nextElement();
            controlWindow.setColorValue(n);
        }
    }

    protected Vector controlWindows() {
        return this._myControlWindowList;
    }

    public void lock() {
        isLock = true;
    }

    public void unlock() {
        isLock = false;
    }

    public boolean save(String string) {
        return this._myControlP5IOHandler.save(this, string);
    }

    public boolean save() {
        if (this._myFilePath != null) {
            return this._myControlP5IOHandler.save(this, this._myFilePath);
        }
        return false;
    }

    public boolean load(String string) {
        System.out.println("loading.." + string);
        String[] stringArray = papplet.loadStrings(string);
        String string2 = "";
        for (int i = 0; i < stringArray.length; ++i) {
            string2 = string2 + stringArray[i];
        }
        if (string2.length() == 0) {
            return false;
        }
        this.clear();
        try {
            Thread.sleep(200L);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this._myControlP5IOHandler.parse(string2);
        return true;
    }

    public String version() {
        return VERSION;
    }

    public void show() {
        this.controlWindow.show();
    }

    public boolean isVisible() {
        return this.controlWindow.isVisible();
    }

    public void hide() {
        this.controlWindow.hide();
    }

    public void update() {
        Enumeration enumeration = this._myControlWindowList.elements();
        while (enumeration.hasMoreElements()) {
            ControlWindow controlWindow = (ControlWindow)enumeration.nextElement();
            controlWindow.update();
        }
    }

    public boolean isUpdate() {
        return this.isUpdate;
    }

    public void setUpdate(boolean bl) {
        this.isUpdate = bl;
        Enumeration enumeration = this._myControlWindowList.elements();
        while (enumeration.hasMoreElements()) {
            ControlWindow controlWindow = (ControlWindow)enumeration.nextElement();
            controlWindow.setUpdate(bl);
        }
    }

    public void trigger() {
        Iterator iterator = this._myControllerMap.keySet().iterator();
        while (iterator.hasNext()) {
            Object k = iterator.next();
            if (!(this._myControllerMap.get(k) instanceof Controller)) continue;
            ((Controller)this._myControllerMap.get(k)).trigger();
        }
    }
}

