/*
 * Decompiled with CFR 0.152.
 */
package controlP5;

import controlP5.ControlP5;
import controlP5.ControlP5XMLElement;
import controlP5.Controller;
import controlP5.ControllerGroup;
import controlP5.Label;
import processing.core.PApplet;

public class Range
extends Controller {
    protected static final int HORIZONTAL = 0;
    protected static final int VERTICAL = 1;
    private int _myDirection;
    public static final int FIX = 1;
    public static final int FLEXIBLE = 0;
    private int _mySliderMode = 1;
    float _myValuePosition;
    float _mySliderbarSize = 0.0f;
    int _myDragArea = 4;
    boolean isDragging;
    boolean isFirstClick;
    Label _myHighValueLabel;

    public Range(ControlP5 controlP5, ControllerGroup controllerGroup, String string, float f, float f2, float f3, float f4, int n, int n2, int n3, int n4) {
        super(controlP5, controllerGroup, string, n, n2, n3, n4);
        this._myCaptionLabel = new Label(string, this.color.colorLabel);
        this._myArrayValue = new float[2];
        this._myArrayValue[0] = f3;
        this._myArrayValue[1] = f4;
        this._myMin = f;
        this._myMax = f2;
        this._myValueLabel = new Label("" + this.adjustValue(this._myMin), this.color.colorValue);
        this._myValueLabel.set("" + this.adjustValue(f3));
        this._myHighValueLabel = new Label(this.adjustValue(this._myMax), this.color.colorValue);
        this._myHighValueLabel.set("" + this.adjustValue(f4));
        this._myValue = f3;
        this.setSliderMode(1);
        this._myDirection = this.width > this.height ? 0 : 1;
    }

    public void setSliderMode(int n) {
        this._mySliderMode = n;
        this._mySliderbarSize = 10.0f;
        this._myUnit = (this._myMax - this._myMin) / (float)this.width;
        this._myArrayValue[0] = this._myArrayValue[0] - this._myMin;
        this._myArrayValue[1] = this._myArrayValue[1] - this._myMin;
        this._myArrayValue[0] = this._myArrayValue[0] / this._myUnit;
        this._myArrayValue[1] = this._myArrayValue[1] / this._myUnit;
        if (ControlP5.DEBUG) {
            System.out.println(this._myArrayValue[0] + " / " + this._myArrayValue[1]);
        }
        this.setValue(this._myValue);
    }

    public void updateInternalEvents(PApplet pApplet) {
        if (this.isVisible && this.isMousePressed && !ControlP5.keyHandler.isAltDown && this._myDirection == 0) {
            float f = (float)this._myControlWindow.mouseX - (this._myParent.absolutePosition().x() + this.position.x);
            if (!this.isFirstClick && f > this._myArrayValue[0] + (this._myArrayValue[1] - this._myArrayValue[0]) / 2.0f - (float)this._myDragArea && f < this._myArrayValue[0] + (this._myArrayValue[1] - this._myArrayValue[0]) / 2.0f + (float)this._myDragArea) {
                this.isDragging = true;
            }
            this.isFirstClick = true;
            if (!this.isDragging) {
                if (Math.abs(f - this._myArrayValue[0]) < Math.abs(f - this._myArrayValue[1])) {
                    this._myArrayValue[0] = (float)this._myControlWindow.mouseX - (this._myParent.absolutePosition().x() + this.position.x);
                } else {
                    this._myArrayValue[1] = (float)this._myControlWindow.mouseX - (this._myParent.absolutePosition().x() + this.position.x);
                }
            } else if (!(this._myArrayValue[0] + (float)this._myControlWindow.mouseX - (float)this._myControlWindow.pmouseX < 0.0f || this._myArrayValue[1] + (float)this._myControlWindow.mouseX - (float)this._myControlWindow.pmouseX > (float)this.width)) {
                this._myArrayValue[0] = this._myArrayValue[0] + (float)(this._myControlWindow.mouseX - this._myControlWindow.pmouseX);
                this._myArrayValue[1] = this._myArrayValue[1] + (float)(this._myControlWindow.mouseX - this._myControlWindow.pmouseX);
            }
            this._myArrayValue[0] = this._myArrayValue[0] < this._myArrayValue[1] ? this._myArrayValue[0] : this._myArrayValue[1];
            this._myArrayValue[0] = this._myArrayValue[0] <= 0.0f ? 0.0f : this._myArrayValue[0];
            this._myArrayValue[1] = this._myArrayValue[1] >= (float)this.width ? (float)this.width : this._myArrayValue[1];
            this._myHighValueLabel.set(this.adjustValue(this._myMin + this._myArrayValue[1] * this._myUnit));
            this._myValueLabel.set(this.adjustValue(this._myMin + this._myArrayValue[0] * this._myUnit));
            this.setValue(0.0f);
        }
    }

    public void draw(PApplet pApplet) {
        if (this.isVisible) {
            pApplet.pushMatrix();
            pApplet.translate(this.position().x(), this.position().y());
            pApplet.fill(this.color.colorBackground);
            pApplet.noStroke();
            pApplet.rect(0.0f, 0.0f, (float)this.width, (float)this.height);
            pApplet.fill(this.isInside ? this.color.colorActive : this.color.colorForeground);
            if (this._myDirection == 0) {
                pApplet.rect(this._myArrayValue[0], 0.0f, this._myArrayValue[1] - this._myArrayValue[0], (float)this.height);
            } else {
                pApplet.rect(0.0f, (float)this.height, (float)this.width, -this._myValuePosition);
            }
            if (this.isLabelVisible) {
                if (this._myDirection == 0) {
                    this._myCaptionLabel.draw(pApplet, this.width + 3, this.height / 2 - 3);
                    this._myValueLabel.draw(pApplet, 3, this.height / 2 - 3);
                    this._myHighValueLabel.draw(pApplet, this.width - this._myHighValueLabel.width(), this.height / 2 - 3);
                } else {
                    this._myCaptionLabel.draw(pApplet, 0, this.height + 3);
                    this._myValueLabel.draw(pApplet, this.width + 4, -((int)this._myValuePosition) + this.height - 8);
                }
            }
            pApplet.popMatrix();
        }
    }

    public void setValue(float f) {
        this._myValue = f;
        this.broadcast(4);
    }

    public void update() {
        this.setValue(this._myValue);
    }

    public float[] arrayValue() {
        return new float[]{this._myMin + this._myArrayValue[0] * this._myUnit, this._myMin + this._myArrayValue[1] * this._myUnit};
    }

    public void setMin(float f) {
        this._myMin = f;
        this.setSliderMode(this._mySliderMode);
    }

    public void setMax(float f) {
        this._myMax = f;
        this.setSliderMode(this._mySliderMode);
    }

    public float lowValue() {
        return this._myMin + this._myArrayValue[0] * this._myUnit;
    }

    public float highValue() {
        return this._myMin + this._myArrayValue[1] * this._myUnit;
    }

    public void setLowValue(float f) {
        this._myArrayValue[0] = f / this._myUnit;
    }

    public void setHighValue(float f) {
        this._myArrayValue[1] = f / this._myUnit;
    }

    public void setWidth(int n) {
        this.width = n;
        this.setSliderMode(this._mySliderMode);
    }

    public void setHeight(int n) {
        this.height = n;
        this.setSliderMode(this._mySliderMode);
    }

    public void setDragArea(int n) {
        this._myDragArea = n;
    }

    public int dragArea() {
        return this._myDragArea;
    }

    public void mouseReleased() {
        this.isDragging = false;
        this.isFirstClick = false;
    }

    public void mouseReleasedOutside() {
        this.mouseReleased();
    }

    public void addToXMLElement(ControlP5XMLElement controlP5XMLElement) {
        controlP5XMLElement.setAttribute("type", "range");
        controlP5XMLElement.setAttribute("min", new Float(this.min()));
        controlP5XMLElement.setAttribute("max", new Float(this.max()));
    }
}

