/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text.pdf;

import com.lowagie.text.DocWriter;
import com.lowagie.text.DocumentException;
import com.lowagie.text.ExceptionConverter;
import com.lowagie.text.Image;
import com.lowagie.text.Rectangle;
import com.lowagie.text.pdf.AcroFields;
import com.lowagie.text.pdf.ByteBuffer;
import com.lowagie.text.pdf.FdfReader;
import com.lowagie.text.pdf.PdfAction;
import com.lowagie.text.pdf.PdfAnnotation;
import com.lowagie.text.pdf.PdfContentByte;
import com.lowagie.text.pdf.PdfDictionary;
import com.lowagie.text.pdf.PdfEncodings;
import com.lowagie.text.pdf.PdfException;
import com.lowagie.text.pdf.PdfFileSpecification;
import com.lowagie.text.pdf.PdfImportedPage;
import com.lowagie.text.pdf.PdfLiteral;
import com.lowagie.text.pdf.PdfName;
import com.lowagie.text.pdf.PdfReader;
import com.lowagie.text.pdf.PdfSigGenericPKCS;
import com.lowagie.text.pdf.PdfSignatureAppearance;
import com.lowagie.text.pdf.PdfStamperImp;
import com.lowagie.text.pdf.PdfString;
import com.lowagie.text.pdf.PdfTransition;
import com.lowagie.text.pdf.PdfWriter;
import java.io.EOFException;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.security.SignatureException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;

public class PdfStamper {
    protected PdfStamperImp stamper;
    private HashMap moreInfo;
    private boolean hasSignature;
    private PdfSignatureAppearance sigApp;

    public PdfStamper(PdfReader pdfReader, OutputStream outputStream) throws DocumentException, IOException {
        this.stamper = new PdfStamperImp(pdfReader, outputStream, '\u0000', false);
    }

    public PdfStamper(PdfReader pdfReader, OutputStream outputStream, char c) throws DocumentException, IOException {
        this.stamper = new PdfStamperImp(pdfReader, outputStream, c, false);
    }

    public PdfStamper(PdfReader pdfReader, OutputStream outputStream, char c, boolean bl) throws DocumentException, IOException {
        this.stamper = new PdfStamperImp(pdfReader, outputStream, c, bl);
    }

    public HashMap getMoreInfo() {
        return this.moreInfo;
    }

    public void setMoreInfo(HashMap hashMap) {
        this.moreInfo = hashMap;
    }

    public void insertPage(int n, Rectangle rectangle) {
        this.stamper.insertPage(n, rectangle);
    }

    public PdfSignatureAppearance getSignatureAppearance() {
        return this.sigApp;
    }

    private String getNewSigName() {
        AcroFields acroFields = this.getAcroFields();
        String string = "Signature";
        int n = 0;
        boolean bl = false;
        block0: while (!bl) {
            String string2 = string + ++n;
            if (acroFields.getFieldItem(string2) != null) continue;
            string2 = string2 + ".";
            bl = true;
            Iterator iterator = acroFields.getFields().keySet().iterator();
            while (iterator.hasNext()) {
                String string3 = (String)iterator.next();
                if (!string3.startsWith(string2)) continue;
                bl = false;
                continue block0;
            }
        }
        string = string + n;
        return string;
    }

    public void close() throws DocumentException, IOException {
        if (!this.hasSignature) {
            this.stamper.close(this.moreInfo);
            return;
        }
        this.sigApp.preClose();
        PdfSigGenericPKCS pdfSigGenericPKCS = this.sigApp.getSigStandard();
        PdfLiteral pdfLiteral = (PdfLiteral)pdfSigGenericPKCS.get(PdfName.CONTENTS);
        int n = (pdfLiteral.getPosLength() - 2) / 2;
        byte[] byArray = new byte[8192];
        InputStream inputStream = this.sigApp.getRangeStream();
        try {
            int n2;
            while ((n2 = inputStream.read(byArray)) > 0) {
                pdfSigGenericPKCS.getSigner().update(byArray, 0, n2);
            }
        }
        catch (SignatureException signatureException) {
            throw new ExceptionConverter(signatureException);
        }
        byArray = new byte[n];
        byte[] byArray2 = pdfSigGenericPKCS.getSignerContents();
        System.arraycopy(byArray2, 0, byArray, 0, byArray2.length);
        PdfString pdfString = new PdfString(byArray);
        pdfString.setHexWriting(true);
        PdfDictionary pdfDictionary = new PdfDictionary();
        pdfDictionary.put(PdfName.CONTENTS, pdfString);
        this.sigApp.close(pdfDictionary);
        this.stamper.reader.close();
    }

    private static int indexArray(byte[] byArray, int n, String string) {
        byte[] byArray2 = PdfEncodings.convertToBytes(string, null);
        while (true) {
            int n2;
            for (n2 = 0; n2 < byArray2.length && byArray2[n2] == byArray[n + n2]; ++n2) {
            }
            if (n2 == byArray2.length) {
                return n;
            }
            ++n;
        }
    }

    private static int indexFile(RandomAccessFile randomAccessFile, int n, String string) throws IOException {
        byte[] byArray = PdfEncodings.convertToBytes(string, null);
        while (true) {
            int n2;
            randomAccessFile.seek(n);
            for (n2 = 0; n2 < byArray.length; ++n2) {
                int n3 = randomAccessFile.read();
                if (n3 < 0) {
                    throw new EOFException("Unexpected EOF");
                }
                if (byArray[n2] != (byte)n3) break;
            }
            if (n2 == byArray.length) {
                return n;
            }
            ++n;
        }
    }

    public PdfContentByte getUnderContent(int n) {
        return this.stamper.getUnderContent(n);
    }

    public PdfContentByte getOverContent(int n) {
        return this.stamper.getOverContent(n);
    }

    public boolean isRotateContents() {
        return this.stamper.isRotateContents();
    }

    public void setRotateContents(boolean bl) {
        this.stamper.setRotateContents(bl);
    }

    public void setEncryption(byte[] byArray, byte[] byArray2, int n, boolean bl) throws DocumentException {
        if (this.stamper.isAppend()) {
            throw new DocumentException("Append mode does not support changing the encryption status.");
        }
        if (this.stamper.isContentWritten()) {
            throw new DocumentException("Content was already written to the output.");
        }
        this.stamper.setEncryption(byArray, byArray2, n, bl);
    }

    public void setEncryption(boolean bl, String string, String string2, int n) throws DocumentException {
        this.setEncryption(DocWriter.getISOBytes(string), DocWriter.getISOBytes(string2), n, bl);
    }

    public PdfImportedPage getImportedPage(PdfReader pdfReader, int n) {
        return this.stamper.getImportedPage(pdfReader, n);
    }

    public PdfWriter getWriter() {
        return this.stamper;
    }

    public PdfReader getReader() {
        return this.stamper.reader;
    }

    public AcroFields getAcroFields() {
        return this.stamper.getAcroFields();
    }

    public void setFormFlattening(boolean bl) {
        this.stamper.setFormFlattening(bl);
    }

    public void setFreeTextFlattening(boolean bl) {
        this.stamper.setFreeTextFlattening(bl);
    }

    public void addAnnotation(PdfAnnotation pdfAnnotation, int n) {
        this.stamper.addAnnotation(pdfAnnotation, n);
    }

    public void addComments(FdfReader fdfReader) throws IOException {
        this.stamper.addComments(fdfReader);
    }

    public void setOutlines(List list) throws IOException {
        this.stamper.setOutlines(list);
    }

    public void setThumbnail(Image image, int n) throws PdfException, DocumentException {
        this.stamper.setThumbnail(image, n);
    }

    public boolean partialFormFlattening(String string) {
        return this.stamper.partialFormFlattening(string);
    }

    public void addJavaScript(String string) {
        this.stamper.addJavaScript(string, !PdfEncodings.isPdfDocEncoding(string));
    }

    public void addFileAttachment(String string, byte[] byArray, String string2, String string3) throws IOException {
        this.addFileAttachment(string, PdfFileSpecification.fileEmbedded(this.stamper, string2, string3, byArray));
    }

    public void addFileAttachment(String string, PdfFileSpecification pdfFileSpecification) throws IOException {
        this.stamper.addFileAttachment(string, pdfFileSpecification);
    }

    public void setViewerPreferences(int n) {
        this.stamper.setViewerPreferences(n);
    }

    public void setXmpMetadata(byte[] byArray) {
        this.stamper.setXmpMetadata(byArray);
    }

    public boolean isFullCompression() {
        return this.stamper.isFullCompression();
    }

    public void setFullCompression() {
        if (this.stamper.isAppend()) {
            return;
        }
        this.stamper.setFullCompression();
    }

    public void setPageAction(PdfName pdfName, PdfAction pdfAction, int n) throws PdfException {
        this.stamper.setPageAction(pdfName, pdfAction, n);
    }

    public void setDuration(int n, int n2) {
        this.stamper.setDuration(n, n2);
    }

    public void setTransition(PdfTransition pdfTransition, int n) {
        this.stamper.setTransition(pdfTransition, n);
    }

    public static PdfStamper createSignature(PdfReader pdfReader, OutputStream outputStream, char c, File file, boolean bl) throws DocumentException, IOException {
        PdfStamper pdfStamper;
        if (file == null) {
            ByteBuffer byteBuffer = new ByteBuffer();
            pdfStamper = new PdfStamper(pdfReader, byteBuffer, c, bl);
            pdfStamper.sigApp = new PdfSignatureAppearance(pdfStamper.stamper);
            pdfStamper.sigApp.setSigout(byteBuffer);
        } else {
            if (file.isDirectory()) {
                file = File.createTempFile("pdf", null, file);
            }
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            pdfStamper = new PdfStamper(pdfReader, fileOutputStream, c, bl);
            pdfStamper.sigApp = new PdfSignatureAppearance(pdfStamper.stamper);
            pdfStamper.sigApp.setTempFile(file);
        }
        pdfStamper.sigApp.setOriginalout(outputStream);
        pdfStamper.sigApp.setStamper(pdfStamper);
        pdfStamper.hasSignature = true;
        return pdfStamper;
    }

    public static PdfStamper createSignature(PdfReader pdfReader, OutputStream outputStream, char c) throws DocumentException, IOException {
        return PdfStamper.createSignature(pdfReader, outputStream, c, null, false);
    }

    public static PdfStamper createSignature(PdfReader pdfReader, OutputStream outputStream, char c, File file) throws DocumentException, IOException {
        return PdfStamper.createSignature(pdfReader, outputStream, c, file, false);
    }
}

