/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text.rtf.style;

import com.lowagie.text.rtf.RtfBasicElement;
import com.lowagie.text.rtf.RtfElement;
import com.lowagie.text.rtf.RtfExtendedElement;
import com.lowagie.text.rtf.document.RtfDocument;
import com.lowagie.text.rtf.style.RtfFont;
import com.lowagie.text.rtf.style.RtfParagraphStyle;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.ArrayList;

public class RtfFontList
extends RtfElement
implements RtfExtendedElement {
    private static final byte[] DEFAULT_FONT = "\\deff".getBytes();
    private static final byte[] FONT_TABLE = "\\fonttbl".getBytes();
    public static final byte[] FONT_NUMBER = "\\f".getBytes();
    private ArrayList fontList = new ArrayList();

    public RtfFontList(RtfDocument rtfDocument) {
        super(rtfDocument);
        this.fontList.add(new RtfFont(this.document, 0));
    }

    public int getFontNumber(RtfFont rtfFont) {
        if (rtfFont instanceof RtfParagraphStyle) {
            rtfFont = new RtfFont(this.document, (RtfParagraphStyle)rtfFont);
        }
        int n = -1;
        for (int i = 0; i < this.fontList.size(); ++i) {
            if (!this.fontList.get(i).equals(rtfFont)) continue;
            n = i;
        }
        if (n == -1) {
            n = this.fontList.size();
            this.fontList.add(rtfFont);
        }
        return n;
    }

    public byte[] writeDefinition() {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            byteArrayOutputStream.write(DEFAULT_FONT);
            byteArrayOutputStream.write(this.intToByteArray(0));
            byteArrayOutputStream.write(RtfBasicElement.OPEN_GROUP);
            byteArrayOutputStream.write(FONT_TABLE);
            for (int i = 0; i < this.fontList.size(); ++i) {
                byteArrayOutputStream.write(RtfBasicElement.OPEN_GROUP);
                byteArrayOutputStream.write(FONT_NUMBER);
                byteArrayOutputStream.write(this.intToByteArray(i));
                byteArrayOutputStream.write(((RtfFont)this.fontList.get(i)).writeDefinition());
                byteArrayOutputStream.write(RtfBasicElement.COMMA_DELIMITER);
                byteArrayOutputStream.write(RtfBasicElement.CLOSE_GROUP);
            }
            byteArrayOutputStream.write(RtfBasicElement.CLOSE_GROUP);
            byteArrayOutputStream.write(10);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        return byteArrayOutputStream.toByteArray();
    }
}

