/*
 * Decompiled with CFR 0.152.
 */
package controlP5;

import controlP5.ControlP5;
import controlP5.ControlP5XMLElement;
import controlP5.Controller;
import controlP5.ControllerGroup;
import processing.core.PApplet;

public class Matrix
extends Controller {
    int cnt;
    int[][] myMarkers;
    int stepX;
    int stepY;
    int cellX;
    int cellY;
    boolean isPressed;
    int _myCellX;
    int _myCellY;
    int sum;
    long _myTime;
    long _myInterval;
    int currentX = -1;
    int currentY = -1;

    public Matrix(ControlP5 controlP5, ControllerGroup controllerGroup, String string, int n, int n2, int n3, int n4, int n5, int n6) {
        super(controlP5, controllerGroup, string, n3, n4, n5, n6);
        this._myCellX = n;
        this._myCellY = n2;
        this.sum = this._myCellX * this._myCellY;
        this.stepX = this.width / this._myCellX;
        this.stepY = this.height / this._myCellY;
        this.myMarkers = new int[this._myCellX][this._myCellY];
        for (int i = 0; i < this._myCellX; ++i) {
            for (int j = 0; j < this._myCellY; ++j) {
                this.myMarkers[i][j] = -1;
            }
        }
        this._myTime = System.currentTimeMillis();
        this._myInterval = 100L;
    }

    public void setInterval(long l) {
        this._myInterval = l;
    }

    public void updateInternalEvents(PApplet pApplet) {
        int n;
        if (System.currentTimeMillis() > this._myTime + this._myInterval) {
            ++this.cnt;
            this.cnt %= this._myCellX;
            this._myTime = System.currentTimeMillis();
            for (n = 0; n < this._myCellY; ++n) {
                if (this.myMarkers[this.cnt][n] != 1) continue;
                this._myValue = 0.0f;
                this._myValue = (this.cnt << 0) + (n << 8);
                this.setValue(this._myValue);
            }
        }
        if (this.isInside && this.isPressed) {
            n = (int)(((float)pApplet.mouseX - this.position.x) / (float)this.stepX);
            int n2 = (int)(((float)pApplet.mouseY - this.position.y) / (float)this.stepY);
            if (n != this.currentX || n2 != this.currentY) {
                boolean bl = this.myMarkers[n][n2] == 1;
                for (int i = 0; i < this._myCellY; ++i) {
                    this.myMarkers[n][i] = 0;
                }
                if (!bl) {
                    this.myMarkers[n][n2] = 1;
                }
                this.currentX = n;
                this.currentY = n2;
            }
        }
    }

    public void draw(PApplet pApplet) {
        pApplet.noStroke();
        pApplet.pushMatrix();
        pApplet.translate(this.position.x, this.position.y);
        pApplet.fill(this.color.colorBackground);
        pApplet.rect(0.0f, 0.0f, (float)this.width, (float)this.height);
        pApplet.noStroke();
        if (this.isInside()) {
            pApplet.fill(this.color.colorForeground);
            pApplet.rect((float)((int)(((float)pApplet.mouseX - this.position.x) / (float)this.stepX) * this.stepX), (float)((int)(((float)pApplet.mouseY - this.position.y) / (float)this.stepY) * this.stepY), (float)this.stepX, (float)this.stepY);
        }
        pApplet.stroke(this.color.colorActive);
        pApplet.line((float)(this.cnt * this.stepX), 0.0f, (float)(this.cnt * this.stepX), (float)this.height);
        for (int i = 0; i < this._myCellX; ++i) {
            for (int j = 0; j < this._myCellY; ++j) {
                if (this.myMarkers[i][j] != 1) continue;
                pApplet.line((float)(i * this.stepX), (float)(j * this.stepY + this.stepY / 2), (float)(i * this.stepX + this.stepX), (float)(j * this.stepY + this.stepY / 2));
            }
        }
        pApplet.popMatrix();
    }

    protected void onEnter() {
        this.isActive = true;
    }

    protected void onLeave() {
        this.isActive = false;
    }

    public void mousePressed() {
        this.isActive = this.isInside;
        if (this.isInside) {
            this.isPressed = true;
        }
    }

    public void mouseReleased() {
        if (this.isActive) {
            this.isActive = false;
        }
        this.isPressed = false;
        this.currentX = -1;
        this.currentY = -1;
    }

    public void setValue(float f) {
        this._myValue = f;
        this.broadcast(1);
    }

    public void update() {
        this.setValue(this._myValue);
    }

    public static int getX(int n) {
        return n >> 0 & 0xFF;
    }

    public static int getY(int n) {
        return n >> 8 & 0xFF;
    }

    public static int getX(float f) {
        return (int)f >> 0 & 0xFF;
    }

    public static int getY(float f) {
        return (int)f >> 8 & 0xFF;
    }

    public void addToXMLElement(ControlP5XMLElement controlP5XMLElement) {
        controlP5XMLElement.setAttribute("type", "matrix");
    }
}

