/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.tools.plugins;

import com.lowagie.text.Document;
import com.lowagie.text.DocumentException;
import com.lowagie.text.Image;
import com.lowagie.text.Rectangle;
import com.lowagie.text.pdf.BaseFont;
import com.lowagie.text.pdf.PdfContentByte;
import com.lowagie.text.pdf.PdfWriter;
import com.lowagie.tools.arguments.FileArgument;
import com.lowagie.tools.arguments.ImageArgument;
import com.lowagie.tools.arguments.PdfFilter;
import com.lowagie.tools.arguments.ToolArgument;
import com.lowagie.tools.plugins.AbstractTool;
import java.awt.Color;
import java.io.File;
import java.io.FileOutputStream;
import javax.swing.JInternalFrame;
import javax.swing.JOptionPane;

public class DvdCover
extends AbstractTool {
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$awt$Color;

    public DvdCover() {
        this.menuoptions = 7;
        this.arguments.add(new FileArgument(this, "destfile", "The file to which the PDF has to be written", true, new PdfFilter()));
        this.arguments.add(new ToolArgument(this, "title", "The title of the DVD", (class$java$lang$String == null ? (class$java$lang$String = DvdCover.class$("java.lang.String")) : class$java$lang$String).getName()));
        this.arguments.add(new ToolArgument(this, "backgroundcolor", "The backgroundcolor of the DVD Cover (for instance 0xFFFFFF)", (class$java$awt$Color == null ? (class$java$awt$Color = DvdCover.class$("java.awt.Color")) : class$java$awt$Color).getName()));
        this.arguments.add(new ImageArgument(this, "front", "The front image of the DVD Cover"));
        this.arguments.add(new ImageArgument(this, "back", "The back image of the DVD Cover"));
        this.arguments.add(new ImageArgument(this, "side", "The side image of the DVD Cover"));
    }

    protected void createFrame() {
        this.internalFrame = new JInternalFrame("Make your own DVD Cover", true, false, true);
        this.internalFrame.setSize(300, 80);
        this.internalFrame.setJMenuBar(this.getMenubar());
        System.out.println("=== DvdCover OPENED ===");
    }

    public void execute() {
        try {
            Image image;
            Rectangle rectangle = new Rectangle(780.0f, 525.0f);
            if (this.getValue("backgroundcolor") != null) {
                rectangle.setBackgroundColor((Color)this.getValue("backgroundcolor"));
            }
            Document document = new Document(rectangle);
            if (this.getValue("destfile") == null) {
                throw new DocumentException("You must provide a destination file!");
            }
            PdfWriter pdfWriter = PdfWriter.getInstance(document, new FileOutputStream((File)this.getValue("destfile")));
            document.open();
            PdfContentByte pdfContentByte = pdfWriter.getDirectContent();
            if (this.getValue("title") != null) {
                pdfContentByte.setFontAndSize(BaseFont.createFont("Helvetica", "Cp1252", false), 24.0f);
                pdfContentByte.beginText();
                if (this.getValue("front") == null) {
                    pdfContentByte.showTextAligned(1, (String)this.getValue("title"), 595.0f, 262.0f, 0.0f);
                }
                if (this.getValue("side") == null) {
                    pdfContentByte.showTextAligned(1, (String)this.getValue("title"), 385.0f, 262.0f, 270.0f);
                }
                pdfContentByte.endText();
            }
            pdfContentByte.moveTo(370.0f, 0.0f);
            pdfContentByte.lineTo(370.0f, 525.0f);
            pdfContentByte.moveTo(410.0f, 525.0f);
            pdfContentByte.lineTo(410.0f, 0.0f);
            pdfContentByte.stroke();
            if (this.getValue("front") != null) {
                image = (Image)this.getValue("front");
                image.scaleToFit(370.0f, 525.0f);
                image.setAbsolutePosition(410.0f + (370.0f - image.scaledWidth()) / 2.0f, (525.0f - image.scaledHeight()) / 2.0f);
                document.add(image);
            }
            if (this.getValue("back") != null) {
                image = (Image)this.getValue("back");
                image.scaleToFit(370.0f, 525.0f);
                image.setAbsolutePosition((370.0f - image.scaledWidth()) / 2.0f, (525.0f - image.scaledHeight()) / 2.0f);
                document.add(image);
            }
            if (this.getValue("side") != null) {
                image = (Image)this.getValue("side");
                image.scaleToFit(40.0f, 525.0f);
                image.setAbsolutePosition(370.0f + (40.0f - image.scaledWidth()) / 2.0f, (525.0f - image.scaledHeight()) / 2.0f);
                document.add(image);
            }
            document.close();
        }
        catch (Exception exception) {
            JOptionPane.showMessageDialog(this.internalFrame, exception.getMessage(), exception.getClass().getName(), 0);
            System.err.println(exception.getMessage());
        }
    }

    public void valueHasChanged(ToolArgument toolArgument) {
        if (this.internalFrame == null) {
            return;
        }
    }

    public static void main(String[] stringArray) {
        DvdCover dvdCover = new DvdCover();
        if (stringArray.length == 0) {
            System.err.println(dvdCover.getUsage());
        }
        dvdCover.setArguments(stringArray);
        dvdCover.execute();
    }

    protected File getDestPathPDF() throws InstantiationException {
        return (File)this.getValue("destfile");
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        DvdCover.addVersion("$Id: DvdCover.java,v 1.11 2005/11/29 21:05:02 blowagie Exp $");
    }
}

