/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.tools.plugins.treeview;

import com.lowagie.text.pdf.PRIndirectReference;
import com.lowagie.text.pdf.PdfArray;
import com.lowagie.text.pdf.PdfDictionary;
import com.lowagie.text.pdf.PdfName;
import com.lowagie.text.pdf.PdfObject;
import com.lowagie.text.pdf.PdfReader;
import com.lowagie.text.pdf.PdfString;
import com.lowagie.tools.plugins.treeview.ArrayTreeNode;
import com.lowagie.tools.plugins.treeview.DictionaryTreeNode;
import com.lowagie.tools.plugins.treeview.FileTreeNode;
import com.lowagie.tools.plugins.treeview.ICommonAnalyzer;
import com.lowagie.tools.plugins.treeview.OutlinelistTreeNode;
import com.lowagie.tools.plugins.treeview.PagelistTreeNode;
import com.lowagie.tools.plugins.treeview.Pagetreenode;
import com.lowagie.tools.plugins.treeview.ProgressDialog;
import com.lowagie.tools.plugins.treeview.SimpletextTreeNode;
import com.lowagie.tools.plugins.treeview.TextpaneTreeNode;
import com.lowagie.tools.plugins.treeview.UpdateableTreeNode;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Set;
import java.util.Vector;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableModel;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;

public class AnalyzePDF
extends Thread
implements TreeModel,
ICommonAnalyzer {
    DefaultMutableTreeNode root;
    DefaultMutableTreeNode filenode;
    int pagecount;
    ProgressDialog progressdialog;
    int numberofpages;
    ArrayList pageInh = new ArrayList();
    private transient Vector treeModelListeners;
    PdfReader reader;

    public AnalyzePDF(String string, ProgressDialog progressDialog) {
        this.progressdialog = progressDialog;
        try {
            this.reader = new PdfReader(string);
            this.root = new SimpletextTreeNode("Dokument");
            this.filenode = new FileTreeNode((Object)string, this.reader);
            this.root.add(this.filenode);
            this.numberofpages = this.reader.getNumberOfPages();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.pagecount = 0;
    }

    public TableModel getXReftable() {
        AbstractTableModel abstractTableModel = new AbstractTableModel(){

            public int getColumnCount() {
                return 2;
            }

            public int getRowCount() {
                return AnalyzePDF.this.reader.getXrefSize() - 1;
            }

            public Object getValueAt(int n, int n2) {
                switch (n2) {
                    case 0: {
                        return new Integer(n + 1);
                    }
                    case 1: {
                        PdfObject pdfObject = AnalyzePDF.this.reader.getPdfObject(n + 1);
                        if (pdfObject.isStream()) {
                            return "Stream " + pdfObject;
                        }
                        return pdfObject;
                    }
                }
                return null;
            }

            public String getColumnName(int n) {
                switch (n) {
                    case 0: {
                        return "XRefNr";
                    }
                    case 1: {
                        return "Object";
                    }
                }
                return null;
            }
        };
        return abstractTableModel;
    }

    protected void iteratePages(PdfDictionary pdfDictionary, PdfReader pdfReader, DefaultMutableTreeNode defaultMutableTreeNode) {
        PdfArray pdfArray = (PdfArray)PdfReader.getPdfObject(pdfDictionary.get(PdfName.KIDS));
        if (pdfArray == null) {
            defaultMutableTreeNode.add(new Pagetreenode(pdfDictionary, this.pagecount, this, pdfReader));
            System.out.println("Page= " + (this.pagecount + 1));
            this.pageInh.add(this.pagecount, pdfDictionary);
            ++this.pagecount;
        } else {
            PagelistTreeNode pagelistTreeNode = new PagelistTreeNode(pdfArray);
            defaultMutableTreeNode.add(pagelistTreeNode);
            pdfDictionary.put(PdfName.TYPE, PdfName.PAGES);
            ArrayList arrayList = pdfArray.getArrayList();
            for (int i = 0; i < arrayList.size(); ++i) {
                PdfDictionary pdfDictionary2 = (PdfDictionary)PdfReader.getPdfObject((PRIndirectReference)arrayList.get(i));
                this.iteratePages(pdfDictionary2, pdfReader, pagelistTreeNode);
            }
        }
    }

    protected void iterateOutlines(PdfDictionary pdfDictionary, PdfReader pdfReader, DefaultMutableTreeNode defaultMutableTreeNode) {
        PdfDictionary pdfDictionary2 = pdfDictionary;
        do {
            PdfString pdfString = (PdfString)PdfReader.getPdfObject(pdfDictionary2.get(PdfName.TITLE));
            OutlinelistTreeNode outlinelistTreeNode = new OutlinelistTreeNode((Object)pdfString, pdfDictionary2);
            defaultMutableTreeNode.add(outlinelistTreeNode);
            PdfDictionary pdfDictionary3 = (PdfDictionary)PdfReader.getPdfObject((PRIndirectReference)pdfDictionary2.get(PdfName.FIRST));
            if (pdfDictionary3 != null) {
                this.iterateOutlines(pdfDictionary3, pdfReader, outlinelistTreeNode);
            } else {
                PdfObject pdfObject;
                PdfObject pdfObject2;
                PdfDictionary pdfDictionary4 = (PdfDictionary)PdfReader.getPdfObject((PRIndirectReference)pdfDictionary2.get(new PdfName("SE")));
                if (pdfDictionary4 != null) {
                    this.iterateObjects(pdfDictionary4, pdfReader, outlinelistTreeNode);
                }
                if ((pdfObject2 = PdfReader.getPdfObject(pdfDictionary2.get(PdfName.DEST))) != null) {
                    this.iterateObjects(pdfObject2, pdfReader, outlinelistTreeNode);
                }
                if ((pdfObject = PdfReader.getPdfObject(pdfDictionary2.get(PdfName.A))) != null) {
                    this.iterateObjects(pdfObject, pdfReader, outlinelistTreeNode);
                }
            }
        } while ((pdfDictionary2 = (PdfDictionary)PdfReader.getPdfObject(pdfDictionary2.get(PdfName.NEXT))) != null);
    }

    public void iterateObjects(PdfObject pdfObject, PdfReader pdfReader, DefaultMutableTreeNode defaultMutableTreeNode) {
        if (pdfObject.isDictionary()) {
            DictionaryTreeNode dictionaryTreeNode = new DictionaryTreeNode((Object)("PdfDictionary " + pdfObject), (PdfDictionary)pdfObject);
            defaultMutableTreeNode.add(dictionaryTreeNode);
            Set set = ((PdfDictionary)pdfObject).getKeys();
            Iterator iterator = set.iterator();
            int n = 0;
            while (iterator.hasNext()) {
                ++n;
                Object e = iterator.next();
                PdfObject pdfObject2 = PdfReader.getPdfObject(((PdfDictionary)pdfObject).get((PdfName)e));
                SimpletextTreeNode simpletextTreeNode = new SimpletextTreeNode(e + " " + pdfObject2);
                dictionaryTreeNode.add(simpletextTreeNode);
                if (e.equals(PdfName.PARENT) || pdfObject2 == null) continue;
                this.iterateObjects(pdfObject2, pdfReader, simpletextTreeNode);
            }
        } else if (pdfObject.isArray()) {
            ArrayTreeNode arrayTreeNode = new ArrayTreeNode((Object)("PdfArray " + pdfObject), (PdfArray)pdfObject);
            defaultMutableTreeNode.add(arrayTreeNode);
            ArrayList arrayList = ((PdfArray)pdfObject).getArrayList();
            for (int i = 0; i < arrayList.size(); ++i) {
                PdfObject pdfObject3;
                PdfObject pdfObject4 = (PdfObject)arrayList.get(i);
                if (pdfObject4.isIndirect()) {
                    pdfObject3 = PdfReader.getPdfObject((PRIndirectReference)arrayList.get(i));
                    if (pdfObject3 == null) continue;
                    this.iterateObjects(pdfObject3, pdfReader, arrayTreeNode);
                    continue;
                }
                if (pdfObject4.isNumber()) continue;
                pdfObject3 = (PdfObject)arrayList.get(i);
                this.iterateObjects(pdfObject3, pdfReader, arrayTreeNode);
            }
        } else if (pdfObject.isIndirect()) {
            SimpletextTreeNode simpletextTreeNode = new SimpletextTreeNode("PRIndirectReference " + pdfObject);
            defaultMutableTreeNode.add(simpletextTreeNode);
            PdfObject pdfObject5 = PdfReader.getPdfObject((PRIndirectReference)pdfObject);
            if (pdfObject5 != null) {
                this.iterateObjects(pdfObject5, pdfReader, simpletextTreeNode);
            }
        } else if (!(pdfObject.isBoolean() || pdfObject.isName() || pdfObject.isNull() || pdfObject.isNumber() || pdfObject.isString())) {
            if (pdfObject.isStream()) {
                UpdateableTreeNode updateableTreeNode = new TextpaneTreeNode(pdfObject, "Stream");
                defaultMutableTreeNode.add(updateableTreeNode);
                updateableTreeNode = new DictionaryTreeNode((Object)("PdfDictionary " + pdfObject), (PdfDictionary)pdfObject);
                defaultMutableTreeNode.add(updateableTreeNode);
                Set set = ((PdfDictionary)pdfObject).getKeys();
                Iterator iterator = set.iterator();
                int n = 0;
                while (iterator.hasNext()) {
                    ++n;
                    Object e = iterator.next();
                    PdfObject pdfObject6 = PdfReader.getPdfObject(((PdfDictionary)pdfObject).get((PdfName)e));
                    SimpletextTreeNode simpletextTreeNode = new SimpletextTreeNode(e + " " + pdfObject6);
                    updateableTreeNode.add(simpletextTreeNode);
                    if (e.equals(PdfName.PARENT) || pdfObject6 == null) continue;
                    this.iterateObjects(pdfObject6, pdfReader, simpletextTreeNode);
                }
            } else {
                SimpletextTreeNode simpletextTreeNode = new SimpletextTreeNode("Unknown " + pdfObject);
                defaultMutableTreeNode.add(simpletextTreeNode);
            }
        }
    }

    public Object getRoot() {
        return this.root;
    }

    public Object getChild(Object object, int n) {
        DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)object;
        return defaultMutableTreeNode.getChildAt(n);
    }

    public int getChildCount(Object object) {
        DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)object;
        return defaultMutableTreeNode.getChildCount();
    }

    public boolean isLeaf(Object object) {
        DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)object;
        return defaultMutableTreeNode.isLeaf();
    }

    public void valueForPathChanged(TreePath treePath, Object object) {
        throw new RuntimeException("Manipulation of objecttree not yet supported!");
    }

    public int getIndexOfChild(Object object, Object object2) {
        DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)object;
        DefaultMutableTreeNode defaultMutableTreeNode2 = (DefaultMutableTreeNode)object2;
        return defaultMutableTreeNode.getIndex(defaultMutableTreeNode2);
    }

    public synchronized void removeTreeModelListener(TreeModelListener treeModelListener) {
        if (this.treeModelListeners != null && this.treeModelListeners.contains(treeModelListener)) {
            Vector vector = (Vector)this.treeModelListeners.clone();
            vector.removeElement(treeModelListener);
            this.treeModelListeners = vector;
        }
    }

    public synchronized void addTreeModelListener(TreeModelListener treeModelListener) {
        Vector vector;
        Vector vector2 = vector = this.treeModelListeners == null ? new Vector(2) : (Vector)this.treeModelListeners.clone();
        if (!vector.contains(treeModelListener)) {
            vector.addElement(treeModelListener);
            this.treeModelListeners = vector;
        }
    }

    protected void fireTreeNodesChanged(TreeModelEvent treeModelEvent) {
        if (this.treeModelListeners != null) {
            Vector vector = this.treeModelListeners;
            int n = vector.size();
            for (int i = 0; i < n; ++i) {
                ((TreeModelListener)vector.elementAt(i)).treeNodesChanged(treeModelEvent);
            }
        }
    }

    protected void fireTreeNodesInserted(TreeModelEvent treeModelEvent) {
        if (this.treeModelListeners != null) {
            Vector vector = this.treeModelListeners;
            int n = vector.size();
            for (int i = 0; i < n; ++i) {
                ((TreeModelListener)vector.elementAt(i)).treeNodesInserted(treeModelEvent);
            }
        }
    }

    protected void fireTreeNodesRemoved(TreeModelEvent treeModelEvent) {
        if (this.treeModelListeners != null) {
            Vector vector = this.treeModelListeners;
            int n = vector.size();
            for (int i = 0; i < n; ++i) {
                ((TreeModelListener)vector.elementAt(i)).treeNodesRemoved(treeModelEvent);
            }
        }
    }

    protected void fireTreeStructureChanged(TreeModelEvent treeModelEvent) {
        if (this.treeModelListeners != null) {
            Vector vector = this.treeModelListeners;
            int n = vector.size();
            for (int i = 0; i < n; ++i) {
                ((TreeModelListener)vector.elementAt(i)).treeStructureChanged(treeModelEvent);
            }
        }
    }

    public void run() {
        try {
            PdfDictionary pdfDictionary = this.reader.getCatalog();
            PdfDictionary pdfDictionary2 = (PdfDictionary)PdfReader.getPdfObject(pdfDictionary.get(PdfName.PAGES));
            SimpletextTreeNode simpletextTreeNode = new SimpletextTreeNode("Pagetree " + pdfDictionary2);
            this.filenode.add(simpletextTreeNode);
            this.iteratePages(pdfDictionary2, this.reader, simpletextTreeNode);
            PdfDictionary pdfDictionary3 = (PdfDictionary)PdfReader.getPdfObject(pdfDictionary.get(PdfName.OUTLINES));
            if (pdfDictionary3 != null) {
                PdfDictionary pdfDictionary4;
                SimpletextTreeNode simpletextTreeNode2 = new SimpletextTreeNode("Outlinetree " + pdfDictionary3);
                this.filenode.add(simpletextTreeNode2);
                PdfObject pdfObject = pdfDictionary3.get(PdfName.FIRST);
                if (pdfObject != null && (pdfDictionary4 = (PdfDictionary)PdfReader.getPdfObject((PRIndirectReference)pdfObject)) != null) {
                    this.iterateOutlines(pdfDictionary4, this.reader, simpletextTreeNode2);
                }
            }
            System.out.println(" Pagecount= " + this.pagecount);
            this.progressdialog.setVisible(false);
        }
        catch (Exception exception) {
            exception.printStackTrace(System.out);
        }
    }

    public int getPagecount() {
        return this.pagecount;
    }

    public void updatecount() {
        this.progressdialog.setAktuelleseite(this.getPagecount());
    }
}

