import processing.core.*; import controlP5.*; import processing.dxf.*; import processing.pdf.*; import java.applet.*; import java.awt.*; import java.awt.image.*; import java.awt.event.*; import java.io.*; import java.net.*; import java.text.*; import java.util.*; import java.util.zip.*; import javax.sound.midi.*; import javax.sound.midi.spi.*; import javax.sound.sampled.*; import javax.sound.sampled.spi.*; import java.util.regex.*; import javax.xml.parsers.*; import javax.xml.transform.*; import javax.xml.transform.dom.*; import javax.xml.transform.sax.*; import javax.xml.transform.stream.*; import org.xml.sax.*; import org.xml.sax.ext.*; import org.xml.sax.helpers.*; public class fractralGIK_4 extends PApplet {/**
 * GIK (Great Invention Kit, or Grace Gershenfeld's Invention Kit) 
 * Module Maker
 * Inspired from GIK on Wikipedia
 * http://en.wikipedia.org/wiki/GIK 
 **/
 
 
 //For Processing 0133 Beta
 




ControlP5 controlP5;

float thickness = 5;
float edge = 50;
boolean record;

//rectangles
float ax = 100;
float ay = 150;

float bx = 250;
float by = 150;

float cx = 400;
float cy = 150;

float dx = 400;
float dy = 150;

//circles
float ex = 100;
float ey = 300;

float fx = 250;
float fy = 300;

float gx = 400;
float gy = 300;

float hx = 400;
float hy = 300;

//triangles


float ix = 100;
float iy = 450;

float jx = 250;
float jy = 450;

float kx = 400;
float ky = 450;

float lx = 400;
float ly = 450;

 public void setup() 
{ 
size(600, 600);
  controlP5 = new ControlP5(this);
  // add a vertical slider
  controlP5.addSlider("thickness",0,25,5,25,60,100,10);
  controlP5.addSlider("edge",0,80,80,25,50,100,10);

}

public void draw()
{
  if (record) {
    println("start");
 //      beginRecord(PDF, "Line.pdf"); 
         beginRecord(PDF, second()+"_"+minute()+"_"+hour()+"_"+day()+"_"+month()+"_"+year()+"_"+"GIK_Kit.pdf"); 
  }


  // do all your drawing here

smooth(); 
background(0);

PFont font;
// The font must be located in the sketch's 
// "data" directory to load successfully
font = loadFont("Tahoma-16.vlw"); 
textFont(font); fill(255);
text("GIK-Kits Constructer", 25, 30); 
text("Sheet Width=550, Height=450", 350,520);
text("Press [r] to Save PDF", 350,550);

noFill();
stroke(255);

rect(25,80,550,450);


// Rectangles

// Shape-A
// 1/4
line(ax,ay-edge/4, ax-thickness/2, ay-edge/4);
line(ax-thickness/2, ay-edge/4, ax-thickness/2, ay-edge/2);
line(ax-thickness/2, ay-edge/2, ax-edge/2, ay-edge/2);
line(ax-edge/2, ay-edge/2, ax-edge/2, ay-thickness/2);
line(ax-edge/2, ay-thickness/2,ax-edge/4, ay-thickness/2);
line(ax-edge/4, ay-thickness/2, ax-edge/4, ay);
// 1/4
line(ax,ay+edge/4, ax-thickness/2, ay+edge/4);
line(ax-thickness/2, ay+edge/4, ax-thickness/2, ay+edge/2);
line(ax-thickness/2, ay+edge/2, ax-edge/2, ay+edge/2);
line(ax-edge/2, ay+edge/2, ax-edge/2, ay+thickness/2);
line(ax-edge/2, ay+thickness/2,ax-edge/4, ay+thickness/2);
line(ax-edge/4, ay+thickness/2, ax-edge/4, ay);
// 1/4
line(ax,ay-edge/4, ax+thickness/2, ay-edge/4);
line(ax+thickness/2, ay-edge/4, ax+thickness/2, ay-edge/2);
line(ax+thickness/2, ay-edge/2, ax+edge/2, ay-edge/2);
line(ax+edge/2, ay-edge/2, ax+edge/2, ay-thickness/2);
line(ax+edge/2, ay-thickness/2,ax+edge/4, ay-thickness/2);
line(ax+edge/4, ay-thickness/2, ax+edge/4, ay);
// 1/4
line(ax,ay+edge/4, ax+thickness/2, ay+edge/4);
line(ax+thickness/2, ay+edge/4, ax+thickness/2, ay+edge/2);
line(ax+thickness/2, ay+edge/2, ax+edge/2, ay+edge/2);
line(ax+edge/2, ay+edge/2, ax+edge/2, ay+thickness/2);
line(ax+edge/2, ay+thickness/2,ax+edge/4, ay+thickness/2);
line(ax+edge/4, ay+thickness/2, ax+edge/4, ay);

// Shape-B
// 1/4
line(bx,by-edge/4, bx-thickness/2, by-edge/4);
line(bx-thickness/2, by-edge/4, bx-thickness/2, by-edge/2);
line(bx-thickness/2, by-edge/2, bx-edge/2, by-edge/2);
line(bx-edge/2, by-edge/2, bx-edge/2, by-thickness/2);
line(bx-edge/2, by-thickness/2, bx, by-thickness/2);
line(bx, by-thickness/2, bx, by);
// 1/4
line(bx,by+edge/4, bx-thickness/2, by+edge/4);
line(bx-thickness/2, by+edge/4, bx-thickness/2, by+edge/2);
line(bx-thickness/2, by+edge/2, bx-edge/2, by+edge/2);
line(bx-edge/2, by+edge/2, bx-edge/2, by+thickness/2);
line(bx-edge/2, by+thickness/2, bx, by+thickness/2);
line(bx, by+thickness/2, bx, by);
// 1/4
line(bx,by-edge/4, bx+thickness/2, by-edge/4);
line(bx+thickness/2, by-edge/4, bx+thickness/2, by-edge/2);
line(bx+thickness/2, by-edge/2, bx+edge/2, by-edge/2);
line(bx+edge/2, by-edge/2, bx+edge/2, by-thickness/2);
line(bx+edge/2, by-thickness/2, bx+edge/4, by-thickness/2);
line(bx+edge/4, by-thickness/2, bx+edge/4, by);
// 1/4
line(bx,by+edge/4, bx+thickness/2, by+edge/4);
line(bx+thickness/2, by+edge/4, bx+thickness/2, by+edge/2);
line(bx+thickness/2, by+edge/2, bx+edge/2, by+edge/2);
line(bx+edge/2, by+edge/2, bx+edge/2, by+thickness/2);
line(bx+edge/2, by+thickness/2,bx+edge/4, by+thickness/2);
line(bx+edge/4, by+thickness/2, bx+edge/4, by);


// Shape-C
// 1/4
line(cx,cy-edge/4, cx-thickness/2, cy-edge/4);
line(cx-thickness/2, cy-edge/4, cx-thickness/2, cy-edge/2);
line(cx-thickness/2, cy-edge/2, cx-edge/2, cy-edge/2);
line(cx-edge/2, cy-edge/2, cx-edge/2, cy-thickness/2);
line(cx-edge/2, cy-thickness/2, cx-edge/4, cy-thickness/2);
line(cx-edge/4, cy-thickness/2, cx-edge/4, cy);
// 1/4
line(cx, cy+edge/4, cx-thickness/2, cy+edge/4);
line(cx-thickness/2, cy+edge/4, cx-thickness/2, cy+edge/2);
line(cx-thickness/2, cy+edge/2, cx-edge/2, cy+edge/2);
line(cx-edge/2, cy+edge/2, cx-edge/2, cy+thickness/2);
line(cx-edge/2, cy+thickness/2, cx-edge/4, cy+thickness/2);
line(cx-edge/4, cy+thickness/2, cx-edge/4, cy);
// 1/4
line(cx, cy-edge/4, cx+thickness/2, cy-edge/4);
line(cx+thickness/2, cy-edge/4, cx+thickness/2, cy-edge/2);
line(cx+thickness/2, cy-edge/2, cx+edge/2, cy-edge/2);
// 1/4
line(cx, cy+edge/4, cx+thickness/2, cy+edge/4);
line(cx+thickness/2, cy+edge/4, cx+thickness/2, cy+edge/2);
line(cx+thickness/2, cy+edge/2, cx+edge/2, cy+edge/2);

dx= cx+ edge;

// 1/4
line(dx,dy-edge/4, dx-thickness/2, dy-edge/4);
line(dx-thickness/2, dy-edge/4, dx-thickness/2, dy-edge/2);
line(dx-thickness/2, dy-edge/2, dx-edge/2, dy-edge/2);

// 1/4
line(dx,dy+edge/4, dx-thickness/2, dy+edge/4);
line(dx-thickness/2, dy+edge/4, dx-thickness/2, dy+edge/2);
line(dx-thickness/2, dy+edge/2, dx-edge/2, dy+edge/2);

// 1/4
line(dx,dy-edge/4, dx+thickness/2, dy-edge/4);
line(dx+thickness/2, dy-edge/4, dx+thickness/2, dy-edge/2);
line(dx+thickness/2, dy-edge/2, dx+edge/2, dy-edge/2);
line(dx+edge/2, dy-edge/2, dx+edge/2, dy-thickness/2);
line(dx+edge/2, dy-thickness/2, dx+edge/4, dy-thickness/2);
line(dx+edge/4, dy-thickness/2, dx+edge/4, dy);
// 1/4
line(dx,dy+edge/4, dx+thickness/2, dy+edge/4);
line(dx+thickness/2, dy+edge/4, dx+thickness/2, dy+edge/2);
line(dx+thickness/2, dy+edge/2, dx+edge/2, dy+edge/2);
line(dx+edge/2, dy+edge/2, dx+edge/2, dy+thickness/2);
line(dx+edge/2, dy+thickness/2, dx+edge/4, dy+thickness/2);
line(dx+edge/4, dy+thickness/2, dx+edge/4, dy);

////////////////////////////////////////////////////////////////////////////

// Circles

// Shape-A
// 1/4
line(ex,ey-edge/4, ex-thickness/2, ey-edge/4);
line(ex-thickness/2, ey-edge/4, ex-thickness/2, ey-edge/2);
arc(ex,ey,edge,edge,PI+atan(thickness/edge),3*PI/2-atan(thickness/edge));
line(ex-edge/2, ey-thickness/2, ex-edge/4, ey-thickness/2);
line(ex-edge/4, ey-thickness/2, ex-edge/4, ey);
// 1/4
line(ex,ey+edge/4,   ex-thickness/2, ey+edge/4);
line(ex-thickness/2, ey+edge/4, ex-thickness/2, ey+edge/2);
arc(ex,ey,edge,edge,PI/2+atan(thickness/edge),PI-atan(thickness/edge));
line(ex-edge/2, ey+thickness/2, ex-edge/4, ey+thickness/2);
line(ex-edge/4, ey+thickness/2, ex-edge/4, ey);
// 1/4
line(ex,ey-edge/4, ex+thickness/2, ey-edge/4);
line(ex+thickness/2, ey-edge/4, ex+thickness/2, ey-edge/2);
arc(ex,ey,edge,edge,3*PI/2+atan(thickness/edge),2*PI-atan(thickness/edge));
line(ex+edge/2, ey-thickness/2, ex+edge/4, ey-thickness/2);
line(ex+edge/4, ey-thickness/2, ex+edge/4, ey);
// 1/4
line(ex, ey+edge/4, ex+thickness/2, ey+edge/4);
line(ex+thickness/2, ey+edge/4, ex+thickness/2, ey+edge/2);
arc(ex,ey,edge,edge,0+atan(thickness/edge),PI/2-atan(thickness/edge));
line(ex+edge/2, ey+thickness/2, ex+edge/4, ey+thickness/2);
line(ex+edge/4, ey+thickness/2, ex+edge/4, ey);

// Shape-B
// 1/4
line(fx,fy-edge/4, fx-thickness/2, fy-edge/4);
line(fx-thickness/2, fy-edge/4, fx-thickness/2, fy-edge/2);
arc(fx,fy,edge,edge,PI+atan(thickness/edge),3*PI/2-atan(thickness/edge));
line(fx-edge/2, fy-thickness/2, fx, fy-thickness/2);
line(fx, fy-thickness/2, fx, fy);
// 1/4
line(fx,fy+edge/4, fx-thickness/2, fy+edge/4);
line(fx-thickness/2, fy+edge/4, fx-thickness/2, fy+edge/2);
arc(fx,fy,edge,edge,PI/2+atan(thickness/edge),PI-atan(thickness/edge));
line(fx-edge/2, fy+thickness/2, fx, fy+thickness/2);
line(fx, fy+thickness/2, fx, fy);
// 1/4
line(fx,fy-edge/4, fx+thickness/2, fy-edge/4);
line(fx+thickness/2, fy-edge/4, fx+thickness/2, fy-edge/2);
arc(fx,fy,edge,edge,3*PI/2+atan(thickness/edge),2*PI-atan(thickness/edge));
line(fx+edge/2, fy-thickness/2, fx+edge/4, fy-thickness/2);
line(fx+edge/4, fy-thickness/2, fx+edge/4, fy);
// 1/4
line(fx, fy+edge/4, fx+thickness/2, fy+edge/4);
line(fx+thickness/2, fy+edge/4, fx+thickness/2, fy+edge/2);
arc(fx,fy,edge,edge,0+atan(thickness/edge),PI/2-atan(thickness/edge));
line(fx+edge/2, fy+thickness/2, fx+edge/4, fy+thickness/2);
line(fx+edge/4, fy+thickness/2, fx+edge/4, fy);



////////////////////////////////////////////////////////////////////////////

// Triangles

/// a 
line(ix+cos(PI*5/6)*edge/4,iy-sin(PI*5/6)*edge/4,ix+cos(PI*5/6)*edge/4+cos(PI*4/3)*thickness/2,iy-sin(PI*5/6)*edge/4-sin(PI*4/3)*thickness/2);
line(ix+cos(PI*5/6)*edge/4+cos(PI*4/3)*thickness/2,iy-sin(PI*5/6)*edge/4-sin(PI*4/3)*thickness/2,ix+cos(PI*5/6)*edge/2+cos(PI*4/3)*thickness/2,iy-sin(PI*5/6)*edge/2-sin(PI*4/3)*thickness/2);
line(ix+cos(PI*5/6)*edge/2+cos(PI*4/3)*thickness/2,iy-sin(PI*5/6)*edge/2-sin(PI*4/3)*thickness/2,ix+cos(PI*7/6)*edge, iy-sin(PI*7/6)*edge);
line(ix+cos(PI*7/6)*edge, iy-sin(PI*7/6)*edge, ix+cos(PI*9/6)*edge/2+cos(PI)*thickness/2,iy-sin(PI*9/6)*edge/2-sin(PI)*thickness/2);
line(ix+cos(PI*9/6)*edge/2+cos(PI)*thickness/2,iy-sin(PI*9/6)*edge/2-sin(PI)*thickness/2,ix+cos(PI*9/6)*edge/4+cos(PI)*thickness/2,iy-sin(PI*9/6)*edge/4-sin(PI)*thickness/2);
line(ix+cos(PI*9/6)*edge/4+cos(PI)*thickness/2,iy-sin(PI*9/6)*edge/4-sin(PI)*thickness/2,ix+cos(PI*9/6)*edge/4,iy-sin(PI*9/6)*edge/4);


line(ix+cos(PI*1/6)*edge/4,iy-sin(PI*1/6)*edge/4,ix+cos(PI*1/6)*edge/4+cos(PI*10/6)*thickness/2,iy-sin(PI*1/6)*edge/4-sin(PI*10/6)*thickness/2);
line(ix+cos(PI*1/6)*edge/4+cos(PI*10/6)*thickness/2,iy-sin(PI*1/6)*edge/4-sin(PI*10/6)*thickness/2,ix+cos(PI*1/6)*edge/2+cos(PI*10/6)*thickness/2,iy-sin(PI*1/6)*edge/2-sin(PI*10/6)*thickness/2);
line(ix+cos(PI*1/6)*edge/2+cos(PI*10/6)*thickness/2,iy-sin(PI*1/6)*edge/2-sin(PI*10/6)*thickness/2,ix+cos(PI*11/6)*edge, iy-sin(PI*11/6)*edge);
line(ix+cos(PI*11/6)*edge, iy-sin(PI*11/6)*edge, ix-cos(PI*9/6)*edge/2-cos(PI)*thickness/2,iy-sin(PI*9/6)*edge/2-sin(PI)*thickness/2);
line(ix-cos(PI*9/6)*edge/2-cos(PI)*thickness/2,iy-sin(PI*9/6)*edge/2-sin(PI)*thickness/2,ix-cos(PI*9/6)*edge/4-cos(PI)*thickness/2,iy-sin(PI*9/6)*edge/4-sin(PI)*thickness/2);
line(ix-cos(PI*9/6)*edge/4-cos(PI)*thickness/2,iy-sin(PI*9/6)*edge/4-sin(PI)*thickness/2,ix-cos(PI*9/6)*edge/4,iy-sin(PI*9/6)*edge/4);

line(ix+cos(PI*5/6)*edge/4,iy-sin(PI*5/6)*edge/4,ix+cos(PI*5/6)*edge/4-cos(PI*4/3)*thickness/2,iy-sin(PI*5/6)*edge/4+sin(PI*4/3)*thickness/2);
line(ix+cos(PI*5/6)*edge/4-cos(PI*4/3)*thickness/2,iy-sin(PI*5/6)*edge/4+sin(PI*4/3)*thickness/2,ix+cos(PI*5/6)*edge/2-cos(PI*4/3)*thickness/2,iy-sin(PI*5/6)*edge/2+sin(PI*4/3)*thickness/2);
line(ix+cos(PI*5/6)*edge/2-cos(PI*4/3)*thickness/2,iy-sin(PI*5/6)*edge/2+sin(PI*4/3)*thickness/2,ix+cos(PI*1/2)*edge, iy-sin(PI*1/2)*edge);
line(ix-cos(PI*5/6)*edge/4,iy-sin(PI*5/6)*edge/4,ix-cos(PI*5/6)*edge/4+cos(PI*4/3)*thickness/2,iy-sin(PI*5/6)*edge/4+sin(PI*4/3)*thickness/2);
line(ix-cos(PI*5/6)*edge/4+cos(PI*4/3)*thickness/2,iy-sin(PI*5/6)*edge/4+sin(PI*4/3)*thickness/2,ix-cos(PI*5/6)*edge/2+cos(PI*4/3)*thickness/2,iy-sin(PI*5/6)*edge/2+sin(PI*4/3)*thickness/2);
line(ix-cos(PI*5/6)*edge/2+cos(PI*4/3)*thickness/2,iy-sin(PI*5/6)*edge/2+sin(PI*4/3)*thickness/2,ix-cos(PI*1/2)*edge, iy-sin(PI*1/2)*edge);


/// b 
line(jx+cos(PI*5/6)*edge/4,jy-sin(PI*5/6)*edge/4,jx+cos(PI*5/6)*edge/4+cos(PI*4/3)*thickness/2,jy-sin(PI*5/6)*edge/4-sin(PI*4/3)*thickness/2);
line(jx+cos(PI*5/6)*edge/4+cos(PI*4/3)*thickness/2,jy-sin(PI*5/6)*edge/4-sin(PI*4/3)*thickness/2,jx+cos(PI*5/6)*edge/2+cos(PI*4/3)*thickness/2,jy-sin(PI*5/6)*edge/2-sin(PI*4/3)*thickness/2);
line(jx+cos(PI*5/6)*edge/2+cos(PI*4/3)*thickness/2,jy-sin(PI*5/6)*edge/2-sin(PI*4/3)*thickness/2,jx+cos(PI*7/6)*edge, jy-sin(PI*7/6)*edge);
line(jx+cos(PI*7/6)*edge, jy-sin(PI*7/6)*edge, jx+cos(PI*9/6)*edge/2+cos(PI)*thickness/2,jy-sin(PI*9/6)*edge/2-sin(PI)*thickness/2);
line(jx+cos(PI*9/6)*edge/2+cos(PI)*thickness/2,jy-sin(PI*9/6)*edge/2-sin(PI)*thickness/2,jx+cos(PI*9/6)*edge/4+cos(PI)*thickness/2,jy-sin(PI*9/6)*edge/4-sin(PI)*thickness/2);
line(jx+cos(PI*9/6)*edge/4+cos(PI)*thickness/2,jy-sin(PI*9/6)*edge/4-sin(PI)*thickness/2,jx+cos(PI*9/6)*edge/4,jy-sin(PI*9/6)*edge/4);


line(jx,jy,jx+cos(PI*10/6)*thickness/2,jy-sin(PI*10/6)*thickness/2);
line(jx+cos(PI*10/6)*thickness/2,jy-sin(PI*10/6)*thickness/2,jx+cos(PI*1/6)*edge/2+cos(PI*10/6)*thickness/2,jy-sin(PI*1/6)*edge/2-sin(PI*10/6)*thickness/2);
line(jx+cos(PI*1/6)*edge/2+cos(PI*10/6)*thickness/2,jy-sin(PI*1/6)*edge/2-sin(PI*10/6)*thickness/2,jx+cos(PI*11/6)*edge, jy-sin(PI*11/6)*edge);
line(jx+cos(PI*11/6)*edge, jy-sin(PI*11/6)*edge, jx-cos(PI*9/6)*edge/2-cos(PI)*thickness/2,jy-sin(PI*9/6)*edge/2-sin(PI)*thickness/2);
line(jx-cos(PI*9/6)*edge/2-cos(PI)*thickness/2,jy-sin(PI*9/6)*edge/2-sin(PI)*thickness/2,jx-cos(PI*9/6)*edge/4-cos(PI)*thickness/2,jy-sin(PI*9/6)*edge/4-sin(PI)*thickness/2);
line(jx-cos(PI*9/6)*edge/4-cos(PI)*thickness/2,jy-sin(PI*9/6)*edge/4-sin(PI)*thickness/2,jx-cos(PI*9/6)*edge/4,jy-sin(PI*9/6)*edge/4);

line(jx+cos(PI*5/6)*edge/4,jy-sin(PI*5/6)*edge/4,jx+cos(PI*5/6)*edge/4-cos(PI*4/3)*thickness/2,jy-sin(PI*5/6)*edge/4+sin(PI*4/3)*thickness/2);
line(jx+cos(PI*5/6)*edge/4-cos(PI*4/3)*thickness/2,jy-sin(PI*5/6)*edge/4+sin(PI*4/3)*thickness/2,jx+cos(PI*5/6)*edge/2-cos(PI*4/3)*thickness/2,jy-sin(PI*5/6)*edge/2+sin(PI*4/3)*thickness/2);
line(jx+cos(PI*5/6)*edge/2-cos(PI*4/3)*thickness/2,jy-sin(PI*5/6)*edge/2+sin(PI*4/3)*thickness/2,jx+cos(PI*1/2)*edge, jy-sin(PI*1/2)*edge);
//line(jx-cos(PI*5/6)*edge/4,jy-sin(PI*5/6)*edge/4,jx-cos(PI*5/6)*edge/4+cos(PI*4/3)*thickness/2,jy-sin(PI*5/6)*edge/4+sin(PI*4/3)*thickness/2);
line(jx,jy,jx+cos(PI*4/3)*thickness/2,jy+sin(PI*4/3)*thickness/2);
//line(jx-cos(PI*5/6)*edge/4+cos(PI*4/3)*thickness/2,jy-sin(PI*5/6)*edge/4+sin(PI*4/3)*thickness/2,jx-cos(PI*5/6)*edge/2+cos(PI*4/3)*thickness/2,jy-sin(PI*5/6)*edge/2+sin(PI*4/3)*thickness/2);
line(jx+cos(PI*4/3)*thickness/2,jy+sin(PI*4/3)*thickness/2,jx-cos(PI*5/6)*edge/2+cos(PI*4/3)*thickness/2,jy-sin(PI*5/6)*edge/2+sin(PI*4/3)*thickness/2);
line(jx-cos(PI*5/6)*edge/2+cos(PI*4/3)*thickness/2,jy-sin(PI*5/6)*edge/2+sin(PI*4/3)*thickness/2,jx-cos(PI*1/2)*edge, jy-sin(PI*1/2)*edge);

 if (record) {
    endRecord();
    record = false;
      println("end");
  }

}


public void keyPressed() {
  // use a key press so that it doesn't make a million files
  if (key == 'r') record = true;
}




  static public void main(String args[]) {     PApplet.main(new String[] { "fractralGIK_4" });  }}