/*
 * Decompiled with CFR 0.152.
 */
package org.boxed_economy.cen.relationview.canvas;

import java.awt.Font;
import java.awt.Graphics;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.boxed_economy.besp.model.fmfw.Agent;
import org.boxed_economy.besp.model.fmfw.RelationType;
import org.boxed_economy.besp.model.fmfw.World;
import org.boxed_economy.besp.presentation.bface.typeselector.TypeSelection;
import org.boxed_economy.cen.relationview.canvas.AbstractRelationViewCanvas;
import org.boxed_economy.cen.relationviewer.model.AgentNode;

public class LinearGraphCanvas
extends AbstractRelationViewCanvas {
    private static final int CHAR_WIDTH = 6;
    private static final int CHAR_HEIGHT = 6;
    private static final int GRAPH_LABEL_CHAR_WIDTH = 16;
    private static final int GRAPH_LABEL_CHAR_HEIGHT = 16;
    private int margin = 50;
    List graphDataList = new ArrayList();
    int agentNumMax;
    int relationNumMax;
    int graphWidth = 0;
    int graphHeight = 0;
    private World world = null;

    public LinearGraphCanvas(TypeSelection agentTypes, TypeSelection relationTypes) {
        super(agentTypes, relationTypes);
    }

    protected void layoutNodes() {
        this.updateGraphData();
        this.removeAllAgentNodes(new ArrayList(super.getOrderedAllNodes()));
    }

    private void updateGraphData() {
        this.graphDataList.clear();
        ArrayList nodes = new ArrayList(super.getOrderedAllNodes());
        this.agentNumMax = nodes.size();
        Iterator i = nodes.iterator();
        int agentCount = -1;
        while (i.hasNext()) {
            ++agentCount;
            int relationNum = 0;
            Agent agent = ((AgentNode)i.next()).getAgent();
            Iterator j = this.getRelationTypeSelection().getSelectedTypes().iterator();
            while (j.hasNext()) {
                if ((relationNum += agent.getRelations((RelationType)j.next()).size()) <= this.relationNumMax) continue;
                this.relationNumMax = relationNum;
            }
            this.graphDataList.add(new Integer(relationNum));
        }
        this.agentNumMax = agentCount;
        Collections.sort(this.graphDataList);
        Collections.reverse(this.graphDataList);
    }

    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        this.graphWidth = this.getWidth() - this.margin * 2;
        this.graphHeight = this.getHeight() - this.margin * 2;
        g.drawLine(this.margin, this.getHeight() - this.margin, this.getWidth() - this.margin + this.margin / 2, this.getHeight() - this.margin);
        g.drawLine(this.margin, this.margin, this.margin, this.getHeight() - this.margin);
        g.setFont(new Font("Helvetica", 0, 16));
        g.drawString("Ranking", this.margin + this.graphWidth / 2 - 16, this.margin + this.graphHeight + 40);
        g.drawString("Link", 10, (int)((double)this.margin / 1.7));
        if (this.graphDataList.size() > 0) {
            int XCount = this.agentNumMax;
            int YCount = this.relationNumMax;
            double xScale = (double)this.graphWidth / (double)XCount;
            double yScale = (double)this.graphHeight / (double)YCount;
            int i = 0;
            while (i <= XCount) {
                if (i % (this.calculateMaxModified(XCount) / 10) == 0) {
                    g.drawString("" + i, this.margin + (int)(xScale * (double)i), this.getHeight() - this.margin + 16 + 3);
                }
                ++i;
            }
            i = 0;
            while (i <= YCount) {
                if (i % (this.calculateMaxModified(YCount) / 10) == 0) {
                    g.drawString("" + i, this.margin - 32, this.getHeight() - this.margin - (int)(yScale * (double)i));
                }
                ++i;
            }
            Iterator i2 = this.graphDataList.iterator();
            int x = 0;
            while (i2.hasNext()) {
                double y = ((Integer)i2.next()).intValue();
                int plotX = this.margin + (int)(xScale * (double)(++x));
                int plotY = this.getHeight() - this.margin - (int)(yScale * y);
                g.fillOval(plotX, plotY, 5, 5);
            }
        }
    }

    private int calculateMax(int max) {
        int count = 0;
        while (Math.pow(10.0, count) < (double)max) {
            if (++count > 10) break;
        }
        return count;
    }

    private int calculateMaxModified(int max) {
        int count = 0;
        while (Math.pow(10.0, count) < (double)max) {
            if (++count > 10) break;
        }
        return (int)Math.pow(10.0, count);
    }

    private void removeAllAgentNodes(List nodes) {
        Iterator i = nodes.iterator();
        while (i.hasNext()) {
            this.removeAgentNode(((AgentNode)i.next()).getAgent());
        }
    }
}

