/*
 * Decompiled with CFR 0.152.
 */
package org.boxed_economy.cen.relationviewer;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridLayout;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import org.boxed_economy.besp.model.ModelContainerEvent;
import org.boxed_economy.besp.model.ModelContainerListener;
import org.boxed_economy.besp.model.SimulationStateEvent;
import org.boxed_economy.besp.model.SimulationStateListener;
import org.boxed_economy.besp.model.fmfw.update.UpdateClockEvent;
import org.boxed_economy.besp.model.fmfw.update.UpdateClockListener;
import org.boxed_economy.besp.presentation.bface.typeselector.TypeSelection;
import org.boxed_economy.besp.presentation.bface.typeselector.TypeSelectionPanel;
import org.boxed_economy.besp.presentation.bface.typeselector.UpdateTypeSelectionListener;
import org.boxed_economy.besp.presentation.guifw.AbstractInternalFrameComponent;
import org.boxed_economy.cen.relationview.canvas.AbstractRelationViewCanvas;
import org.boxed_economy.cen.relationview.canvas.CircleRelationViewCanvas;
import org.boxed_economy.cen.relationview.canvas.CollaborationGraphCanvas;
import org.boxed_economy.cen.relationview.canvas.DistributionRelationViewCanvas;
import org.boxed_economy.cen.relationview.canvas.LayerRelationViewCanvas;
import org.boxed_economy.cen.relationview.canvas.LinearGraphCanvas;
import org.boxed_economy.cen.relationview.canvas.RandomRelationViewCanvas;

public class RelationViewer
extends AbstractInternalFrameComponent
implements ModelContainerListener,
UpdateClockListener,
UpdateTypeSelectionListener,
SimulationStateListener {
    private JTabbedPane tabbedPane = new JTabbedPane();
    private List canvases = new ArrayList();
    private TypeSelectionPanel agentTypeSelection = null;
    private TypeSelectionPanel relationTypeSelection = null;

    public void initialize() {
        this.initializeComponents();
        this.addUpdateClockListener(this);
    }

    protected void initializeFrame() {
        super.initializeFrame();
        this.setTitle("Network Link Viewer");
    }

    private void initializeComponents() {
        this.getContentPane().setLayout(new BorderLayout());
        this.setSize(new Dimension(750, 400));
        JPanel selectionPanel = this.createTypeSelectionPanels();
        this.initializeCanvases();
        this.getContentPane().add((Component)selectionPanel, "West");
        this.getContentPane().add((Component)this.tabbedPane, "Center");
    }

    private JPanel createTypeSelectionPanels() {
        JPanel panel = new JPanel();
        panel.setLayout(new GridLayout(2, 0));
        Collection agentTypes = this.getPresentationContainer().getModelContainer().getAgentTypes();
        this.agentTypeSelection = new TypeSelectionPanel((Frame)this.getMainFrame(), new ArrayList(agentTypes), "AgentType");
        this.agentTypeSelection.addUpdateViewModelListener((UpdateTypeSelectionListener)this);
        Collection relationTypes = this.getPresentationContainer().getModelContainer().getRelationTypes();
        this.relationTypeSelection = new TypeSelectionPanel((Frame)this.getMainFrame(), new ArrayList(relationTypes), "RelationType");
        this.relationTypeSelection.addUpdateViewModelListener((UpdateTypeSelectionListener)this);
        panel.add((Component)this.agentTypeSelection);
        panel.add((Component)this.relationTypeSelection);
        return panel;
    }

    private void initializeCanvases() {
        DistributionRelationViewCanvas distribution = new DistributionRelationViewCanvas((TypeSelection)this.agentTypeSelection, (TypeSelection)this.relationTypeSelection);
        distribution.setEnabled(false);
        this.tabbedPane.add("\u60c5\u5831\u4f1d\u64ad", distribution);
        CircleRelationViewCanvas circle = new CircleRelationViewCanvas((TypeSelection)this.agentTypeSelection, (TypeSelection)this.relationTypeSelection);
        circle.setEnabled(false);
        this.tabbedPane.add("\u5186\u5f62\u914d\u7f6e", circle);
        LayerRelationViewCanvas layer = new LayerRelationViewCanvas((TypeSelection)this.agentTypeSelection, (TypeSelection)this.relationTypeSelection);
        layer.setEnabled(false);
        this.tabbedPane.add("\u30ec\u30a4\u30e4\u30fc\u914d\u7f6e", layer);
        RandomRelationViewCanvas random = new RandomRelationViewCanvas((TypeSelection)this.agentTypeSelection, (TypeSelection)this.relationTypeSelection);
        random.setEnabled(false);
        this.tabbedPane.add("\u30e9\u30f3\u30c0\u30e0\u914d\u7f6e", random);
        CollaborationGraphCanvas graph = new CollaborationGraphCanvas((TypeSelection)this.agentTypeSelection, (TypeSelection)this.relationTypeSelection);
        graph.setEnabled(false);
        this.tabbedPane.add("\u4e21\u5bfe\u6570\u30b0\u30e9\u30d5", graph);
        LinearGraphCanvas lgraph = new LinearGraphCanvas((TypeSelection)this.agentTypeSelection, (TypeSelection)this.relationTypeSelection);
        lgraph.setEnabled(false);
        this.tabbedPane.add("\u7dda\u5f62\u30b0\u30e9\u30d5", lgraph);
    }

    public void terminate() {
        this.removeUpdateClockListener(this);
    }

    public void prepareWorldClose(ModelContainerEvent ev) {
    }

    public void prepareWorldOpen(ModelContainerEvent ev) {
    }

    public void worldClosed(ModelContainerEvent ev) {
        Component[] components = this.tabbedPane.getComponents();
        int i = 0;
        while (i < components.length) {
            AbstractRelationViewCanvas canvas = (AbstractRelationViewCanvas)components[i];
            canvas.setEnabled(false);
            canvas.setWorld(null);
            ++i;
        }
    }

    public void worldOpened(ModelContainerEvent ev) {
        Component[] components = this.tabbedPane.getComponents();
        int i = 0;
        while (i < components.length) {
            AbstractRelationViewCanvas canvas = (AbstractRelationViewCanvas)components[i];
            canvas.setEnabled(true);
            canvas.setWorld(this.getWorld());
            ++i;
        }
    }

    public void viewModelUpdated() {
        Component[] components = this.tabbedPane.getComponents();
        int i = 0;
        while (i < components.length) {
            AbstractRelationViewCanvas canvas = (AbstractRelationViewCanvas)components[i];
            canvas.updateAll();
            ++i;
        }
    }

    public void clockGained(UpdateClockEvent e) {
        ((AbstractRelationViewCanvas)this.tabbedPane.getSelectedComponent()).updateAll();
    }

    public void simulationStarted(SimulationStateEvent ev) {
    }

    public void simulationStopped(SimulationStateEvent ev) {
    }

    public void simulationStopping(SimulationStateEvent ev) {
        this.repaint();
    }
}

