/*
 * Decompiled with CFR 0.152.
 */
package org.boxed_economy.cen.relationviewer.model;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import javax.swing.JPanel;
import org.boxed_economy.besp.model.fmfw.Agent;

public class AgentNode
extends JPanel {
    private static final Dimension DEFAULT_SIZE = new Dimension(10, 10);
    private static final Point DEFAULT_LABEL_LOCATION = new Point(10, 10);
    private Point labelLocation = DEFAULT_LABEL_LOCATION;
    private Agent agent = null;
    private Color color = Color.BLACK;

    public AgentNode(Agent agent) {
        this.agent = agent;
        this.initialize();
    }

    private void initialize() {
        this.setSize(DEFAULT_SIZE);
        this.addMouseMotionListener(new MouseMotionListener(){

            public void mouseMoved(MouseEvent e) {
            }

            public void mouseDragged(MouseEvent e) {
                int x = AgentNode.this.getX();
                int y = AgentNode.this.getY();
                int newX = x + (e.getX() - AgentNode.this.getWidth() / 2);
                int newY = y + (e.getY() - AgentNode.this.getHeight() / 2);
                AgentNode.this.setLocation(newX, newY);
                AgentNode.this.getParent().repaint();
            }
        });
    }

    protected void paintComponent(Graphics g) {
        g.setColor(this.color);
        g.fillOval(0, 0, this.getWidth(), this.getHeight());
    }

    public Point getCenter() {
        return new Point(this.getX() + this.getWidth() / 2, this.getY() + this.getHeight() / 2);
    }

    public Point getLeftUpper() {
        return new Point(this.getX(), this.getY());
    }

    public Point getLeftLower() {
        return new Point(this.getX(), this.getY() + this.getHeight());
    }

    public Point getRightUpper() {
        return new Point(this.getX() + this.getWidth(), this.getY());
    }

    public Point getRightLower() {
        return new Point(this.getX() + this.getWidth(), this.getY() + this.getHeight());
    }

    public Point getLabelLocation() {
        return this.labelLocation;
    }

    public void setLabelLocation(Point labelPoint) {
        this.labelLocation = labelPoint;
    }

    public Agent getAgent() {
        return this.agent;
    }

    public void setAgentColor(Color color) {
        this.color = color;
    }
}

