/*
 * Decompiled with CFR 0.152.
 */
package org.boxed_economy.evolvingnetwork;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.log4j.Logger;
import org.boxed_economy.besp.container.BESP;
import org.boxed_economy.besp.model.fmfw.Agent;
import org.boxed_economy.besp.model.fmfw.Clock;
import org.boxed_economy.besp.model.fmfw.Information;
import org.boxed_economy.besp.model.fmfw.RandomNumberGenerator;
import org.boxed_economy.besp.model.fmfw.World;
import org.boxed_economy.besp.model.fmfw.informations.DoubleInformation;
import org.boxed_economy.components.stepclock.StepClock;
import org.boxed_economy.evolvingnetwork.EvolvingNetworkModel;

public class EvolvingNetworkWorld
extends World {
    private static final long serialVersionUID = 1L;
    private static final Logger logger;
    private int bEHAVIOR_RandomOrganizer = 0;
    private int bEHAVIOR_PreferentialOrganizer = 1;
    private int bEHAVIOR_FitnessOrganizer = 0;
    private int pARAMETER_FirstNodesNum = 7;
    private int pARAMETER_OrganizerWaitingForTime = 15;
    private int pARAMETER_NodeCommunicationInterval = 10;
    private int bEHAVIOR_Communication = 0;
    private List organizers = new ArrayList();
    private List nodes = new ArrayList();
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.boxed_economy.evolvingnetwork.EvolvingNetworkWorld");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        $assertionsDisabled = !clazz.desiredAssertionStatus();
        Class<?> clazz2 = class$0;
        if (clazz2 == null) {
            try {
                clazz2 = class$0 = Class.forName("org.boxed_economy.evolvingnetwork.EvolvingNetworkWorld");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        logger = Logger.getLogger((String)clazz2.getName());
    }

    public static void main(String[] args) {
        String[] stringArray = new String[2];
        stringArray[0] = "-model";
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.boxed_economy.evolvingnetwork.EvolvingNetworkWorld");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        stringArray[1] = clazz.getName();
        BESP.main((String[])stringArray);
    }

    public void initializeWorld() {
        logger.info((Object)"Initialize World.");
        super.initializeWorld();
        this.setClock((Clock)new StepClock());
    }

    public void initializeAgents() {
        logger.info((Object)" Initialize Agents.");
        super.initializeAgents();
        this.createAgents();
        this.addRelations();
        this.initializeByHands();
    }

    private void initializeByHands() {
        Agent node;
        int i;
        Agent organizer = this.getAgent(EvolvingNetworkModel.AGENTTYPE_Organizer);
        List allnodes = (List)this.getAgents(EvolvingNetworkModel.AGENTTYPE_Node);
        if (this.getBEHAVIOR_RandomOrganizer() == 1) {
            organizer.addBehavior(EvolvingNetworkModel.BEHAVIORTYPE_RandomAttachBehavior);
        }
        if (this.getBEHAVIOR_PreferentialOrganizer() == 1) {
            organizer.addBehavior(EvolvingNetworkModel.BEHAVIORTYPE_PreferentialAttachBehavior);
        }
        if (this.getBEHAVIOR_FitnessOrganizer() == 1) {
            organizer.addBehavior(EvolvingNetworkModel.BEHAVIORTYPE_FitnessAttachBehavior);
            i = 0;
            while (i < allnodes.size()) {
                node = (Agent)allnodes.get(i);
                double fitness = this.getRandomNumberGenerator().generate();
                DoubleInformation fitnessInfo = new DoubleInformation(fitness);
                node.putInformation((Information)EvolvingNetworkModel.INFORMATIONTYPE_FitnessInformation, (Information)fitnessInfo);
                ++i;
            }
        }
        if (this.getBEHAVIOR_Communication() == 1) {
            organizer.addBehavior(EvolvingNetworkModel.BEHAVIORTYPE_StartingCommunicationBehavior);
            i = 0;
            while (i < allnodes.size()) {
                node = (Agent)allnodes.get(i);
                organizer.addRelation(EvolvingNetworkModel.RELATIONTYPE_OrganizingRelation, node);
                ++i;
            }
        }
    }

    private void createAgents() {
        logger.info((Object)"Create Agents.");
        this.createOrganizerAgent();
        this.createNodeAgents();
    }

    private void addRelations() {
        logger.info((Object)"Add Relations");
        this.addLinkRelations();
    }

    private void createNodeAgents() {
        logger.info((Object)"Create Node Agents");
        int i = 0;
        while (i < this.pARAMETER_FirstNodesNum) {
            this.createNodeAgent();
            ++i;
        }
    }

    private void createOrganizerAgent() {
        logger.info((Object)"Create Organizer Agent");
        Agent agentOrganizer = super.createAgent(EvolvingNetworkModel.AGENTTYPE_Organizer);
        this.organizers.add(agentOrganizer);
    }

    private void createNodeAgent() {
        logger.info((Object)"Create Node Agent");
        Agent agentNode = super.createAgent(EvolvingNetworkModel.AGENTTYPE_Node);
        agentNode.addBehavior(EvolvingNetworkModel.BEHAVIORTYPE_RandomCommunicateBehavior);
        this.nodes.add(agentNode);
    }

    private void addLinkRelations() {
        logger.info((Object)"add Link relations");
        ArrayList sourceAgents = new ArrayList(this.nodes);
        ArrayList targetAgents = new ArrayList(this.nodes);
        int i = 0;
        while (i < sourceAgents.size()) {
            Agent sourceAgent = (Agent)sourceAgents.get(i);
            int[] electedNumbers = this.generateElectedRandomNumbers("defaultRandom", 2, targetAgents.size(), targetAgents.indexOf(sourceAgent));
            int j = 0;
            while (j < targetAgents.size()) {
                Agent targetAgent = (Agent)targetAgents.get(j);
                if (this.isElectedNumber(electedNumbers, j)) {
                    sourceAgent.addRelation(EvolvingNetworkModel.RELATIONTYPE_Link, targetAgent);
                    targetAgent.addRelation(EvolvingNetworkModel.RELATIONTYPE_Link, sourceAgent);
                }
                ++j;
            }
            ++i;
        }
    }

    public String getName() {
        return "EvolvingNetworkWorld";
    }

    public String getDescription() {
        return "\u300c\u6210\u9577\u3059\u308b\u30cd\u30c3\u30c8\u30ef\u30fc\u30af\u300d\u306e\u30e2\u30c7\u30eb\u3092\u30b7\u30df\u30e5\u30ec\u30fc\u30c8\u3059\u308b\u30ef\u30fc\u30eb\u30c9\u3002" + System.getProperty("line.separator") + "" + System.getProperty("line.separator") + "\u6210\u9577\u3059\u308b\u969b\u306e3\u3064\u306e\u30a2\u30eb\u30b4\u30ea\u30ba\u30e0\u3001" + System.getProperty("line.separator") + "\u30e9\u30f3\u30c0\u30e0\u9078\u629e\u6210\u9577\u30e2\u30c7\u30eb\u3001" + System.getProperty("line.separator") + "\u512a\u5148\u7684\u9078\u629e\u6210\u9577\u30e2\u30c7\u30eb\u3001" + System.getProperty("line.separator") + "\u9069\u5fdc\u5ea6\u4ed8\u512a\u5148\u7684\u9078\u629e\u6210\u9577\u30e2\u30c7\u30eb\u306e\uff13\u3064\u3092\u30b7\u30df\u30e5\u30ec\u30fc\u30b7\u30e7\u30f3\u3059\u308b\u3053\u3068\u304c\u51fa\u6765\u307e\u3059\u3002" + System.getProperty("line.separator") + "" + System.getProperty("line.separator") + "\u30e9\u30f3\u30c0\u30e0\u9078\u629e\u6210\u9577\u30e2\u30c7\u30eb\u3068\u3001\u512a\u5148\u7684\u9078\u629e\u6210\u9577\u30e2\u30c7\u30eb\u306f\u3001" + System.getProperty("line.separator") + "\u300e\u65b0\u30cd\u30c3\u30c8\u30ef\u30fc\u30af\u601d\u8003\u300f\uff08\u30a2\u30eb\u30d0\u30fc\u30c8\u30fb\u30e9\u30ba\u30ed\u30fb\u30d0\u30e9\u30d0\u30b7\u3001NHK\u51fa\u7248\u3001\uff12\uff10\uff10\uff12)" + System.getProperty("line.separator") + "\u306e\u7b2c\uff15\uff5e7\u7ae0(\u7279\u306b7\u7ae0)\u3092\u53c2\u7167\u3057\u3066\u304f\u3060\u3055\u3044\u3002";
    }

    private double generateRandomNumberByDouble(String generatorName, double max, double minimum) {
        RandomNumberGenerator generator = super.getRandomNumberGenerator(generatorName);
        double randomNumber = generator.generate();
        double result = minimum + randomNumber * (max - minimum);
        return result;
    }

    private int generateRandomNumberByInt(String generatorName, int max, int minimum) {
        RandomNumberGenerator generator = super.getRandomNumberGenerator(generatorName);
        double randomNumber = generator.generate();
        int result = (int)((double)minimum + randomNumber * (double)(max - minimum));
        return result;
    }

    private long generateRandomNumberByLong(String generatorName, long max, long minimum) {
        RandomNumberGenerator generator = super.getRandomNumberGenerator(generatorName);
        double randomNumber = generator.generate();
        long result = (long)((double)minimum + randomNumber * (double)(max - minimum));
        return result;
    }

    private int[] generateElectedRandomNumbers(String generatorName, int number, int max, int excludedNumber) {
        if (!$assertionsDisabled && number >= max) {
            throw new AssertionError();
        }
        RandomNumberGenerator generator = super.getRandomNumberGenerator(generatorName);
        int[] electedNumbers = new int[number];
        Arrays.fill(electedNumbers, -1);
        int i = 0;
        while (i < number) {
            int generatedNumber;
            if (excludedNumber >= 0) {
                generatedNumber = generator.generate(max - 1);
                if (generatedNumber >= excludedNumber) {
                    ++generatedNumber;
                }
            } else {
                generatedNumber = generator.generate(max);
            }
            if (this.isElectedNumber(electedNumbers, generatedNumber)) {
                --i;
            } else {
                electedNumbers[i] = generatedNumber;
            }
            ++i;
        }
        return electedNumbers;
    }

    private boolean isElectedNumber(int[] electedNumbers, int target) {
        int[] copy = new int[electedNumbers.length];
        int i = 0;
        while (i < copy.length) {
            copy[i] = electedNumbers[i];
            ++i;
        }
        Arrays.sort(copy);
        int result = Arrays.binarySearch(copy, target);
        return result >= 0;
    }

    public int getBEHAVIOR_RandomOrganizer() {
        return this.bEHAVIOR_RandomOrganizer;
    }

    public void setBEHAVIOR_RandomOrganizer(int bEHAVIOR_RandomOrganizer) {
        this.bEHAVIOR_RandomOrganizer = bEHAVIOR_RandomOrganizer;
    }

    public String getBEHAVIOR_RandomOrganizerComment() {
        return "\u3053\u306e\u30d1\u30e9\u30e1\u30fc\u30bf\u30921\u306b\u3059\u308b\u3068Organizer\u304c\u30e9\u30f3\u30c0\u30e0\u9078\u629e\u3067\u30ce\u30fc\u30c9\u3092\u8ffd\u52a0\u3057\u3066\u3044\u304d\u307e\u3059\u3002";
    }

    public int getBEHAVIOR_PreferentialOrganizer() {
        return this.bEHAVIOR_PreferentialOrganizer;
    }

    public void setBEHAVIOR_PreferentialOrganizer(int bEHAVIOR_PreferentialOrganizer) {
        this.bEHAVIOR_PreferentialOrganizer = bEHAVIOR_PreferentialOrganizer;
    }

    public String getBEHAVIOR_PreferentialOrganizerComment() {
        return "\u3053\u306e\u30d1\u30e9\u30e1\u30fc\u30bf\u30921\u306b\u3059\u308b\u3068Organizer\u304c\u512a\u5148\u7684\u9078\u629e\u3067\u30ce\u30fc\u30c9\u3092\u8ffd\u52a0\u3057\u3066\u3044\u304d\u307e\u3059\u3002";
    }

    public int getBEHAVIOR_FitnessOrganizer() {
        return this.bEHAVIOR_FitnessOrganizer;
    }

    public void setBEHAVIOR_FitnessOrganizer(int bEHAVIOR_FitnessOrganizer) {
        this.bEHAVIOR_FitnessOrganizer = bEHAVIOR_FitnessOrganizer;
    }

    public String getBEHAVIOR_FitnessOrganizerComment() {
        return "\u3053\u306e\u30d1\u30e9\u30e1\u30fc\u30bf\u3092\uff11\u306b\u3059\u308b\u3068Organizer\u304c\u9069\u5fdc\u5ea6\u3092\u8003\u616e\u3057\u305f\u512a\u5148\u7684\u9078\u629e\u3067\u30ce\u30fc\u30c9\u3092\u8ffd\u52a0\u3057\u3066\u3044\u304d\u307e\u3059\u3002";
    }

    public int getPARAMETER_FirstNodesNum() {
        return this.pARAMETER_FirstNodesNum;
    }

    public void setPARAMETER_FirstNodesNum(int pARAMETER_FirstNodesNum) {
        this.pARAMETER_FirstNodesNum = pARAMETER_FirstNodesNum;
    }

    public String getPARAMETER_FirstNodesNumComment() {
        return "\u59cb\u3081\u306b\u4e16\u754c\u306b\u3044\u308bNode\u306e\u6570";
    }

    public int getPARAMETER_OrganizerWaitingForTime() {
        return this.pARAMETER_OrganizerWaitingForTime;
    }

    public void setPARAMETER_OrganizerWaitingForTime(int pARAMETER_OrganizerWaitingForTime) {
        this.pARAMETER_OrganizerWaitingForTime = pARAMETER_OrganizerWaitingForTime;
    }

    public String getPARAMETER_OrganizerWaitingForTimeComment() {
        return "\u3053\u306e\u30d1\u30e9\u30e1\u30fc\u30bf\u306e\u30b9\u30c6\u30c3\u30d7\u3060\u3051Organizer\u304c\u5f85\u3063\u3066\u304b\u3089\u30b3\u30df\u30e5\u30cb\u30b1\u30fc\u30b7\u30e7\u30f3\u3092\u59cb\u3081\u308b";
    }

    public int getPARAMETER_NodeCommunicationInterval() {
        return this.pARAMETER_NodeCommunicationInterval;
    }

    public void setPARAMETER_NodeCommunicationInterval(int pARAMETER_NodeCommunicationInterval) {
        this.pARAMETER_NodeCommunicationInterval = pARAMETER_NodeCommunicationInterval;
    }

    public String getPARAMETER_NodeCommunicationIntervalComment() {
        return "\u60c5\u5831\u3092\u3082\u3063\u305f\u30ce\u30fc\u30c9\u306f\u3053\u306e\u30d1\u30e9\u30e1\u30fc\u30bf\u306e\u30b9\u30c6\u30c3\u30d7\u304a\u304d\u306b\u4ed6\u306e\u30ce\u30fc\u30c9\u306b\u60c5\u5831\u3092\u9001\u308b";
    }

    public int getBEHAVIOR_Communication() {
        return this.bEHAVIOR_Communication;
    }

    public void setBEHAVIOR_Communication(int bEHAVIOR_Communication) {
        this.bEHAVIOR_Communication = bEHAVIOR_Communication;
    }

    public String getBEHAVIOR_CommunicationComment() {
        return "\u3053\u306e\u30d1\u30e9\u30e1\u30fc\u30bf\u30921\u306b\u3059\u308b\u3068\u30cd\u30c3\u30c8\u30ef\u30fc\u30af\u5f62\u6210\u3068\u3068\u3082\u306b\u60c5\u5831\u4f1d\u64ad\u3082\u884c\u3046";
    }
}

