/*
 * Decompiled with CFR 0.152.
 */
package org.boxed_economy.evolvingnetwork_behavior;

import java.util.ArrayList;
import java.util.List;
import org.boxed_economy.besp.model.fmfw.Agent;
import org.boxed_economy.besp.model.fmfw.Information;
import org.boxed_economy.besp.model.fmfw.RandomNumberGenerator;
import org.boxed_economy.besp.model.fmfw.informations.DoubleInformation;
import org.boxed_economy.evolvingnetwork.EvolvingNetworkModel;
import org.boxed_economy.evolvingnetwork_behavior.AbstractFitnessAttachBehavior;

public class FitnessAttachBehavior
extends AbstractFitnessAttachBehavior {
    protected void initialize() {
    }

    protected void terminate() {
    }

    protected void fitnessAttachAction() {
        List nodes = (List)this.getWorld().getAgents(EvolvingNetworkModel.AGENTTYPE_Node);
        List nodeFitnesses = this.colculateFitnessOfAllNodes(nodes);
        Agent node1 = this.selectByFitness(nodes, nodeFitnesses);
        Agent node2 = null;
        while (node1 == (node2 = this.selectByFitness(nodes, nodeFitnesses))) {
        }
        Agent newNode = this.createNewNode();
        newNode.addBehavior(EvolvingNetworkModel.BEHAVIORTYPE_RandomCommunicateBehavior);
        newNode.addRelation(EvolvingNetworkModel.RELATIONTYPE_Link, node1);
        node1.addRelation(EvolvingNetworkModel.RELATIONTYPE_Link, newNode);
        newNode.addRelation(EvolvingNetworkModel.RELATIONTYPE_Link, node2);
        node2.addRelation(EvolvingNetworkModel.RELATIONTYPE_Link, newNode);
    }

    private Agent selectByFitness(List nodes, List nodeFitnesses) {
        double total = this.getTotalValue(nodeFitnesses);
        RandomNumberGenerator random = this.getWorld().getRandomNumberGenerator();
        double randomValue = random.generate() * total;
        double currentFitness = 0.0;
        Agent selectedNode = null;
        int i = 0;
        while (i < nodeFitnesses.size()) {
            Double fitnessAsDouble = (Double)nodeFitnesses.get(i);
            double fitness = fitnessAsDouble;
            if (currentFitness < randomValue && randomValue <= currentFitness + fitness) {
                selectedNode = (Agent)nodes.get(i);
                break;
            }
            currentFitness += fitness;
            ++i;
        }
        return selectedNode;
    }

    private Agent createNewNode() {
        Agent newNode = this.getWorld().createAgent(EvolvingNetworkModel.AGENTTYPE_Node);
        RandomNumberGenerator random = this.getWorld().getRandomNumberGenerator();
        double appealValue = random.generate();
        newNode.putInformation((Information)EvolvingNetworkModel.INFORMATIONTYPE_FitnessInformation, (Information)new DoubleInformation(appealValue));
        return newNode;
    }

    private double getTotalValue(List nodeFitnesses) {
        double total = 0.0;
        int i = 0;
        while (i < nodeFitnesses.size()) {
            Double fitnessAsDouble = (Double)nodeFitnesses.get(i);
            double fitness = fitnessAsDouble;
            total += fitness;
            ++i;
        }
        return total;
    }

    private List colculateFitnessOfAllNodes(List nodes) {
        ArrayList<Double> nodeFitnesses = new ArrayList<Double>();
        int i = 0;
        while (i < nodes.size()) {
            Agent node = (Agent)nodes.get(i);
            int linkNum = node.getRelations(EvolvingNetworkModel.RELATIONTYPE_Link).size();
            DoubleInformation appealInfo = (DoubleInformation)node.getInformation((Information)EvolvingNetworkModel.INFORMATIONTYPE_FitnessInformation);
            double appeal = appealInfo.getValue();
            double fitness = (double)linkNum * appeal;
            nodeFitnesses.add(new Double(fitness));
            ++i;
        }
        return nodeFitnesses;
    }
}

