/*
 * Decompiled with CFR 0.152.
 */
package org.boxed_economy.evolvingnetwork_behavior;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.boxed_economy.besp.model.ModelException;
import org.boxed_economy.besp.model.fmfw.Agent;
import org.boxed_economy.evolvingnetwork.EvolvingNetworkModel;
import org.boxed_economy.evolvingnetwork_behavior.AbstractPreferentialAttachBehavior;

public class PreferentialAttachBehavior
extends AbstractPreferentialAttachBehavior {
    protected void initialize() {
    }

    protected void terminate() {
    }

    protected void preferentialAttachAction() {
        List nodes = (List)this.getWorld().getAgents(EvolvingNetworkModel.AGENTTYPE_Node);
        List cumulativeLinkNumList = this.investigateLinkNum(nodes);
        Agent newNode = this.getWorld().createAgent(EvolvingNetworkModel.AGENTTYPE_Node);
        newNode.addBehavior(EvolvingNetworkModel.BEHAVIORTYPE_RandomCommunicateBehavior);
        Agent node1 = this.preferentialSelect(cumulativeLinkNumList, nodes);
        Agent node2 = null;
        while (node1 == (node2 = this.preferentialSelect(cumulativeLinkNumList, nodes))) {
        }
        newNode.addRelation(EvolvingNetworkModel.RELATIONTYPE_Link, node1);
        node1.addRelation(EvolvingNetworkModel.RELATIONTYPE_Link, newNode);
        newNode.addRelation(EvolvingNetworkModel.RELATIONTYPE_Link, node2);
        node2.addRelation(EvolvingNetworkModel.RELATIONTYPE_Link, newNode);
    }

    private List investigateLinkNum(List nodes) {
        Iterator i = nodes.iterator();
        ArrayList<Integer> cumulativeLinkNum = new ArrayList<Integer>();
        int totalLinkNum = 0;
        while (i.hasNext()) {
            Agent agent = (Agent)i.next();
            int linkNum = agent.getRelations(EvolvingNetworkModel.RELATIONTYPE_Link).size();
            cumulativeLinkNum.add(new Integer(totalLinkNum += linkNum));
        }
        return cumulativeLinkNum;
    }

    private Agent preferentialSelect(List cumulativeLinkNumList, List nodes) {
        int totalLinkNum = (Integer)cumulativeLinkNumList.get(cumulativeLinkNumList.size() - 1);
        int random = this.getWorld().getRandomNumberGenerator().generate(totalLinkNum);
        Iterator i = cumulativeLinkNumList.iterator();
        Iterator j = nodes.iterator();
        while (j.hasNext()) {
            int cumulativeLinkNum = (Integer)i.next();
            Agent agent = (Agent)j.next();
            if (cumulativeLinkNum <= random) continue;
            return agent;
        }
        throw new ModelException("error at PreferentialAttachBehavior " + (Object)((Object)this));
    }
}

