/*
 * Decompiled with CFR 0.152.
 */
package org.boxed_economy.artificialmarket.model.behavior;

import org.boxed_economy.artificialmarket.model.ArtificialMarketModel;
import org.boxed_economy.artificialmarket.model.ArtificialMarketWorld;
import org.boxed_economy.artificialmarket.model.behavior.TraderBehavior;
import org.boxed_economy.artificialmarket.model.information.OrderInformation;
import org.boxed_economy.besp.model.ModelException;
import org.boxed_economy.besp.model.fmfw.RandomNumberGenerator;

public class RandomTraderBehavior
extends TraderBehavior {
    protected OrderInformation createOrder() {
        String orderAction = null;
        int price = 0;
        int amount = 0;
        int previousprice = 100;
        RandomNumberGenerator random = this.getWorld().getRandomNumberGenerator();
        int buyOrSell = random.generate(2);
        if (buyOrSell == 0) {
            orderAction = "BUY";
            price = previousprice - this.getOrderPriceVariance() / 2 + random.generate(this.getOrderPriceVariance());
            int canbuyAmount = this.getAgent().getQuantity(ArtificialMarketModel.GOODS_Money).getValueAsInt() / price;
            amount = canbuyAmount / (random.generate(9) + 1);
        } else if (buyOrSell == 1) {
            orderAction = "SELL";
            price = previousprice - this.getOrderPriceVariance() / 2 + random.generate(this.getOrderPriceVariance());
            int canSellAmount = this.getAgent().getQuantity(ArtificialMarketModel.GOODS_Stock).getValueAsInt();
            amount = canSellAmount / (random.generate(9) + 1);
        } else {
            throw new ModelException("Invalid Number: " + (Object)((Object)this));
        }
        return new OrderInformation(this.getAgent(), orderAction, price, amount);
    }

    private int getOrderPriceVariance() {
        ArtificialMarketWorld world = (ArtificialMarketWorld)this.getWorld();
        return world.getOrderPriceVariance();
    }
}

