/*
 * Decompiled with CFR 0.152.
 */
package org.boxed_economy.artificialmarket.model.behavior;

import java.util.Iterator;
import java.util.List;
import org.apache.log4j.Logger;
import org.boxed_economy.artificialmarket.model.ArtificialMarketModel;
import org.boxed_economy.artificialmarket.model.behavior.AbstractStockExchangeBehavior;
import org.boxed_economy.artificialmarket.model.behavior.ReceiveGoodsAction;
import org.boxed_economy.artificialmarket.model.information.BoardInformation;
import org.boxed_economy.artificialmarket.model.information.OrderInformation;
import org.boxed_economy.artificialmarket.model.information.StartSignalInformation;
import org.boxed_economy.besp.model.ModelException;
import org.boxed_economy.besp.model.fmfw.Agent;
import org.boxed_economy.besp.model.fmfw.Behavior;
import org.boxed_economy.besp.model.fmfw.Goods;
import org.boxed_economy.besp.model.fmfw.Information;
import org.boxed_economy.besp.model.fmfw.Relation;
import org.boxed_economy.besp.model.fmfw.Type;
import org.boxed_economy.besp.model.fmfw.behavior.Event;

public class StockExchangeBehavior
extends AbstractStockExchangeBehavior {
    private static final Logger logger;
    private int receiveCounter = 0;
    private List contractResult = null;
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.boxed_economy.artificialmarket.model.behavior.StockExchangeBehavior");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        $assertionsDisabled = !clazz.desiredAssertionStatus();
        Class<?> clazz2 = class$0;
        if (clazz2 == null) {
            try {
                clazz2 = class$0 = Class.forName("org.boxed_economy.artificialmarket.model.behavior.StockExchangeBehavior");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        logger = Logger.getLogger((String)clazz2.getName());
    }

    protected void initialize() {
        this.createBoard();
    }

    protected void terminate() {
    }

    protected void initializeBoardAction() {
        this.createBoard();
    }

    protected void sendStartSignalToAllTraderAction() {
        logger.debug((Object)("\u95a2\u4fc2\u3092\u3082\u3064\u5168\u3066\u306e\u30c8\u30ec\u30fc\u30c0\u30fc\u306bstartSignal\u3092\u9001\u308a\u307e\u3059 --- " + (Object)((Object)this)));
        this.receiveCounter = this.sendInformation(ArtificialMarketModel.RELATION_ToTrader, ArtificialMarketModel.BEHAVIOR_Trader, new StartSignalInformation(), true);
        logger.debug((Object)("\u95a2\u4fc2\u3092\u3082\u3064\u5168\u3066\u306e\u30c8\u30ec\u30fc\u30c0\u30fc\u306bstartSignal\u3092\u9001\u308a\u7d42\u3048\u307e\u3057\u305f --- " + (Object)((Object)this)));
    }

    protected void receiveOrderAction() {
        OrderInformation order = (OrderInformation)this.getReceivedInformation();
        this.getBoard().addOrder(order);
        --this.receiveCounter;
        logger.debug((Object)(String.valueOf(order.toString()) + "\u306e\u6ce8\u6587\u3092\u53d7\u3051\u53d6\u308a\u307e\u3057\u305f --- " + (Object)((Object)this)));
    }

    protected void contractAction() {
        this.contractResult = this.getBoard().getContractResult();
    }

    protected void sendContractResultToAllTraderAction() {
        if (!$assertionsDisabled && this.receiveCounter != 0) {
            throw new AssertionError();
        }
        this.receiveCounter = 0;
        Iterator i = this.contractResult.iterator();
        while (i.hasNext()) {
            OrderInformation result = (OrderInformation)i.next();
            Goods goods = this.getWorld().createGoods(ArtificialMarketModel.GOODS_Result, 1.0);
            goods.setAttachment((Information)result);
            Relation relation = this.getAgent().getRelation(ArtificialMarketModel.RELATION_ToTrader, result.getAgent());
            this.sendGoods(relation, ArtificialMarketModel.BEHAVIOR_Trader, goods);
            ++this.receiveCounter;
        }
    }

    protected void sendGoodsToAllTraderAction() {
        Iterator i = this.contractResult.iterator();
        while (i.hasNext()) {
            OrderInformation result = (OrderInformation)i.next();
            Relation relation = this.getAgent().getRelation(ArtificialMarketModel.RELATION_ToTrader, result.getAgent());
            Goods goods = this.removeGoods(result);
            this.sendGoods(relation, ArtificialMarketModel.BEHAVIOR_Trader, goods);
        }
    }

    protected void receiveGoodsAction() {
        ReceiveGoodsAction action = new ReceiveGoodsAction();
        action.setBehavior((Behavior)this);
        action.doAction();
        --this.receiveCounter;
    }

    protected boolean isOrder(Event e) {
        return this.getReceivedGoods().getType().equals((Type)ArtificialMarketModel.GOODS_Order);
    }

    protected boolean isAllReplyReceived(Event e) {
        return this.receiveCounter == 0;
    }

    private void createBoard() {
        this.getAgent().putInformation((Information)new BoardInformation());
    }

    public BoardInformation getBoard() {
        Agent agent = this.getAgent();
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("org.boxed_economy.artificialmarket.model.information.BoardInformation");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return (BoardInformation)agent.getInformation((Class)clazz);
    }

    private Goods removeGoods(OrderInformation result) {
        Goods sentGoods = null;
        if (result.getOrderAction().equals("BUY")) {
            sentGoods = this.getAgent().removeGoods(ArtificialMarketModel.GOODS_Stock, (double)result.getAmount());
        } else if (result.getOrderAction().equals("SELL")) {
            sentGoods = this.getAgent().removeGoods(ArtificialMarketModel.GOODS_Money, (double)(result.getPrice() * result.getAmount()));
        } else if (result.getOrderAction().equals("NONE")) {
            sentGoods = this.getWorld().createGoods(ArtificialMarketModel.GOODS_Stock, 0.0);
        } else {
            throw new ModelException("Invalid orderAction. " + result.getOrderAction() + (Object)((Object)this));
        }
        return sentGoods;
    }
}

