/*
 * Decompiled with CFR 0.152.
 */
package org.boxed_economy.artificialmarket.model.behavior;

import org.apache.log4j.Logger;
import org.boxed_economy.artificialmarket.model.ArtificialMarketModel;
import org.boxed_economy.artificialmarket.model.behavior.AbstractTraderBehavior;
import org.boxed_economy.artificialmarket.model.information.OrderInformation;
import org.boxed_economy.besp.model.ModelException;
import org.boxed_economy.besp.model.fmfw.Goods;
import org.boxed_economy.besp.model.fmfw.Information;
import org.boxed_economy.besp.model.fmfw.Type;
import org.boxed_economy.besp.model.fmfw.behavior.Event;

public abstract class TraderBehavior
extends AbstractTraderBehavior {
    private static final Logger logger;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.boxed_economy.artificialmarket.model.behavior.TraderBehavior");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        logger = Logger.getLogger((String)clazz.getName());
    }

    protected void initialize() {
    }

    protected void terminate() {
    }

    protected void orderAction() {
        OrderInformation order = this.createOrder();
        Goods sentGoods = this.getWorld().createGoods(ArtificialMarketModel.GOODS_Order, 1.0);
        sentGoods.setAttachment((Information)order);
        this.sendGoods(sentGoods);
        logger.debug((Object)(String.valueOf(order.toString()) + "\u306e\u6ce8\u6587\u3092\u9001\u308a\u307e\u3059 --- " + (Object)((Object)this)));
    }

    protected void sendGoodsAction() {
        OrderInformation result = (OrderInformation)this.getReceivedGoods().getAttachment();
        Goods sentGoods = null;
        if (result.getOrderAction().equals("BUY")) {
            if (this.getAgent().getQuantity(ArtificialMarketModel.GOODS_Money).getValueAsInt() < result.getPrice() * result.getAmount()) {
                throw new ModelException("Not enough money. " + (Object)((Object)this));
            }
            sentGoods = this.getAgent().removeGoods(ArtificialMarketModel.GOODS_Money, (double)(result.getPrice() * result.getAmount()));
        } else if (result.getOrderAction().equals("SELL")) {
            if (this.getAgent().getQuantity(ArtificialMarketModel.GOODS_Stock).getValueAsInt() < result.getAmount()) {
                throw new ModelException("Not enough stock. " + (Object)((Object)this));
            }
            sentGoods = this.getAgent().removeGoods(ArtificialMarketModel.GOODS_Stock, (double)result.getAmount());
        } else if (result.getOrderAction().equals("NONE")) {
            sentGoods = this.getWorld().createGoods(ArtificialMarketModel.GOODS_Stock, 0.0);
        } else {
            throw new ModelException("Invalid orderAction. " + result.getOrderAction() + (Object)((Object)this));
        }
        logger.debug((Object)(String.valueOf(result.toString()) + "\u3068\u3044\u3046\u7d04\u5b9a\u7d50\u679c\u3092\u53d7\u3051\u53d6\u308a\u307e\u3057\u305f" + (Object)((Object)this)));
        logger.debug((Object)(String.valueOf(sentGoods.getType().getName()) + " \u3092 " + sentGoods.getGoodsQuantity().getValueAsInt() + " \u3060\u3051\u9001\u308a\u307e\u3059" + (Object)((Object)this)));
        this.sendGoods(sentGoods);
    }

    protected boolean isStartSignal(Event e) {
        String string = this.getReceivedInformation().getClass().getName();
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("org.boxed_economy.artificialmarket.model.information.StartSignalInformation");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return string.equals(clazz.getName());
    }

    protected boolean isContractResult(Event e) {
        return this.getReceivedGoods().getType().equals((Type)ArtificialMarketModel.GOODS_Result);
    }

    protected abstract OrderInformation createOrder();
}

