/*
 * Decompiled with CFR 0.152.
 */
package org.boxed_economy.artificialmarket.model.information;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.boxed_economy.artificialmarket.model.information.OrderInformation;
import org.boxed_economy.artificialmarket.model.information.OrderListInformation;
import org.boxed_economy.besp.model.ModelException;
import org.boxed_economy.besp.model.fmfw.Information;

public class BoardInformation
implements Information {
    private Map priceBoardMap = new HashMap();
    private List nonePriceOrders = new ArrayList();
    private OrderListInformation contractedPriceBoard = null;

    public void addOrder(OrderInformation order) {
        OrderListInformation priceBoard;
        if (this.contractedPriceBoard != null) {
            throw new ModelException("Already Contracted: " + this);
        }
        if (order.getOrderAction().equals("NONE")) {
            this.nonePriceOrders.add(order);
            return;
        }
        Integer priceInt = new Integer(order.getPrice());
        if (!this.priceBoardMap.containsKey(priceInt)) {
            priceBoard = new OrderListInformation(order.getPrice());
            this.priceBoardMap.put(priceInt, priceBoard);
        }
        priceBoard = (OrderListInformation)this.priceBoardMap.get(priceInt);
        priceBoard.addOrder(order);
    }

    public List getContractResult() {
        if (this.contractedPriceBoard == null) {
            this.contract();
        }
        return this.createContractResult();
    }

    private List createContractResult() {
        int amount;
        OrderInformation order;
        Iterator orderIterator;
        ArrayList<OrderInformation> resultList = new ArrayList<OrderInformation>();
        LinkedList priceBoards = this.getOrderList();
        int contractAmount = this.getContractAmount();
        Iterator i = priceBoards.iterator();
        while (i.hasNext()) {
            OrderListInformation orders = (OrderListInformation)i.next();
            orderIterator = orders.buyOrderIterator();
            while (orderIterator.hasNext()) {
                order = (OrderInformation)orderIterator.next();
                if (contractAmount == 0) {
                    resultList.add(this.createNoneResult(order));
                    continue;
                }
                if (contractAmount < 0) {
                    throw new ModelException("Invalid Contract Amount: " + this);
                }
                if (order.getAmount() == 0) {
                    resultList.add(this.createNoneResult(order));
                    continue;
                }
                amount = contractAmount >= order.getAmount() ? order.getAmount() : contractAmount;
                contractAmount -= amount;
                resultList.add(this.createResult(order, "BUY", amount));
            }
        }
        contractAmount = this.getContractAmount();
        Collections.reverse(priceBoards);
        i = priceBoards.iterator();
        while (i.hasNext()) {
            OrderListInformation pb = (OrderListInformation)i.next();
            orderIterator = pb.sellOrderIterator();
            while (orderIterator.hasNext()) {
                order = (OrderInformation)orderIterator.next();
                if (contractAmount == 0) {
                    resultList.add(this.createNoneResult(order));
                    continue;
                }
                if (contractAmount < 0) {
                    throw new ModelException("Invalid Contract Amount: " + this);
                }
                if (order.getAmount() == 0) {
                    resultList.add(this.createNoneResult(order));
                    continue;
                }
                amount = contractAmount >= order.getAmount() ? order.getAmount() : contractAmount;
                contractAmount -= amount;
                resultList.add(this.createResult(order, "SELL", amount));
            }
        }
        i = this.nonePriceOrders.iterator();
        while (i.hasNext()) {
            OrderInformation order2 = (OrderInformation)i.next();
            resultList.add(this.createNoneResult(order2));
        }
        return resultList;
    }

    public int getContractAmount() {
        if (this.contractedPriceBoard == null) {
            return 0;
        }
        return this.contractedPriceBoard.getBuyCumTotal() < this.contractedPriceBoard.getSellCumTotal() ? this.contractedPriceBoard.getBuyCumTotal() : this.contractedPriceBoard.getSellCumTotal();
    }

    public boolean isContracted() {
        return this.contractedPriceBoard != null;
    }

    public int getContractPrice() {
        if (this.contractedPriceBoard == null) {
            return 0;
        }
        return this.contractedPriceBoard.getPrice();
    }

    public LinkedList getOrderList() {
        LinkedList priceBoards = new LinkedList(this.priceBoardMap.values());
        Collections.sort(priceBoards);
        return priceBoards;
    }

    private OrderInformation createResult(OrderInformation order, String action, int amount) {
        return new OrderInformation(order.getAgent(), action, this.contractedPriceBoard != null ? this.contractedPriceBoard.getPrice() : -1, amount);
    }

    private OrderInformation createNoneResult(OrderInformation order) {
        return this.createResult(order, "NONE", 0);
    }

    private void contract() {
        LinkedList priceBoards = this.getOrderList();
        OrderListInformation max = null;
        OrderListInformation min = null;
        if (!priceBoards.isEmpty()) {
            max = new OrderListInformation(((OrderListInformation)priceBoards.getFirst()).getPrice() + 1);
            min = new OrderListInformation(((OrderListInformation)priceBoards.getLast()).getPrice() - 1);
            priceBoards.addFirst(max);
            priceBoards.addLast(min);
        }
        this.calcCumTotal(priceBoards);
        this.contractedPriceBoard = this.calcContractPoint(priceBoards);
        if (!priceBoards.isEmpty()) {
            priceBoards.remove(max);
            priceBoards.remove(min);
        }
    }

    private OrderListInformation calcContractPoint(LinkedList priceBoards) {
        int length = priceBoards.size();
        OrderListInformation candidatePB1 = null;
        OrderListInformation candidatePB2 = null;
        int i = 0;
        while (i < length) {
            candidatePB2 = (OrderListInformation)priceBoards.get(i);
            if (candidatePB2.getSellCumTotal() == 0 && candidatePB2.getBuyCumTotal() == 0) {
                return null;
            }
            if (candidatePB2.getSellCumTotal() == candidatePB2.getBuyCumTotal()) {
                return candidatePB2;
            }
            if (candidatePB2.getSellCumTotal() < candidatePB2.getBuyCumTotal()) {
                if (candidatePB1.getBuyCumTotal() == candidatePB2.getSellCumTotal()) {
                    return candidatePB1;
                }
                if (candidatePB1.getBuyCumTotal() < candidatePB2.getSellCumTotal()) {
                    return candidatePB2;
                }
                return candidatePB1;
            }
            candidatePB1 = candidatePB2;
            ++i;
        }
        return null;
    }

    private void calcCumTotal(LinkedList priceBoards) {
        int length = priceBoards.size();
        int sellCumTotal = 0;
        int buyCumTotal = 0;
        int i = 0;
        while (i < length) {
            OrderListInformation sellPriceBoard = (OrderListInformation)priceBoards.get(length - i - 1);
            sellPriceBoard.setSellCumTotal(sellCumTotal += sellPriceBoard.getSellAmount());
            OrderListInformation buyPriceBoard = (OrderListInformation)priceBoards.get(i);
            buyPriceBoard.setBuyCumTotal(buyCumTotal += buyPriceBoard.getBuyAmount());
            ++i;
        }
    }

    public void dump() {
        LinkedList priceBoards = this.getOrderList();
        int length = priceBoards.size();
        OrderListInformation priceBoardPrinter = null;
        System.out.println("\u7d2f\u8a08\t\u58f2\u308a\t\u4fa1\u683c\t\u8cb7\u3044\t\u7d2f\u8a08");
        int i = 0;
        while (i < length) {
            priceBoardPrinter = (OrderListInformation)priceBoards.get(i);
            System.out.println(priceBoardPrinter);
            ++i;
        }
        if (this.contractedPriceBoard == null) {
            System.out.println("\u7d04\u5b9a\u3057\u307e\u305b\u3093");
        } else {
            System.out.println(String.valueOf(this.contractedPriceBoard.getPrice()) + "\u5186\u304c\u7d04\u5b9a\u4fa1\u683c\u3067\u3059");
        }
    }
}

