/*
 * Decompiled with CFR 0.152.
 */
package org.boxed_economy.artificialmarket.model.information;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.boxed_economy.artificialmarket.model.information.OrderInformation;
import org.boxed_economy.besp.model.ModelException;
import org.boxed_economy.besp.model.fmfw.Information;

public class OrderListInformation
implements Comparable,
Information {
    private List sellOrderList = new ArrayList();
    private List buyOrderList = new ArrayList();
    private int price = 0;
    private int sellCumTotal = 0;
    private int buyCumTotal = 0;

    protected OrderListInformation(int price) {
        this.price = price;
    }

    public void addOrder(OrderInformation order) {
        if (order.getOrderAction().equals("SELL")) {
            this.sellOrderList.add(order);
        } else if (order.getOrderAction().equals("BUY")) {
            this.buyOrderList.add(order);
        } else {
            throw new ModelException("\u4e0d\u6b63\u306a\u6ce8\u6587\u3067\u3059");
        }
    }

    public Iterator buyOrderIterator() {
        return this.buyOrderList.iterator();
    }

    public Iterator sellOrderIterator() {
        return this.sellOrderList.iterator();
    }

    public int getBuyAmount() {
        return this.calcAmount(this.buyOrderList);
    }

    public int getSellAmount() {
        return this.calcAmount(this.sellOrderList);
    }

    private int calcAmount(List orderList) {
        int amount = 0;
        Iterator i = orderList.iterator();
        while (i.hasNext()) {
            amount += ((OrderInformation)i.next()).getAmount();
        }
        return amount;
    }

    public int compareTo(Object o) {
        return ((OrderListInformation)o).price - this.price;
    }

    private String format(int i) {
        if (i < 1000) {
            return String.valueOf(Integer.toString(i)) + "\t";
        }
        return Integer.toString(i);
    }

    public String toString() {
        return String.valueOf(this.format(this.sellCumTotal)) + "\t" + this.format(this.getSellAmount()) + "\t" + this.format(this.price) + "\t" + this.format(this.getBuyAmount()) + "\t" + this.format(this.buyCumTotal);
    }

    public int getBuyCumTotal() {
        return this.buyCumTotal;
    }

    public int getPrice() {
        return this.price;
    }

    public int getSellCumTotal() {
        return this.sellCumTotal;
    }

    protected void setBuyCumTotal(int buyCumTotal) {
        this.buyCumTotal = buyCumTotal;
    }

    public void setPrice(int price) {
        this.price = price;
    }

    protected void setSellCumTotal(int sellCumTotal) {
        this.sellCumTotal = sellCumTotal;
    }
}

