/*
 * Decompiled with CFR 0.152.
 */
package org.boxed_economy.artificialmarket.model.information;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.boxed_economy.besp.model.ModelException;
import org.boxed_economy.besp.model.fmfw.Information;

public class PriceHistoryInformation
implements Information {
    private static PriceHistoryInformation bull = PriceHistoryInformation.createBull();
    private static PriceHistoryInformation bear = PriceHistoryInformation.createBear();
    private static PriceHistoryInformation random = PriceHistoryInformation.createRandom();
    public static PriceHistoryInformation[] runupPrices = new PriceHistoryInformation[]{bull, bear, random};
    private LinkedList priceList = new LinkedList();

    private static PriceHistoryInformation createBull() {
        PriceHistoryInformation ph = new PriceHistoryInformation();
        ph.addPrice(97.0);
        ph.addPrice(97.0);
        ph.addPrice(98.0);
        ph.addPrice(98.0);
        ph.addPrice(99.0);
        ph.addPrice(99.0);
        ph.addPrice(100.0);
        ph.addPrice(100.0);
        ph.addPrice(101.0);
        ph.addPrice(101.0);
        return ph;
    }

    private static PriceHistoryInformation createBear() {
        PriceHistoryInformation ph = PriceHistoryInformation.createBull();
        Collections.reverse(ph.priceList);
        return ph;
    }

    private static PriceHistoryInformation createRandom() {
        PriceHistoryInformation ph = new PriceHistoryInformation();
        ph.addPrice(97.0);
        ph.addPrice(103.0);
        ph.addPrice(100.0);
        ph.addPrice(101.0);
        ph.addPrice(105.0);
        ph.addPrice(99.0);
        ph.addPrice(102.0);
        ph.addPrice(97.0);
        ph.addPrice(98.0);
        ph.addPrice(101.0);
        return ph;
    }

    public void addPrice(double addPrice) {
        this.priceList.add(new Double(addPrice));
    }

    public List getPriceList() {
        return new ArrayList(this.priceList);
    }

    public int size() {
        return this.priceList.size();
    }

    public List getPriceListByRange(int range) {
        int min;
        ArrayList returnArrayList = new ArrayList();
        if (this.priceList.size() < range || range <= 0) {
            throw new ModelException("getSelectedPriceList(int)\u306e\u7bc4\u56f2\u6307\u5b9a\u304c\u4e0d\u6b63\u3067\u3059");
        }
        int size = this.priceList.size();
        int i = min = size - range;
        while (i < size) {
            returnArrayList.add(this.priceList.get(i));
            ++i;
        }
        return returnArrayList;
    }

    public double getAvaragePrice(int beginIndex, int lastIndex) {
        if (beginIndex < 0 || beginIndex > lastIndex || lastIndex > this.priceList.size()) {
            throw new ModelException("getAvaragePrice(int)\u306e\u7bc4\u56f2\u6307\u5b9a\u304c\u4e0d\u6b63\u3067\u3059");
        }
        double r = 0.0;
        int i = beginIndex;
        while (i <= lastIndex) {
            r += ((Double)this.priceList.get(i)).doubleValue();
            ++i;
        }
        return r / (double)(lastIndex - beginIndex + 1);
    }

    public PriceHistoryInformation getCopy() {
        PriceHistoryInformation priceHistory = new PriceHistoryInformation();
        priceHistory.priceList = new LinkedList(this.priceList);
        return priceHistory;
    }
}

