/*
 * Decompiled with CFR 0.152.
 */
package org.boxed_economy.artificialmarket.presentation;

import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;
import org.boxed_economy.artificialmarket.model.ArtificialMarketModel;
import org.boxed_economy.artificialmarket.model.information.BoardInformation;
import org.boxed_economy.artificialmarket.model.information.OrderListInformation;
import org.boxed_economy.besp.model.fmfw.Agent;
import org.boxed_economy.besp.model.fmfw.World;
import org.boxed_economy.besp.model.fmfw.update.UpdateClockEvent;
import org.boxed_economy.besp.model.fmfw.update.UpdateClockListener;
import org.boxed_economy.besp.presentation.guifw.AbstractInternalFrameComponent;
import org.boxed_economy.components.stepclock.StepClock;

public class BoardPresentationComponent
extends AbstractInternalFrameComponent
implements UpdateClockListener {
    private JTable orderTable;
    private BoardTableModel model = new BoardTableModel();
    private JLabel timeText = new JLabel("\u73fe\u5728\u6642\u523b\uff1a");
    private JLabel contractPrice = new JLabel("\u7d04\u5b9a\u4fa1\u683c");
    private JLabel contractAmount = new JLabel("\u53d6\u5f15\u91cf");
    private long startStep;
    private BoardInformation board;
    static /* synthetic */ Class class$0;

    public BoardPresentationComponent() {
        this.setPreferredSize(new Dimension(400, 300));
        Container contentPane = this.getContentPane();
        JPanel panel = new JPanel(new GridLayout(3, 1));
        panel.add(this.timeText);
        panel.add(this.contractPrice);
        panel.add(this.contractAmount);
        this.orderTable = new JTable();
        this.orderTable.createDefaultColumnsFromModel();
        contentPane.add("North", panel);
        JScrollPane scroll = new JScrollPane();
        this.orderTable.setModel(this.model);
        scroll.getViewport().add(this.orderTable);
        contentPane.add("Center", scroll);
    }

    private BoardInformation getBoard() {
        World world = this.getWorld();
        if (world == null) {
            return null;
        }
        Agent agent = world.getAgent(ArtificialMarketModel.AGENT_StockExchange);
        if (agent == null) {
            return null;
        }
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.boxed_economy.artificialmarket.model.information.BoardInformation");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return (BoardInformation)agent.getInformation((Class)clazz);
    }

    public void clockGained(UpdateClockEvent e) {
        this.board = this.getBoard();
        StepClock clock = (StepClock)e.getSource();
        if (this.startStep == 0L) {
            this.startStep = clock.getStep();
        }
        this.timeText.setText("\u73fe\u5728\u306e\u30b9\u30c6\u30c3\u30d7:" + Long.toString(clock.getStep() - this.startStep));
        if (this.board != null) {
            this.contractPrice.setText("\u7d04\u5b9a\u4fa1\u683c:" + this.board.getContractPrice());
            this.contractAmount.setText("\u53d6\u5f15\u91cf" + this.board.getContractAmount() + "\u682a");
            this.model.update();
            this.repaint();
        }
    }

    public void initialize() {
        this.addUpdateClockListener(this);
    }

    public void terminate() {
        this.removeUpdateClockListener(this);
    }

    private class BoardTableModel
    extends AbstractTableModel {
        static /* synthetic */ Class class$0;

        BoardTableModel() {
        }

        public String getColumnName(int columnIndex) {
            switch (columnIndex) {
                case 0: {
                    return "\u58f2\u308a\u6ce8\u6587\u7d2f\u8a08";
                }
                case 1: {
                    return "\u58f2\u308a\u6ce8\u6587";
                }
                case 2: {
                    return "\u4fa1\u683c";
                }
                case 3: {
                    return "\u8cb7\u3044\u6ce8\u6587";
                }
                case 4: {
                    return "\u8cb7\u3044\u6ce8\u6587\u7d2f\u8a08";
                }
            }
            return null;
        }

        public int getColumnCount() {
            return 5;
        }

        public int getRowCount() {
            if (BoardPresentationComponent.this.board != null) {
                return BoardPresentationComponent.this.board.getOrderList().size();
            }
            return 0;
        }

        public Object getValueAt(int rowIndex, int columnIndex) {
            if (BoardPresentationComponent.this.board.getOrderList().size() - 1 < rowIndex) {
                rowIndex = BoardPresentationComponent.this.board.getOrderList().size();
            }
            OrderListInformation orderList = (OrderListInformation)BoardPresentationComponent.this.board.getOrderList().get(rowIndex);
            switch (columnIndex) {
                case 0: {
                    return Integer.toString(orderList.getSellCumTotal());
                }
                case 1: {
                    return Integer.toString(orderList.getSellAmount());
                }
                case 2: {
                    return Integer.toString(orderList.getPrice());
                }
                case 3: {
                    return Integer.toString(orderList.getBuyAmount());
                }
                case 4: {
                    return Integer.toString(orderList.getBuyCumTotal());
                }
            }
            return null;
        }

        public Class getColumnClass(int columnIndex) {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("java.lang.String");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            return clazz;
        }

        public void update() {
            this.fireTableDataChanged();
        }
    }
}

